/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.XMLConfigParserTest;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.OperationGroup;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.generators.WeightedRandomLoadEventGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedRandomLoadEventGeneratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightedRandomLoadEventGeneratorTest.class);

    public DataModel readTestDataModel(String resourceName) throws Exception {
        URL scenarioUrl = XMLConfigParserTest.class.getResource(resourceName);
        Assert.assertNotNull((Object)scenarioUrl);
        Path p = Paths.get(scenarioUrl.toURI());
        return XMLConfigParser.readDataModel((Path)p);
    }

    @Test
    public void testVariousEventGeneration() throws Exception {
        int numRuns = 10;
        int numOperations = 100000;
        double normalizedOperations = (double)(numOperations * numRuns) / 10000.0;
        int numTenantGroups = 3;
        int numOpGroups = 5;
        PhoenixUtil pUtil = PhoenixUtil.create();
        Properties properties = PherfConstants.create().getProperties("pherf.properties", false);
        DataModel model = this.readTestDataModel("/scenario/test_evt_gen1.xml");
        for (Scenario scenario : model.getScenarios()) {
            LOGGER.debug(String.format("Testing %s", scenario.getName()));
            LoadProfile loadProfile = scenario.getLoadProfile();
            Assert.assertEquals((String)"tenant group size is not as expected: ", (long)numTenantGroups, (long)loadProfile.getTenantDistribution().size());
            Assert.assertEquals((String)"operation group size is not as expected: ", (long)numOpGroups, (long)loadProfile.getOpDistribution().size());
            double[][] expectedDistribution = new double[numOpGroups][numTenantGroups];
            for (int r = 0; r < numOpGroups; ++r) {
                for (int c = 0; c < numTenantGroups; ++c) {
                    int tenantWeight = ((TenantGroup)loadProfile.getTenantDistribution().get(c)).getWeight();
                    int opWeight = ((OperationGroup)loadProfile.getOpDistribution().get(r)).getWeight();
                    expectedDistribution[r][c] = normalizedOperations * (double)(tenantWeight * opWeight);
                    LOGGER.debug(String.format("Expected [%d,%d] = %f", r, c, expectedDistribution[r][c]));
                }
            }
            WeightedRandomLoadEventGenerator evtGen = new WeightedRandomLoadEventGenerator(pUtil, model, scenario, properties);
            double[][] distribution = new double[numOpGroups][numTenantGroups];
            for (int i = 0; i < numRuns; ++i) {
                int ops = numOperations;
                loadProfile.setNumOperations((long)ops);
                while (ops-- > 0) {
                    TenantOperationInfo info = evtGen.next();
                    int row = TestOperationGroup.valueOf(info.getOperationGroupId()).ordinal();
                    int col = TestTenantGroup.valueOf(info.getTenantGroupId()).ordinal();
                    double[] dArray = distribution[row];
                    int n = col;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            this.validateResults(numOpGroups, numTenantGroups, expectedDistribution, distribution);
        }
    }

    @Test
    public void testAutoAssignedPMFs() throws Exception {
        int numRuns = 50;
        int numOperations = 100000;
        double normalizedOperations = (double)(numOperations * numRuns) / 10000.0;
        int numTenantGroups = 3;
        int numOpGroups = 11;
        PhoenixUtil pUtil = PhoenixUtil.create();
        Properties properties = PherfConstants.create().getProperties("pherf.properties", false);
        DataModel model = this.readTestDataModel("/scenario/test_evt_gen2.xml");
        for (Scenario scenario : model.getScenarios()) {
            LOGGER.debug(String.format("Testing %s", scenario.getName()));
            LoadProfile loadProfile = scenario.getLoadProfile();
            Assert.assertEquals((String)"tenant group size is not as expected: ", (long)numTenantGroups, (long)loadProfile.getTenantDistribution().size());
            Assert.assertEquals((String)"operation group size is not as expected: ", (long)numOpGroups, (long)loadProfile.getOpDistribution().size());
            float totalOperationWeight = 0.0f;
            float autoAssignedOperationWeight = 0.0f;
            float remainingOperationWeight = 0.0f;
            int numAutoWeightedOperations = 0;
            for (int r = 0; r < numOpGroups; ++r) {
                int opWeight = ((OperationGroup)loadProfile.getOpDistribution().get(r)).getWeight();
                if ((float)opWeight > 0.0f) {
                    totalOperationWeight += (float)opWeight;
                    continue;
                }
                ++numAutoWeightedOperations;
            }
            remainingOperationWeight = 100.0f - totalOperationWeight;
            if (numAutoWeightedOperations > 0) {
                autoAssignedOperationWeight = remainingOperationWeight / (float)numAutoWeightedOperations;
            }
            LOGGER.debug(String.format("Auto [%d,%f] = %f", numAutoWeightedOperations, Float.valueOf(remainingOperationWeight), Float.valueOf(autoAssignedOperationWeight)));
            double[][] expectedDistribution = new double[numOpGroups][numTenantGroups];
            for (int r = 0; r < numOpGroups; ++r) {
                for (int c = 0; c < numTenantGroups; ++c) {
                    float tenantWeight = ((TenantGroup)loadProfile.getTenantDistribution().get(c)).getWeight();
                    float opWeight = ((OperationGroup)loadProfile.getOpDistribution().get(r)).getWeight();
                    if (opWeight <= 0.0f) {
                        opWeight = autoAssignedOperationWeight;
                    }
                    expectedDistribution[r][c] = Math.round(normalizedOperations * (double)(tenantWeight * opWeight));
                    LOGGER.debug(String.format("Expected [%d,%d] = %f", r, c, expectedDistribution[r][c]));
                }
            }
            WeightedRandomLoadEventGenerator evtGen = new WeightedRandomLoadEventGenerator(pUtil, model, scenario, properties);
            double[][] distribution = new double[numOpGroups][numTenantGroups];
            for (int i = 0; i < numRuns; ++i) {
                int ops = numOperations;
                loadProfile.setNumOperations((long)ops);
                while (ops-- > 0) {
                    TenantOperationInfo info = evtGen.next();
                    int row = TestOperationGroup2.valueOf(info.getOperationGroupId()).ordinal();
                    int col = TestTenantGroup.valueOf(info.getTenantGroupId()).ordinal();
                    double[] dArray = distribution[row];
                    int n = col;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            this.validateResults(numOpGroups, numTenantGroups, expectedDistribution, distribution);
        }
    }

    private void validateResults(int numOpGroups, int numTenantGroups, double[][] expectedDistribution, double[][] actualDistribution) throws Exception {
        double variancePercent = 0.05f;
        for (int r = 0; r < numOpGroups; ++r) {
            for (int c = 0; c < numTenantGroups; ++c) {
                double allowedVariance = expectedDistribution[r][c] * variancePercent;
                double diff = Math.abs(expectedDistribution[r][c] - actualDistribution[r][c]);
                boolean isAllowed = diff < allowedVariance;
                LOGGER.debug(String.format("Actual[%d,%d] = %f, %f, %f", r, c, actualDistribution[r][c], diff, allowedVariance));
                Assert.assertTrue((String)String.format("Difference is outside the allowed variance [expected = %f, actual = %f]", allowedVariance, diff), (boolean)isAllowed);
            }
        }
    }

    private static enum TestOperationGroup {
        upsertOp,
        queryOp1,
        queryOp2,
        idleOp,
        udfOp;

    }

    private static enum TestTenantGroup {
        tg1,
        tg2,
        tg3;

    }

    private static enum TestOperationGroup2 {
        upsertOp,
        queryOp1,
        queryOp2,
        queryOp3,
        queryOp4,
        queryOp5,
        queryOp6,
        queryOp7,
        queryOp8,
        idleOp,
        udfOp;

    }
}

