/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.MultiTenantTestUtils;
import org.apache.phoenix.pherf.workload.mt.generators.TenantLoadEventGeneratorFactory;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class TenantViewOperationWorkloadIT
extends ParallelStatsDisabledIT {
    private final MultiTenantTestUtils multiTenantTestUtils = new MultiTenantTestUtils();
    private final Properties properties = PherfConstants.create().getProperties("pherf.properties", false);
    private final PhoenixUtil util = PhoenixUtil.create((boolean)true);
    private final RegionCoprocessorEnvironment taskRegionEnvironment;
    private TenantLoadEventGeneratorFactory.GeneratorType generatorType;

    public TenantViewOperationWorkloadIT(String generatorType) throws Exception {
        this.generatorType = TenantLoadEventGeneratorFactory.GeneratorType.valueOf((String)generatorType);
        this.taskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)TenantViewOperationWorkloadIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    @BeforeClass
    public static synchronized void setUrl() {
        PhoenixUtil.setZookeeper((String)MultiTenantTestUtils.getZookeeperFromUrl(url));
    }

    @Parameterized.Parameters(name="generator_type={0}")
    public static synchronized Collection<Object[]> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new Object[]{"WEIGHTED"});
        testCases.add(new Object[]{"UNIFORM"});
        testCases.add(new Object[]{"SEQUENTIAL"});
        return testCases;
    }

    @Before
    public void setup() throws Exception {
        this.multiTenantTestUtils.applySchema(this.util, ".*datamodel/.*test_mt.*.sql");
    }

    @After
    public void cleanup() throws Exception {
        this.util.deleteTables("PHERF.*BASE_TABLE");
        if (this.taskRegionEnvironment != null) {
            this.util.dropChildView(this.taskRegionEnvironment, 2);
        }
    }

    @Test
    public void testVariousOperations() throws Exception {
        DataModel model = this.multiTenantTestUtils.readTestDataModel("/scenario/test_mt_workload_template.xml");
        for (Scenario scenario : model.getScenarios()) {
            MultiTenantTestUtils.TestConfigAndExpectations settings = this.getTestConfigAndExpectations(scenario, this.generatorType);
            scenario.setGeneratorName(this.generatorType.name());
            scenario.getLoadProfile().setTenantDistribution(settings.tenantGroups);
            this.multiTenantTestUtils.testVariousOperations(this.properties, model, scenario.getName(), settings.expectedTenantGroups, settings.expectedOpGroups);
        }
    }

    @Test
    public void testWorkloadWithOneHandler() throws Exception {
        int numHandlers = 1;
        DataModel model = this.multiTenantTestUtils.readTestDataModel("/scenario/test_mt_workload_template.xml");
        for (Scenario scenario : model.getScenarios()) {
            MultiTenantTestUtils.TestConfigAndExpectations settings = this.getTestConfigAndExpectations(scenario, this.generatorType);
            scenario.setGeneratorName(this.generatorType.name());
            scenario.getLoadProfile().setTenantDistribution(settings.tenantGroups);
            this.multiTenantTestUtils.testWorkloadWithHandlers(this.properties, model, scenario.getName(), numHandlers, settings.expectedTenantGroups, settings.expectedOpGroups);
        }
    }

    @Test
    public void testWorkloadWithManyHandlers() throws Exception {
        int numHandlers = 5;
        DataModel model = this.multiTenantTestUtils.readTestDataModel("/scenario/test_mt_workload_template.xml");
        for (Scenario scenario : model.getScenarios()) {
            MultiTenantTestUtils.TestConfigAndExpectations settings = this.getTestConfigAndExpectations(scenario, this.generatorType);
            scenario.setGeneratorName(this.generatorType.name());
            scenario.getLoadProfile().setTenantDistribution(settings.tenantGroups);
            this.multiTenantTestUtils.testWorkloadWithHandlers(this.properties, model, scenario.getName(), numHandlers, settings.expectedTenantGroups, settings.expectedOpGroups);
        }
    }

    private MultiTenantTestUtils.TestConfigAndExpectations getTestConfigAndExpectations(Scenario scenario, TenantLoadEventGeneratorFactory.GeneratorType generatorType) {
        MultiTenantTestUtils.TestConfigAndExpectations settings = new MultiTenantTestUtils.TestConfigAndExpectations();
        switch (generatorType) {
            case WEIGHTED: {
                settings.tenantGroups = scenario.getLoadProfile().getTenantDistribution();
                settings.expectedOpGroups = scenario.getLoadProfile().getOpDistribution().size();
                settings.expectedTenantGroups = scenario.getLoadProfile().getTenantDistribution().size();
            }
        }
        ArrayList<TenantGroup> tenantGroups = new ArrayList<TenantGroup>();
        TenantGroup tg1 = new TenantGroup();
        tg1.setId("tg1");
        tg1.setNumTenants(10);
        tg1.setWeight(100);
        tenantGroups.add(tg1);
        settings.tenantGroups = tenantGroups;
        settings.expectedTenantGroups = 1;
        settings.expectedOpGroups = scenario.getLoadProfile().getOpDistribution().size();
        return settings;
    }
}

