/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.XMLConfigParserTest;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.generators.WeightedRandomLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.operations.IdleTimeOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.QueryOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.TenantOperationFactory;
import org.apache.phoenix.pherf.workload.mt.operations.UpsertOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.UserDefinedOperationSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantOperationFactoryTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantOperationFactoryTest.class);

    public DataModel readTestDataModel(String resourceName) throws Exception {
        URL scenarioUrl = XMLConfigParserTest.class.getResource(resourceName);
        Assert.assertNotNull((Object)scenarioUrl);
        Path p = Paths.get(scenarioUrl.toURI());
        return XMLConfigParser.readDataModel((Path)p);
    }

    @Test
    public void testVariousOperations() throws Exception {
        int numTenantGroups = 3;
        int numOpGroups = 5;
        int numRuns = 10;
        int numOperations = 10;
        PhoenixUtil pUtil = PhoenixUtil.create();
        Properties properties = PherfConstants.create().getProperties("pherf.properties", false);
        DataModel model = this.readTestDataModel("/scenario/test_evt_gen1.xml");
        for (Scenario scenario : model.getScenarios()) {
            LOGGER.debug(String.format("Testing %s", scenario.getName()));
            LoadProfile loadProfile = scenario.getLoadProfile();
            Assert.assertEquals((String)"tenant group size is not as expected: ", (long)numTenantGroups, (long)loadProfile.getTenantDistribution().size());
            Assert.assertEquals((String)"operation group size is not as expected: ", (long)numOpGroups, (long)loadProfile.getOpDistribution().size());
            WeightedRandomLoadEventGenerator evtGen = new WeightedRandomLoadEventGenerator(pUtil, model, scenario, properties);
            TenantOperationFactory opFactory = evtGen.getOperationFactory();
            Assert.assertEquals((String)"operation group size from the factory is not as expected: ", (long)numOpGroups, (long)opFactory.getOperations().size());
            for (int i = 0; i < numRuns; ++i) {
                int ops = numOperations;
                loadProfile.setNumOperations((long)ops);
                block8: while (ops-- > 0) {
                    TenantOperationInfo info = evtGen.next();
                    switch (TestOperationGroup.valueOf(info.getOperationGroupId())) {
                        case upsertOp: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(UpsertOperationSupplier.class));
                            continue block8;
                        }
                        case queryOp1: 
                        case queryOp2: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(QueryOperationSupplier.class));
                            continue block8;
                        }
                        case idleOp: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(IdleTimeOperationSupplier.class));
                            continue block8;
                        }
                        case udfOp: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(UserDefinedOperationSupplier.class));
                            continue block8;
                        }
                    }
                    Assert.fail();
                }
            }
        }
    }

    private static enum TestOperationGroup {
        upsertOp,
        queryOp1,
        queryOp2,
        idleOp,
        udfOp;

    }

    private static enum TestTenantGroup {
        tg1,
        tg2,
        tg3;

    }
}

