/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt;

import com.lmax.disruptor.LifecycleAware;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.XMLConfigParserTest;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.Workload;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.pherf.workload.mt.MultiTenantWorkload;
import org.apache.phoenix.pherf.workload.mt.generators.BaseLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.LoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantLoadEventGeneratorFactory;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.IdleTimeOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.Operation;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.QueryOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.TenantOperationFactory;
import org.apache.phoenix.pherf.workload.mt.operations.UpsertOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.UserDefinedOperationSupplier;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Supplier;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTenantTestUtils.class);

    public static String getZookeeperFromUrl(String jdbcUrl) {
        jdbcUrl.replaceAll("\\\\:", "=");
        String[] parts = jdbcUrl.split(":");
        return String.join((CharSequence)":", parts[2], parts[3], parts[4]).replaceAll("=", "\\\\:");
    }

    public SchemaReader applySchema(PhoenixUtil util, String matcherSchema) throws Exception {
        PherfConstants constants = PherfConstants.create();
        SchemaReader reader = new SchemaReader(util, matcherSchema);
        reader.applySchema();
        ArrayList resources = new ArrayList(reader.getResourceList());
        Assert.assertTrue((String)"Could not pull list of schema files.", (resources.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Could not read schema file.", (Object)reader.resourceToString((Path)resources.get(0)));
        return reader;
    }

    public DataModel readTestDataModel(String resourceName) throws Exception {
        URL scenarioUrl = XMLConfigParserTest.class.getResource(resourceName);
        Assert.assertNotNull((Object)scenarioUrl);
        Path p = Paths.get(scenarioUrl.toURI());
        return XMLConfigParser.readDataModel((Path)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkloadWithCountingHandlers(Properties properties, DataModel model, String scenarioName, int numHandlers, int expectedTenantGroups, int expectedOpGroups) throws Exception {
        int totalOperations = 500;
        int perHandlerCount = 50;
        ArrayList<MultiTenantWorkload> workloads = new ArrayList<MultiTenantWorkload>();
        WorkloadExecutor workloadExecutor = new WorkloadExecutor(properties, workloads, false);
        try {
            PhoenixUtil pUtil = PhoenixUtil.create();
            for (Scenario scenario : model.getScenarios()) {
                if (scenarioName != null && !scenarioName.isEmpty() && scenario.getName().compareTo(scenarioName) != 0) continue;
                LOGGER.debug(String.format("Testing %s", scenario.getName()));
                LoadProfile loadProfile = scenario.getLoadProfile();
                loadProfile.setNumOperations((long)totalOperations);
                TenantOperationFactory opFactory = new TenantOperationFactory(pUtil, model, scenario);
                Assert.assertEquals((String)"tenant group size is not as expected: ", (long)expectedTenantGroups, (long)loadProfile.getTenantDistribution().size());
                Assert.assertEquals((String)"operation group size from the factory is not as expected: ", (long)expectedOpGroups, (long)opFactory.getOperations().size());
                ArrayList workers = Lists.newArrayList();
                ConcurrentMap latches = Maps.newConcurrentMap();
                for (int i = 0; i < numHandlers; ++i) {
                    String handlerId = String.format("%s.%d", InetAddress.getLocalHost().getHostName(), i);
                    workers.add(new EventCountingWorkHandler(opFactory, handlerId, latches));
                    latches.put(handlerId, new CountDownLatch(perHandlerCount));
                }
                MultiTenantWorkload workload = new MultiTenantWorkload(pUtil, model, scenario, (List)workers, properties);
                workloads.add(workload);
                workloadExecutor.add((Workload)workload);
                workloadExecutor.get();
                for (Map.Entry latch : latches.entrySet()) {
                    Assert.assertTrue((boolean)((CountDownLatch)latch.getValue()).await(60L, TimeUnit.SECONDS));
                }
            }
        }
        finally {
            if (!workloads.isEmpty()) {
                for (Workload workload : workloads) {
                    workload.complete();
                }
            }
            workloadExecutor.complete();
            workloadExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkloadWithHandlers(Properties properties, DataModel model, String scenarioName, int numHandlers, int expectedTenantGroups, int expectedOpGroups) throws Exception {
        int totalOperations = 500;
        ArrayList<MultiTenantWorkload> workloads = new ArrayList<MultiTenantWorkload>();
        WorkloadExecutor workloadExecutor = new WorkloadExecutor(properties, workloads, false);
        try {
            PhoenixUtil pUtil = PhoenixUtil.create();
            for (Scenario scenario : model.getScenarios()) {
                if (scenarioName != null && !scenarioName.isEmpty() && scenario.getName().compareTo(scenarioName) != 0) continue;
                HashMap scenarioProperties = Maps.newHashMap();
                scenarioProperties.put("pherf.mt.handlers_per_scenario", String.valueOf(numHandlers));
                scenario.setPhoenixProperties((Map)scenarioProperties);
                LOGGER.debug(String.format("Testing %s", scenario.getName()));
                LoadProfile loadProfile = scenario.getLoadProfile();
                loadProfile.setNumOperations((long)totalOperations);
                TenantOperationFactory opFactory = new TenantOperationFactory(pUtil, model, scenario);
                Assert.assertEquals((String)"tenant group size is not as expected: ", (long)expectedTenantGroups, (long)loadProfile.getTenantDistribution().size());
                Assert.assertEquals((String)"operation group size from the factory is not as expected: ", (long)expectedOpGroups, (long)opFactory.getOperations().size());
                MultiTenantWorkload workload = new MultiTenantWorkload(pUtil, model, scenario, properties);
                workloads.add(workload);
                workloadExecutor.add((Workload)workload);
                workloadExecutor.get();
            }
        }
        finally {
            if (!workloads.isEmpty()) {
                for (Workload workload : workloads) {
                    workload.complete();
                }
            }
            workloadExecutor.complete();
            workloadExecutor.shutdown();
        }
    }

    public void testVariousOperations(Properties properties, DataModel model, String scenarioName, int expectedTenantGroups, int expectedOpGroups) throws Exception {
        int numRuns = 10;
        int numOperations = 10;
        PhoenixUtil pUtil = PhoenixUtil.create();
        for (Scenario scenario : model.getScenarios()) {
            if (scenarioName != null && !scenarioName.isEmpty() && scenario.getName().compareTo(scenarioName) != 0) continue;
            LOGGER.debug(String.format("Testing %s", scenario.getName()));
            LoadProfile loadProfile = scenario.getLoadProfile();
            Assert.assertEquals((String)"tenant group size is not as expected: ", (long)expectedTenantGroups, (long)loadProfile.getTenantDistribution().size());
            Assert.assertEquals((String)"operation group size is not as expected: ", (long)expectedOpGroups, (long)loadProfile.getOpDistribution().size());
            TenantLoadEventGeneratorFactory eventGenFactory = new TenantLoadEventGeneratorFactory();
            LoadEventGenerator evtGen = eventGenFactory.newLoadEventGenerator(pUtil, model, scenario, properties);
            TenantOperationFactory opFactory = evtGen.getOperationFactory();
            Assert.assertEquals((String)"operation group size from the factory is not as expected: ", (long)expectedOpGroups, (long)opFactory.getOperations().size());
            int numRowsInserted = 0;
            for (int i = 0; i < numRuns; ++i) {
                int ops = numOperations;
                loadProfile.setNumOperations((long)ops);
                block8: while (ops-- > 0) {
                    TenantOperationInfo info = evtGen.next();
                    opFactory.initializeTenant(info);
                    Supplier opSupplier = opFactory.getOperationSupplier(info);
                    OperationStats stats = (OperationStats)((Function)opSupplier.get()).apply((Object)info);
                    LOGGER.info(PhoenixUtil.getGSON().toJson((Object)stats));
                    if (info.getOperation().getType() == Operation.OperationType.PRE_RUN) continue;
                    Assert.assertTrue((stats.getStatus() != -1 ? 1 : 0) != 0);
                    switch (TestOperationGroup.valueOf(info.getOperationGroupId())) {
                        case upsertOp: {
                            Assert.assertTrue((boolean)opSupplier.getClass().isAssignableFrom(UpsertOperationSupplier.class));
                            numRowsInserted = (int)((long)numRowsInserted + stats.getRowCount());
                            continue block8;
                        }
                        case queryOp1: 
                        case queryOp2: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(QueryOperationSupplier.class));
                            Assert.assertTrue((stats.getRowCount() >= 0L ? 1 : 0) != 0);
                            continue block8;
                        }
                        case idleOp: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(IdleTimeOperationSupplier.class));
                            Assert.assertEquals((long)0L, (long)stats.getRowCount());
                            Assert.assertTrue((25L < stats.getDurationInMs() && stats.getDurationInMs() < 75L ? 1 : 0) != 0);
                            continue block8;
                        }
                        case udfOp: {
                            Assert.assertTrue((boolean)opFactory.getOperationSupplier(info).getClass().isAssignableFrom(UserDefinedOperationSupplier.class));
                            Assert.assertEquals((long)0L, (long)stats.getRowCount());
                            continue block8;
                        }
                    }
                    Assert.fail();
                }
            }
        }
    }

    private static class EventCountingWorkHandler
    implements PherfWorkHandler<BaseLoadEventGenerator.TenantOperationEvent>,
    LifecycleAware {
        private final String handlerId;
        private final TenantOperationFactory tenantOperationFactory;
        private final Map<String, CountDownLatch> latches;

        public EventCountingWorkHandler(TenantOperationFactory tenantOperationFactory, String handlerId, Map<String, CountDownLatch> latches) {
            this.handlerId = handlerId;
            this.tenantOperationFactory = tenantOperationFactory;
            this.latches = latches;
        }

        public void onStart() {
        }

        public void onShutdown() {
        }

        public void onEvent(BaseLoadEventGenerator.TenantOperationEvent event) throws Exception {
            TenantOperationInfo input = event.getTenantOperationInfo();
            Supplier opSupplier = this.tenantOperationFactory.getOperationSupplier(input);
            OperationStats stats = (OperationStats)((Function)opSupplier.get()).apply((Object)input);
            LOGGER.info(PhoenixUtil.getGSON().toJson((Object)stats));
            Assert.assertEquals((long)0L, (long)stats.getStatus());
            this.latches.get(this.handlerId).countDown();
        }

        public List<ResultValue<OperationStats>> getResults() {
            return null;
        }
    }

    static enum TestOperationGroup {
        upsertOp,
        queryOp1,
        queryOp2,
        idleOp,
        udfOp;

    }

    public static class TestConfigAndExpectations {
        List<TenantGroup> tenantGroups;
        int expectedTenantGroups;
        int expectedOpGroups;
    }
}

