/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.sql.ResultSet;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.workload.MultiThreadedRunner;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.util.DefaultEnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MultiThreadedRunnerTest {
    @Mock
    private static XMLConfigParser mockParser;
    @Mock
    private static DataModelResult mockDMR;
    @Mock
    private static RulesApplier mockRA;
    @Mock
    private static ThreadTime mockTT;
    @Mock
    private static Scenario mockScenario;
    @Mock
    private static WorkloadExecutor mockWE;
    @Mock
    private static Query mockQuery;
    @Mock
    private static ResultSet mockRS;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testExpectedRowsMismatch() throws Exception {
        Mockito.when((Object)mockQuery.getExpectedAggregateRowCount()).thenReturn((Object)1L);
        MultiThreadedRunner mtr = new MultiThreadedRunner("test", mockQuery, mockDMR, mockTT, 10L, 1000L, true, mockRA, mockScenario, mockWE, mockParser);
        Mockito.when((Object)mockRS.next()).thenReturn((Object)true);
        Mockito.when((Object)mockRS.getLong(1)).thenReturn((Object)2L);
        try {
            mtr.getResults(mockRS, "test_iteration", false, Long.valueOf(0L));
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws Exception {
        Mockito.when((Object)mockQuery.getTimeoutDuration()).thenReturn((Object)1000L);
        Mockito.when((Object)mockQuery.getExpectedAggregateRowCount()).thenReturn((Object)1L);
        MultiThreadedRunner mtr = new MultiThreadedRunner("test", mockQuery, mockDMR, mockTT, 10L, 1000L, true, mockRA, mockScenario, mockWE, mockParser);
        DefaultEnvironmentEdge myClock = (DefaultEnvironmentEdge)Mockito.mock(DefaultEnvironmentEdge.class);
        Mockito.when((Object)myClock.currentTime()).thenReturn((Object)0L, (Object[])new Long[]{5000L});
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)myClock);
        try {
            Mockito.when((Object)mockRS.next()).thenReturn((Object)true);
            Mockito.when((Object)mockRS.getLong(1)).thenReturn((Object)1L);
            Pair results = mtr.getResults(mockRS, "test_iteration", false, Long.valueOf(0L));
            Assert.assertTrue(((Long)results.getSecond() > mockQuery.getTimeoutDuration() ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinishWithoutTimeout() throws Exception {
        DefaultEnvironmentEdge myClock = (DefaultEnvironmentEdge)Mockito.mock(DefaultEnvironmentEdge.class);
        Mockito.when((Object)myClock.currentTime()).thenReturn((Object)0L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)myClock);
        try {
            Mockito.when((Object)mockQuery.getTimeoutDuration()).thenReturn((Object)1000L);
            Mockito.when((Object)mockQuery.getExpectedAggregateRowCount()).thenReturn((Object)1L);
            MultiThreadedRunner mtr = new MultiThreadedRunner("test", mockQuery, mockDMR, mockTT, 10L, 1000L, true, mockRA, mockScenario, mockWE, mockParser);
            Mockito.when((Object)mockRS.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)mockRS.getLong(1)).thenReturn((Object)1L);
            Pair results = mtr.getResults(mockRS, "test_iteration", false, Long.valueOf(0L));
            Assert.assertFalse(((Long)results.getSecond() > mockQuery.getTimeoutDuration() ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }
}

