/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.SequentialIntegerDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SequentialIntegerDataGeneratorTest {
    SequentialIntegerDataGenerator generator;

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonSequential() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.INTEGER);
        columnA.setDataSequence(DataSequence.RANDOM);
        this.generator = new SequentialIntegerDataGenerator(columnA);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonInteger() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.VARCHAR);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        this.generator = new SequentialIntegerDataGenerator(columnA);
    }

    @Test
    public void testGetDataValue() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.INTEGER);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        columnA.setMinValue(1L);
        columnA.setMaxValue(3L);
        this.generator = new SequentialIntegerDataGenerator(columnA);
        DataValue result1 = this.generator.getDataValue();
        Assert.assertEquals((Object)"1", (Object)result1.getValue());
        DataValue result2 = this.generator.getDataValue();
        Assert.assertEquals((Object)"2", (Object)result2.getValue());
        DataValue result3 = this.generator.getDataValue();
        Assert.assertEquals((Object)"3", (Object)result3.getValue());
        DataValue result4 = this.generator.getDataValue();
        Assert.assertEquals((Object)"1", (Object)result4.getValue());
    }
}

