/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.UnmarshalException;
import javax.xml.stream.XMLStreamException;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLConfigParserTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLConfigParserTest.class);

    @Test
    public void testDTDInScenario() throws Exception {
        URL scenarioUrl = XMLConfigParserTest.class.getResource("/scenario/malicious_scenario_with_dtd.xml");
        Assert.assertNotNull((Object)scenarioUrl);
        Path p = Paths.get(scenarioUrl.toURI());
        try {
            XMLConfigParser.readDataModel((Path)p);
            Assert.fail((String)"The scenario should have failed to parse because it contains a DTD");
        }
        catch (UnmarshalException e) {
            LOGGER.warn("Caught expected exception", (Throwable)e);
            Throwable cause = e.getLinkedException();
            Assert.assertTrue((String)("Cause was a " + cause.getClass()), (boolean)(cause instanceof XMLStreamException));
        }
    }
}

