/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.workload.WriteWorkload;
import org.junit.Assert;
import org.junit.Test;

public class RuleGeneratorTest {
    private static final String matcherScenario = PherfConstants.TEST_SCENARIO_ROOT_PATTERN + ".xml";

    @Test
    public void testDateGenerator() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        for (Column dataMapping : model.getDataMappingColumns()) {
            if (dataMapping.getType() != DataTypeMapping.DATE || !dataMapping.getName().equals("SOME_DATE")) continue;
            this.assertRandomDateValue(dataMapping, rulesApplier);
            for (int i = 0; i < 20; ++i) {
                DataValue value = rulesApplier.getDataValue(dataMapping);
                Assert.assertNotNull((String)"Could not retrieve DataValue for random DATE.", (Object)value);
                Assert.assertNotNull((String)"Could not retrieve a value in DataValue for random DATE.", (Object)value.getValue());
                if (value.getMinValue() == null) continue;
                this.assertDateBetween(value);
            }
        }
    }

    @Test
    public void testCurrentDateGenerator() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        String timeStamp1 = rulesApplier.getCurrentDate();
        this.sleep(2);
        for (Column dataMapping : model.getDataMappingColumns()) {
            if (dataMapping.getType() == DataTypeMapping.DATE && dataMapping.getUseCurrentDate() && dataMapping.getDataSequence() != DataSequence.SEQUENTIAL) {
                DataValue value = rulesApplier.getDataValue(dataMapping);
                Assert.assertNotNull((String)"Could not retrieve DataValue for random DATE.", (Object)value);
                Assert.assertNotNull((String)"Could not retrieve a value in DataValue for random DATE.", (Object)value.getValue());
                this.sleep(2);
                String timeStamp2 = rulesApplier.getCurrentDate();
                value.setMinValue(timeStamp1);
                value.setMaxValue(timeStamp2);
                this.assertDateBetween(value);
            }
            if (dataMapping.getType() != DataTypeMapping.DATE || !dataMapping.getName().equals("PRESENT_DATE")) continue;
            for (int i = 0; i < 1; ++i) {
                DataValue value = rulesApplier.getDataValue(dataMapping);
                Assert.assertNotNull((String)"Could not retrieve DataValue for random DATE.", (Object)value);
                Assert.assertNotNull((String)"Could not retrieve a value in DataValue for random DATE.", (Object)value.getValue());
                this.sleep(2);
                String timeStamp2 = rulesApplier.getCurrentDate();
                value.setMinValue(timeStamp1);
                value.setMaxValue(timeStamp2);
                this.assertDateBetween(value);
            }
        }
    }

    @Test
    public void testNullChance() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        int sampleSize = 100;
        ArrayList<String> values = new ArrayList<String>(sampleSize);
        for (Column dataMapping : model.getDataMappingColumns()) {
            DataValue value = rulesApplier.getDataValue(dataMapping);
            if (dataMapping.getNullChance() == 0) {
                Assert.assertFalse((String)"", (boolean)value.getValue().equals(""));
                continue;
            }
            if (dataMapping.getNullChance() == 100) {
                Assert.assertTrue((String)"", (boolean)value.getValue().equals(""));
                continue;
            }
            if (dataMapping.getNullChance() != 90) continue;
            for (int i = 0; i < sampleSize; ++i) {
                DataValue tVal = rulesApplier.getDataValue(dataMapping);
                values.add(tVal.getValue());
            }
            Collections.sort(values);
        }
    }

    @Test
    public void testSequentialDataSequence() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Column targetColumn = null;
        for (Column column : model.getDataMappingColumns()) {
            DataSequence sequence = column.getDataSequence();
            if (DataTypeMapping.INTEGER.equals((Object)column.getType()) || sequence != DataSequence.SEQUENTIAL) continue;
            targetColumn = column;
            break;
        }
        Assert.assertNotNull((String)"Could not find a DataSequence.SEQENTIAL rule.", targetColumn);
        this.assertMultiThreadedIncrementValue(targetColumn, rulesApplier);
    }

    @Test
    public void testSequentialIntegerDataSequence() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Column targetColumn = null;
        for (Column column : model.getDataMappingColumns()) {
            DataSequence sequence = column.getDataSequence();
            if (!DataTypeMapping.INTEGER.equals((Object)column.getType()) || sequence != DataSequence.SEQUENTIAL) continue;
            targetColumn = column;
            break;
        }
        Assert.assertNotNull((String)"Could not find a DataSequence.SEQENTIAL rule.", targetColumn);
        this.assertMultiThreadedIncrementValue(targetColumn, rulesApplier);
    }

    private void assertRandomDateValue(Column dataMapping, RulesApplier rulesApplier) throws Exception {
        List dataValues = dataMapping.getDataValues();
        DataValue ruleValue = (DataValue)dataValues.get(2);
        String dt = rulesApplier.generateRandomDate(ruleValue.getMinValue(), ruleValue.getMaxValue());
        ruleValue.setValue(dt);
        this.assertDateBetween(ruleValue);
    }

    private void assertMultiThreadedIncrementValue(final Column column, final RulesApplier rulesApplier) throws Exception {
        int threadCount = 30;
        int increments = 100;
        final TreeSet testSet = new TreeSet();
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 30; ++i) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (int i = 0; i < 100; ++i) {
                        try {
                            Set set = testSet;
                            synchronized (set) {
                                DataValue value = rulesApplier.getDataValue(column);
                                String strValue = value.getValue();
                                Assert.assertFalse((String)("Incrementer gave a duplicate value: " + strValue), (boolean)testSet.contains(strValue));
                                if (DataTypeMapping.INTEGER.equals((Object)column.getType())) {
                                    Assert.assertEquals((long)(testSet.size() + 1), (long)Long.valueOf(strValue));
                                } else {
                                    Assert.assertTrue((String)"Length did not equal expected.", (strValue.length() == column.getLength() ? 1 : 0) != 0);
                                }
                                testSet.add(strValue);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            Assert.fail((String)("Caught an exception during test: " + e.getMessage()));
                        }
                    }
                }
            };
            t.start();
            threadList.add(t);
        }
        for (Thread t : threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)("There was a problem reading thread: " + e.getMessage()));
            }
        }
        Assert.assertTrue((String)"Expected count in increments did not match expected", (testSet.size() == 3000 ? 1 : 0) != 0);
    }

    @Test
    public void testTimestampRule() throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Scenario scenario = (Scenario)parser.getScenarios().get(0);
        Column simPhxCol = new Column();
        simPhxCol.setName("TS_DATE");
        simPhxCol.setType(DataTypeMapping.TIMESTAMP);
        for (int i = 0; i < 10; ++i) {
            DataValue value = rulesApplier.getDataForRule(scenario, simPhxCol);
            Date dt = simpleDateFormat.parse(value.getValue());
            int year = Integer.parseInt(df.format(dt));
            Assert.assertTrue((String)("Got unexpected TS value" + value.getValue()), (year >= 2020 && year <= 2025 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVarcharArray() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        for (int i = 0; i < 15; ++i) {
            Column c = rulesApplier.getRule("VAR_ARRAY");
            DataValue value = rulesApplier.getDataValue(c);
            Assert.assertTrue((String)("Got a value not in the list for the rule. :" + value.getValue()), (boolean)value.getValue().equals("Foo,Bar"));
        }
    }

    @Test
    public void testVarBinary() throws Exception {
        ArrayList<CallSite> expectedValues = new ArrayList<CallSite>();
        for (int i = 0; i < 10; ++i) {
            expectedValues.add((CallSite)((Object)("VBOxx00" + i)));
        }
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        for (int i = 0; i < 5; ++i) {
            Column c = rulesApplier.getRule("VAR_BIN");
            DataValue value = rulesApplier.getDataValue(c);
            System.out.println(value.getValue());
            Assert.assertTrue((String)("Got a value not in the list for the rule. :" + value.getValue()), (boolean)expectedValues.contains(value.getValue()));
        }
    }

    @Test
    public void testPrefixSequence() throws Exception {
        ArrayList<String> expectedValues = new ArrayList<String>();
        expectedValues.add("0F90000000000X0");
        expectedValues.add("0F90000000000X1");
        expectedValues.add("0F90000000000X2");
        expectedValues.add("0F90000000000X3");
        expectedValues.add("0F90000000000X4");
        expectedValues.add("0F90000000000X5");
        expectedValues.add("0F90000000000X6");
        expectedValues.add("0F90000000000X7");
        expectedValues.add("0F90000000000X8");
        expectedValues.add("0F90000000000X9");
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        for (int i = 0; i < 15; ++i) {
            DataValue value = rulesApplier.getDataValue(rulesApplier.getRule("NEWVAL_STRING"));
            Assert.assertTrue((String)("Got a value not in the list for the rule. :" + value.getValue()), (boolean)expectedValues.contains(value.getValue()));
        }
    }

    @Test
    public void testValueListRule() throws Exception {
        ArrayList<String> expectedValues = new ArrayList<String>();
        expectedValues.add("aAAyYhnNbBs9kWk");
        expectedValues.add("bBByYhnNbBs9kWu");
        expectedValues.add("cCCyYhnNbBs9kWr");
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Scenario scenario = (Scenario)parser.getScenarios().get(0);
        Column simPhxCol = new Column();
        simPhxCol.setName("PARENT_ID");
        simPhxCol.setType(DataTypeMapping.CHAR);
        for (int i = 0; i < 10; ++i) {
            DataValue value = rulesApplier.getDataForRule(scenario, simPhxCol);
            Assert.assertTrue((String)("Got a value not in the list for the rule. :" + value.getValue()), (boolean)expectedValues.contains(value.getValue()));
        }
    }

    @Test
    public void testRuleOverrides() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Scenario scenario = (Scenario)parser.getScenarios().get(0);
        Column simPhxCol = new Column();
        simPhxCol.setName("OTHER_ID");
        simPhxCol.setType(DataTypeMapping.CHAR);
        Column rule = rulesApplier.getRule(simPhxCol);
        Assert.assertEquals((String)"Did not find the correct rule.", (Object)rule.getName(), (Object)simPhxCol.getName());
        Assert.assertEquals((String)"Did not find the matching rule type.", (Object)rule.getType(), (Object)simPhxCol.getType());
        Assert.assertEquals((String)"Rule contains incorrect length.", (long)rule.getLength(), (long)8L);
        Assert.assertEquals((String)"Rule contains incorrect prefix.", (Object)rule.getPrefix(), (Object)"z0Oxx00");
        DataValue value = rulesApplier.getDataForRule(scenario, simPhxCol);
        Assert.assertEquals((String)"Value returned does not match rule.", (long)value.getValue().length(), (long)8L);
        simPhxCol.setName("OLDVAL_STRING");
        simPhxCol.setType(DataTypeMapping.VARCHAR);
        rule = rulesApplier.getRule(simPhxCol);
        Assert.assertEquals((String)"Did not find the correct rule.", (Object)rule.getName(), (Object)simPhxCol.getName());
        Assert.assertEquals((String)"Did not find the matching rule type.", (Object)rule.getType(), (Object)simPhxCol.getType());
        Assert.assertEquals((String)"Rule contains incorrect length.", (long)rule.getLength(), (long)10L);
        Assert.assertEquals((String)"Rule contains incorrect prefix.", (Object)rule.getPrefix(), (Object)"MYPRFX");
        value = rulesApplier.getDataForRule(scenario, simPhxCol);
        Assert.assertEquals((String)"Value returned does not match rule.", (long)10L, (long)value.getValue().length());
        Assert.assertTrue((String)("Value returned start with prefix. " + value.getValue()), (boolean)StringUtils.startsWith((CharSequence)value.getValue(), (CharSequence)rule.getPrefix()));
    }

    @Test
    public void testScenarioLevelRuleOverride() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        WriteWorkload loader = new WriteWorkload(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Scenario scenario = (Scenario)parser.getScenarios().get(0);
        Column simPhxCol = new Column();
        simPhxCol.setName("FIELD");
        simPhxCol.setType(DataTypeMapping.VARCHAR);
        DataValue value = rulesApplier.getDataForRule(scenario, simPhxCol);
        Assert.assertEquals((String)"Override rule should contain field length of 5", (long)5L, (long)value.getValue().length());
    }

    private void assertDateBetween(DataValue value) {
        DateTimeFormatter fmtr = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.of("UTC"));
        Instant dt = ZonedDateTime.parse(value.getValue(), fmtr).toInstant();
        Instant min = ZonedDateTime.parse(value.getMinValue(), fmtr).toInstant();
        Instant max = ZonedDateTime.parse(value.getMaxValue(), fmtr).toInstant();
        Assert.assertTrue((String)("Value " + dt + " is not after minValue"), (boolean)dt.isAfter(min));
        Assert.assertTrue((String)("Value " + dt + " is not before maxValue"), (boolean)dt.isBefore(max));
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

