/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.MultiTenantTestUtils;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class ResultBaseTestIT
extends ParallelStatsDisabledIT {
    protected static final String matcherScenario = ".*scenario/.*test_scenario.xml";
    protected static final String matcherSchema = ".*datamodel/.*test_schema.sql";
    protected static PhoenixUtil util = PhoenixUtil.create((boolean)true);
    protected static Properties properties;
    protected static SchemaReader reader;
    protected static XMLConfigParser parser;
    protected static List<Path> resources;
    protected static ResultUtil resultUtil;

    protected static Configuration getTestClusterConfig() {
        return new Configuration(config);
    }

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        PherfConstants constants = PherfConstants.create();
        properties = constants.getProperties("pherf.properties", false);
        String dir = properties.getProperty("pherf.default.results.dir");
        resultUtil.ensureBaseDirExists(dir);
        reader = new SchemaReader(util, matcherSchema);
        parser = new XMLConfigParser(matcherScenario);
        ResultBaseTestIT.setUpTestDriver((ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS);
        PhoenixUtil.setZookeeper((String)MultiTenantTestUtils.getZookeeperFromUrl(url));
    }

    @AfterClass
    public static synchronized void tearDown() throws Exception {
        ResultBaseTestIT.dropNonSystemTables();
        resultUtil.deleteDir(properties.getProperty("pherf.default.results.dir"));
    }

    @After
    public void cleanUpAfterTest() throws Exception {
        ResultBaseTestIT.deletePriorMetaData((long)Long.MAX_VALUE, (String)ResultBaseTestIT.getUrl());
    }

    static {
        resultUtil = new ResultUtil();
    }
}

