/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import com.jcabi.jdbc.JdbcSession;
import com.jcabi.jdbc.Outcome;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.ResultBaseTestIT;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.QueryExecutor;
import org.apache.phoenix.pherf.workload.Workload;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.pherf.workload.WriteWorkload;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class DataIngestIT
extends ResultBaseTestIT {
    private Properties properties;

    @Before
    public void applySchema() throws Exception {
        reader.applySchema();
        resources = new ArrayList(reader.getResourceList());
        Assert.assertTrue((String)"Could not pull list of schema files.", (resources.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Could not read schema file.", (Object)reader.resourceToString((Path)resources.get(0)));
        this.properties = PherfConstants.create().getProperties("pherf.properties", true);
    }

    @Test
    public void testColumnRulesApplied() {
        Scenario scenario = null;
        try {
            scenario = parser.getScenarioByName("testScenario");
            List columnListFromPhoenix = util.getColumnsFromPhoenix(scenario.getSchemaName(), scenario.getTableNameWithoutSchemaName(), util.getConnection());
            Assert.assertTrue((String)"Could not get phoenix columns.", (columnListFromPhoenix.size() > 0 ? 1 : 0) != 0);
            WriteWorkload loader = new WriteWorkload(util, parser, this.properties, scenario, PherfConstants.GeneratePhoenixStats.NO);
            WorkloadExecutor executor = new WorkloadExecutor();
            executor.add((Workload)loader);
            executor.get();
            executor.shutdown();
            RulesApplier rulesApplier = loader.getRulesApplier();
            List modelList = rulesApplier.getModelList();
            Assert.assertTrue((String)"Could not generate the modelList", (modelList.size() > 0 ? 1 : 0) != 0);
            for (Column column : columnListFromPhoenix) {
                DataValue data = rulesApplier.getDataForRule(scenario, column);
                Assert.assertTrue((String)("Failed to retrieve data for column type: " + column.getType()), (data != null ? 1 : 0) != 0);
                if (column.getType() != DataTypeMapping.VARCHAR || !column.getName().equals("NEWVAL_STRING")) continue;
                Assert.assertTrue((String)"Failed to retrieve data for column type: ", (data.getDistribution() == Integer.MIN_VALUE ? 1 : 0) != 0);
            }
            this.assertExpectedNumberOfRecordsWritten(scenario);
            executor = new WorkloadExecutor();
            QueryExecutor query = new QueryExecutor(parser, util, executor);
            executor.add((Workload)query);
            executor.get();
            executor.shutdown();
            PhoenixUtil.create().deleteTables("ALL");
        }
        catch (Exception e) {
            Assert.fail((String)("We had an exception: " + e.getMessage()));
        }
    }

    @Test
    public void testPreAndPostDataLoadDdls() throws Exception {
        Scenario scenario = parser.getScenarioByName("testPreAndPostDdls");
        WorkloadExecutor executor = new WorkloadExecutor();
        executor.add((Workload)new WriteWorkload(util, parser, this.properties, scenario, PherfConstants.GeneratePhoenixStats.NO));
        try {
            executor.get();
            executor.shutdown();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to load data. An exception was thrown: " + e.getMessage()));
        }
        this.assertExpectedNumberOfRecordsWritten(scenario);
    }

    @Test
    public void testRWWorkload() throws Exception {
        Connection connection = util.getConnection();
        WorkloadExecutor executor = new WorkloadExecutor();
        DataModel dataModel = parser.getDataModelByName("test_scenario");
        ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
        dataModels.add(dataModel);
        QueryExecutor qe = new QueryExecutor(parser, util, executor, dataModels, null, false);
        executor.add((Workload)qe);
        Scenario scenario = parser.getScenarioByName("testScenarioRW");
        String sql = "select count(*) from " + scenario.getTableName();
        try {
            executor.get();
            executor.shutdown();
            Integer count = (Integer)new JdbcSession(connection).sql(sql).select((Outcome)new Outcome<Integer>(){

                public Integer handle(ResultSet resultSet, Statement statement) throws SQLException {
                    if (resultSet.next()) {
                        return resultSet.getInt(1);
                    }
                    return null;
                }
            });
            Assert.assertNotNull((Object)("Could not retrieve count. " + count));
            Assert.assertTrue((String)("Could not query any rows for in " + scenario.getTableName()), (count > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to load data. An exception was thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testMultiTenantViewWriteWorkload() throws Exception {
        Scenario scenario = parser.getScenarioByName("testMTWriteScenario");
        WorkloadExecutor executor = new WorkloadExecutor();
        executor.add((Workload)new WriteWorkload(util, parser, this.properties, scenario, PherfConstants.GeneratePhoenixStats.NO));
        try {
            executor.get();
            executor.shutdown();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to load data. An exception was thrown: " + e.getMessage()));
        }
        this.assertExpectedNumberOfRecordsWritten(scenario);
    }

    @Test
    public void testMultiTenantScenarioRunBeforeWriteWorkload() throws Exception {
        Scenario scenario = parser.getScenarioByName("testMTDdlWriteScenario");
        WorkloadExecutor executor = new WorkloadExecutor();
        executor.add((Workload)new WriteWorkload(util, parser, this.properties, scenario, PherfConstants.GeneratePhoenixStats.NO));
        try {
            executor.get();
            executor.shutdown();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to load data. An exception was thrown: " + e.getMessage()));
        }
        this.assertExpectedNumberOfRecordsWritten(scenario);
    }

    private void assertExpectedNumberOfRecordsWritten(Scenario scenario) throws Exception {
        Connection connection = util.getConnection(scenario.getTenantId());
        String sql = "select count(*) from " + scenario.getTableName();
        Integer count = (Integer)new JdbcSession(connection).sql(sql).select((Outcome)new Outcome<Integer>(){

            public Integer handle(ResultSet resultSet, Statement statement) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getInt(1);
                }
                return null;
            }
        });
        Assert.assertNotNull((String)"Could not retrieve count. ", (Object)count);
        Assert.assertEquals((String)"Expected 100 rows to have been inserted", (long)scenario.getRowCount(), (long)count.intValue());
    }
}

