/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.csv;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.csv.StringToArrayConverter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToArrayConverterTest
extends BaseConnectionlessQueryTest {
    private Connection conn;
    private StringToArrayConverter converter;

    @Before
    public void setUp() throws SQLException {
        this.conn = DriverManager.getConnection(StringToArrayConverterTest.getUrl());
        this.converter = new StringToArrayConverter(this.conn, ":", (PDataType)PVarchar.INSTANCE);
    }

    @After
    public void tearDown() throws SQLException {
        this.conn.close();
    }

    @Test
    public void testToArray_EmptyString() throws SQLException {
        Array emptyArray = this.converter.toArray("");
        Assert.assertEquals((long)0L, (long)((Object[])emptyArray.getArray()).length);
    }

    @Test
    public void testToArray_SingleElement() throws SQLException {
        Array singleElementArray = this.converter.toArray("value");
        Assert.assertArrayEquals((Object[])new Object[]{"value"}, (Object[])((Object[])singleElementArray.getArray()));
    }

    @Test
    public void testToArray_MultipleElements() throws SQLException {
        Array multiElementArray = this.converter.toArray("one:two");
        Assert.assertArrayEquals((Object[])new Object[]{"one", "two"}, (Object[])((Object[])multiElementArray.getArray()));
    }

    @Test
    public void testToArray_IntegerValues() throws SQLException {
        StringToArrayConverter intArrayConverter = new StringToArrayConverter(this.conn, ":", (PDataType)PInteger.INSTANCE);
        Array intArray = intArrayConverter.toArray("1:2:3");
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])((int[])intArray.getArray()));
    }
}

