/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.bson;

import java.util.ArrayList;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.util.bson.BsonConditionInvalidArgumentException;
import org.apache.phoenix.expression.util.bson.DocumentComparisonExpressionUtils;
import org.apache.phoenix.expression.util.bson.SQLComparisonExpressionUtils;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Test;

public class ComparisonExpressionUtilsTest {
    @Test
    public void testSQLComparisonExpression1() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getDocumentValue();
        RawBsonDocument compareValues = ComparisonExpressionUtilsTest.getCompareValDocument();
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"(field_exists(Id) OR field_not_exists(Title))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(Id) AND field_not_exists(Title1)) OR field_exists(ISBN2)) OR ((Id <> #Title) AND ((InPublication = InPublication) OR ((ISBN = :ISBN) AND (Title = #Title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_exists(NestedMap1.ISBN) AND field_not_exists(NestedMap1.NList1[3])))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedMap1.Id = $Id AND (NestedMap1.InPublication = InPublication)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((attribute_exists(0) AND attribute_exists(1)) AND attribute_not_exists(#3)) AND (((attribute_not_exists(0) AND attribute_not_exists(1)) OR attribute_exists(#0)) OR (#_ = :0))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((NestedMap1.Id = $Id) AND ((NestedMap1.InPublication[0] = InPublication) OR ((ISBN[0] = :ISBN) AND (Title = #Title))) OR (NestedMap1.NList1[0] = #NMap1_NList1))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(Id) AND field_not_exists(Title1)) OR field_exists(ISBN2)) OR ((NestedMap1.Id = $Id) AND ((NestedMap1.InPublication = InPublication) OR ((ISBN = :ISBN) AND (Title = #Title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] <= $NestedList1_485 AND NestedList1[1] > #NestedList1_1 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id < $Id1 AND IdS < $Ids1 AND Id2 > $Id2 AND NestedMap1.NList1[2] > #NestedMap1_NList1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] <= $NestedList1_485 AND NestedList1[1] >= #NestedList1_1 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id <= $Id1 AND IdS <= $Ids1 AND Id2 >= $Id2 AND NestedMap1.NList1[2] >= #NestedMap1_NList1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] < #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id > $Id10 AND IdS > $Ids10 AND Id2 < $Id20 AND NestedMap1.NList1[2] < $NestedMap1_NList1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id >= $Id10 AND IdS >= $Ids10 AND Id2 <= $Id20 AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND NestedMap1.NList1[2] <> $NestedMap1_NList1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id >= $Id10 AND IdS >= $Ids10 AND Id2 <= $Id20 AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND (NestedMap1.NList1[2] = $NestedMap1_NList1_30 OR NestedList1[0] BETWEEN $NestedList1_4850 AND $Id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedMap1.NList1[0] IN ($Id, $Id1, $Id20, #NMap1_NList1) AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND (NestedMap1.NList1[2] = $NestedMap1_NList1_30 OR NestedList1[0] BETWEEN $NestedList1_4850 AND $Id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedMap1.NList1[0] IN ($Id,  $Id1, $Id20, #NMap1_NList1) AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND (NestedMap1.NList1[2] = $NestedMap1_NList1_30 OR  NestedList1[0] BETWEEN $NestedList1_4850 AND $Id2) AND NOT NestedMap1.InPublication IN ($Id, $Id1, $Id20, $Id21)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
    }

    @Test
    public void testSQLComparisonExpression2() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getDocumentValue();
        RawBsonDocument compareValues = ComparisonExpressionUtilsTest.getCompareValDocument();
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"(field_not_exists(Id) OR field_not_exists(Title))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(Id) AND field_not_exists(Title1)) OR field_exists(ISBN2)) OR ((Id = #Title) AND ((InPublication = InPublication) OR ((ISBN = :ISBN) AND (Title = #Title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_exists(NestedMap1.ISBN) AND field_exists(NestedMap1.NList1[3])))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedMap1.Id = $Id AND (NestedMap1.InPublication <> InPublication)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((NestedMap1.Id = $Id) AND ((NestedMap1.InPublication[0] = InPublication) OR ((ISBN[0] = :ISBN) AND (Title = #Title))) OR (NestedMap1.NList1[0] <> #NMap1_NList1))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(Id) AND field_not_exists(Title1)) OR field_exists(ISBN2)) OR ((NestedMap1.Id = $Id) AND ((NestedMap1.InPublication <> InPublication) OR NOT ((ISBN = :ISBN) AND (Title = #Title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] <= $NestedList1_485 AND NestedList1[1] > #NestedList1_1 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id < $Id1 AND IdS < $Ids1 AND Id2 > $Id2 AND NestedMap1.NList1[2] < #NestedMap1_NList1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] <= $NestedList1_485 AND NestedList1[1] >= #NestedList1_1 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id <= $Id1 AND IdS <= $Ids1 AND Id2 >= $Id2 AND NestedMap1.NList1[2] < #NestedMap1_NList1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] < #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id > $Id10 AND IdS > $Ids10 AND Id2 < $Id20 AND NestedMap1.NList1[2] >= $NestedMap1_NList1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id >= $Id10 AND IdS >= $Ids10 AND Id2 <= $Id20 AND NestedMap1.NList1[2] > $NestedMap1_NList1_30 AND NestedMap1.NList1[2] <> $NestedMap1_NList1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedList1[2][1].Id >= $Id10 AND IdS >= $Ids10 AND Id2 <= $Id20 AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND (NestedMap1.NList1[2] = $NestedMap1_NList1_30 OR NOT NestedList1[0] BETWEEN $NestedList1_4850 AND $Id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedMap1.NList1[0] NOT IN ($Id, $Id1, $Id20, #NMap1_NList1) AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND (NestedMap1.NList1[2] = $NestedMap1_NList1_30 OR NestedList1[0] BETWEEN $NestedList1_4850 AND $Id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NestedList1[0] >= $NestedList1_4850 AND NestedList1[1] <= #NestedList1_10 AND NestedList1[2][0] >= #NestedList1_xyz0123 AND NestedMap1.NList1[0] IN ($Id,  $Id1, $Id20, #NMap1_NList1) AND NestedMap1.NList1[2] <= $NestedMap1_NList1_30 AND (NestedMap1.NList1[2] <> $NestedMap1_NList1_30 OR NestedList1[0] NOT BETWEEN $NestedList1_4850 AND $Id2) AND NOT NestedMap1.InPublication IN ($Id, $Id1, $Id20, $Id21)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
    }

    @Test
    public void testDocumentComparisonExpression1() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getDocumentValue();
        BsonDocument expressionDocument = new BsonDocument();
        ArrayList<BsonDocument> orList = new ArrayList<BsonDocument>();
        orList.add(new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        orList.add(new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        expressionDocument.append("$or", (BsonValue)new BsonArray(orList));
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        BsonArray orListArray = new BsonArray();
        BsonArray orList1 = new BsonArray();
        BsonDocument orDoc1 = new BsonDocument();
        BsonDocument andDoc1 = new BsonDocument();
        BsonArray andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andList1.add((BsonValue)new BsonDocument().append("Title1", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andDoc1.append("$and", (BsonValue)andList1);
        orList1.add((BsonValue)andDoc1);
        orList1.add((BsonValue)new BsonDocument().append("ISBN2", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        orDoc1.append("$or", (BsonValue)orList1);
        orListArray.add((BsonValue)orDoc1);
        BsonArray andList2 = new BsonArray();
        BsonDocument andDoc2 = new BsonDocument();
        andList2.add((BsonValue)new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonString("Book 101 Title"))));
        BsonArray orList2 = new BsonArray();
        BsonDocument orDoc2 = new BsonDocument();
        orList2.add((BsonValue)new BsonDocument().append("InPublication", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonBoolean(false))));
        BsonArray andList3 = new BsonArray();
        BsonDocument andDoc3 = new BsonDocument();
        andList3.add((BsonValue)new BsonDocument().append("ISBN", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("111-1111111111"))));
        andList3.add((BsonValue)new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        andDoc3.append("$and", (BsonValue)andList3);
        orList2.add((BsonValue)andDoc3);
        orDoc2.append("$or", (BsonValue)orList2);
        andList2.add((BsonValue)orDoc2);
        andDoc2.append("$and", (BsonValue)andList2);
        orListArray.add((BsonValue)andDoc2);
        expressionDocument.append("$or", (BsonValue)orListArray);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.ISBN", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[3]", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonDouble(101.01))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.InPublication", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonBoolean(false))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andDoc1 = new BsonDocument();
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonDouble(101.01))));
        orList1 = new BsonArray();
        orDoc1 = new BsonDocument();
        orList1.add((BsonValue)new BsonDocument().append("NestedMap1.InPublication[0]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonBoolean(false))));
        andList2 = new BsonArray();
        andDoc2 = new BsonDocument();
        andList2.add((BsonValue)new BsonDocument().append("ISBN[0]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("111-1111111111"))));
        andList2.add((BsonValue)new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        andDoc2.append("$and", (BsonValue)andList2);
        orList1.add((BsonValue)andDoc2);
        orDoc1.append("$or", (BsonValue)orList1);
        andList1.add((BsonValue)orDoc1);
        andDoc1.append("$and", (BsonValue)andList1);
        orList2 = new BsonArray();
        orDoc2 = new BsonDocument();
        orList2.add((BsonValue)andDoc1);
        orList2.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[0]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("NListVal01"))));
        expressionDocument.append("$or", (BsonValue)orList2);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        orListArray = new BsonArray();
        andList1 = new BsonArray();
        andDoc1 = new BsonDocument();
        andList1.add((BsonValue)new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andList1.add((BsonValue)new BsonDocument().append("Title1", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andDoc1.append("$and", (BsonValue)andList1);
        orList1 = new BsonArray();
        orDoc1 = new BsonDocument();
        orList1.add((BsonValue)andDoc1);
        orList1.add((BsonValue)new BsonDocument().append("ISBN2", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        orDoc1.append("$or", (BsonValue)orList1);
        orListArray.add((BsonValue)orDoc1);
        andList2 = new BsonArray();
        andDoc2 = new BsonDocument();
        andList2.add((BsonValue)new BsonDocument().append("NestedMap1.Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonDouble(101.01))));
        orList2 = new BsonArray();
        orDoc2 = new BsonDocument();
        orList2.add((BsonValue)new BsonDocument().append("NestedMap1.InPublication", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonBoolean(false))));
        andList3 = new BsonArray();
        andDoc3 = new BsonDocument();
        andList3.add((BsonValue)new BsonDocument().append("ISBN", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("111-1111111111"))));
        andList3.add((BsonValue)new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        andDoc3.append("$and", (BsonValue)andList3);
        orList2.add((BsonValue)andDoc3);
        orDoc2.append("$or", (BsonValue)orList2);
        andList2.add((BsonValue)orDoc2);
        andDoc2.append("$and", (BsonValue)andList2);
        orListArray.add((BsonValue)andDoc2);
        expressionDocument.append("$or", (BsonValue)orListArray);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonDouble(-485.33))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonString("1234abcc"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonInt32(120))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonString("12"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonInt32(12))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whit")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonDouble(-485.33))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("1234abcc"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonInt32(120))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonString("12"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonInt32(12))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whit")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonDouble(-485.35))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonString("1234abce"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonInt64(101L))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonString("100"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonDouble(101.011))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonDouble(-485.35))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonString("1234abce"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonInt64(101L))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("100"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonDouble(101.011))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertTrue((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
    }

    @Test
    public void testDocumentComparisonExpression2() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getDocumentValue();
        BsonDocument expressionDocument = new BsonDocument();
        ArrayList<BsonDocument> orList = new ArrayList<BsonDocument>();
        orList.add(new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        orList.add(new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        expressionDocument.append("$or", (BsonValue)new BsonArray(orList));
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        BsonArray orListArray = new BsonArray();
        BsonArray orList1 = new BsonArray();
        BsonDocument orDoc1 = new BsonDocument();
        BsonDocument andDoc1 = new BsonDocument();
        BsonArray andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andList1.add((BsonValue)new BsonDocument().append("Title1", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andDoc1.append("$and", (BsonValue)andList1);
        orList1.add((BsonValue)andDoc1);
        orList1.add((BsonValue)new BsonDocument().append("ISBN2", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        orDoc1.append("$or", (BsonValue)orList1);
        orListArray.add((BsonValue)orDoc1);
        BsonArray andList2 = new BsonArray();
        BsonDocument andDoc2 = new BsonDocument();
        andList2.add((BsonValue)new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        BsonArray orList2 = new BsonArray();
        BsonDocument orDoc2 = new BsonDocument();
        orList2.add((BsonValue)new BsonDocument().append("InPublication", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonBoolean(false))));
        BsonArray andList3 = new BsonArray();
        BsonDocument andDoc3 = new BsonDocument();
        andList3.add((BsonValue)new BsonDocument().append("ISBN", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("111-1111111111"))));
        andList3.add((BsonValue)new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        andDoc3.append("$and", (BsonValue)andList3);
        orList2.add((BsonValue)andDoc3);
        orDoc2.append("$or", (BsonValue)orList2);
        andList2.add((BsonValue)orDoc2);
        andDoc2.append("$and", (BsonValue)andList2);
        orListArray.add((BsonValue)andDoc2);
        expressionDocument.append("$or", (BsonValue)orListArray);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.ISBN", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[3]", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonDouble(101.01))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.InPublication", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonBoolean(false))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andDoc1 = new BsonDocument();
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonDouble(101.01))));
        orList1 = new BsonArray();
        orDoc1 = new BsonDocument();
        orList1.add((BsonValue)new BsonDocument().append("NestedMap1.InPublication[0]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonBoolean(false))));
        andList2 = new BsonArray();
        andDoc2 = new BsonDocument();
        andList2.add((BsonValue)new BsonDocument().append("ISBN[0]", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("111-1111111111"))));
        andList2.add((BsonValue)new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        andDoc2.append("$and", (BsonValue)andList2);
        orList1.add((BsonValue)andDoc2);
        orDoc1.append("$or", (BsonValue)orList1);
        andList1.add((BsonValue)orDoc1);
        andDoc1.append("$and", (BsonValue)andList1);
        orList2 = new BsonArray();
        orDoc2 = new BsonDocument();
        orList2.add((BsonValue)andDoc1);
        orList2.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[0]", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonString("NListVal01"))));
        expressionDocument.append("$or", (BsonValue)orList2);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        orListArray = new BsonArray();
        andList1 = new BsonArray();
        andDoc1 = new BsonDocument();
        andList1.add((BsonValue)new BsonDocument().append("Id", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andList1.add((BsonValue)new BsonDocument().append("Title1", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(false))));
        andDoc1.append("$and", (BsonValue)andList1);
        orList1 = new BsonArray();
        orDoc1 = new BsonDocument();
        orList1.add((BsonValue)andDoc1);
        orList1.add((BsonValue)new BsonDocument().append("ISBN2", (BsonValue)new BsonDocument().append("$exists", (BsonValue)new BsonBoolean(true))));
        orDoc1.append("$or", (BsonValue)orList1);
        orListArray.add((BsonValue)orDoc1);
        andList2 = new BsonArray();
        andDoc2 = new BsonDocument();
        andList2.add((BsonValue)new BsonDocument().append("NestedMap1.Id", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonDouble(101.01))));
        orList2 = new BsonArray();
        orDoc2 = new BsonDocument();
        orList2.add((BsonValue)new BsonDocument().append("NestedMap1.InPublication", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonBoolean(false))));
        andList3 = new BsonArray();
        andDoc3 = new BsonDocument();
        andList3.add((BsonValue)new BsonDocument().append("ISBN", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonString("111-1111111111"))));
        andList3.add((BsonValue)new BsonDocument().append("Title", (BsonValue)new BsonDocument().append("$eq", (BsonValue)new BsonString("Book 101 Title"))));
        andDoc3.append("$and", (BsonValue)andList3);
        orList2.add((BsonValue)andDoc3);
        orDoc2.append("$or", (BsonValue)orList2);
        andList2.add((BsonValue)orDoc2);
        andDoc2.append("$and", (BsonValue)andList2);
        orListArray.add((BsonValue)andDoc2);
        expressionDocument.append("$or", (BsonValue)orListArray);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonDouble(-485.33))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonString("1234abcc"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonInt32(120))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonString("12"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonInt32(12))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whit")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonDouble(-485.33))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("1234abcc"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonInt32(120))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonString("12"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonInt32(12))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whit")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonDouble(-485.35))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonString("1234abce"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonInt64(101L))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonString("100"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$lt", (BsonValue)new BsonDouble(101.011))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
        expressionDocument = new BsonDocument();
        andList1 = new BsonArray();
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonDouble(-485.35))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[1]", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonString("1234abce"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][0]", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("xyz0123"))));
        andList1.add((BsonValue)new BsonDocument().append("NestedList1[2][1].Id", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonInt64(101L))));
        andList1.add((BsonValue)new BsonDocument().append("IdS", (BsonValue)new BsonDocument().append("$gte", (BsonValue)new BsonString("100"))));
        andList1.add((BsonValue)new BsonDocument().append("Id2", (BsonValue)new BsonDocument().append("$lte", (BsonValue)new BsonDouble(101.011))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$gt", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")))));
        andList1.add((BsonValue)new BsonDocument().append("NestedMap1.NList1[2]", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")))));
        expressionDocument.append("$and", (BsonValue)andList1);
        Assert.assertFalse((boolean)DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)expressionDocument));
    }

    @Test
    public void testBeginsWithFunction() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getDocumentValue();
        RawBsonDocument compareValues = ComparisonExpressionUtilsTest.getCompareValDocument();
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(ISBN, :ISBN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, :TitlePrefix)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, #NestedList1_xyz0123)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(ISBN, #NestedList1_1)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(NestedMap1.Title, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(NestedMap1.Title, #NestedList1_xyz0123)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(NestedMap1.NList1[2], #NestedMap1_NList1_3)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(NestedMap1.NList1[2], $NestedMap1_NList1_30)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(NonExistentField, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Id, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        try {
            SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, :1)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues);
            Assert.fail((String)"Expected BsonConditionInvalidArgumentException");
        }
        catch (BsonConditionInvalidArgumentException bsonConditionInvalidArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, #Title) AND field_exists(Id) = begins_with(Title, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, #NestedList1_xyz0123) AND field_exists(Id)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, #NestedList1_xyz0123) OR field_exists(Id)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"begins_with(Title, #Title) OR field_not_exists(Id)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, #NestedList1_xyz0123)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, #Title)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, #NestedList1_xyz0123)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, :TitlePrefix)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(NestedMap1.NList1[2], #NestedMap1_NList1_3)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(NestedMap1.NList1[2], $NestedMap1_NList1_30)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, #NestedList1_xyz0123) AND field_exists(Id)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT begins_with(Title, #Title) OR NOT begins_with(Title, :TitlePrefix)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
    }

    @Test
    public void testContainsFunction() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getContainsTestDocument();
        RawBsonDocument compareValues = ComparisonExpressionUtilsTest.getContainsCompareValDocument();
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Description, :DescriptionWord)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(NestedMap1.Title, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :NonExistentSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Description, :WrongWord)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Tags, :TagScience)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Numbers, :NumberFive)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(NestedList1, :NestedListString)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Tags, :NonExistentTag)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Numbers, :NumberTen)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Categories, :CategoryFiction)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(StatusSet, :StatusActive)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Categories, :NonExistentCategory)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(StatusSet, :StatusInactive)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(BinaryDataSet, :BinaryHello)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(BinaryDataSet, :BinaryNotFound)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :TitleSubstring) AND contains(Tags, :TagScience)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :NonExistentSubstring) OR contains(Tags, :TagScience)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :NonExistentSubstring) AND contains(Tags, :TagScience)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT contains(Title, :NonExistentSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT contains(Title, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(NonExistentField, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :NonExistentValue)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Title, :NumberFive)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Numbers, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(Id, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(InPublication, :TitleSubstring)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(NestedMap1.SubTags, :TagMath)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"contains(NestedMap1.SubTags, :NonExistentTag)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
    }

    private static RawBsonDocument getContainsTestDocument() {
        String json = "{\n  \"Title\" : \"Advanced Data Science and Machine Learning\",\n  \"Description\" : \"This book covers comprehensive topics in Quantum Computing\",\n  \"Tags\" : [ \"science\", \"technology\", \"programming\", \"AI\" ],\n  \"Numbers\" : [ 1, 2, 3, 5, 8, 13 ],\n  \"NestedList1\" : [ -485.34, \"1234abcd\", \"xyz0123\", \"test_string\" ],\n  \"Categories\" : { \"$set\" : [ \"fiction\", \"educational\", \"technical\" ] },\n  \"StatusSet\" : { \"$set\" : [ \"active\", \"published\", \"available\" ] },\n  \"BinaryDataSet\" : { \"$set\" : [ {\n    \"$binary\" : {\n      \"base64\" : \"SGVsbG8=\",\n      \"subType\" : \"00\"\n    }\n  }, {\n    \"$binary\" : {\n      \"base64\" : \"V29ybGQ=\",\n      \"subType\" : \"00\"\n    }\n  }, {\n    \"$binary\" : {\n      \"base64\" : \"VGVzdA==\",\n      \"subType\" : \"00\"\n    }\n  } ] },\n  \"NestedMap1\" : {\n    \"Title\" : \"Nested Advanced Data Science Guide\",\n    \"SubTags\" : [ \"mathematics\", \"statistics\", \"algorithms\" ],\n    \"InnerSet\" : { \"$set\" : [ \"regression\", \"classification\" ] }\n  },\n  \"Id\" : 101.01,\n  \"InPublication\" : true\n}";
        return RawBsonDocument.parse((String)json);
    }

    private static RawBsonDocument getContainsCompareValDocument() {
        String json = "{\n  \":TitleSubstring\" : \"Data Science\",\n  \":DescriptionWord\" : \"Quantum Comput\",\n  \":NonExistentSubstring\" : \"Quantum Physics\",\n  \":WrongWord\" : \"geology\",\n  \":TagScience\" : \"science\",\n  \":TagMath\" : \"mathematics\",\n  \":NonExistentTag\" : \"biology\",\n  \":NumberFive\" : 5,\n  \":NumberTen\" : 10,\n  \":NestedListString\" : \"test_string\",\n  \":CategoryFiction\" : \"fiction\",\n  \":NonExistentCategory\" : \"romance\",\n  \":StatusActive\" : \"active\",\n  \":StatusInactive\" : \"inactive\",\n  \":NonExistentValue\" : \"does_not_exist\",\n  \":BinaryHello\" : {\n    \"$binary\" : {\n      \"base64\" : \"SGVsbG8=\",\n      \"subType\" : \"00\"\n    }\n  },\n  \":BinaryNotFound\" : {\n    \"$binary\" : {\n      \"base64\" : \"Tm90Rm91bmQ=\",\n      \"subType\" : \"00\"\n    }\n  }\n}";
        return RawBsonDocument.parse((String)json);
    }

    private static RawBsonDocument getCompareValDocument() {
        String json = "{\n  \"$Id20\" : 101.011,\n  \"$Id2\" : 12,\n  \"#NestedList1_10\" : \"1234abce\",\n  \"$Id1\" : 120,\n  \"$Id10\" : 101,\n  \":1\" : 100,\n   \"$Ids1\" : \"12\",\n  \":ISBN\" : \"111-1111111111\",\n  \"#NestedList1_xyz0123\" : \"xyz0123\",\n  \"$NestedList1_485\" : -485.33,\n  \"$NestedMap1_NList1_30\" : {\n    \"$binary\" : {\n      \"base64\" : \"V2hpdGVl\",\n      \"subType\" : \"00\"\n    }\n  },\n  \"InPublication\" : false,\n  \"$Ids10\" : \"100\",\n  \"#NestedMap1_NList1_3\" : {\n    \"$binary\" : {\n      \"base64\" : \"V2hpdA==\",\n      \"subType\" : \"00\"\n    }\n  },\n  \"#NestedList1_1\" : \"1234abcc\",\n  \"#NMap1_NList1\" : \"NListVal01\",\n  \"$NestedList1_4850\" : -485.35,\n  \"$Id\" : 101.01,\n  \"#Title\" : \"Book 101 Title\",\n  \":TitlePrefix\" : \"Book\"\n}";
        return RawBsonDocument.parse((String)json);
    }

    private static RawBsonDocument getDocumentValue() {
        String json = "{\n  \"InPublication\" : false,\n  \"ISBN\" : \"111-1111111111\",\n  \"NestedList1\" : [ -485.34, \"1234abcd\", [ \"xyz0123\", {\n    \"InPublication\" : false,\n    \"ISBN\" : \"111-1111111111\",\n    \"Title\" : \"Book 101 Title\",\n    \"Id\" : 101.01\n  } ] ],\n  \"NestedMap1\" : {\n    \"InPublication\" : false,\n    \"ISBN\" : \"111-1111111111\",\n    \"Title\" : \"Book 101 Title\",\n    \"Id\" : 101.01,\n    \"NList1\" : [ \"NListVal01\", -23.4, {\n      \"$binary\" : {\n        \"base64\" : \"V2hpdGU=\",\n        \"subType\" : \"00\"\n      }\n    } ]\n  },\n  \"Id2\" : 101.01,\n  \"IdS\" : \"101.01\",\n  \">\" : 12,\n   \"Title\" : \"Book 101 Title\",\n  \"Id\" : 101.01\n}";
        return RawBsonDocument.parse((String)json);
    }

    @Test
    public void testFieldTypeFunction() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getFieldTypeTestDocument();
        RawBsonDocument compareValues = ComparisonExpressionUtilsTest.getFieldTypeCompareValDocument();
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NumberFieldDouble, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NumberFieldInt, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BinaryField, :TypeB)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BinaryField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BooleanFieldTrue, :TypeBOOL)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BooleanFieldFalse, :TypeBOOL)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BooleanFieldTrue, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NullField, :TypeNULL)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NullField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField, :TypeL)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(DocumentField, :TypeM)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(DocumentField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringSetField, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringSetField, :TypeNS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NumberSetField, :TypeNS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NumberSetField, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BinarySetField, :TypeBS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(BinarySetField, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedString, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedNumber, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedString, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NonExistentField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeS) AND field_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeN) OR field_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeN) AND field_type(NumberFieldInt, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT field_type(StringField, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT field_type(StringField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeS) AND field_exists(StringField)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NonExistentField, :TypeS) AND field_exists(NonExistentField)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringField, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(BooleanFieldTrue, :TypeBOOL)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(ArrayField, :TypeL)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(DocumentField, :TypeM)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringSetField, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(NumberSetField, :TypeNS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(BinarySetField, :TypeBS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(NestedDoc.NestedString, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(NestedDoc.NestedString, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringField, :TypeS) AND attribute_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringField, :TypeN) OR attribute_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringField, :TypeN) AND attribute_type(NumberFieldInt, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT attribute_type(StringField, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT attribute_type(StringField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeS) AND attribute_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringField, :TypeN) OR attribute_type(NumberFieldInt, :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(NonExistentField, :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(StringField, :TypeS) AND attribute_exists(StringField)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(NonExistentField, :TypeS) AND attribute_not_exists(NonExistentField)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(EmptyStringSet, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(EmptyNumberSet, :TypeNS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(EmptyBinarySet, :TypeBS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(EmptyStringSet, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(EmptyNumberSet, :TypeNS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(EmptyBinarySet, :TypeBS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(StringSetField, :TypeSS) AND NOT field_type(EmptyStringSet, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(EmptyStringSet, :TypeSS) AND field_type(StringSetField, :TypeSS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField[0], :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField[1], :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField[2], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField[0], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField[2], :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(ArrayField[0], :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(ArrayField[2], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"attribute_type(ArrayField[1], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedArray[0], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedArray[1], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedArray[2], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedArray[0], :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(ArrayField[5], :TypeS)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"field_type(NestedDoc.NestedArray[10], :TypeN)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
    }

    private static RawBsonDocument getFieldTypeTestDocument() {
        String json = "{\n  \"StringField\" : \"Hello World\",\n  \"NumberFieldInt\" : 42,\n  \"NumberFieldDouble\" : 3.14159,\n  \"BinaryField\" : {\n    \"$binary\" : {\n      \"base64\" : \"SGVsbG8gV29ybGQ=\",\n      \"subType\" : \"00\"\n    }\n  },\n  \"BooleanFieldTrue\" : true,\n  \"BooleanFieldFalse\" : false,\n  \"NullField\" : null,\n  \"ArrayField\" : [ \"item1\", \"item2\", 123 ],\n  \"DocumentField\" : {\n    \"nestedKey\" : \"nestedValue\",\n    \"nestedNum\" : 999\n  },\n  \"StringSetField\" : { \"$set\" : [ \"apple\", \"banana\", \"cherry\" ] },\n  \"NumberSetField\" : { \"$set\" : [ 10, 20, 30 ] },\n  \"BinarySetField\" : { \"$set\" : [ {\n    \"$binary\" : {\n      \"base64\" : \"VGVzdA==\",\n      \"subType\" : \"00\"\n    }\n  }, {\n    \"$binary\" : {\n      \"base64\" : \"RGF0YQ==\",\n      \"subType\" : \"00\"\n    }\n  } ] },\n  \"EmptyStringSet\" : { \"$set\" : [ ] },\n  \"EmptyNumberSet\" : { \"$set\" : [ ] },\n  \"EmptyBinarySet\" : { \"$set\" : [ ] },\n  \"NestedDoc\" : {\n    \"NestedString\" : \"nested value\",\n    \"NestedNumber\" : 777,\n    \"NestedArray\" : [ 1, 2, 3 ]\n  }\n}";
        return RawBsonDocument.parse((String)json);
    }

    private static RawBsonDocument getFieldTypeCompareValDocument() {
        String json = "{\n  \":TypeS\" : \"S\",\n  \":TypeN\" : \"N\",\n  \":TypeB\" : \"B\",\n  \":TypeBOOL\" : \"BOOL\",\n  \":TypeNULL\" : \"NULL\",\n  \":TypeL\" : \"L\",\n  \":TypeM\" : \"M\",\n  \":TypeSS\" : \"SS\",\n  \":TypeNS\" : \"NS\",\n  \":TypeBS\" : \"BS\"\n}";
        return RawBsonDocument.parse((String)json);
    }

    @Test
    public void testSizeFunction() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtilsTest.getSizeTestDocument();
        RawBsonDocument compareValues = ComparisonExpressionUtilsTest.getSizeCompareValDocument();
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(LongString) = :Size24", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptyString) = :Size0", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(SmallArray) = :Size3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(LargeArray) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptyArray) = :Size0", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(SmallDoc) = :Size2", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(LargeDoc) = :Size4", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptyDoc) = :Size0", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(StringSet) = :Size3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NumberSet) = :Size4", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptySet) = :Size0", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(BinaryData) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NestedDoc.NestedString) = :Size12", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NestedDoc.NestedArray) = :Size3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NonExistentField) = :Size0", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(LongString) > :Size20", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(LongString) >= :Size24", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) < :Size10", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) <= :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) <> :Size10", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(SmallArray) IN (:Size3, :Size4, :Size5)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(SmallArray) IN (:Size1, :Size2, :Size4)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) = :Size5 AND size(SmallArray) = :Size3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptyString) = :Size0 OR size(LargeArray) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) = :Size10 AND size(SmallArray) = :Size3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT size(ShortString) = :Size10", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"NOT size(ShortString) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) = :Size5 AND field_exists(ShortString)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NonExistentField) = :Size0 AND field_not_exists(NonExistentField)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(LongString) BETWEEN :Size20 AND :Size30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) BETWEEN :Size10 AND :Size20", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) = :Size10", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptyArray) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(SmallDoc) = :Size10", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ArrayOfStrings[0]) = :Size6", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ArrayOfStrings[1]) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ArrayOfStrings[0]) > :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(VeryLargeArray) = :Size100", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(ShortString) < :Size24", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(EmptyArray) < :Size3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(SmallDoc) < :Size4", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues));
        try {
            SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NumberField) = :Size5", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues);
            Assert.fail((String)"Expected BsonConditionInvalidArgumentException for number field");
        }
        catch (BsonConditionInvalidArgumentException bsonConditionInvalidArgumentException) {
            // empty catch block
        }
        try {
            SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(BooleanField) = :Size1", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues);
            Assert.fail((String)"Expected BsonConditionInvalidArgumentException for boolean field");
        }
        catch (BsonConditionInvalidArgumentException bsonConditionInvalidArgumentException) {
            // empty catch block
        }
        try {
            SQLComparisonExpressionUtils.evaluateConditionExpression((String)"size(NullField) = :Size0", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues);
            Assert.fail((String)"Expected BsonConditionInvalidArgumentException for null field");
        }
        catch (BsonConditionInvalidArgumentException bsonConditionInvalidArgumentException) {
            // empty catch block
        }
    }

    private static RawBsonDocument getSizeTestDocument() {
        String json = "{\n  \"ShortString\" : \"Hello\",\n  \"LongString\" : \"This is a longer string!\",\n  \"EmptyString\" : \"\",\n  \"SmallArray\" : [ 1, 2, 3 ],\n  \"LargeArray\" : [ \"a\", \"b\", \"c\", \"d\", \"e\" ],\n  \"EmptyArray\" : [ ],\n  \"SmallDoc\" : {\n    \"field1\" : \"value1\",\n    \"field2\" : \"value2\"\n  },\n  \"LargeDoc\" : {\n    \"name\" : \"John\",\n    \"age\" : 30,\n    \"city\" : \"New York\",\n    \"active\" : true\n  },\n  \"EmptyDoc\" : { },\n  \"StringSet\" : { \"$set\" : [ \"apple\", \"banana\", \"cherry\" ] },\n  \"NumberSet\" : { \"$set\" : [ 10, 20, 30, 40 ] },\n  \"EmptySet\" : { \"$set\" : [ ] },\n  \"BinaryData\" : {\n    \"$binary\" : {\n      \"base64\" : \"SGVsbG8=\",\n      \"subType\" : \"00\"\n    }\n  },\n  \"NestedDoc\" : {\n    \"NestedString\" : \"Nested Value\",\n    \"NestedArray\" : [ \"x\", \"y\", \"z\" ]\n  },\n  \"ArrayOfStrings\" : [ \"String\", \"World\" ],\n  \"NumberField\" : 42,\n  \"BooleanField\" : true,\n  \"NullField\" : null,\n  \"VeryLargeArray\" : [ ";
        for (int i = 0; i < 100; ++i) {
            json = json + i;
            if (i >= 99) continue;
            json = json + ", ";
        }
        json = json + " ]\n}";
        return RawBsonDocument.parse((String)json);
    }

    private static RawBsonDocument getSizeCompareValDocument() {
        String json = "{\n  \":Size0\" : 0,\n  \":Size1\" : 1,\n  \":Size2\" : 2,\n  \":Size3\" : 3,\n  \":Size4\" : 4,\n  \":Size5\" : 5,\n  \":Size6\" : 6,\n  \":Size10\" : 10,\n  \":Size12\" : 12,\n  \":Size20\" : 20,\n  \":Size24\" : 24,\n  \":Size30\" : 30,\n  \":Size100\" : 100\n}";
        return RawBsonDocument.parse((String)json);
    }
}

