/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.phoenix.util.SchemaUtil;

public class TestDDLUtil {
    private boolean isNamespaceMapped;
    private boolean isChangeDetectionEnabled;

    public TestDDLUtil(boolean isNamespaceMapped) {
        this.isNamespaceMapped = isNamespaceMapped;
    }

    public void createBaseTable(Connection conn, String schemaName, String tableName, boolean multiTenant, Integer saltBuckets, String splits, boolean immutable) throws SQLException {
        String ddlOptions;
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String ddl = "CREATE " + (immutable ? "IMMUTABLE" : "") + " TABLE " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + " (t_id VARCHAR NOT NULL,\nk1 VARCHAR NOT NULL,\nk2 INTEGER NOT NULL,\nv1 VARCHAR,\nv2 INTEGER,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n";
        String string = ddlOptions = multiTenant ? "MULTI_TENANT=true" : "";
        if (saltBuckets != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ", ") + "salt_buckets=" + saltBuckets;
        }
        if (this.isChangeDetectionEnabled) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ", ") + "CHANGE_DETECTION_ENABLED=TRUE";
        }
        if (splits != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ", ") + "splits=" + splits;
        }
        conn.createStatement().execute(ddl + ddlOptions);
    }

    public void createIndex(Connection conn, String schemaName, String indexName, String tableName, String indexedColumnName, boolean isLocal, boolean isAsync) throws SQLException {
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String local = isLocal ? " LOCAL " : "";
        String async = isAsync ? " ASYNC " : "";
        String sql = "CREATE " + local + " INDEX " + indexName + " ON " + fullTableName + "(" + indexedColumnName + ")" + async;
        conn.createStatement().execute(sql);
    }

    public void createView(Connection conn, String schemaName, String viewName, String baseTableName) throws SQLException {
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)baseTableName);
        String viewSql = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName;
        if (this.isChangeDetectionEnabled) {
            viewSql = viewSql + " " + "CHANGE_DETECTION_ENABLED" + "=TRUE";
        }
        conn.createStatement().execute(viewSql);
    }

    public void createViewIndex(Connection conn, String schemaName, String indexName, String viewName, String indexColumn) throws SQLException {
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullViewName + "(" + indexColumn + ")");
    }

    public void setChangeDetectionEnabled(boolean isChangeDetectionEnabled) {
        this.isChangeDetectionEnabled = isChangeDetectionEnabled;
    }
}

