/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TenantIdByteConversionTest {
    private RowKeySchema schema;
    private boolean isSalted;
    private PName tenantId;
    private byte[] expectedTenantIdBytes;

    public TenantIdByteConversionTest(RowKeySchema schema, boolean isSalted, PName tenantId, byte[] expectedTenantIdBytes) {
        this.schema = schema;
        this.isSalted = isSalted;
        this.tenantId = tenantId;
        this.expectedTenantIdBytes = expectedTenantIdBytes;
    }

    @Test
    public void test() {
        try {
            byte[] actualTenantIdBytes = ScanUtil.getTenantIdBytes((RowKeySchema)this.schema, (boolean)this.isSalted, (PName)this.tenantId, (boolean)false);
            Assert.assertArrayEquals((byte[])this.expectedTenantIdBytes, (byte[])actualTenantIdBytes);
        }
        catch (SQLException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Parameterized.Parameters
    public static synchronized Collection<Object[]> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PVarchar.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"NameOfTenant"), PVarchar.INSTANCE.toBytes((Object)"NameOfTenant")});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PChar.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"N"), PChar.INSTANCE.toBytes(PChar.INSTANCE.toObject("N"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PInteger.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"2147483646"), PInteger.INSTANCE.toBytes(PInteger.INSTANCE.toObject("2147483646"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedInt.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"2147483646"), PUnsignedInt.INSTANCE.toBytes(PUnsignedInt.INSTANCE.toObject("2147483646"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PLong.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"9223372036854775806"), PLong.INSTANCE.toBytes(PLong.INSTANCE.toObject("9223372036854775806"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedLong.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"9223372036854775806"), PUnsignedLong.INSTANCE.toBytes(PUnsignedLong.INSTANCE.toObject("9223372036854775806"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PTinyint.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"126"), PTinyint.INSTANCE.toBytes(PTinyint.INSTANCE.toObject("126"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedTinyint.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"126"), PUnsignedTinyint.INSTANCE.toBytes(PUnsignedTinyint.INSTANCE.toObject("126"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PSmallint.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"32766"), PSmallint.INSTANCE.toBytes(PSmallint.INSTANCE.toObject("32766"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedSmallint.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"32766"), PUnsignedSmallint.INSTANCE.toBytes(PUnsignedSmallint.INSTANCE.toObject("32766"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PFloat.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"3.402823466"), PFloat.INSTANCE.toBytes(PFloat.INSTANCE.toObject("3.402823466"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedFloat.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"3.402823466"), PUnsignedFloat.INSTANCE.toBytes(PUnsignedFloat.INSTANCE.toObject("3.402823466"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PDouble.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"1.7976931348623158"), PDouble.INSTANCE.toBytes(PDouble.INSTANCE.toObject("1.7976931348623158"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedDouble.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"1.7976931348623158"), PUnsignedDouble.INSTANCE.toBytes(PUnsignedDouble.INSTANCE.toObject("1.7976931348623158"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PDecimal.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"3.402823466"), PDecimal.INSTANCE.toBytes(PDecimal.INSTANCE.toObject("3.402823466"))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PBoolean.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)"true"), PBoolean.INSTANCE.toBytes(PBoolean.INSTANCE.toObject("true"))});
        byte[] bytes = new byte[]{0, 1, 2, 3};
        String byteString = new String(Base64.getEncoder().encode(bytes));
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PBinary.INSTANCE, SortOrder.getDefault()), false, PNameFactory.newName((String)byteString), PBinary.INSTANCE.toBytes(PBinary.INSTANCE.toObject(byteString))});
        testCases.add(new Object[]{TenantIdByteConversionTest.getDataSchema((PDataType)PUnsignedInt.INSTANCE, SortOrder.DESC), false, PNameFactory.newName((String)"2147483646"), PUnsignedInt.INSTANCE.toBytes(PUnsignedInt.INSTANCE.toObject("2147483646"))});
        return testCases;
    }

    public static RowKeySchema getDataSchema(final PDataType data, final SortOrder sortOrder) {
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(3);
        builder.addField(new PDatum(){

            public boolean isNullable() {
                return false;
            }

            public PDataType getDataType() {
                return data;
            }

            public Integer getMaxLength() {
                return 1;
            }

            public Integer getScale() {
                return null;
            }

            public SortOrder getSortOrder() {
                return sortOrder;
            }
        }, false, sortOrder);
        builder.addField(new PDatum(){

            public boolean isNullable() {
                return false;
            }

            public PDataType getDataType() {
                return PUnsignedInt.INSTANCE;
            }

            public Integer getMaxLength() {
                return 3;
            }

            public Integer getScale() {
                return null;
            }

            public SortOrder getSortOrder() {
                return sortOrder;
            }
        }, false, sortOrder);
        builder.addField(new PDatum(){

            public boolean isNullable() {
                return true;
            }

            public PDataType getDataType() {
                return PVarchar.INSTANCE;
            }

            public Integer getMaxLength() {
                return 3;
            }

            public Integer getScale() {
                return null;
            }

            public SortOrder getSortOrder() {
                return sortOrder;
            }
        }, false, sortOrder);
        return builder.build();
    }
}

