/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    private void testLpad(String inputString, int length, String fillString, String expectedOutput) throws Exception {
        byte[] input = inputString.getBytes();
        byte[] fill = fillString.getBytes();
        byte[] output = StringUtil.lpad((byte[])input, (int)0, (int)input.length, (byte[])fill, (int)0, (int)fill.length, (boolean)false, (int)length);
        Assert.assertArrayEquals((String)"Incorrect output of lpad", (byte[])expectedOutput.getBytes(), (byte[])output);
    }

    @Test
    public void testLpadFillLengthLessThanPadLength() throws Exception {
        this.testLpad("ABCD", 8, "12", "1212ABCD");
    }

    @Test
    public void testLpadFillLengthEqualPadLength() throws Exception {
        this.testLpad("ABCD", 8, "1234", "1234ABCD");
    }

    @Test
    public void testLpadFillLengthGreaterThanPadLength() throws Exception {
        this.testLpad("ABCD", 8, "12345", "1234ABCD");
    }

    @Test
    public void testLpadZeroPadding() throws Exception {
        this.testLpad("ABCD", 4, "1234", "ABCD");
    }

    @Test
    public void testCalculateUTF8Offset() throws Exception {
        int ret;
        int i;
        String padding = "padding";
        String data = "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
        String trailing = "trailing";
        byte[] bytes = (padding + data + trailing).getBytes();
        int offset = padding.getBytes().length;
        int length = data.getBytes().length;
        String tmp = padding;
        for (i = 0; i < data.length(); ++i) {
            ret = StringUtil.calculateUTF8Offset((byte[])bytes, (int)offset, (int)length, (SortOrder)SortOrder.ASC, (int)i);
            Assert.assertEquals((long)tmp.getBytes().length, (long)ret);
            tmp = tmp + data.charAt(i);
        }
        for (i = data.length(); i < data.length() + 10; ++i) {
            ret = StringUtil.calculateUTF8Offset((byte[])bytes, (int)offset, (int)length, (SortOrder)SortOrder.ASC, (int)i);
            Assert.assertEquals((long)-1L, (long)ret);
        }
        for (i = -data.length() - 10; i < -data.length(); ++i) {
            ret = StringUtil.calculateUTF8Offset((byte[])bytes, (int)offset, (int)length, (SortOrder)SortOrder.ASC, (int)i);
            Assert.assertEquals((long)-1L, (long)ret);
        }
        tmp = padding;
        for (i = -data.length(); i <= -1; ++i) {
            ret = StringUtil.calculateUTF8Offset((byte[])bytes, (int)offset, (int)length, (SortOrder)SortOrder.ASC, (int)i);
            Assert.assertEquals((String)("i=" + i), (long)tmp.getBytes().length, (long)ret);
            tmp = tmp + data.charAt(i + data.length());
        }
    }
}

