/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class ScanUtilTest {

    public static class NonParameterizedScanUtilTest {
        @Test
        public void testSlotsSaltedVarbinaryPk() {
            byte[] key = new byte[1024];
            RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(2);
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PBinary.INSTANCE;
                }

                public Integer getMaxLength() {
                    return 1;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PVarbinary.INSTANCE;
                }

                public Integer getMaxLength() {
                    return 60;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
            ArrayList ranges = Lists.newArrayList((Object[])new KeyRange[]{KeyRange.getKeyRange((byte[])new byte[]{0, 5})});
            ArrayList pkKeyRanges = Lists.newArrayList();
            pkKeyRanges.add(ranges);
            int[] slotSpans = new int[]{1};
            int offset = ScanUtil.setKey((RowKeySchema)builder.build(), (List)pkKeyRanges, (int[])slotSpans, (int[])new int[]{0}, (KeyRange.Bound)KeyRange.Bound.UPPER, (byte[])key, (int)0, (int)0, (int)slotSpans.length);
            byte[] actualKey = new byte[offset];
            System.arraycopy(key, 0, actualKey, 0, offset);
            Assert.assertArrayEquals((byte[])new byte[]{0, 5, 0}, (byte[])actualKey);
        }

        @Test
        public void testLastPkColumnIsVariableLengthAndDescBug5307() throws Exception {
            RowKeySchema.RowKeySchemaBuilder rowKeySchemaBuilder = new RowKeySchema.RowKeySchemaBuilder(2);
            rowKeySchemaBuilder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PVarchar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return null;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
            rowKeySchemaBuilder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PVarchar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return null;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.DESC;
                }
            }, false, SortOrder.DESC);
            rowKeySchemaBuilder.rowKeyOrderOptimizable(true);
            RowKeySchema rowKeySchema = rowKeySchemaBuilder.build();
            List<List> rowKeySlotRangesList = Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)"obj1", SortOrder.ASC)), KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)"obj2", SortOrder.ASC)), KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)"obj3", SortOrder.ASC))), Arrays.asList(KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)"2222", SortOrder.DESC)), KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)"1111", SortOrder.DESC)), KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)"1111", SortOrder.DESC))));
            int[] rowKeySlotSpans = new int[]{0, 0};
            byte[] rowKey = new byte[1024];
            int[] rowKeySlotRangesIndexes = new int[]{0, 0};
            int rowKeyLength = ScanUtil.setKey((RowKeySchema)rowKeySchema, rowKeySlotRangesList, (int[])rowKeySlotSpans, (int[])rowKeySlotRangesIndexes, (KeyRange.Bound)KeyRange.Bound.LOWER, (byte[])rowKey, (int)0, (int)0, (int)2);
            byte[] startKey = Arrays.copyOf(rowKey, rowKeyLength);
            rowKeySlotRangesIndexes = new int[]{2, 2};
            rowKey = new byte[1024];
            rowKeyLength = ScanUtil.setKey((RowKeySchema)rowKeySchema, rowKeySlotRangesList, (int[])rowKeySlotSpans, (int[])rowKeySlotRangesIndexes, (KeyRange.Bound)KeyRange.Bound.UPPER, (byte[])rowKey, (int)0, (int)0, (int)2);
            byte[] endKey = Arrays.copyOf(rowKey, rowKeyLength);
            byte[] expectedStartKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"obj1", SortOrder.ASC), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)"2222", SortOrder.DESC), QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
            byte[] expectedEndKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"obj3", SortOrder.ASC), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)"1111", SortOrder.DESC), QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey((byte[])expectedEndKey, (int)expectedEndKey.length);
            Assert.assertArrayEquals((byte[])expectedStartKey, (byte[])startKey);
            Assert.assertArrayEquals((byte[])expectedEndKey, (byte[])endKey);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ParameterizedScanUtilTest {
        private final List<List<KeyRange>> slots;
        private final byte[] expectedKey;
        private final RowKeySchema schema;
        private final KeyRange.Bound bound;
        private static final Function<KeyRange[], List<KeyRange>> ARRAY_TO_LIST = new Function<KeyRange[], List<KeyRange>>(){

            public List<KeyRange> apply(KeyRange[] input) {
                return Lists.newArrayList((Object[])input);
            }
        };

        public ParameterizedScanUtilTest(List<List<KeyRange>> slots, int[] widths, byte[] expectedKey, KeyRange.Bound bound) throws Exception {
            RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(widths.length);
            for (final int width : widths) {
                if (width > 0) {
                    builder.addField(new PDatum(){

                        public boolean isNullable() {
                            return false;
                        }

                        public PDataType getDataType() {
                            return PChar.INSTANCE;
                        }

                        public Integer getMaxLength() {
                            return width;
                        }

                        public Integer getScale() {
                            return null;
                        }

                        public SortOrder getSortOrder() {
                            return SortOrder.getDefault();
                        }
                    }, false, SortOrder.getDefault());
                    continue;
                }
                builder.addField(new PDatum(){

                    public boolean isNullable() {
                        return false;
                    }

                    public PDataType getDataType() {
                        return PVarchar.INSTANCE;
                    }

                    public Integer getMaxLength() {
                        return null;
                    }

                    public Integer getScale() {
                        return null;
                    }

                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }
                }, false, SortOrder.getDefault());
            }
            this.schema = builder.build();
            this.slots = slots;
            this.expectedKey = expectedKey;
            this.bound = bound;
        }

        @Test
        public void test() {
            byte[] key = new byte[1024];
            int[] position = new int[this.slots.size()];
            int offset = ScanUtil.setKey((RowKeySchema)this.schema, this.slots, (int[])ScanUtil.getDefaultSlotSpans((int)this.slots.size()), (int[])position, (KeyRange.Bound)this.bound, (byte[])key, (int)0, (int)0, (int)this.slots.size());
            byte[] actualKey = new byte[offset];
            System.arraycopy(key, 0, actualKey, 0, offset);
            Assert.assertArrayEquals((byte[])this.expectedKey, (byte[])actualKey);
        }

        @Parameterized.Parameters(name="{0} {1} {2} {3} {4}")
        public static synchronized Collection<Object> data() {
            ArrayList testCases = Lists.newArrayList();
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a1A"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a1A"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a1A"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), false, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), false, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), false, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"b2B"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), false, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), false, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"b1B"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), false, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a1B"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), false, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"a"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a"), KeyRange.Bound.LOWER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"a1B"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"b2C"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"b"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), false, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.toBytes((Object)"b"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"a3"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"b"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"b"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"b2"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), false, SortOrder.ASC)}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"a2"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"b"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}}, new int[]{1, 1}, PChar.INSTANCE.toBytes((Object)"b"), KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(new byte[]{-1}, true, new byte[]{-1}, true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(new byte[]{-1}, true, new byte[]{-1}, true, SortOrder.ASC)}}, new int[]{1, 1}, ByteUtil.EMPTY_BYTE_ARRAY, KeyRange.Bound.UPPER));
            testCases.addAll(ParameterizedScanUtilTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 0}, ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"aB"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY})), KeyRange.Bound.UPPER));
            return testCases;
        }

        private static Collection<?> foreach(KeyRange[][] ranges, int[] widths, byte[] expectedKey, KeyRange.Bound bound) {
            List slots = Lists.transform((List)Lists.newArrayList((Object[])ranges), ARRAY_TO_LIST);
            ArrayList ret = Lists.newArrayList();
            ret.add(new Object[]{slots, widths, expectedKey, bound});
            return ret;
        }
    }
}

