/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.RowKeyMatcher;
import org.apache.phoenix.coprocessorclient.TableTTLInfo;
import org.apache.phoenix.coprocessorclient.TableTTLInfoCache;
import org.apache.phoenix.util.ByteUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RowKeyMatcherTest {
    public List<TableTTLInfo> getSampleData() {
        ArrayList<TableTTLInfo> tableList = new ArrayList<TableTTLInfo>();
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "", "TEST_ENTITY.GV_000001", "001", 30000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "", "TEST_ENTITY.GV_000002", "002", 60000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "", "TEST_ENTITY.GV_000003", "003", 60000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "00D0t0001000001", "TEST_ENTITY.Z01", "00D0t0001000001Z01", 60000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "00D0t0002000001", "TEST_ENTITY.Z01", "00D0t0002000001Z01", 120000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "00D0t0003000001", "TEST_ENTITY.Z01", "00D0t0003000001Z01", 180000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "00D0t0004000001", "TEST_ENTITY.Z01", "00D0t0004000001Z01", 300000));
        tableList.add(new TableTTLInfo("TEST_ENTITY.T_000001", "00D0t0005000001", "TEST_ENTITY.Z01", "00D0t0005000001Z01", 6000));
        return tableList;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOverlappingPrefixes() {
        RowKeyMatcher globalRowKeyMatcher = new RowKeyMatcher();
        RowKeyMatcher tenantRowKeyMatcher = new RowKeyMatcher();
        TableTTLInfoCache cache = new TableTTLInfoCache();
        ArrayList<String> sampleRows = new ArrayList<String>();
        sampleRows.add("0010t0001000001001Z01#12348");
        sampleRows.add("0010t0001000001002Z01#7832438");
        TableTTLInfo table1 = new TableTTLInfo("TEST_ENTITY.T_000001", "", "TEST_ENTITY.GV_000001", "001", 30000);
        TableTTLInfo table2 = new TableTTLInfo("TEST_ENTITY.T_000001", "0010t0001000001", "TEST_ENTITY.Z01", "0010t0001000001002Z01", 60000);
        Integer tableId1 = cache.addTable(table1);
        Integer tableId2 = cache.addTable(table2);
        globalRowKeyMatcher.put(table1.getMatchPattern(), tableId1.intValue());
        tenantRowKeyMatcher.put(table2.getMatchPattern(), tableId2.intValue());
        int tenantOffset = 0;
        int globalOffset = 15;
        Integer row0GlobalMatch = globalRowKeyMatcher.get(((String)sampleRows.get(0)).getBytes(), globalOffset);
        Assert.assertTrue((String)String.format("row-%d, matched = %s, row = %s", 0, row0GlobalMatch != null, sampleRows.get(0)), (row0GlobalMatch != null ? 1 : 0) != 0);
        Integer row0TenantMatch = tenantRowKeyMatcher.get(((String)sampleRows.get(0)).getBytes(), tenantOffset);
        Assert.assertTrue((String)String.format("row-%d, matched = %s, row = %s", 0, row0TenantMatch != null, sampleRows.get(0)), (row0TenantMatch == null ? 1 : 0) != 0);
        Integer row1GlobalMatch = globalRowKeyMatcher.get(((String)sampleRows.get(1)).getBytes(), globalOffset);
        Assert.assertTrue((String)String.format("row-%d, matched = %s, row = %s", 0, row1GlobalMatch != null, sampleRows.get(1)), (row1GlobalMatch == null ? 1 : 0) != 0);
        Integer row1TenantMatch = tenantRowKeyMatcher.get(((String)sampleRows.get(1)).getBytes(), tenantOffset);
        Assert.assertTrue((String)String.format("row-%d, matched = %s, row = %s", 0, row1TenantMatch != null, sampleRows.get(1)), (row1TenantMatch != null ? 1 : 0) != 0);
    }

    @Test
    public void testSamplePrefixes() {
        RowKeyMatcher rowKeyMatcher = new RowKeyMatcher();
        TableTTLInfoCache cache = new TableTTLInfoCache();
        ArrayList<TableTTLInfo> sampleTableList = new ArrayList<TableTTLInfo>();
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000001".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x00"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000002".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x01"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000003".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x02"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000004".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x03"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000005".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x04"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000006".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x8F"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000007".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\x9F"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000008".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\xAF"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000009".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\xBF"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_0000010".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\xCF"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000011".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\xDF"), 300));
        sampleTableList.add(new TableTTLInfo("TEST_ENTITY.T_000001".getBytes(), ByteUtil.EMPTY_BYTE_ARRAY, "TEST_ENTITY.GV_000012".getBytes(), Bytes.toBytesBinary((String)"\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\x80\\xEF"), 300));
        for (int i = 0; i < sampleTableList.size(); ++i) {
            Integer tableId = cache.addTable((TableTTLInfo)sampleTableList.get(i));
            rowKeyMatcher.put(((TableTTLInfo)sampleTableList.get(i)).getMatchPattern(), tableId.intValue());
            Assert.assertEquals((long)tableId.intValue(), (long)i);
        }
        int offset = 0;
        for (int i = 0; i < sampleTableList.size(); ++i) {
            Assert.assertEquals((long)rowKeyMatcher.get(((TableTTLInfo)sampleTableList.get(i)).getMatchPattern(), offset).intValue(), (long)i);
        }
    }

    @Test
    public void testSingleSampleDataCount() {
        RowKeyMatcher rowKeyMatcher = new RowKeyMatcher();
        TableTTLInfoCache cache = new TableTTLInfoCache();
        List<TableTTLInfo> sampleTableList = this.getSampleData();
        this.runTest(rowKeyMatcher, cache, sampleTableList, 1, 1);
        this.assertResults(rowKeyMatcher, sampleTableList);
        this.assertResults(cache, sampleTableList);
    }

    @Test
    public void testRepeatingSampleDataCount() {
        RowKeyMatcher rowKeyMatcher = new RowKeyMatcher();
        TableTTLInfoCache cache = new TableTTLInfoCache();
        List<TableTTLInfo> sampleTableList = this.getSampleData();
        this.runTest(rowKeyMatcher, cache, sampleTableList, 1, 25);
        this.assertResults(rowKeyMatcher, sampleTableList);
        this.assertResults(cache, sampleTableList);
    }

    @Test
    public void testConcurrentSampleDataCount() {
        RowKeyMatcher rowKeyMatcher = new RowKeyMatcher();
        TableTTLInfoCache cache = new TableTTLInfoCache();
        List<TableTTLInfo> sampleTableList = this.getSampleData();
        this.runTest(rowKeyMatcher, cache, sampleTableList, 5, 5);
        this.assertResults(rowKeyMatcher, sampleTableList);
        this.assertResults(cache, sampleTableList);
    }

    private void assertResults(RowKeyMatcher rowKeyMatcher, List<TableTTLInfo> sampleTableList) {
        int tableCountExpected = sampleTableList.size();
        int prefixCountActual = rowKeyMatcher.getNumEntries();
        String message = String.format("expected = %d, actual = %d", tableCountExpected, prefixCountActual);
        Assert.assertTrue((String)message, (tableCountExpected == prefixCountActual ? 1 : 0) != 0);
    }

    private void assertResults(TableTTLInfoCache cache, List<TableTTLInfo> sampleTableList) {
        HashSet<TableTTLInfo> dedupedTables = new HashSet<TableTTLInfo>();
        dedupedTables.addAll(sampleTableList);
        int tableCountExpected = sampleTableList.size();
        int dedupeTableCountExpected = dedupedTables.size();
        int tableCountActual = cache.getNumTablesInCache();
        String message = String.format("expected = %d, actual = %d", tableCountExpected, tableCountActual);
        Assert.assertTrue((String)message, (dedupeTableCountExpected == tableCountActual ? 1 : 0) != 0);
        Assert.assertTrue((String)message, (tableCountExpected == tableCountActual ? 1 : 0) != 0);
    }

    private void runTest(final RowKeyMatcher targetRowKeyMatcher, final TableTTLInfoCache cache, final List<TableTTLInfo> sampleData, int numThreads, final int numRepeats) {
        try {
            int i;
            Thread[] threads = new Thread[numThreads];
            final CountDownLatch latch = new CountDownLatch(threads.length);
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (int repeats = 0; repeats < numRepeats; ++repeats) {
                                RowKeyMatcherTest.this.addTablesToPrefixIndex(sampleData, targetRowKeyMatcher);
                                RowKeyMatcherTest.this.addTablesToCache(sampleData, cache);
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                }, "data-generator-" + i);
                threads[i].setDaemon(true);
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
            latch.await();
        }
        catch (InterruptedException ie) {
            Assert.fail((String)ie.getMessage());
        }
    }

    private void addTablesToPrefixIndex(List<TableTTLInfo> tableList, RowKeyMatcher rowKeyMatcher) {
        AtomicInteger tableId = new AtomicInteger(0);
        tableList.forEach(m -> rowKeyMatcher.put(m.getMatchPattern(), tableId.incrementAndGet()));
    }

    private void addTablesToCache(List<TableTTLInfo> tableList, TableTTLInfoCache cache) {
        tableList.forEach(m -> cache.addTable(m));
    }
}

