/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.HashMap;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyPropsTest {
    @Test
    public void testGetLongBytesMissingProperty() {
        HashMap props = new HashMap();
        ReadOnlyProps readOnlyProps = new ReadOnlyProps(props);
        Assert.assertEquals((long)1L, (long)readOnlyProps.getLongBytes("missing-prop", 1L));
    }

    @Test
    public void testGetLongBytesValidValue() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "1K");
        ReadOnlyProps readOnlyProps = new ReadOnlyProps(props);
        Assert.assertEquals((long)1024L, (long)readOnlyProps.getLongBytes("prop1", 0L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLongBytesInvalidValue() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "1KY");
        ReadOnlyProps readOnlyProps = new ReadOnlyProps(props);
        Assert.assertEquals((long)1024L, (long)readOnlyProps.getLongBytes("prop1", 0L));
    }
}

