/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.phoenix.schema.PTable;
import org.junit.Assert;
import org.junit.Test;

public class QualifierEncodingSchemeTest {
    @Test
    public void testOneByteQualifierEncodeDecode() {
        Assert.assertEquals((long)1L, (long)PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.encode(1)));
        Assert.assertEquals((long)127L, (long)PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.encode(127)));
        Assert.assertEquals((long)63L, (long)PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.encode(63)));
        Assert.assertEquals((long)130L, (long)PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.encode(130)));
        Assert.assertEquals((long)255L, (long)PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.encode(255)));
        byte[] arr1 = PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.encode(255);
        byte[] arr2 = new byte[]{-128, arr1[0]};
        Assert.assertEquals((long)255L, (long)PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(arr2, 1, 1));
        try {
            PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(arr2);
            Assert.fail();
        }
        catch (PTable.QualifierEncodingScheme.InvalidQualifierBytesException invalidQualifierBytesException) {
            // empty catch block
        }
        try {
            PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.decode(arr2, 0, 2);
            Assert.fail();
        }
        catch (PTable.QualifierEncodingScheme.InvalidQualifierBytesException invalidQualifierBytesException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoByteQualifierEncodeDecode() {
        Assert.assertEquals((long)1L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(1)));
        Assert.assertEquals((long)127L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(127)));
        Assert.assertEquals((long)63L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(63)));
        Assert.assertEquals((long)130L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(130)));
        Assert.assertEquals((long)128L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(128)));
        Assert.assertEquals((long)129L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(129)));
        Assert.assertEquals((long)32767L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(Short.MAX_VALUE)));
        Assert.assertEquals((long)32768L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(32768)));
        Assert.assertEquals((long)65535L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(65535)));
        byte[] arr1 = PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.encode(65535);
        byte[] arr2 = new byte[]{-128, arr1[0], arr1[1]};
        Assert.assertEquals((long)65535L, (long)PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(arr2, 1, 2));
        try {
            PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.decode(arr2);
            Assert.fail();
        }
        catch (PTable.QualifierEncodingScheme.InvalidQualifierBytesException invalidQualifierBytesException) {
            // empty catch block
        }
    }

    @Test
    public void testThreeByteQualifierEncodeDecode() {
        Assert.assertEquals((long)1L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(1)));
        Assert.assertEquals((long)127L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(127)));
        Assert.assertEquals((long)63L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(63)));
        Assert.assertEquals((long)130L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(130)));
        Assert.assertEquals((long)128L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(128)));
        Assert.assertEquals((long)129L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(129)));
        Assert.assertEquals((long)32767L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(Short.MAX_VALUE)));
        Assert.assertEquals((long)32768L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(32768)));
        Assert.assertEquals((long)65535L, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(65535)));
        Assert.assertEquals((long)0xFFFFFFL, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(0xFFFFFF)));
        byte[] arr1 = PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.encode(0xFFFFFF);
        byte[] arr2 = new byte[]{-128, arr1[0], arr1[1], arr1[2]};
        Assert.assertEquals((long)0xFFFFFFL, (long)PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(arr2, 1, 3));
        try {
            PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS.decode(arr2, 0, 2);
            Assert.fail();
        }
        catch (PTable.QualifierEncodingScheme.InvalidQualifierBytesException invalidQualifierBytesException) {
            // empty catch block
        }
    }

    @Test
    public void testFourByteQualifierEncodeDecode() {
        Assert.assertEquals((long)1L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(1)));
        Assert.assertEquals((long)127L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(127)));
        Assert.assertEquals((long)63L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(63)));
        Assert.assertEquals((long)130L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(130)));
        Assert.assertEquals((long)128L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(128)));
        Assert.assertEquals((long)129L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(129)));
        Assert.assertEquals((long)32767L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(Short.MAX_VALUE)));
        Assert.assertEquals((long)32768L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(32768)));
        Assert.assertEquals((long)65535L, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(65535)));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(Integer.MAX_VALUE)));
        byte[] arr1 = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(Integer.MAX_VALUE);
        byte[] arr2 = new byte[]{-128, arr1[0], arr1[1], arr1[2], arr1[3]};
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(arr2, 1, 4));
        try {
            PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(arr2);
            Assert.fail();
        }
        catch (PTable.QualifierEncodingScheme.InvalidQualifierBytesException invalidQualifierBytesException) {
            // empty catch block
        }
        try {
            PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.decode(arr2, 0, 3);
            Assert.fail();
        }
        catch (PTable.QualifierEncodingScheme.InvalidQualifierBytesException invalidQualifierBytesException) {
            // empty catch block
        }
    }
}

