/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtilHelper;
import org.apache.phoenix.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesUtilTest {
    private static final String SOME_TENANT_ID = "00Dxx0000001234";
    private static final String SOME_OTHER_PROPERTY_KEY = "some_other_property";
    private static final String SOME_OTHER_PROPERTY_VALUE = "some_other_value";

    @Test
    public void testCopy() throws Exception {
        Properties propsWithTenant = new Properties();
        propsWithTenant.put("TenantId", SOME_TENANT_ID);
        this.verifyValidCopy(propsWithTenant);
    }

    @Test
    public void testCopyOnWrappedProperties() throws Exception {
        Properties propsWithTenant = new Properties();
        propsWithTenant.put("TenantId", SOME_TENANT_ID);
        this.verifyValidCopy(new Properties(propsWithTenant));
    }

    @Test
    public void testCopyFromConfiguration() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Properties props = new Properties();
        conf.set("hbase.zookeeper.quorum", "localhost");
        conf.set(SOME_OTHER_PROPERTY_KEY, SOME_OTHER_PROPERTY_VALUE);
        Properties combinedProps = PropertiesUtil.combineProperties((Properties)props, (Configuration)conf);
        Assert.assertEquals((Object)combinedProps.getProperty("hbase.zookeeper.quorum"), (Object)conf.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((Object)combinedProps.getProperty(SOME_OTHER_PROPERTY_KEY), (Object)conf.get(SOME_OTHER_PROPERTY_KEY));
    }

    @Test
    public void testPropertyOverrideRespected() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Properties props = new Properties();
        props.setProperty("hbase.rpc.timeout", Long.toString(600000L));
        Properties combinedProps = PropertiesUtil.combineProperties((Properties)props, (Configuration)conf);
        Assert.assertEquals((Object)combinedProps.getProperty("hbase.rpc.timeout"), (Object)Long.toString(600000L));
    }

    @Test
    public void testDeprecatedProperties() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("phoneix.mapreduce.output.cluster.quorum", "myoverridezookeeperhost");
        String test = PhoenixConfigurationUtilHelper.getOutputCluster((Configuration)conf);
        Assert.assertEquals((Object)"myoverridezookeeperhost", (Object)test);
        Assert.assertEquals((Object)"myoverridezookeeperhost", (Object)conf.get("phoenix.mapreduce.output.cluster.quorum"));
    }

    private void verifyValidCopy(Properties props) throws SQLException {
        Properties copy = PropertiesUtil.deepCopy((Properties)props);
        copy.containsKey("TenantId");
        Assert.assertEquals((Object)SOME_TENANT_ID, (Object)copy.getProperty("TenantId"));
    }
}

