/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PrefixByteCodec;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class PrefixByteEncoderDecoderTest {
    static final List<byte[]> guideposts = Arrays.asList(ByteUtil.concat((byte[])Bytes.toBytes((String)"aaaaaaaaaa"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbbbbbb")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"aaaaaaaaaa"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbccccc")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"aaaaaaaaaa"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)2000L), Bytes.toBytes((String)"bbbbbbbbbb")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"bbbbbbbbbb"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbbbbbb")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"bbbbbbbbbb"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)2000L), Bytes.toBytes((String)"bbbbbbbbbb")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"bbbbbbbbbb"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)2000L), Bytes.toBytes((String)"c")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"bbbbbbbbbbb"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbbbbbb")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"d"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbbbbbb")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"d"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbbbbbbc")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"e"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((long)1000L), Bytes.toBytes((String)"bbbbbbbbbb")}));

    @Test
    public void testEncode() throws IOException {
        List listOfBytes = Arrays.asList(Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"aaaabb"));
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        int maxLength = PrefixByteCodec.encodeBytes(listOfBytes, (ImmutableBytesWritable)ptr);
        Assert.assertEquals((long)6L, (long)maxLength);
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(PrefixByteCodec.calculateSize(listOfBytes));
        DataOutputStream output = new DataOutputStream((OutputStream)stream);
        WritableUtils.writeVInt((DataOutput)output, (int)0);
        WritableUtils.writeVInt((DataOutput)output, (int)5);
        output.write(Bytes.toBytes((String)"aaaaa"));
        WritableUtils.writeVInt((DataOutput)output, (int)4);
        WritableUtils.writeVInt((DataOutput)output, (int)2);
        output.write(Bytes.toBytes((String)"bb"));
        Assert.assertArrayEquals((byte[])stream.toByteArray(), (byte[])ptr.copyBytes());
    }

    @Test
    public void testEncodeDecodeWithSingleBuffer() throws IOException {
        this.testEncodeDecode(true);
    }

    @Test
    public void testEncodeDecodeWithNewBuffer() throws IOException {
        this.testEncodeDecode(false);
    }

    private void testEncodeDecode(boolean useSingleBuffer) throws IOException {
        int unencodedSize;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        int maxLength = PrefixByteCodec.encodeBytes(guideposts, (ImmutableBytesWritable)ptr);
        int encodedSize = ptr.getLength();
        Assert.assertTrue((encodedSize < (unencodedSize = PrefixByteCodec.calculateSize(guideposts)) ? 1 : 0) != 0);
        List listOfBytes = PrefixByteCodec.decodeBytes((ImmutableBytesWritable)ptr, (int)(useSingleBuffer ? maxLength : -1));
        PrefixByteEncoderDecoderTest.assertListByteArraysEquals(guideposts, listOfBytes);
    }

    private static void assertListByteArraysEquals(List<byte[]> listOfBytes1, List<byte[]> listOfBytes2) {
        Assert.assertEquals((long)listOfBytes1.size(), (long)listOfBytes2.size());
        for (int i = 0; i < listOfBytes1.size(); ++i) {
            Assert.assertArrayEquals((byte[])listOfBytes1.get(i), (byte[])listOfBytes2.get(i));
        }
    }
}

