/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixRuntimeTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testParseArguments_MinimalCase() {
        PhoenixRuntime.ExecutionCommand execCmd = PhoenixRuntime.ExecutionCommand.parseArgs((String[])new String[]{"localhost", "test.csv"});
        Assert.assertEquals((Object)"localhost", (Object)execCmd.getConnectionString());
        Assert.assertEquals((Object)ImmutableList.of((Object)"test.csv"), (Object)execCmd.getInputFiles());
        Assert.assertEquals((long)44L, (long)execCmd.getFieldDelimiter());
        Assert.assertEquals((long)34L, (long)execCmd.getQuoteCharacter());
        Assert.assertNull((Object)execCmd.getEscapeCharacter());
        Assert.assertNull((Object)execCmd.getTableName());
        Assert.assertNull((Object)execCmd.getColumns());
        Assert.assertFalse((boolean)execCmd.isStrict());
        Assert.assertEquals((Object)":", (Object)execCmd.getArrayElementSeparator());
    }

    @Test
    public void testParseArguments_FullOption() {
        PhoenixRuntime.ExecutionCommand execCmd = PhoenixRuntime.ExecutionCommand.parseArgs((String[])new String[]{"-t", "mytable", "myzkhost:2181", "--strict", "file1.sql", "test.csv", "file2.sql", "--header", "one, two,three", "-a", "!", "-d", ":", "-q", "3", "-e", "4"});
        Assert.assertEquals((Object)"myzkhost:2181", (Object)execCmd.getConnectionString());
        Assert.assertEquals((Object)ImmutableList.of((Object)"file1.sql", (Object)"test.csv", (Object)"file2.sql"), (Object)execCmd.getInputFiles());
        Assert.assertEquals((long)58L, (long)execCmd.getFieldDelimiter());
        Assert.assertEquals((long)51L, (long)execCmd.getQuoteCharacter());
        Assert.assertEquals((Object)Character.valueOf('4'), (Object)execCmd.getEscapeCharacter());
        Assert.assertEquals((Object)"mytable", (Object)execCmd.getTableName());
        Assert.assertEquals((Object)ImmutableList.of((Object)"one", (Object)"two", (Object)"three"), (Object)execCmd.getColumns());
        Assert.assertTrue((boolean)execCmd.isStrict());
        Assert.assertEquals((Object)"!", (Object)execCmd.getArrayElementSeparator());
    }

    @Test
    public void testGetPkColsEncodeDecode() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixRuntimeTest.getUrl());
        String ddl = "CREATE TABLE t (\nTENANT_ID VARCHAR NOT NULL,\nPARENT_ID CHAR(15) NOT NULL,\nCREATED_DATE DATE NOT NULL,\nENTITY_HISTORY_ID CHAR(15) NOT NULL,\nDATA_TYPE VARCHAR,\nOLDVAL_STRING VARCHAR,\nNEWVAL_STRING VARCHAR\nCONSTRAINT PK PRIMARY KEY(TENANT_ID, PARENT_ID, CREATED_DATE DESC, ENTITY_HISTORY_ID)) MULTI_TENANT = true, IMMUTABLE_ROWS = true";
        conn.createStatement().execute(ddl);
        String indexDDL = "CREATE INDEX i ON t (CREATED_DATE, PARENT_ID) INCLUDE (DATA_TYPE, OLDVAL_STRING, NEWVAL_STRING)";
        conn.createStatement().execute(indexDDL);
        String tenantId = "111111111111111";
        String parentId = "222222222222222";
        Date createdDate = new Date(System.currentTimeMillis());
        String ehId = "333333333333333";
        Object[] values = new Object[]{tenantId, createdDate, parentId, ehId};
        QueryPlan plan = conn.createStatement().unwrap(PhoenixStatement.class).optimizeQuery("SELECT PARENT_ID FROM T WHERE CREATED_DATE > CURRENT_DATE()-1 AND TENANT_ID = '111111111111111'");
        List pkColumns = PhoenixRuntime.getPkColsForSql((Connection)conn, (QueryPlan)plan);
        String fullTableName = plan.getTableRef().getTable().getName().getString();
        Assert.assertEquals((Object)"I", (Object)fullTableName);
        byte[] encodedValues = PhoenixRuntime.encodeColumnValues((Connection)conn, (String)fullTableName, (Object[])values, (List)pkColumns);
        Object[] decodedValues = PhoenixRuntime.decodeColumnValues((Connection)conn, (String)fullTableName, (byte[])encodedValues, (List)pkColumns);
        Assert.assertArrayEquals((Object[])values, (Object[])decodedValues);
        plan = conn.createStatement().unwrap(PhoenixStatement.class).optimizeQuery("SELECT /*+ NO_INDEX */ ENTITY_HISTORY_ID FROM T");
        pkColumns = PhoenixRuntime.getPkColsForSql((Connection)conn, (QueryPlan)plan);
        values = new Object[]{tenantId, parentId, createdDate, ehId};
        fullTableName = plan.getTableRef().getTable().getName().getString();
        Assert.assertEquals((Object)"T", (Object)fullTableName);
        encodedValues = PhoenixRuntime.encodeColumnValues((Connection)conn, (String)fullTableName, (Object[])values, (List)pkColumns);
        decodedValues = PhoenixRuntime.decodeColumnValues((Connection)conn, (String)fullTableName, (byte[])encodedValues, (List)pkColumns);
        Assert.assertArrayEquals((Object[])values, (Object[])decodedValues);
    }

    @Test
    public void testGetPkColsDataTypes() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixRuntimeTest.getUrl(), new Properties());
        int i = 0;
        PDataType[] pTypes = PDataType.values();
        int size = pTypes.length;
        StringBuilder sb = null;
        try {
            for (i = 0; i < size; ++i) {
                PDataType pType = pTypes[i];
                String sqlTypeName = pType.getSqlTypeName();
                if (sqlTypeName.equalsIgnoreCase("VARBINARY ARRAY") || !pType.canBePrimaryKey()) continue;
                if (pType.isArrayType() && PDataType.arrayBaseType((PDataType)pType).isFixedWidth() && PDataType.arrayBaseType((PDataType)pType).getByteSize() == null) {
                    String baseTypeName = PDataType.arrayBaseType((PDataType)pType).getSqlTypeName();
                    sqlTypeName = baseTypeName + "(15) " + "ARRAY";
                } else if (pType.isFixedWidth() && pType.getByteSize() == null) {
                    sqlTypeName = sqlTypeName + "(15)";
                }
                String columnName = "col" + i;
                String tableName = "t" + i;
                sb = new StringBuilder(100);
                sb.append("CREATE TABLE " + tableName + " (");
                sb.append(columnName + " " + sqlTypeName + " NOT NULL PRIMARY KEY, V1 VARCHAR)");
                conn.createStatement().execute(sb.toString());
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE " + columnName + " = ?");
                Integer maxLength = pType.isFixedWidth() && pType.getByteSize() == null ? Integer.valueOf(15) : null;
                stmt.setObject(1, pType.getSampleValue(maxLength));
                QueryPlan plan = PhoenixRuntime.getOptimizedQueryPlan((PreparedStatement)stmt);
                ArrayList pkCols = new ArrayList();
                ArrayList dataTypes = new ArrayList();
                PhoenixRuntime.getPkColsDataTypesForSql(pkCols, dataTypes, (QueryPlan)plan, (Connection)conn, (boolean)true);
                tableName = "newt" + i;
                columnName = "newCol" + i;
                String roundTripSqlTypeName = (String)dataTypes.get(0);
                sb = new StringBuilder(100);
                sb.append("CREATE TABLE " + tableName + " (");
                sb.append(columnName + " " + roundTripSqlTypeName + " NOT NULL PRIMARY KEY)");
                conn.createStatement().execute(sb.toString());
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Failed sql: " + sb.toString() + ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    @Test
    public void testGetTenantIdExpression() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixRuntimeTest.getUrl());
        Expression e1 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)PhoenixDatabaseMetaData.SYSTEM_STATS_NAME);
        Assert.assertNull((Object)e1);
        Expression e2 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
        Assert.assertNotNull((Object)e2);
        Expression e3 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME);
        Assert.assertNotNull((Object)e3);
        conn.createStatement().execute("CREATE TABLE FOO (k VARCHAR PRIMARY KEY)");
        Expression e4 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)"FOO");
        Assert.assertNull((Object)e4);
        conn.createStatement().execute("CREATE TABLE A.BAR (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2)) MULTI_TENANT=true");
        Expression e5 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)"A.BAR");
        Assert.assertNotNull((Object)e5);
        conn.createStatement().execute("CREATE INDEX I1 ON A.BAR (K2)");
        Expression e5A = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)"A.I1");
        Assert.assertNotNull((Object)e5A);
        conn.createStatement().execute("CREATE TABLE BAS (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2)) MULTI_TENANT=true, SALT_BUCKETS=3");
        Expression e6 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)"BAS");
        Assert.assertNotNull((Object)e6);
        conn.createStatement().execute("CREATE INDEX I2 ON BAS (K2)");
        Expression e6A = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)"I2");
        Assert.assertNotNull((Object)e6A);
        try {
            PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)"NOT.ATABLE");
            Assert.fail();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", "t1");
        Connection tsconn = DriverManager.getConnection(PhoenixRuntimeTest.getUrl(), props);
        tsconn.createStatement().execute("CREATE VIEW V(V1 VARCHAR) AS SELECT * FROM BAS");
        Expression e7 = PhoenixRuntime.getTenantIdExpression((Connection)tsconn, (String)"V");
        Assert.assertNotNull((Object)e7);
        tsconn.createStatement().execute("CREATE LOCAL INDEX I3 ON V (V1)");
        try {
            PhoenixRuntime.getTenantIdExpression((Connection)tsconn, (String)"I3");
            Assert.fail();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    @Test
    public void testTableNameWithoutSchema() throws Exception {
        String tableName = "tableName";
        String tableNameNormalized = tableName.toUpperCase();
        this.getTableTester(tableNameNormalized, tableName);
    }

    @Test
    public void testTableNameWithSchema() throws Exception {
        String tableName = "tableName";
        String schemaName = "schemaName";
        String fullName = schemaName + "." + tableName;
        String fullNameNormalized = fullName.toUpperCase();
        this.getTableTester(fullNameNormalized, fullName);
    }

    @Test
    public void testCaseSensitiveTableNameWithoutSchema() throws Exception {
        String caseSensitiveTableName = "tableName";
        this.getTableTester(caseSensitiveTableName, this.quoteString(caseSensitiveTableName));
    }

    @Test
    public void testCaseSensitiveTableNameWithSchema() throws Exception {
        String caseSensitiveTableName = "tableName";
        String schemaName = "schemaName";
        String fullNameNormalized = schemaName.toUpperCase() + "." + caseSensitiveTableName;
        String fullNameQuoted = schemaName + "." + this.quoteString(caseSensitiveTableName);
        this.getTableTester(fullNameNormalized, fullNameQuoted);
    }

    @Test
    public void testCaseSensitiveTableNameWithCaseSensitiveSchema() throws Exception {
        String caseSensitiveTableName = "tableName";
        String caseSensitiveSchemaName = "schemaName";
        String fullName = caseSensitiveSchemaName + "." + caseSensitiveTableName;
        String fullNameQuoted = this.quoteString(caseSensitiveSchemaName) + "." + this.quoteString(caseSensitiveTableName);
        this.getTableTester(fullName, fullNameQuoted);
    }

    @Test
    public void testCaseSensitiveTableNameWithCaseSensitiveSchemaWithPeriod() throws Exception {
        String caseSensitiveTableName = "tableName";
        String caseSensitiveSchemaName = "schema.Name";
        String fullName = caseSensitiveSchemaName + "." + caseSensitiveTableName;
        String fullNameQuoted = this.quoteString(caseSensitiveSchemaName) + "." + this.quoteString(caseSensitiveTableName);
        this.getTableTester(fullName, fullNameQuoted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTableTester(String normalizedName, String sqlStatementName) throws SQLException {
        Connection conn = DriverManager.getConnection(PhoenixRuntimeTest.getUrl());
        try {
            conn.createStatement().execute("CREATE TABLE " + sqlStatementName + " (k VARCHAR PRIMARY KEY)");
            PTable aTable = PhoenixRuntime.getTable((Connection)conn, (String)normalizedName);
            Assert.assertNotNull((Object)aTable);
        }
        finally {
            if (null != conn) {
                conn.createStatement().execute("DROP TABLE IF EXISTS " + sqlStatementName);
            }
        }
    }

    private String quoteString(String string) {
        return "\"" + string + "\"";
    }

    @Test
    public void testGetWallClockTimeFromCellTimeStamp() {
        long ts = System.currentTimeMillis();
        Assert.assertEquals((long)ts, (long)PhoenixRuntime.getWallClockTimeFromCellTimeStamp((long)ts));
        long nanoTs = TransactionUtil.convertToNanoseconds((long)ts);
        Assert.assertEquals((long)ts, (long)PhoenixRuntime.getWallClockTimeFromCellTimeStamp((long)nanoTs));
        long skewedTs = ts + 86400000L;
        Assert.assertEquals((long)skewedTs, (long)PhoenixRuntime.getWallClockTimeFromCellTimeStamp((long)skewedTs));
    }
}

