/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;

public class IndexScrutiny {
    public static long scrutinizeIndex(Connection conn, String fullTableName, String fullIndexName) throws SQLException {
        PColumn dcol;
        PColumn dcol22;
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable ptable = pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName));
        int tableColumnOffset = 0;
        List tableColumns = ptable.getColumns();
        List tablePKColumns = ptable.getPKColumns();
        if (ptable.getBucketNum() != null) {
            tableColumnOffset = 1;
            tableColumns = tableColumns.subList(tableColumnOffset, tableColumns.size());
            tablePKColumns = tablePKColumns.subList(tableColumnOffset, tablePKColumns.size());
        }
        PTable pindex = pconn.getTable(new PTableKey(pconn.getTenantId(), fullIndexName));
        List indexColumns = pindex.getColumns();
        int indexColumnOffset = 0;
        if (pindex.getBucketNum() != null) {
            indexColumnOffset = 1;
        }
        if (pindex.getViewIndexId() != null) {
            ++indexColumnOffset;
        }
        if (indexColumnOffset > 0) {
            indexColumns = indexColumns.subList(indexColumnOffset, indexColumns.size());
        }
        StringBuilder indexQueryBuf = new StringBuilder("SELECT ");
        for (PColumn dcol3 : tablePKColumns) {
            indexQueryBuf.append("CAST(\"" + IndexUtil.getIndexColumnName((PColumn)dcol3) + "\" AS " + dcol3.getDataType().getSqlTypeName() + ")");
            indexQueryBuf.append(",");
        }
        for (Object icol : indexColumns) {
            dcol22 = IndexUtil.getDataColumn((PTable)ptable, (String)icol.getName().getString());
            if (!SchemaUtil.isPKColumn((PColumn)icol) || SchemaUtil.isPKColumn((PColumn)dcol22)) continue;
            indexQueryBuf.append("CAST (\"" + icol.getName().getString() + "\" AS " + dcol22.getDataType().getSqlTypeName() + ")");
            indexQueryBuf.append(",");
        }
        for (Object icol : indexColumns) {
            if (SchemaUtil.isPKColumn((PColumn)icol)) continue;
            dcol22 = IndexUtil.getDataColumn((PTable)ptable, (String)icol.getName().getString());
            indexQueryBuf.append("CAST (\"" + icol.getName().getString() + "\" AS " + dcol22.getDataType().getSqlTypeName() + ")");
            indexQueryBuf.append(",");
        }
        indexQueryBuf.setLength(indexQueryBuf.length() - 1);
        indexQueryBuf.append("\nFROM " + fullIndexName);
        StringBuilder tableQueryBuf = new StringBuilder("SELECT ");
        for (PColumn dcol22 : tablePKColumns) {
            tableQueryBuf.append("\"" + dcol22.getName().getString() + "\"");
            tableQueryBuf.append(",");
        }
        for (PColumn icol : indexColumns) {
            dcol = IndexUtil.getDataColumn((PTable)ptable, (String)icol.getName().getString());
            if (!SchemaUtil.isPKColumn((PColumn)icol) || SchemaUtil.isPKColumn((PColumn)dcol)) continue;
            if (dcol.getFamilyName() != null) {
                tableQueryBuf.append("\"" + dcol.getFamilyName().getString() + "\"");
                tableQueryBuf.append(".");
            }
            tableQueryBuf.append("\"" + dcol.getName().getString() + "\"");
            tableQueryBuf.append(",");
        }
        for (PColumn icol : indexColumns) {
            if (SchemaUtil.isPKColumn((PColumn)icol)) continue;
            dcol = IndexUtil.getDataColumn((PTable)ptable, (String)icol.getName().getString());
            if (dcol.getFamilyName() != null) {
                tableQueryBuf.append("\"" + dcol.getFamilyName().getString() + "\"");
                tableQueryBuf.append(".");
            }
            tableQueryBuf.append("\"" + dcol.getName().getString() + "\"");
            tableQueryBuf.append(",");
        }
        tableQueryBuf.setLength(tableQueryBuf.length() - 1);
        tableQueryBuf.append("\nFROM " + fullTableName + "\nWHERE (");
        for (PColumn dcol22 : tablePKColumns) {
            tableQueryBuf.append("\"" + dcol22.getName().getString() + "\"");
            tableQueryBuf.append(",");
        }
        tableQueryBuf.setLength(tableQueryBuf.length() - 1);
        tableQueryBuf.append(") = ((");
        for (int i = 0; i < tablePKColumns.size(); ++i) {
            tableQueryBuf.append("?");
            tableQueryBuf.append(",");
        }
        tableQueryBuf.setLength(tableQueryBuf.length() - 1);
        tableQueryBuf.append("))");
        String tableQuery = tableQueryBuf.toString();
        PreparedStatement istmt = conn.prepareStatement(tableQuery);
        String indexQuery = indexQueryBuf.toString();
        ResultSet irs = conn.createStatement().executeQuery(indexQuery);
        ResultSetMetaData irsmd = irs.getMetaData();
        long icount = 0L;
        while (irs.next()) {
            ++icount;
            StringBuilder pkBuf = new StringBuilder("(");
            for (int i = 0; i < tablePKColumns.size(); ++i) {
                PColumn dcol4 = (PColumn)tablePKColumns.get(i);
                int offset = i + 1;
                Object pkVal = irs.getObject(offset);
                PDataType pkType = PDataType.fromTypeId((int)irsmd.getColumnType(offset));
                istmt.setObject(offset, pkVal, dcol4.getDataType().getSqlType());
                pkBuf.append(pkType.toStringLiteral(pkVal));
                pkBuf.append(",");
            }
            pkBuf.setLength(pkBuf.length() - 1);
            pkBuf.append(")");
            ResultSet drs = istmt.executeQuery();
            ResultSetMetaData drsmd = drs.getMetaData();
            Assert.assertTrue((String)("Expected to find PK in data table: " + pkBuf), (boolean)drs.next());
            for (int i = 0; i < irsmd.getColumnCount(); ++i) {
                Object iVal = irs.getObject(i + 1);
                PDataType iType = PDataType.fromTypeId((int)irsmd.getColumnType(i + 1));
                Object dVal = drs.getObject(i + 1);
                PDataType dType = PDataType.fromTypeId((int)drsmd.getColumnType(i + 1));
                Assert.assertTrue((String)("Expected equality for " + drsmd.getColumnName(i + 1) + ", but " + iType.toStringLiteral(iVal) + "!=" + dType.toStringLiteral(dVal)), (boolean)Objects.equal((Object)iVal, (Object)dVal));
            }
        }
        long dcount = TestUtil.getRowCount(conn, fullTableName);
        Assert.assertEquals((String)"Expected data table row count to match", (long)dcount, (long)icount);
        return dcount;
    }
}

