/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.util.EquiDepthStreamHistogram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EquiDepthStreamHistogramTest {
    byte[] bytesA = Bytes.toBytes((String)"a");
    byte[] bytesB = Bytes.toBytes((String)"b");
    byte[] bytesC = Bytes.toBytes((String)"c");
    byte[] bytesD = Bytes.toBytes((String)"d");
    byte[] bytesE = Bytes.toBytes((String)"e");
    EquiDepthStreamHistogram.Bar a_b;
    EquiDepthStreamHistogram.Bar b_c;
    EquiDepthStreamHistogram.Bar c_d;
    EquiDepthStreamHistogram.Bar d_e;

    @Before
    public void resetBars() {
        this.a_b = new EquiDepthStreamHistogram.Bar(this.bytesA, this.bytesB);
        this.b_c = new EquiDepthStreamHistogram.Bar(this.bytesB, this.bytesC);
        this.c_d = new EquiDepthStreamHistogram.Bar(this.bytesC, this.bytesD);
        this.d_e = new EquiDepthStreamHistogram.Bar(this.bytesD, this.bytesE);
    }

    @Test
    public void testComparator() {
        ArrayList<EquiDepthStreamHistogram.Bar> barList = new ArrayList<EquiDepthStreamHistogram.Bar>();
        barList.add(this.b_c);
        barList.add(this.c_d);
        barList.add(this.a_b);
        Collections.sort(barList);
        Assert.assertEquals((Object)this.a_b, barList.get(0));
        Assert.assertEquals((Object)this.b_c, barList.get(1));
        Assert.assertEquals((Object)this.c_d, barList.get(2));
        EquiDepthStreamHistogram.Bar a_a = new EquiDepthStreamHistogram.Bar(this.bytesA, this.bytesA);
        Assert.assertEquals((long)0L, (long)this.a_b.compareTo(a_a));
        Assert.assertEquals((long)0L, (long)a_a.compareTo(this.a_b));
        Assert.assertEquals((long)1L, (long)this.b_c.compareTo(a_a));
        Assert.assertEquals((long)-1L, (long)a_a.compareTo(this.b_c));
        Assert.assertEquals((long)0L, (long)Collections.binarySearch(barList, a_a));
        Assert.assertEquals((long)1L, (long)Collections.binarySearch(barList, new EquiDepthStreamHistogram.Bar(this.bytesB, this.bytesB)));
        Assert.assertEquals((long)-4L, (long)Collections.binarySearch(barList, new EquiDepthStreamHistogram.Bar(Bytes.toBytes((String)"e"), Bytes.toBytes((String)"e"))));
        Assert.assertEquals((long)0L, (long)a_a.compareTo(a_a));
    }

    @Test
    public void testGetBar() {
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(10);
        EquiDepthStreamHistogram.Bar bar = histo.getBar(this.bytesB);
        Assert.assertTrue((boolean)Arrays.equals(this.bytesB, bar.getLeftBoundInclusive()));
        Assert.assertEquals((long)1L, (long)histo.bars.size());
        Assert.assertTrue((bar == histo.getBar(this.bytesB) ? 1 : 0) != 0);
        Assert.assertTrue((bar == histo.getBar(this.bytesA) ? 1 : 0) != 0);
        Assert.assertTrue((bar == histo.getBar(this.bytesC) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)histo.bars.size());
        Assert.assertArrayEquals((byte[])this.bytesA, (byte[])bar.getLeftBoundInclusive());
        Assert.assertArrayEquals((byte[])this.bytesC, (byte[])bar.getRightBoundExclusive());
        histo.bars = new ArrayList();
        histo.bars.add(this.b_c);
        histo.bars.add(this.c_d);
        Assert.assertEquals((Object)this.b_c, (Object)histo.getBar(this.bytesB));
        Assert.assertEquals((Object)this.c_d, (Object)histo.getBar(this.bytesC));
        Assert.assertTrue((histo.getBar(this.bytesA) == this.b_c ? 1 : 0) != 0);
        Assert.assertTrue((histo.getBar(this.bytesE) == this.c_d ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])this.bytesA, (byte[])this.b_c.getLeftBoundInclusive());
        Assert.assertArrayEquals((byte[])this.bytesE, (byte[])this.c_d.getRightBoundExclusive());
    }

    @Test
    public void testMergeBars() {
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(2, 1);
        histo.bars.add(this.a_b);
        histo.bars.add(this.b_c);
        histo.bars.add(this.c_d);
        histo.bars.add(this.d_e);
        histo.totalCount = 20L;
        this.a_b.incrementCount(3L);
        this.b_c.incrementCount(2L);
        this.c_d.incrementCount(10L);
        this.d_e.incrementCount(5L);
        histo.mergeBars();
        Assert.assertEquals((long)3L, (long)histo.bars.size());
        EquiDepthStreamHistogram.Bar mergedBar = (EquiDepthStreamHistogram.Bar)histo.bars.get(0);
        Assert.assertEquals((long)5L, (long)mergedBar.getSize());
        Assert.assertArrayEquals((byte[])this.bytesA, (byte[])mergedBar.getLeftBoundInclusive());
        Assert.assertArrayEquals((byte[])this.bytesC, (byte[])mergedBar.getRightBoundExclusive());
        histo.mergeBars();
        Assert.assertEquals((long)2L, (long)histo.bars.size());
        mergedBar = (EquiDepthStreamHistogram.Bar)histo.bars.get(0);
        Assert.assertEquals((long)15L, (long)mergedBar.getSize());
        Assert.assertArrayEquals((byte[])this.bytesA, (byte[])mergedBar.getLeftBoundInclusive());
        Assert.assertArrayEquals((byte[])this.bytesD, (byte[])mergedBar.getRightBoundExclusive());
        histo.mergeBars();
        Assert.assertEquals((long)2L, (long)histo.bars.size());
    }

    @Test
    public void testSplitBar() {
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(10);
        EquiDepthStreamHistogram.Bar targetBar = new EquiDepthStreamHistogram.Bar(this.bytesA, this.bytesC);
        targetBar.incrementCount(31L);
        histo.bars.add(targetBar);
        histo.splitBar(targetBar);
        Assert.assertEquals((long)2L, (long)histo.bars.size());
        EquiDepthStreamHistogram.Bar newLeft = (EquiDepthStreamHistogram.Bar)histo.bars.get(0);
        Assert.assertArrayEquals((byte[])this.bytesA, (byte[])newLeft.getLeftBoundInclusive());
        Assert.assertArrayEquals((byte[])this.bytesB, (byte[])newLeft.getRightBoundExclusive());
        Assert.assertEquals((long)15L, (long)newLeft.getSize());
        EquiDepthStreamHistogram.Bar newRight = (EquiDepthStreamHistogram.Bar)histo.bars.get(1);
        Assert.assertArrayEquals((byte[])this.bytesB, (byte[])newRight.getLeftBoundInclusive());
        Assert.assertArrayEquals((byte[])this.bytesC, (byte[])newRight.getRightBoundExclusive());
        Assert.assertEquals((long)16L, (long)newRight.getSize());
        histo.bars.clear();
        targetBar = new EquiDepthStreamHistogram.Bar(this.bytesA, this.bytesE);
        targetBar.incrementCount(10L);
        this.a_b.incrementCount(3L);
        targetBar.addBlockedBar(this.a_b);
        this.b_c.incrementCount(4L);
        targetBar.addBlockedBar(this.b_c);
        this.c_d.incrementCount(2L);
        targetBar.addBlockedBar(this.c_d);
        this.d_e.incrementCount(1L);
        targetBar.addBlockedBar(this.d_e);
        histo.bars.add(targetBar);
        histo.splitBar(targetBar);
        newLeft = (EquiDepthStreamHistogram.Bar)histo.bars.get(0);
        newRight = (EquiDepthStreamHistogram.Bar)histo.bars.get(1);
        Assert.assertEquals((long)10L, (long)newLeft.getSize());
        Assert.assertEquals((Object)this.a_b, newLeft.getBlockedBars().get(0));
        Assert.assertEquals((Object)this.d_e, newLeft.getBlockedBars().get(1));
        Assert.assertEquals((long)10L, (long)newRight.getSize());
        Assert.assertEquals((Object)this.b_c, newRight.getBlockedBars().get(0));
        Assert.assertEquals((Object)this.c_d, newRight.getBlockedBars().get(1));
    }

    @Test
    public void testAddValues() {
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(3);
        for (int i = 0; i < 100; ++i) {
            histo.addValue(Bytes.toBytes((String)(i + "")));
        }
        Assert.assertEquals((long)21L, (long)histo.bars.size());
        long total = 0L;
        for (EquiDepthStreamHistogram.Bar b : histo.bars) {
            total += b.getSize();
        }
        Assert.assertEquals((long)100L, (long)total);
    }

    @Test
    public void testComputeBuckets() {
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(3);
        histo.addValue(this.bytesA);
        histo.addValue(this.bytesB);
        histo.addValue(this.bytesC);
        histo.addValue(this.bytesD);
        histo.addValue(this.bytesE);
        List buckets = histo.computeBuckets();
        Assert.assertEquals((long)3L, (long)buckets.size());
        EquiDepthStreamHistogram.Bucket bucket = (EquiDepthStreamHistogram.Bucket)buckets.get(0);
        Assert.assertEquals((long)2L, (long)bucket.getCountEstimate());
        this.assertInBucket(bucket, this.bytesA);
        this.assertInBucket(bucket, this.bytesB);
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.get(1);
        Assert.assertEquals((long)2L, (long)bucket.getCountEstimate());
        this.assertInBucket(bucket, this.bytesC);
        this.assertInBucket(bucket, this.bytesD);
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.get(2);
        Assert.assertEquals((long)1L, (long)bucket.getCountEstimate());
        this.assertInBucketInclusive(bucket, this.bytesE);
        histo.bars.clear();
        this.a_b.incrementCount();
        histo.bars.add(this.a_b);
        EquiDepthStreamHistogram.Bar b_d = new EquiDepthStreamHistogram.Bar(this.bytesB, this.bytesD);
        b_d.incrementCount(3L);
        histo.bars.add(b_d);
        histo.bars.add(this.d_e);
        buckets = histo.computeBuckets();
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.get(0);
        byte[][] splits = Bytes.split((byte[])this.bytesB, (byte[])this.bytesD, (int)8);
        Assert.assertArrayEquals((byte[])splits[3], (byte[])bucket.getRightBoundExclusive());
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.get(1);
        Assert.assertArrayEquals((byte[])splits[3], (byte[])bucket.leftBoundInclusive);
    }

    private void assertInBucket(EquiDepthStreamHistogram.Bucket bucket, byte[] value) {
        Assert.assertTrue((Bytes.compareTo((byte[])value, (byte[])bucket.getLeftBoundInclusive()) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.compareTo((byte[])value, (byte[])bucket.getRightBoundExclusive()) < 0 ? 1 : 0) != 0);
    }

    private void assertInBucketInclusive(EquiDepthStreamHistogram.Bucket bucket, byte[] value) {
        Assert.assertTrue((Bytes.compareTo((byte[])value, (byte[])bucket.getLeftBoundInclusive()) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.compareTo((byte[])value, (byte[])bucket.getRightBoundExclusive()) <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUniformDistribution() {
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(4);
        for (int i = 0; i < 100000; ++i) {
            histo.addValue(Bytes.toBytes((String)(i % 8 + "")));
        }
        Iterator buckets = histo.computeBuckets().iterator();
        EquiDepthStreamHistogram.Bucket bucket = (EquiDepthStreamHistogram.Bucket)buckets.next();
        Assert.assertEquals((long)25000L, (long)bucket.getCountEstimate());
        this.assertInBucket(bucket, Bytes.toBytes((String)"0"));
        this.assertInBucket(bucket, Bytes.toBytes((String)"1"));
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.next();
        Assert.assertEquals((long)25000L, (long)bucket.getCountEstimate());
        this.assertInBucket(bucket, Bytes.toBytes((String)"2"));
        this.assertInBucket(bucket, Bytes.toBytes((String)"3"));
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.next();
        Assert.assertEquals((long)25000L, (long)bucket.getCountEstimate());
        this.assertInBucket(bucket, Bytes.toBytes((String)"4"));
        this.assertInBucket(bucket, Bytes.toBytes((String)"5"));
        bucket = (EquiDepthStreamHistogram.Bucket)buckets.next();
        Assert.assertEquals((long)25000L, (long)bucket.getCountEstimate());
        this.assertInBucket(bucket, Bytes.toBytes((String)"6"));
        this.assertInBucket(bucket, Bytes.toBytes((String)"7"));
    }

    @Test
    public void testSkewedDistribution() {
        Random random = new Random();
        EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(5);
        for (int i = 0; i < 100000; ++i) {
            int value = (int)Math.round(random.nextGaussian() * 25.0 + 100.0);
            histo.addValue(Bytes.toBytes((int)value));
        }
        List buckets = histo.computeBuckets();
        EquiDepthStreamHistogram.Bucket first = (EquiDepthStreamHistogram.Bucket)buckets.get(0);
        int firstLength = this.getLength(first);
        EquiDepthStreamHistogram.Bucket last = (EquiDepthStreamHistogram.Bucket)buckets.get(4);
        int lastLength = this.getLength(last);
        EquiDepthStreamHistogram.Bucket middle = (EquiDepthStreamHistogram.Bucket)buckets.get(2);
        int middleLength = this.getLength(middle);
        Assert.assertTrue((firstLength - middleLength > 25 ? 1 : 0) != 0);
        Assert.assertTrue((lastLength - middleLength > 25 ? 1 : 0) != 0);
    }

    private int getLength(EquiDepthStreamHistogram.Bucket last) {
        return Math.abs(Bytes.toInt((byte[])last.getLeftBoundInclusive()) - Bytes.toInt((byte[])last.getRightBoundExclusive()));
    }
}

