/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedRegionServer
extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedRegionServer.class);
    static boolean doDelay = false;
    private static int DELAY_GET = 0;
    private static int DELAY_SCAN = 30000;
    private static int DELAY_MUTATE = 0;
    private static int DELAY_MULTI_OP = 0;

    public static void setDelayEnabled(boolean delay) {
        doDelay = delay;
    }

    public static void setDelayGet(int delayGet) {
        DELAY_GET = delayGet;
    }

    public static void setDelayScan(int delayScan) {
        DELAY_SCAN = delayScan;
    }

    public static void setDelayMutate(int delayMutate) {
        DELAY_MUTATE = delayMutate;
    }

    public static void setDelayMultiOp(int delayMultiOp) {
        DELAY_MULTI_OP = delayMultiOp;
    }

    public DelayedRegionServer(Configuration conf) throws IOException, InterruptedException {
        super(conf);
    }

    protected RSRpcServices createRpcServices() throws IOException {
        return new DelayedRSRpcServices((HRegionServer)this);
    }

    public static class DelayedRSRpcServices
    extends RSRpcServices {
        DelayedRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            try {
                if (doDelay) {
                    Thread.sleep(DELAY_GET);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Sleep interrupted during get operation", (Throwable)e);
            }
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
            try {
                if (doDelay) {
                    Thread.sleep(DELAY_MUTATE);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Sleep interrupted during mutate operation", (Throwable)e);
            }
            return super.mutate(rpcc, request);
        }

        public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
            try {
                if (doDelay) {
                    Thread.sleep(DELAY_MULTI_OP);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Sleep interrupted during multi operation", (Throwable)e);
            }
            return super.multi(rpcc, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            try {
                if (doDelay) {
                    Thread.sleep(DELAY_SCAN);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Sleep interrupted during scan operation", (Throwable)e);
            }
            return super.scan(controller, request);
        }
    }
}

