/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;

public class DateUtilTest {
    private static final long ONE_HOUR_IN_MILLIS = 3600000L;

    @Test
    public void testDemonstrateSetNanosOnTimestampLosingMillis() {
        Timestamp ts1 = new Timestamp(120055L);
        ts1.setNanos(60);
        Timestamp ts2 = new Timestamp(120100L);
        ts2.setNanos(60);
        Assert.assertTrue((boolean)ts1.equals(ts2));
        ts1 = DateUtil.getTimestamp((long)120055L, (int)60);
        ts2 = DateUtil.getTimestamp((long)120100L, (int)60);
        Assert.assertFalse((boolean)ts1.equals(ts2));
        Assert.assertTrue((boolean)ts2.after(ts1));
    }

    @Test
    public void testGetDateParser_DefaultTimeZone() throws ParseException {
        Date date = new Date(DateUtil.getDateTimeParser((String)"yyyy-MM-dd", (PDataType)PDate.INSTANCE).parseDateTime("1970-01-01"));
        Assert.assertEquals((long)0L, (long)date.getTime());
    }

    @Test
    public void testGetDateParser_CustomTimeZone() throws ParseException {
        Date date = new Date(DateUtil.getDateTimeParser((String)"yyyy-MM-dd", (PDataType)PDate.INSTANCE, (String)TimeZone.getTimeZone("GMT+1").getID()).parseDateTime("1970-01-01"));
        Assert.assertEquals((long)-3600000L, (long)date.getTime());
    }

    @Test
    public void testGetDateParser_LocalTimeZone() throws ParseException {
        Date date = new Date(DateUtil.getDateTimeParser((String)"yyyy-MM-dd", (PDataType)PDate.INSTANCE, (String)TimeZone.getDefault().getID()).parseDateTime("1970-01-01"));
        Assert.assertEquals((Object)Date.valueOf("1970-01-01"), (Object)date);
    }

    @Test
    public void testGetTimestampParser_DefaultTimeZone() throws ParseException {
        Timestamp ts = new Timestamp(DateUtil.getDateTimeParser((String)"yyyy-MM-dd HH:mm:ss", (PDataType)PTimestamp.INSTANCE).parseDateTime("1970-01-01 00:00:00"));
        Assert.assertEquals((long)0L, (long)ts.getTime());
    }

    @Test
    public void testGetTimestampParser_CustomTimeZone() throws ParseException {
        Timestamp ts = new Timestamp(DateUtil.getDateTimeParser((String)"yyyy-MM-dd HH:mm:ss", (PDataType)PTimestamp.INSTANCE, (String)TimeZone.getTimeZone("GMT+1").getID()).parseDateTime("1970-01-01 00:00:00"));
        Assert.assertEquals((long)-3600000L, (long)ts.getTime());
    }

    @Test
    public void testGetTimestampParser_LocalTimeZone() throws ParseException {
        Timestamp ts = new Timestamp(DateUtil.getDateTimeParser((String)"yyyy-MM-dd HH:mm:ss", (PDataType)PTimestamp.INSTANCE, (String)TimeZone.getDefault().getID()).parseDateTime("1970-01-01 00:00:00"));
        Assert.assertEquals((Object)Timestamp.valueOf("1970-01-01 00:00:00"), (Object)ts);
    }

    @Test
    public void testGetTimeParser_DefaultTimeZone() throws ParseException {
        Time time = new Time(DateUtil.getDateTimeParser((String)"HH:mm:ss", (PDataType)PTime.INSTANCE).parseDateTime("00:00:00"));
        Assert.assertEquals((long)0L, (long)time.getTime());
    }

    @Test
    public void testGetTimeParser_CustomTimeZone() throws ParseException {
        Time time = new Time(DateUtil.getDateTimeParser((String)"HH:mm:ss", (PDataType)PTime.INSTANCE, (String)TimeZone.getTimeZone("GMT+1").getID()).parseDateTime("00:00:00"));
        Assert.assertEquals((long)-3600000L, (long)time.getTime());
    }

    @Test
    public void testGetTimeParser_LocalTimeZone() throws ParseException {
        Time time = new Time(DateUtil.getDateTimeParser((String)"HH:mm:ss", (PDataType)PTime.INSTANCE, (String)TimeZone.getDefault().getID()).parseDateTime("00:00:00"));
        Assert.assertEquals((Object)Time.valueOf("00:00:00"), (Object)time);
    }

    @Test
    public void testParseDate() {
        Assert.assertEquals((long)10000L, (long)DateUtil.parseDate((String)"1970-01-01 00:00:10").getTime());
    }

    @Test
    public void testParseDate_PureDate() {
        Assert.assertEquals((long)0L, (long)DateUtil.parseDate((String)"1970-01-01").getTime());
    }

    @Test(expected=IllegalDataException.class)
    public void testParseDate_InvalidDate() {
        DateUtil.parseDate((String)"not-a-date");
    }

    @Test
    public void testParseTime() {
        Assert.assertEquals((long)10000L, (long)DateUtil.parseTime((String)"1970-01-01 00:00:10").getTime());
    }

    @Test(expected=IllegalDataException.class)
    public void testParseTime_InvalidTime() {
        DateUtil.parseDate((String)"not-a-time");
    }

    @Test
    public void testParseTimestamp() {
        Assert.assertEquals((long)10000L, (long)DateUtil.parseTimestamp((String)"1970-01-01 00:00:10").getTime());
    }

    @Test
    public void testParseTimestamp_WithMillis() {
        Assert.assertEquals((long)10123L, (long)DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.123").getTime());
    }

    @Test
    public void testParseTimestamp_WithNanos() {
        Assert.assertEquals((long)123000000L, (long)DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.123").getNanos());
        Assert.assertEquals((long)123456780L, (long)DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.12345678").getNanos());
        Assert.assertEquals((long)999999999L, (long)DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.999999999").getNanos());
    }

    @Test(expected=IllegalDataException.class)
    public void testParseTimestamp_tooLargeNanos() {
        DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.9999999999");
    }

    @Test(expected=IllegalDataException.class)
    public void testParseTimestamp_missingNanos() {
        DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.");
    }

    @Test(expected=IllegalDataException.class)
    public void testParseTimestamp_negativeNanos() {
        DateUtil.parseTimestamp((String)"1970-01-01 00:00:10.-1");
    }

    @Test(expected=IllegalDataException.class)
    public void testParseTimestamp_InvalidTimestamp() {
        DateUtil.parseTimestamp((String)"not-a-timestamp");
    }

    @Test
    public void testTZCorrection() {
        TimeZone tz = TimeZone.getDefault();
        LocalDateTime nowLDT = LocalDateTime.now();
        Instant nowInstantLocal = nowLDT.atZone(ZoneId.systemDefault()).toInstant();
        Instant nowInstantGMT = nowLDT.atZone(ZoneOffset.UTC).toInstant();
        Date sqlDateNowLocal = new Date(nowInstantLocal.toEpochMilli());
        Time sqlTimeNowLocal = new Time(nowInstantLocal.toEpochMilli());
        Timestamp sqlTimestampNowLocal = new Timestamp(nowInstantLocal.toEpochMilli());
        Date sqlDateNowGMT = new Date(nowInstantGMT.toEpochMilli());
        Time sqlTimeNowGMT = new Time(nowInstantGMT.toEpochMilli());
        Timestamp sqlTimestampNowGMT = new Timestamp(nowInstantGMT.toEpochMilli());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Date)sqlDateNowLocal, (TimeZone)tz), (Object)sqlDateNowGMT);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Time)sqlTimeNowLocal, (TimeZone)tz), (Object)sqlTimeNowGMT);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)sqlTimestampNowLocal, (TimeZone)tz), (Object)sqlTimestampNowGMT);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Date)sqlDateNowGMT, (TimeZone)tz), (Object)sqlDateNowLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Time)sqlTimeNowGMT, (TimeZone)tz), (Object)sqlTimeNowLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)sqlTimestampNowGMT, (TimeZone)tz), (Object)sqlTimestampNowLocal);
        LocalDateTime summerLDT = LocalDateTime.of(2023, 6, 1, 10, 10, 10);
        LocalDateTime winterLDT = LocalDateTime.of(2023, 1, 1, 10, 10, 10);
        Instant summerInstantLocal = summerLDT.atZone(ZoneId.systemDefault()).toInstant();
        Instant summerInstantDisplaced = summerLDT.atZone(ZoneOffset.UTC).toInstant();
        Instant winterInstantLocal = winterLDT.atZone(ZoneId.systemDefault()).toInstant();
        Instant winterInstantDisplaced = winterLDT.atZone(ZoneOffset.UTC).toInstant();
        Date sqlDateSummerLocal = new Date(summerInstantLocal.toEpochMilli());
        Time sqlTimeSummerLocal = new Time(summerInstantLocal.toEpochMilli());
        Timestamp sqlTimestampSummerLocal = new Timestamp(summerInstantLocal.toEpochMilli());
        Date sqlDateSummerDisplaced = new Date(summerInstantDisplaced.toEpochMilli());
        Time sqlTimeSummerDisplaced = new Time(summerInstantDisplaced.toEpochMilli());
        Timestamp sqlTimestampSummerDisplaced = new Timestamp(summerInstantDisplaced.toEpochMilli());
        Date sqlDateWinterLocal = new Date(winterInstantLocal.toEpochMilli());
        Time sqlTimeWinterLocal = new Time(winterInstantLocal.toEpochMilli());
        Timestamp sqlTimestampWinterLocal = new Timestamp(winterInstantLocal.toEpochMilli());
        Date sqlDateWinterDisplaced = new Date(winterInstantDisplaced.toEpochMilli());
        Time sqlTimeWinterDisplaced = new Time(winterInstantDisplaced.toEpochMilli());
        Timestamp sqlTimestampWinterDisplaced = new Timestamp(winterInstantDisplaced.toEpochMilli());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Date)sqlDateSummerLocal, (TimeZone)tz), (Object)sqlDateSummerDisplaced);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Time)sqlTimeSummerLocal, (TimeZone)tz), (Object)sqlTimeSummerDisplaced);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)sqlTimestampSummerLocal, (TimeZone)tz), (Object)sqlTimestampSummerDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Date)sqlDateSummerDisplaced, (TimeZone)tz), (Object)sqlDateSummerLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Time)sqlTimeSummerDisplaced, (TimeZone)tz), (Object)sqlTimeSummerLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)sqlTimestampSummerDisplaced, (TimeZone)tz), (Object)sqlTimestampSummerLocal);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Date)sqlDateWinterLocal, (TimeZone)tz), (Object)sqlDateWinterDisplaced);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Time)sqlTimeWinterLocal, (TimeZone)tz), (Object)sqlTimeWinterDisplaced);
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)sqlTimestampWinterLocal, (TimeZone)tz), (Object)sqlTimestampWinterDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Date)sqlDateWinterDisplaced, (TimeZone)tz), (Object)sqlDateWinterLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Time)sqlTimeWinterDisplaced, (TimeZone)tz), (Object)sqlTimeWinterLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)sqlTimestampWinterDisplaced, (TimeZone)tz), (Object)sqlTimestampWinterLocal);
        ZoneId pacific = ZoneId.of("America/Los_Angeles");
        Assert.assertEquals((String)"Test must be run in America/Los_Angeles time zone", (Object)ZoneId.systemDefault(), (Object)pacific);
        LocalDateTime endOfWinter = LocalDateTime.of(2023, 3, 12, 1, 59, 59);
        LocalDateTime nonExistent = LocalDateTime.of(2023, 3, 12, 2, 0, 0);
        LocalDateTime startOfSummer = LocalDateTime.of(2023, 3, 12, 3, 0, 0);
        LocalDateTime endOfSummer = LocalDateTime.of(2023, 1, 5, 0, 59, 59);
        LocalDateTime ambiguous = LocalDateTime.of(2023, 1, 5, 1, 30, 0);
        LocalDateTime startOfWinter = LocalDateTime.of(2023, 1, 5, 2, 0, 0);
        Timestamp endOfWinterLocal = Timestamp.from(endOfWinter.atZone(pacific).toInstant());
        Timestamp endOfWinterDisplaced = Timestamp.from(endOfWinter.atZone(ZoneOffset.UTC).toInstant());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)endOfWinterLocal, (TimeZone)tz), (Object)endOfWinterDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)endOfWinterDisplaced, (TimeZone)tz), (Object)endOfWinterLocal);
        Timestamp startOfSummerLocal = Timestamp.from(startOfSummer.atZone(pacific).toInstant());
        Timestamp startOfSummerDisplaced = Timestamp.from(startOfSummer.atZone(ZoneOffset.UTC).toInstant());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)startOfSummerLocal, (TimeZone)tz), (Object)startOfSummerDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)startOfSummerDisplaced, (TimeZone)tz), (Object)startOfSummerLocal);
        Timestamp nonExistentLocal = Timestamp.from(nonExistent.atZone(pacific).toInstant());
        Assert.assertEquals((Object)nonExistentLocal, (Object)startOfSummerLocal);
        Timestamp nonExistentDisplaced = Timestamp.from(nonExistent.atZone(ZoneOffset.UTC).toInstant());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)nonExistentLocal, (TimeZone)tz), (Object)startOfSummerDisplaced);
        Assert.assertNotEquals((Object)nonExistentDisplaced, (Object)startOfSummerDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)nonExistentDisplaced, (TimeZone)tz), (Object)nonExistentLocal);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)startOfSummerDisplaced, (TimeZone)tz), (Object)nonExistentLocal);
        Timestamp endOfSummerLocal = Timestamp.from(endOfSummer.atZone(pacific).toInstant());
        Timestamp endOfSummerDisplaced = Timestamp.from(endOfSummer.atZone(ZoneOffset.UTC).toInstant());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)endOfSummerLocal, (TimeZone)tz), (Object)endOfSummerDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)endOfSummerDisplaced, (TimeZone)tz), (Object)endOfSummerLocal);
        Timestamp ambiguousLocal = Timestamp.from(ambiguous.atZone(pacific).toInstant());
        Timestamp ambiguousDisplaced = Timestamp.from(ambiguous.atZone(ZoneOffset.UTC).toInstant());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)ambiguousLocal, (TimeZone)tz), (Object)ambiguousDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)ambiguousDisplaced, (TimeZone)tz), (Object)ambiguousLocal);
        Timestamp startOfWinterLocal = Timestamp.from(startOfWinter.atZone(pacific).toInstant());
        Timestamp startOfWinterDisplaced = Timestamp.from(startOfWinter.atZone(ZoneOffset.UTC).toInstant());
        Assert.assertEquals((Object)DateUtil.applyInputDisplacement((Timestamp)startOfWinterLocal, (TimeZone)tz), (Object)startOfWinterDisplaced);
        Assert.assertEquals((Object)DateUtil.applyOutputDisplacement((Timestamp)startOfWinterDisplaced, (TimeZone)tz), (Object)startOfWinterLocal);
    }
}

