/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.types.PCharArray;
import org.apache.phoenix.schema.types.PDecimalArray;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.util.ColumnInfo;
import org.junit.Assert;
import org.junit.Test;

public class ColumnInfoTest {
    @Test
    public void testToFromStringRoundTrip() {
        ColumnInfo columnInfo = new ColumnInfo("a.myColumn", 4);
        Assert.assertEquals((Object)columnInfo, (Object)ColumnInfo.fromString((String)columnInfo.toString()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromString_InvalidString() {
        ColumnInfo.fromString((String)"invalid");
    }

    @Test
    public void testFromString_InvalidDataType() {
        try {
            ColumnInfo.fromString((String)"COLNAME:badType");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SQLException));
            SQLException sqlE = (SQLException)e.getCause();
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)sqlE.getErrorCode());
        }
    }

    @Test
    public void testToFromColonInColumnName() {
        ColumnInfo columnInfo = new ColumnInfo(":myColumn", 4);
        Assert.assertEquals((Object)columnInfo, (Object)ColumnInfo.fromString((String)columnInfo.toString()));
    }

    @Test
    public void testOptionalDescriptionType() {
        this.testType(new ColumnInfo("a.myColumn", 1), "CHAR:\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", 1, Integer.valueOf(100)), "CHAR(100):\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", 12), "VARCHAR:\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", 12, Integer.valueOf(100)), "VARCHAR(100):\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", 3), "DECIMAL:\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", 3, Integer.valueOf(100), Integer.valueOf(10)), "DECIMAL(100,10):\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", -2, Integer.valueOf(5)), "BINARY(5):\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", PCharArray.INSTANCE.getSqlType(), Integer.valueOf(3)), "CHAR(3) ARRAY:\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", PDecimalArray.INSTANCE.getSqlType(), Integer.valueOf(10), Integer.valueOf(2)), "DECIMAL(10,2) ARRAY:\"a\".\"myColumn\"");
        this.testType(new ColumnInfo("a.myColumn", PVarcharArray.INSTANCE.getSqlType(), Integer.valueOf(4)), "VARCHAR(4) ARRAY:\"a\".\"myColumn\"");
    }

    private void testType(ColumnInfo columnInfo, String expected) {
        Assert.assertEquals((Object)expected, (Object)columnInfo.toString());
        ColumnInfo reverted = ColumnInfo.fromString((String)columnInfo.toString());
        Assert.assertEquals((Object)reverted.getColumnName(), (Object)columnInfo.getColumnName());
        Assert.assertEquals((Object)reverted.getDisplayName(), (Object)columnInfo.getDisplayName());
        Assert.assertEquals((long)reverted.getSqlType(), (long)columnInfo.getSqlType());
        Assert.assertEquals((Object)reverted.getMaxLength(), (Object)columnInfo.getMaxLength());
        Assert.assertEquals((Object)reverted.getScale(), (Object)columnInfo.getScale());
    }
}

