/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tx;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class FlappingTransactionIT
extends ParallelStatsDisabledIT {
    private final String txProvider;

    public FlappingTransactionIT(String provider) {
        this.txProvider = provider;
    }

    @Parameterized.Parameters(name="FlappingTransactionIT_transactionProvider={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"OMID"}});
    }

    @Test
    public void testDelete() throws Exception {
        String transTableName = FlappingTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        String selectSQL = "SELECT * FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(FlappingTransactionIT.getUrl());
             Connection conn1 = DriverManager.getConnection(FlappingTransactionIT.getUrl());
             Connection conn2 = DriverManager.getConnection(FlappingTransactionIT.getUrl());){
            TestUtil.createTransactionalTable(conn, fullTableName, "TRANSACTION_PROVIDER='" + this.txProvider + "'");
            conn1.setAutoCommit(false);
            ResultSet rs = conn1.createStatement().executeQuery(selectSQL);
            Assert.assertFalse((boolean)rs.next());
            String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn1.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            conn1.commit();
            TestUtil.setRowKeyColumns(stmt, 2);
            stmt.execute();
            int rowsDeleted = conn1.createStatement().executeUpdate("DELETE FROM " + fullTableName);
            Assert.assertEquals((long)2L, (long)rowsDeleted);
            rs = conn2.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            conn1.commit();
            rs = conn1.createStatement().executeQuery(selectSQL);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testInflightUpdateNotSeen() throws Exception {
        String transTableName = FlappingTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        String selectSQL = "SELECT * FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(FlappingTransactionIT.getUrl());
             Connection conn1 = DriverManager.getConnection(FlappingTransactionIT.getUrl());
             Connection conn2 = DriverManager.getConnection(FlappingTransactionIT.getUrl());){
            TestUtil.createTransactionalTable(conn, fullTableName, "TRANSACTION_PROVIDER='" + this.txProvider + "'");
            conn1.setAutoCommit(false);
            conn2.setAutoCommit(true);
            ResultSet rs = conn1.createStatement().executeQuery(selectSQL);
            Assert.assertFalse((boolean)rs.next());
            String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn1.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            conn1.commit();
            TestUtil.setRowKeyColumns(stmt, 2);
            stmt.execute();
            rs = conn1.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName + " WHERE int_col1 IS NULL");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk, int_col1) VALUES(?, ?, ?, ?, ?, ?, 1)";
            stmt = conn1.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            rs = conn1.createStatement().executeQuery("SELECT int_col1 FROM " + fullTableName + " WHERE int_col1 = 1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName + " WHERE int_col1 = 1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullTableName + " WHERE int_col1 = 1");
            boolean hasNext = rs.next();
            Assert.assertFalse((boolean)hasNext);
            conn1.commit();
            rs = conn2.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName + " WHERE int_col1 = 1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullTableName + " WHERE int_col1 = 1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testInflightDeleteNotSeen() throws Exception {
        String transTableName = FlappingTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        String selectSQL = "SELECT * FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(FlappingTransactionIT.getUrl());
             Connection conn1 = DriverManager.getConnection(FlappingTransactionIT.getUrl());
             Connection conn2 = DriverManager.getConnection(FlappingTransactionIT.getUrl());){
            TestUtil.createTransactionalTable(conn, fullTableName, "TRANSACTION_PROVIDER='" + this.txProvider + "'");
            conn1.setAutoCommit(false);
            conn2.setAutoCommit(true);
            ResultSet rs = conn1.createStatement().executeQuery(selectSQL);
            Assert.assertFalse((boolean)rs.next());
            String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn1.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            TestUtil.setRowKeyColumns(stmt, 2);
            stmt.execute();
            conn1.commit();
            rs = conn1.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            String delete = "DELETE FROM " + fullTableName + " WHERE varchar_pk = 'varchar1'";
            stmt = conn1.prepareStatement(delete);
            int count = stmt.executeUpdate();
            Assert.assertEquals((long)1L, (long)count);
            rs = conn1.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            conn1.commit();
            rs = conn2.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testExternalTxContext() throws Exception {
        ResultSet rs;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(FlappingTransactionIT.getUrl(), props);
        conn.setAutoCommit(false);
        String fullTableName = FlappingTransactionIT.generateUniqueName();
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + fullTableName + "(K VARCHAR PRIMARY KEY, V1 VARCHAR, V2 VARCHAR) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.txProvider + "'");
        Table htable = pconn.getQueryServices().getTable(Bytes.toBytes((String)fullTableName));
        stmt.executeUpdate("upsert into " + fullTableName + " values('x', 'a', 'a')");
        conn.commit();
        try (Connection newConn = DriverManager.getConnection(FlappingTransactionIT.getUrl(), props);){
            rs = newConn.createStatement().executeQuery("select count(*) from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
        PhoenixTransactionProvider provider = TransactionFactory.Provider.valueOf((String)this.txProvider).getTransactionProvider();
        PhoenixTransactionContext txContext = provider.getTransactionContext(pconn);
        txContext.begin();
        Table txTable = txContext.getTransactionalTable(htable, false);
        Put put = new Put(Bytes.toBytes((String)"z"));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V1"), Bytes.toBytes((String)"b"));
        txTable.put(put);
        pconn.setTransactionContext(txContext);
        conn.createStatement().executeUpdate("upsert into " + fullTableName + " values('y', 'c', 'c')");
        try (Connection newConn = DriverManager.getConnection(FlappingTransactionIT.getUrl(), props);){
            rs = newConn.createStatement().executeQuery("select count(*) from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
        Connection connWithConflict = DriverManager.getConnection(FlappingTransactionIT.getUrl(), props);
        connWithConflict.createStatement().execute("upsert into " + fullTableName + " values('z', 'd', 'd')");
        rs = conn.createStatement().executeQuery("select count(*) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        txContext.commit();
        try {
            connWithConflict.commit();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION.getErrorCode(), (long)e.getErrorCode());
        }
        try (Connection newConn = DriverManager.getConnection(FlappingTransactionIT.getUrl(), props);){
            rs = newConn.createStatement().executeQuery("select count(*) from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
        }
        txContext = provider.getTransactionContext(pconn);
        txContext.begin();
        txTable = txContext.getTransactionalTable(htable, false);
        put = new Put(Bytes.toBytes((String)"j"));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V1"), Bytes.toBytes((String)"e"));
        txTable.put(put);
        pconn.setTransactionContext(txContext);
        conn.createStatement().executeUpdate("upsert into " + fullTableName + " values('k', 'f', 'f')");
        rs = conn.createStatement().executeQuery("select count(*) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        connWithConflict.createStatement().execute("upsert into " + fullTableName + " values('k', 'g', 'g')");
        rs = connWithConflict.createStatement().executeQuery("select count(*) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        txContext.abort();
        rs = conn.createStatement().executeQuery("select count(*) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        connWithConflict.commit();
        newConn = DriverManager.getConnection(FlappingTransactionIT.getUrl(), props);
        var14_21 = null;
        try {
            rs = newConn.createStatement().executeQuery("select count(*) from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
        }
        catch (Throwable throwable) {
            var14_21 = throwable;
            throw throwable;
        }
        finally {
            if (newConn != null) {
                if (var14_21 != null) {
                    try {
                        newConn.close();
                    }
                    catch (Throwable throwable) {
                        var14_21.addSuppressed(throwable);
                    }
                } else {
                    newConn.close();
                }
            }
        }
        Result result = htable.get(new Get(Bytes.toBytes((String)"j")));
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

