/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.Trace;
import org.apache.htrace.Tracer;
import org.apache.htrace.impl.MilliSpan;
import org.apache.phoenix.trace.TraceSpanReceiver;
import org.apache.phoenix.trace.TracingUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TraceSpanReceiverTest {
    @BeforeClass
    public static synchronized void setup() throws Exception {
    }

    @Test
    public void testNonIntegerAnnotations() {
        Span span = this.getSpan();
        byte[] value = Bytes.toBytes((String)"a");
        byte[] someInt = Bytes.toBytes((int)1);
        Assert.assertTrue((someInt.length > value.length ? 1 : 0) != 0);
        span.addKVAnnotation(Bytes.toBytes((String)"key"), value);
        TraceSpanReceiver source = new TraceSpanReceiver();
        Trace.addReceiver((SpanReceiver)source);
        Tracer.getInstance().deliver(span);
        Assert.assertTrue((source.getNumSpans() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerAnnotations() {
        Span span = this.getSpan();
        TracingUtils.addAnnotation((Span)span, (String)"message", (int)10);
        TraceSpanReceiver source = new TraceSpanReceiver();
        Trace.addReceiver((SpanReceiver)source);
        Tracer.getInstance().deliver(span);
        Assert.assertTrue((source.getNumSpans() == 1 ? 1 : 0) != 0);
    }

    private Span getSpan() {
        return new MilliSpan("test span", 1L, 1L, 2L, "pid");
    }
}

