/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryArray;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PCharArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDataTypeFactory;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.TreeMultimap;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class PDataTypeTest {
    @Test
    public void testFloatToLongComparison() {
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)1.0E100), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)0.001), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Integer.MAX_VALUE), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)0x7FFFFFFE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)-2147483647), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Float.valueOf(2.1474836E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Integer.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Float.valueOf(2.147484E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Integer.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Float.valueOf(-2.1474836E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Float.valueOf(-2.147484E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        float f1 = 9.111111E15f;
        float f2 = 9.111111E15f;
        Assert.assertTrue((f1 == f2 ? 1 : 0) != 0);
        long la = 9111111111111111L;
        Assert.assertTrue((f1 > 2.1474836E9f ? 1 : 0) != 0);
        Assert.assertTrue(((float)la == f1 ? 1 : 0) != 0);
        Assert.assertTrue(((float)la == f2 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Float.valueOf(f1)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)la), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PFloat.INSTANCE.compareTo(PFloat.INSTANCE.toBytes((Object)Float.valueOf(f2)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)la), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)1.0E100), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)0.001), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)0x7FFFFFFE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Integer.MAX_VALUE), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)-2147483647), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Integer.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Float.valueOf(2.1474836E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Integer.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Float.valueOf(2.147484E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Float.valueOf(-2.1474836E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Integer.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Float.valueOf(-2.147484E9f)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)la), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Float.valueOf(f1)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)la), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PFloat.INSTANCE.toBytes((Object)Float.valueOf(f2)), 0, PFloat.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PFloat.INSTANCE) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToDecimalComparison() {
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)1.23), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDecimal.INSTANCE.toBytes((Object)BigDecimal.valueOf(1.24)), 0, PDecimal.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDecimal.INSTANCE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToLongComparison() {
        double d2;
        double d;
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)-1.0E100), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)0.001), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)Long.MAX_VALUE), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)0x7FFFFFFFFFFFFFFEL), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)-9223372036854775807L), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)9.223372036854776E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Long.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)9.223372036854778E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Long.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)-9.223372036854776E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PDouble.INSTANCE.compareTo(PDouble.INSTANCE.toBytes((Object)-9.223372036854778E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PLong.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PLong.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)-1.0E100), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)1), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)0.001), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)0x7FFFFFFFFFFFFFFEL), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)Long.MAX_VALUE), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)-9223372036854775807L), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Long.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)9.223372036854776E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Long.MAX_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)9.223372036854778E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)-9.223372036854776E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PLong.INSTANCE.compareTo(PLong.INSTANCE.toBytes((Object)Long.MIN_VALUE), 0, PLong.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), PDouble.INSTANCE.toBytes((Object)-9.223372036854778E18), 0, PDouble.INSTANCE.getByteSize().intValue(), SortOrder.getDefault(), (PDataType)PDouble.INSTANCE) > 0 ? 1 : 0) != 0);
        long maxl = 0x4000000000000000L;
        for (long i = 10L; i < 100L; ++i) {
            d = Math.pow(2.0, i);
            if ((long)d > maxl) {
                Assert.assertTrue((i > 62L ? 1 : 0) != 0);
                continue;
            }
            long l = (1L << (int)i) - 1L;
            Assert.assertTrue((l + 1L == (long)d ? 1 : 0) != 0);
            Assert.assertTrue((l < (long)d ? 1 : 0) != 0);
        }
        for (d = 0.0; d <= 1024.0; d += 1.0) {
            d2 = 9.223372036854776E18 + d;
            double d1 = 9.223372036854776E18;
            Assert.assertTrue((d2 == d1 ? 1 : 0) != 0);
        }
        for (d = 0.0; d >= -1024.0; d -= 1.0) {
            d2 = -9.223372036854776E18 + d;
            double d1 = -9.223372036854776E18;
            Assert.assertTrue((d2 == d1 ? 1 : 0) != 0);
        }
        double d1 = 9.223372036854776E18;
        d2 = 9.223372036854776E18;
        double d3 = 9.223372036854778E18;
        Assert.assertTrue((d1 == d2 ? 1 : 0) != 0);
        Assert.assertTrue((d3 > d1 ? 1 : 0) != 0);
        long l1 = 0x7FFFFFFFFFFFFFFEL;
        Assert.assertTrue(((long)d1 > l1 ? 1 : 0) != 0);
    }

    @Test
    public void testLong() {
        Long la = 4L;
        byte[] b = PLong.INSTANCE.toBytes((Object)la);
        Long lb = (Long)PLong.INSTANCE.toObject(b);
        Assert.assertEquals((Object)la, (Object)lb);
        Long na = 1L;
        Long nb = -1L;
        byte[] ba = PLong.INSTANCE.toBytes((Object)na);
        byte[] bb = PLong.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PLong.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Long));
        Assert.assertEquals((long)100L, (long)((Long)obj));
        Long longValue = 100L;
        Object longObj = PLong.INSTANCE.toObject((Object)longValue, (PDataType)PLong.INSTANCE);
        Assert.assertTrue((boolean)(longObj instanceof Long));
        Assert.assertEquals((long)100L, (long)((Long)longObj));
        Assert.assertEquals((long)0L, (long)PLong.INSTANCE.compareTo((Object)Long.MAX_VALUE, (Object)Float.valueOf(9.223372E18f), (PDataType)PFloat.INSTANCE));
        Assert.assertEquals((long)0L, (long)PLong.INSTANCE.compareTo((Object)Long.MAX_VALUE, (Object)9.223372036854776E18, (PDataType)PDouble.INSTANCE));
        Assert.assertEquals((long)-1L, (long)PLong.INSTANCE.compareTo((Object)99, (Object)Float.valueOf(100.0f), (PDataType)PFloat.INSTANCE));
        Assert.assertEquals((long)1L, (long)PLong.INSTANCE.compareTo((Object)101, (Object)Float.valueOf(100.0f), (PDataType)PFloat.INSTANCE));
        Double d = -2.0;
        Object lo = PLong.INSTANCE.toObject((Object)d, (PDataType)PDouble.INSTANCE);
        Assert.assertEquals((long)-2L, (long)((Long)lo));
        byte[] bytes = PDouble.INSTANCE.toBytes((Object)d);
        lo = PLong.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PDouble.INSTANCE);
        Assert.assertEquals((long)-2L, (long)((Long)lo));
        Float f = Float.valueOf(-2.0f);
        lo = PLong.INSTANCE.toObject((Object)f, (PDataType)PFloat.INSTANCE);
        Assert.assertEquals((long)-2L, (long)((Long)lo));
        bytes = PFloat.INSTANCE.toBytes((Object)f);
        lo = PLong.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PFloat.INSTANCE);
        Assert.assertEquals((long)-2L, (long)((Long)lo));
        d = 2.0;
        lo = PUnsignedLong.INSTANCE.toObject((Object)d, (PDataType)PDouble.INSTANCE);
        Assert.assertEquals((long)2L, (long)((Long)lo));
        bytes = PDouble.INSTANCE.toBytes((Object)d);
        lo = PUnsignedLong.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PDouble.INSTANCE);
        Assert.assertEquals((long)2L, (long)((Long)lo));
        f = Float.valueOf(2.0f);
        lo = PUnsignedLong.INSTANCE.toObject((Object)f, (PDataType)PFloat.INSTANCE);
        Assert.assertEquals((long)2L, (long)((Long)lo));
        bytes = PFloat.INSTANCE.toBytes((Object)f);
        lo = PUnsignedLong.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PFloat.INSTANCE);
        Assert.assertEquals((long)2L, (long)((Long)lo));
    }

    @Test
    public void testInt() {
        Integer na = 4;
        byte[] b = PInteger.INSTANCE.toBytes((Object)na);
        Integer nb = (Integer)PInteger.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 1;
        nb = -1;
        byte[] ba = PInteger.INSTANCE.toBytes((Object)na);
        byte[] bb = PInteger.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -1;
        nb = -3;
        ba = PInteger.INSTANCE.toBytes((Object)na);
        bb = PInteger.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -3;
        nb = -100000000;
        ba = PInteger.INSTANCE.toBytes((Object)na);
        bb = PInteger.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Long value = 100L;
        Object obj = PInteger.INSTANCE.toObject((Object)value, (PDataType)PLong.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Integer));
        Assert.assertEquals((long)100L, (long)((Integer)obj).intValue());
        Float unsignedFloatValue = Float.valueOf(100.0f);
        Object unsignedFloatObj = PInteger.INSTANCE.toObject((Object)unsignedFloatValue, (PDataType)PUnsignedFloat.INSTANCE);
        Assert.assertTrue((boolean)(unsignedFloatObj instanceof Integer));
        Assert.assertEquals((long)100L, (long)((Integer)unsignedFloatObj).intValue());
        Double unsignedDoubleValue = 100.0;
        Object unsignedDoubleObj = PInteger.INSTANCE.toObject((Object)unsignedDoubleValue, (PDataType)PUnsignedDouble.INSTANCE);
        Assert.assertTrue((boolean)(unsignedDoubleObj instanceof Integer));
        Assert.assertEquals((long)100L, (long)((Integer)unsignedDoubleObj).intValue());
        Float floatValue = Float.valueOf(100.0f);
        Object floatObj = PInteger.INSTANCE.toObject((Object)floatValue, (PDataType)PFloat.INSTANCE);
        Assert.assertTrue((boolean)(floatObj instanceof Integer));
        Assert.assertEquals((long)100L, (long)((Integer)floatObj).intValue());
        Double doubleValue = 100.0;
        Object doubleObj = PInteger.INSTANCE.toObject((Object)doubleValue, (PDataType)PDouble.INSTANCE);
        Assert.assertTrue((boolean)(doubleObj instanceof Integer));
        Assert.assertEquals((long)100L, (long)((Integer)doubleObj).intValue());
        Short shortValue = 100;
        Object shortObj = PInteger.INSTANCE.toObject((Object)shortValue, (PDataType)PSmallint.INSTANCE);
        Assert.assertTrue((boolean)(shortObj instanceof Integer));
        Assert.assertEquals((long)100L, (long)((Integer)shortObj).intValue());
    }

    @Test
    public void testSmallInt() {
        Short na = 4;
        byte[] b = PSmallint.INSTANCE.toBytes((Object)na);
        Short nb = (Short)PSmallint.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 4;
        b = PSmallint.INSTANCE.toBytes((Object)na, SortOrder.DESC);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(b);
        nb = PSmallint.INSTANCE.getCodec().decodeShort(ptr, SortOrder.DESC);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 1;
        nb = -1;
        byte[] ba = PSmallint.INSTANCE.toBytes((Object)na);
        byte[] bb = PSmallint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -1;
        nb = -3;
        ba = PSmallint.INSTANCE.toBytes((Object)na);
        bb = PSmallint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -3;
        nb = -10000;
        ba = PSmallint.INSTANCE.toBytes((Object)na);
        bb = PSmallint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PSmallint.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)obj).shortValue());
        Float unsignedFloatValue = Float.valueOf(100.0f);
        Object unsignedFloatObj = PSmallint.INSTANCE.toObject((Object)unsignedFloatValue, (PDataType)PUnsignedFloat.INSTANCE);
        Assert.assertTrue((boolean)(unsignedFloatObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)unsignedFloatObj).shortValue());
        Double unsignedDoubleValue = 100.0;
        Object unsignedDoubleObj = PSmallint.INSTANCE.toObject((Object)unsignedDoubleValue, (PDataType)PUnsignedDouble.INSTANCE);
        Assert.assertTrue((boolean)(unsignedDoubleObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)unsignedDoubleObj).shortValue());
        Float floatValue = Float.valueOf(100.0f);
        Object floatObj = PSmallint.INSTANCE.toObject((Object)floatValue, (PDataType)PFloat.INSTANCE);
        Assert.assertTrue((boolean)(floatObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)floatObj).shortValue());
        Double doubleValue = 100.0;
        Object doubleObj = PSmallint.INSTANCE.toObject((Object)doubleValue, (PDataType)PDouble.INSTANCE);
        Assert.assertTrue((boolean)(doubleObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)doubleObj).shortValue());
    }

    @Test
    public void testTinyInt() {
        Byte na = 4;
        byte[] b = PTinyint.INSTANCE.toBytes((Object)na);
        Byte nb = (Byte)PTinyint.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 1;
        nb = -1;
        byte[] ba = PTinyint.INSTANCE.toBytes((Object)na);
        byte[] bb = PTinyint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -1;
        nb = -3;
        ba = PTinyint.INSTANCE.toBytes((Object)na);
        bb = PTinyint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -3;
        nb = -100;
        ba = PTinyint.INSTANCE.toBytes((Object)na);
        bb = PTinyint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PTinyint.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)obj).byteValue());
        Float floatValue = Float.valueOf(100.0f);
        Object floatObj = PTinyint.INSTANCE.toObject((Object)floatValue, (PDataType)PFloat.INSTANCE);
        Assert.assertTrue((boolean)(floatObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)floatObj).byteValue());
        Float unsignedFloatValue = Float.valueOf(100.0f);
        Object unsignedFloatObj = PTinyint.INSTANCE.toObject((Object)unsignedFloatValue, (PDataType)PUnsignedFloat.INSTANCE);
        Assert.assertTrue((boolean)(unsignedFloatObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)unsignedFloatObj).byteValue());
        Double unsignedDoubleValue = 100.0;
        Object unsignedDoubleObj = PTinyint.INSTANCE.toObject((Object)unsignedDoubleValue, (PDataType)PUnsignedDouble.INSTANCE);
        Assert.assertTrue((boolean)(unsignedDoubleObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)unsignedDoubleObj).byteValue());
        Double doubleValue = 100.0;
        Object doubleObj = PTinyint.INSTANCE.toObject((Object)doubleValue, (PDataType)PDouble.INSTANCE);
        Assert.assertTrue((boolean)(doubleObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)doubleObj).byteValue());
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-1));
    }

    @Test
    public void testUnsignedSmallInt() {
        Short na = 4;
        byte[] b = PUnsignedSmallint.INSTANCE.toBytes((Object)na);
        Short nb = (Short)PUnsignedSmallint.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 10;
        nb = 8;
        byte[] ba = PUnsignedSmallint.INSTANCE.toBytes((Object)na);
        byte[] bb = PUnsignedSmallint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PUnsignedSmallint.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)obj).shortValue());
        Float floatValue = Float.valueOf(100.0f);
        Object floatObj = PUnsignedSmallint.INSTANCE.toObject((Object)floatValue, (PDataType)PFloat.INSTANCE);
        Assert.assertTrue((boolean)(floatObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)floatObj).shortValue());
        Float unsignedFloatValue = Float.valueOf(100.0f);
        Object unsignedFloatObj = PUnsignedSmallint.INSTANCE.toObject((Object)unsignedFloatValue, (PDataType)PUnsignedFloat.INSTANCE);
        Assert.assertTrue((boolean)(unsignedFloatObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)unsignedFloatObj).shortValue());
        Double unsignedDoubleValue = 100.0;
        Object unsignedDoubleObj = PUnsignedSmallint.INSTANCE.toObject((Object)unsignedDoubleValue, (PDataType)PUnsignedDouble.INSTANCE);
        Assert.assertTrue((boolean)(unsignedDoubleObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)unsignedDoubleObj).shortValue());
        Double doubleValue = 100.0;
        Object doubleObj = PUnsignedSmallint.INSTANCE.toObject((Object)doubleValue, (PDataType)PDouble.INSTANCE);
        Assert.assertTrue((boolean)(doubleObj instanceof Short));
        Assert.assertEquals((long)100L, (long)((Short)doubleObj).shortValue());
    }

    @Test
    public void testUnsignedTinyInt() {
        Byte na = 4;
        byte[] b = PUnsignedTinyint.INSTANCE.toBytes((Object)na);
        Byte nb = (Byte)PUnsignedTinyint.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 10;
        nb = 8;
        byte[] ba = PUnsignedTinyint.INSTANCE.toBytes((Object)na);
        byte[] bb = PUnsignedTinyint.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PUnsignedTinyint.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)obj).byteValue());
        Float floatValue = Float.valueOf(100.0f);
        Object floatObj = PUnsignedTinyint.INSTANCE.toObject((Object)floatValue, (PDataType)PFloat.INSTANCE);
        Assert.assertTrue((boolean)(floatObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)floatObj).byteValue());
        Float unsignedFloatValue = Float.valueOf(100.0f);
        Object unsignedFloatObj = PUnsignedTinyint.INSTANCE.toObject((Object)unsignedFloatValue, (PDataType)PUnsignedFloat.INSTANCE);
        Assert.assertTrue((boolean)(unsignedFloatObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)unsignedFloatObj).byteValue());
        Double unsignedDoubleValue = 100.0;
        Object unsignedDoubleObj = PUnsignedTinyint.INSTANCE.toObject((Object)unsignedDoubleValue, (PDataType)PUnsignedDouble.INSTANCE);
        Assert.assertTrue((boolean)(unsignedDoubleObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)unsignedDoubleObj).byteValue());
        Double doubleValue = 100.0;
        Object doubleObj = PUnsignedTinyint.INSTANCE.toObject((Object)doubleValue, (PDataType)PDouble.INSTANCE);
        Assert.assertTrue((boolean)(doubleObj instanceof Byte));
        Assert.assertEquals((long)100L, (long)((Byte)doubleObj).byteValue());
    }

    @Test
    public void testUnsignedFloat() {
        Float na = Float.valueOf(0.005f);
        byte[] b = PUnsignedFloat.INSTANCE.toBytes((Object)na);
        Float nb = (Float)PUnsignedFloat.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = Float.valueOf(10.0f);
        b = PUnsignedFloat.INSTANCE.toBytes((Object)na, SortOrder.DESC);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(b);
        nb = Float.valueOf(PUnsignedFloat.INSTANCE.getCodec().decodeFloat(ptr, SortOrder.DESC));
        Assert.assertEquals((Object)na, (Object)nb);
        na = Float.valueOf(2.0f);
        nb = Float.valueOf(1.0f);
        byte[] ba = PUnsignedFloat.INSTANCE.toBytes((Object)na);
        byte[] bb = PUnsignedFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = Float.valueOf(0.0f);
        nb = Float.valueOf(Float.MIN_VALUE);
        ba = PUnsignedFloat.INSTANCE.toBytes((Object)na);
        bb = PUnsignedFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.MIN_VALUE);
        nb = Float.valueOf(Float.MAX_VALUE);
        ba = PUnsignedFloat.INSTANCE.toBytes((Object)na);
        bb = PUnsignedFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.MAX_VALUE);
        nb = Float.valueOf(Float.POSITIVE_INFINITY);
        ba = PUnsignedFloat.INSTANCE.toBytes((Object)na);
        bb = PUnsignedFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.POSITIVE_INFINITY);
        nb = Float.valueOf(Float.NaN);
        ba = PUnsignedFloat.INSTANCE.toBytes((Object)na);
        bb = PUnsignedFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PUnsignedFloat.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Float));
    }

    @Test
    public void testUnsignedDouble() {
        Double na = 0.005;
        byte[] b = PUnsignedDouble.INSTANCE.toBytes((Object)na);
        Double nb = (Double)PUnsignedDouble.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 10.0;
        b = PUnsignedDouble.INSTANCE.toBytes((Object)na, SortOrder.DESC);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(b);
        nb = PUnsignedDouble.INSTANCE.getCodec().decodeDouble(ptr, SortOrder.DESC);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 2.0;
        nb = 1.0;
        byte[] ba = PUnsignedDouble.INSTANCE.toBytes((Object)na);
        byte[] bb = PUnsignedDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = 0.0;
        nb = Double.MIN_VALUE;
        ba = PUnsignedDouble.INSTANCE.toBytes((Object)na);
        bb = PUnsignedDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Double.MIN_VALUE;
        nb = Double.MAX_VALUE;
        ba = PUnsignedDouble.INSTANCE.toBytes((Object)na);
        bb = PUnsignedDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Double.MAX_VALUE;
        nb = Double.POSITIVE_INFINITY;
        ba = PUnsignedDouble.INSTANCE.toBytes((Object)na);
        bb = PUnsignedDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Double.POSITIVE_INFINITY;
        nb = Double.NaN;
        ba = PUnsignedDouble.INSTANCE.toBytes((Object)na);
        bb = PUnsignedDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PUnsignedDouble.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Double));
        Assert.assertEquals((long)1L, (long)PUnsignedDouble.INSTANCE.compareTo((Object)101.0, (Object)100L, (PDataType)PLong.INSTANCE));
        Assert.assertEquals((long)0L, (long)PUnsignedDouble.INSTANCE.compareTo((Object)9.223372036854776E18, (Object)Long.MAX_VALUE, (PDataType)PLong.INSTANCE));
        Assert.assertEquals((long)-1L, (long)PUnsignedDouble.INSTANCE.compareTo((Object)1.0, (Object)100L, (PDataType)PLong.INSTANCE));
        Assert.assertEquals((long)0L, (long)PUnsignedDouble.INSTANCE.compareTo((Object)101.0, (Object)BigDecimal.valueOf(101.0), (PDataType)PDecimal.INSTANCE));
    }

    @Test
    public void testFloat() {
        Float na = Float.valueOf(0.005f);
        byte[] b = PFloat.INSTANCE.toBytes((Object)na);
        Float nb = (Float)PFloat.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = Float.valueOf(10.0f);
        b = PFloat.INSTANCE.toBytes((Object)na, SortOrder.DESC);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(b);
        nb = Float.valueOf(PFloat.INSTANCE.getCodec().decodeFloat(ptr, SortOrder.DESC));
        Assert.assertEquals((Object)na, (Object)nb);
        na = Float.valueOf(1.0f);
        nb = Float.valueOf(-1.0f);
        byte[] ba = PFloat.INSTANCE.toBytes((Object)na);
        byte[] bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = Float.valueOf(-1.0f);
        nb = Float.valueOf(-3.0f);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.NEGATIVE_INFINITY);
        nb = Float.valueOf(-3.4028235E38f);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(-3.4028235E38f);
        nb = Float.valueOf(-1.4E-45f);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(-1.4E-45f);
        nb = Float.valueOf(-0.0f);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(-0.0f);
        nb = Float.valueOf(0.0f);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(0.0f);
        nb = Float.valueOf(Float.MIN_VALUE);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.MIN_VALUE);
        nb = Float.valueOf(Float.MAX_VALUE);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.MAX_VALUE);
        nb = Float.valueOf(Float.POSITIVE_INFINITY);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Float.valueOf(Float.POSITIVE_INFINITY);
        nb = Float.valueOf(Float.NaN);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PFloat.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Float));
        Double dvalue = Double.NEGATIVE_INFINITY;
        obj = PFloat.INSTANCE.toObject((Object)dvalue, (PDataType)PDouble.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)obj);
        na = Float.valueOf(1.0f);
        nb = Float.valueOf(-1.0f);
        ba = PFloat.INSTANCE.toBytes((Object)na);
        bb = PFloat.INSTANCE.toBytes((Object)nb);
        float nna = PFloat.INSTANCE.getCodec().decodeFloat(ba, 0, SortOrder.DESC);
        float nnb = PFloat.INSTANCE.getCodec().decodeFloat(bb, 0, SortOrder.DESC);
        Assert.assertTrue((Float.compare(nna, nnb) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleComparison() {
        PDataTypeTest.testRealNumberComparison((PDataType)PDouble.INSTANCE, new Double[]{0.99, 1.0, 1.001, 1.01, 2.0});
    }

    @Test
    public void testFloatComparison() {
        PDataTypeTest.testRealNumberComparison((PDataType)PFloat.INSTANCE, new Float[]{Float.valueOf(0.99f), Float.valueOf(1.0f), Float.valueOf(1.001f), Float.valueOf(1.01f), Float.valueOf(2.0f)});
    }

    @Test
    public void testDecimalComparison() {
        PDataTypeTest.testRealNumberComparison((PDataType)PDecimal.INSTANCE, new BigDecimal[]{BigDecimal.valueOf(0.99), BigDecimal.valueOf(1.0), BigDecimal.valueOf(1.001), BigDecimal.valueOf(1.01), BigDecimal.valueOf(2.0)});
    }

    private static void testRealNumberComparison(PDataType type, Object[] a) {
        for (SortOrder sortOrder : SortOrder.values()) {
            int factor = sortOrder == SortOrder.ASC ? 1 : -1;
            byte[] prev_b = null;
            Object prev_o = null;
            for (Object o : a) {
                byte[] b = type.toBytes(o, sortOrder);
                if (prev_b != null) {
                    Assert.assertTrue((String)("Compare of " + o + " with " + prev_o + " " + sortOrder + " failed."), (ScanUtil.getComparator((boolean)type.isFixedWidth(), (SortOrder)sortOrder).compare(prev_b, 0, prev_b.length, b, 0, b.length) * factor < 0 ? 1 : 0) != 0);
                }
                prev_b = b;
                prev_o = o;
            }
        }
    }

    @Test
    public void testDouble() {
        Double na = 0.005;
        byte[] b = PDouble.INSTANCE.toBytes((Object)na);
        Double nb = (Double)PDouble.INSTANCE.toObject(b);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 10.0;
        b = PDouble.INSTANCE.toBytes((Object)na, SortOrder.DESC);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(b);
        nb = PDouble.INSTANCE.getCodec().decodeDouble(ptr, SortOrder.DESC);
        Assert.assertEquals((Object)na, (Object)nb);
        na = 1.0;
        nb = -1.0;
        byte[] ba = PDouble.INSTANCE.toBytes((Object)na);
        byte[] bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = -1.0;
        nb = -3.0;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        na = Double.NEGATIVE_INFINITY;
        nb = -1.7976931348623157E308;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = -1.7976931348623157E308;
        nb = -4.9E-324;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = -4.9E-324;
        nb = -0.0;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = -0.0;
        nb = 0.0;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = 0.0;
        nb = Double.MIN_VALUE;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Double.MIN_VALUE;
        nb = Double.MAX_VALUE;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Double.MAX_VALUE;
        nb = Double.POSITIVE_INFINITY;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        na = Double.POSITIVE_INFINITY;
        nb = Double.NaN;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) < 0 ? 1 : 0) != 0);
        Integer value = 100;
        Object obj = PDouble.INSTANCE.toObject((Object)value, (PDataType)PInteger.INSTANCE);
        Assert.assertTrue((boolean)(obj instanceof Double));
        na = 1.0;
        nb = -1.0;
        ba = PDouble.INSTANCE.toBytes((Object)na);
        bb = PDouble.INSTANCE.toBytes((Object)nb);
        double nna = PDouble.INSTANCE.getCodec().decodeDouble(ba, 0, SortOrder.DESC);
        double nnb = PDouble.INSTANCE.getCodec().decodeDouble(bb, 0, SortOrder.DESC);
        Assert.assertTrue((Double.compare(nna, nnb) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)PDouble.INSTANCE.compareTo((Object)101.0, (Object)100L, (PDataType)PLong.INSTANCE));
        Assert.assertEquals((long)0L, (long)PDouble.INSTANCE.compareTo((Object)9.223372036854776E18, (Object)Long.MAX_VALUE, (PDataType)PLong.INSTANCE));
        Assert.assertEquals((long)-1L, (long)PDouble.INSTANCE.compareTo((Object)1.0, (Object)100L, (PDataType)PLong.INSTANCE));
        Assert.assertEquals((long)0L, (long)PDouble.INSTANCE.compareTo((Object)101.0, (Object)BigDecimal.valueOf(101.0), (PDataType)PDecimal.INSTANCE));
    }

    @Test
    public void testBigDecimal() {
        String[] strs;
        BigDecimal expected;
        int i;
        byte[] b = new byte[]{-62, 2, 16, 54, 34, 34, 34, 34, 34, 34, 15, 39, 56, 28, 5, 64, 98, 33, 84, 77, 78, 1, 20, 54, 13, 51};
        BigDecimal decodedBytes = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((decodedBytes.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0);
        BigDecimal na = new BigDecimal(new BigInteger("12345678901239998123456789"), 2);
        b = PDecimal.INSTANCE.toBytes((Object)na);
        BigDecimal nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        TestUtil.assertRoundEquals(na, nb);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal("115.533333333333331438552704639732837677001953125");
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        TestUtil.assertRoundEquals(na, nb);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal("-5.00000000000000000000000001");
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        TestUtil.assertRoundEquals(na, nb);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal("-2.4999999999999999999999999999999999999");
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        TestUtil.assertRoundEquals(na, nb);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal("-2.499999999999999999999999999999999999999");
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((nb.compareTo(new BigDecimal("-2.5")) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new BigDecimal("-2.5"), (Object)nb);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal(2.5);
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((na.compareTo(nb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal(Double.parseDouble("96.45238095238095"));
        String naStr = na.toString();
        Assert.assertTrue((naStr != null ? 1 : 0) != 0);
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        TestUtil.assertRoundEquals(na, nb);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal(-1000);
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((na.compareTo(nb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal("1000.5829999999999913");
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((na.compareTo(nb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = TestUtil.computeAverage(11000L, 3L);
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((na.compareTo(nb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal(new BigInteger("12345678901239999"), 2);
        b = PDecimal.INSTANCE.toBytes((Object)na);
        nb = (BigDecimal)PDecimal.INSTANCE.toObject(b);
        Assert.assertTrue((na.compareTo(nb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        na = new BigDecimal(1);
        nb = new BigDecimal(-1);
        byte[] ba = PDecimal.INSTANCE.toBytes((Object)na);
        byte[] bb = PDecimal.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ba.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        Assert.assertTrue((bb.length <= PDecimal.INSTANCE.estimateByteSize((Object)nb) ? 1 : 0) != 0);
        na = new BigDecimal(-1);
        nb = new BigDecimal(-2);
        ba = PDecimal.INSTANCE.toBytes((Object)na);
        bb = PDecimal.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ba.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        Assert.assertTrue((bb.length <= PDecimal.INSTANCE.estimateByteSize((Object)nb) ? 1 : 0) != 0);
        na = new BigDecimal(-3);
        nb = new BigDecimal(-1000);
        Assert.assertTrue((na.compareTo(nb) > 0 ? 1 : 0) != 0);
        ba = PDecimal.INSTANCE.toBytes((Object)na);
        bb = PDecimal.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ba.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        Assert.assertTrue((bb.length <= PDecimal.INSTANCE.estimateByteSize((Object)nb) ? 1 : 0) != 0);
        na = new BigDecimal(BigInteger.valueOf(12345678901239998L), 2);
        nb = new BigDecimal(97);
        Assert.assertTrue((na.compareTo(nb) > 0 ? 1 : 0) != 0);
        ba = PDecimal.INSTANCE.toBytes((Object)na);
        bb = PDecimal.INSTANCE.toBytes((Object)nb);
        Assert.assertTrue((Bytes.compareTo((byte[])ba, (byte[])bb) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ba.length <= PDecimal.INSTANCE.estimateByteSize((Object)na) ? 1 : 0) != 0);
        Assert.assertTrue((bb.length <= PDecimal.INSTANCE.estimateByteSize((Object)nb) ? 1 : 0) != 0);
        List<BigDecimal> values = Arrays.asList(new BigDecimal(-1000), new BigDecimal(-100000000), new BigDecimal(1000), new BigDecimal("-0.001"), new BigDecimal("0.001"), new BigDecimal(new BigInteger("12345678901239999"), 2), new BigDecimal(new BigInteger("12345678901239998"), 2), new BigDecimal(new BigInteger("12345678901239998123456789"), 2), new BigDecimal(new BigInteger("-1000"), 3), new BigDecimal(new BigInteger("-1000"), 10), new BigDecimal(99), new BigDecimal(97), new BigDecimal(-3));
        ArrayList<byte[]> byteValues = new ArrayList<byte[]>();
        for (i = 0; i < values.size(); ++i) {
            byteValues.add(PDecimal.INSTANCE.toBytes((Object)values.get(i)));
        }
        for (i = 0; i < values.size(); ++i) {
            expected = values.get(i);
            BigDecimal actual = (BigDecimal)PDecimal.INSTANCE.toObject((byte[])byteValues.get(i));
            Assert.assertTrue((String)("For " + i + " expected " + expected + " but got " + actual), (expected.round(PDataType.DEFAULT_MATH_CONTEXT).compareTo(actual.round(PDataType.DEFAULT_MATH_CONTEXT)) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((((byte[])byteValues.get(i)).length <= PDecimal.INSTANCE.estimateByteSize((Object)expected) ? 1 : 0) != 0);
        }
        Collections.sort(values);
        Collections.sort(byteValues, Bytes.BYTES_COMPARATOR);
        for (i = 0; i < values.size(); ++i) {
            expected = values.get(i);
            byte[] bytes = PDecimal.INSTANCE.toBytes((Object)values.get(i));
            Assert.assertNotNull((String)"bytes converted from values should not be null!", (Object)bytes);
            BigDecimal actual = (BigDecimal)PDecimal.INSTANCE.toObject((byte[])byteValues.get(i));
            Assert.assertTrue((String)("For " + i + " expected " + expected + " but got " + actual), (expected.round(PDataType.DEFAULT_MATH_CONTEXT).compareTo(actual.round(PDataType.DEFAULT_MATH_CONTEXT)) == 0 ? 1 : 0) != 0);
        }
        for (String str : strs = new String[]{"\\xC2\\x03\\x0C\\x10\\x01\\x01\\x01\\x01\\x01\\x019U#\\x13W\\x09\\x09", "\\xC2\\x03<,ddddddN\\x1B\\x1B!.9N", "\\xC2\\x039", "\\xC2\\x03\\x16,\\x01\\x01\\x01\\x01\\x01\\x01E\\x16\\x16\\x03@\\x1EG", "\\xC2\\x02d6dddddd\\x15*]\\x0E<1F", "\\xC2\\x04 3", "\\xC2\\x03$Ldddddd\\x0A\\x06\\x06\\x1ES\\x1C\\x08", "\\xC2\\x03\\x1E\\x0A\\x01\\x01\\x01\\x01\\x01\\x01#\\x0B=4 AV", "\\xC2\\x02\\\\x04dddddd\\x15*]\\x0E<1F", "\\xC2\\x02V\"\\x01\\x01\\x01\\x01\\x01\\x02\\x1A\\x068\\x162&O"}) {
            byte[] bytes = Bytes.toBytesBinary((String)str);
            Object o = PDecimal.INSTANCE.toObject(bytes);
            Assert.assertNotNull((Object)o);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Test
    public void testEmptyString() throws Throwable {
        byte[] b1 = PVarchar.INSTANCE.toBytes((Object)"");
        byte[] b2 = PVarchar.INSTANCE.toBytes(null);
        assert (b1.length == 0 && Bytes.compareTo((byte[])b1, (byte[])b2) == 0);
    }

    @Test
    public void testNull() throws Throwable {
        byte[] b = new byte[8];
        for (PDataType type : PDataType.values()) {
            try {
                type.toBytes(null);
                type.toBytes(null, b, 0);
                type.toObject(new byte[0], 0, 0);
                type.toObject(new byte[0], 0, 0, type);
                if (!type.isArrayType()) continue;
                type.toBytes((Object)new PhoenixArray());
                type.toBytes((Object)new PhoenixArray(), b, 0);
            }
            catch (ConstraintViolationException e) {
                if (type.isArrayType() || type.isFixedWidth() && e.getMessage().contains("may not be null")) continue;
                Assert.fail((String)(type + ":" + (Object)((Object)e)));
            }
        }
    }

    @Test
    public void testValueCoersion() throws Exception {
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)0.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)(Double.valueOf(3.4028234663852886E38) + Double.valueOf(3.4028234663852886E38))));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)(Double.valueOf(9.223372036854776E18) + Double.valueOf(9.223372036854776E18))));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-100000.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-1000.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-100000.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-1000.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)-10.0));
        Assert.assertFalse((boolean)PDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)Double.MAX_VALUE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(Float.valueOf(9.223372E18f).floatValue() + Float.valueOf(9.223372E18f).floatValue())));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)Float.valueOf(-100000.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)Float.valueOf(-1000.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)Float.valueOf(-100000.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)Float.valueOf(-1000.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)Float.valueOf(-10.0f)));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE, (Object)Double.MAX_VALUE));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Double.MAX_VALUE));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)10.0));
        Assert.assertTrue((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)0.0));
        Assert.assertFalse((boolean)PUnsignedDouble.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)Double.MAX_VALUE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)Float.valueOf(Float.MAX_VALUE)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)Float.valueOf(10.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)Float.valueOf(0.0f)));
        Assert.assertTrue((boolean)PUnsignedFloat.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-100000));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-1000));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-100000));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-1000));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)-10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)-10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PInteger.INSTANCE.isCoercibleTo((PDataType)PVarbinary.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0x80000009L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)Integer.MAX_VALUE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0x7FFFFFF5L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)-10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)-2147483638L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)Integer.MIN_VALUE));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)-2147483658L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)-10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)-10L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-10L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-100000L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-10L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-1000L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-10L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-100000L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-10L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-1000L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)-1L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)-1L));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)-10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)1000));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)1000));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)-1));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)-1));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)-10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)-10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)100));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)-10));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)-10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, (Object)-1));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, (Object)-1));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)100000));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)1000));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)100000L));
        Assert.assertFalse((boolean)PUnsignedInt.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0L));
        Assert.assertFalse((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)1000L));
        Assert.assertTrue((boolean)PUnsignedLong.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)1000));
        Assert.assertFalse((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)0));
        Assert.assertFalse((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, (Object)1000));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedSmallint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PFloat.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PInteger.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedInt.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PSmallint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PTinyint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)10));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, (Object)0));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE));
        Assert.assertTrue((boolean)PUnsignedTinyint.INSTANCE.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE));
        Assert.assertTrue((boolean)PDate.INSTANCE.isCoercibleTo((PDataType)PTimestamp.INSTANCE));
        Assert.assertTrue((boolean)PDate.INSTANCE.isCoercibleTo((PDataType)PTime.INSTANCE));
        Assert.assertFalse((boolean)PTimestamp.INSTANCE.isCoercibleTo((PDataType)PDate.INSTANCE));
        Assert.assertFalse((boolean)PTimestamp.INSTANCE.isCoercibleTo((PDataType)PTime.INSTANCE));
        Assert.assertTrue((boolean)PTime.INSTANCE.isCoercibleTo((PDataType)PTimestamp.INSTANCE));
        Assert.assertTrue((boolean)PTime.INSTANCE.isCoercibleTo((PDataType)PDate.INSTANCE));
    }

    @Test
    public void testGetDeicmalPrecisionAndScaleFromRawBytes() throws Exception {
        BigDecimal bd = new BigDecimal("0");
        byte[] b = PDecimal.INSTANCE.toBytes((Object)bd);
        int[] v = PDataType.getDecimalPrecisionAndScale((byte[])b, (int)0, (int)b.length, (SortOrder)SortOrder.getDefault());
        Assert.assertEquals((long)0L, (long)v[0]);
        Assert.assertEquals((long)0L, (long)v[1]);
        bd = new BigDecimal("0");
        b = PDecimal.INSTANCE.toBytes((Object)bd, SortOrder.DESC);
        v = PDataType.getDecimalPrecisionAndScale((byte[])b, (int)0, (int)b.length, (SortOrder)SortOrder.DESC);
        Assert.assertEquals((long)0L, (long)v[0]);
        Assert.assertEquals((long)0L, (long)v[1]);
        BigDecimal[] bds = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0.11"), new BigDecimal("1.1"), new BigDecimal("11"), new BigDecimal("101"), new BigDecimal("10.1"), new BigDecimal("1.01"), new BigDecimal("0.101"), new BigDecimal("1001"), new BigDecimal("100.1"), new BigDecimal("10.01"), new BigDecimal("1.001"), new BigDecimal("0.1001"), new BigDecimal("10001"), new BigDecimal("1000.1"), new BigDecimal("100.01"), new BigDecimal("10.001"), new BigDecimal("1.0001"), new BigDecimal("0.10001"), new BigDecimal("100000000000000000000000000000"), new BigDecimal("1000000000000000000000000000000"), new BigDecimal("0.000000000000000000000000000001"), new BigDecimal("0.0000000000000000000000000000001"), new BigDecimal("111111111111111111111111111111"), new BigDecimal("1111111111111111111111111111111"), new BigDecimal("0.111111111111111111111111111111"), new BigDecimal("0.1111111111111111111111111111111")};
        for (int i = 0; i < bds.length; ++i) {
            this.testReadDecimalPrecisionAndScaleFromRawBytes(bds[i], SortOrder.ASC);
            this.testReadDecimalPrecisionAndScaleFromRawBytes(bds[i], SortOrder.DESC);
            this.testReadDecimalPrecisionAndScaleFromRawBytes(bds[i].negate(), SortOrder.getDefault());
        }
        Assert.assertTrue((boolean)new BigDecimal("5").remainder(BigDecimal.ONE).equals(BigDecimal.ZERO));
        Assert.assertTrue((new BigDecimal("5.0").remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new BigDecimal("5.00").remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)new BigDecimal("5.01").remainder(BigDecimal.ONE).equals(BigDecimal.ZERO));
        Assert.assertFalse((boolean)new BigDecimal("-5.1").remainder(BigDecimal.ONE).equals(BigDecimal.ZERO));
    }

    @Test
    public void testDateConversions() {
        long now = System.currentTimeMillis();
        Date date = new Date(now);
        Time t = new Time(now);
        Timestamp ts = new Timestamp(now);
        Object o = PDate.INSTANCE.toObject((Object)ts, (PDataType)PTimestamp.INSTANCE);
        Assert.assertEquals(o.getClass(), Date.class);
        o = PDate.INSTANCE.toObject((Object)t, (PDataType)PTime.INSTANCE);
        Assert.assertEquals(o.getClass(), Date.class);
        o = PTime.INSTANCE.toObject((Object)date, (PDataType)PDate.INSTANCE);
        Assert.assertEquals(o.getClass(), Time.class);
        o = PTime.INSTANCE.toObject((Object)ts, (PDataType)PTimestamp.INSTANCE);
        Assert.assertEquals(o.getClass(), Time.class);
        o = PTimestamp.INSTANCE.toObject((Object)date, (PDataType)PDate.INSTANCE);
        Assert.assertEquals(o.getClass(), Timestamp.class);
        o = PTimestamp.INSTANCE.toObject((Object)t, (PDataType)PTime.INSTANCE);
        Assert.assertEquals(o.getClass(), Timestamp.class);
    }

    @Test
    public void testNegativeDateTime() {
        Date date1 = new Date(-1000L);
        Date date2 = new Date(-2000L);
        Assert.assertTrue((date1.compareTo(date2) > 0 ? 1 : 0) != 0);
        byte[] b1 = PDate.INSTANCE.toBytes((Object)date1);
        byte[] b2 = PDate.INSTANCE.toBytes((Object)date2);
        Assert.assertTrue((Bytes.compareTo((byte[])b1, (byte[])b2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIllegalUnsignedDateTime() {
        Date date1 = new Date(-1000L);
        try {
            PUnsignedDate.INSTANCE.toBytes((Object)date1);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SQLException));
            SQLException sqlE = (SQLException)e.getCause();
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)sqlE.getErrorCode());
        }
    }

    @Test
    public void testGetResultSetSqlType() {
        Assert.assertEquals((long)4L, (long)PInteger.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)4L, (long)PUnsignedInt.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)-5L, (long)PLong.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)-5L, (long)PUnsignedLong.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)5L, (long)PSmallint.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)5L, (long)PUnsignedSmallint.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)-6L, (long)PTinyint.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)-6L, (long)PUnsignedTinyint.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)6L, (long)PFloat.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)6L, (long)PUnsignedFloat.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)8L, (long)PDouble.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)8L, (long)PUnsignedDouble.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)91L, (long)PDate.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)91L, (long)PUnsignedDate.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)92L, (long)PTime.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)92L, (long)PUnsignedTime.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)93L, (long)PTimestamp.INSTANCE.getResultSetSqlType());
        Assert.assertEquals((long)93L, (long)PUnsignedTimestamp.INSTANCE.getResultSetSqlType());
        for (PDataType dataType : PDataType.values()) {
            if (!dataType.isArrayType()) continue;
            Assert.assertEquals((String)("Wrong datatype for " + dataType), (long)2003L, (long)dataType.getResultSetSqlType());
        }
    }

    private void testReadDecimalPrecisionAndScaleFromRawBytes(BigDecimal bd, SortOrder sortOrder) {
        byte[] b = PDecimal.INSTANCE.toBytes((Object)bd, sortOrder);
        int[] v = PDataType.getDecimalPrecisionAndScale((byte[])b, (int)0, (int)b.length, (SortOrder)sortOrder);
        Assert.assertEquals((String)bd.toString(), (long)bd.precision(), (long)v[0]);
        Assert.assertEquals((String)bd.toString(), (long)bd.scale(), (long)v[1]);
    }

    @Test
    public void testArithmeticOnLong() {
        long next;
        int i;
        long startWith = -5L;
        long incrementBy = 1L;
        for (i = 0; i < 10; ++i) {
            next = this.nextValueFor(startWith, incrementBy);
            Assert.assertEquals((long)(startWith + incrementBy), (long)next);
            startWith = next;
        }
        startWith = 5L;
        incrementBy = -1L;
        for (i = 0; i < 10; ++i) {
            next = this.nextValueFor(startWith, incrementBy);
            Assert.assertEquals((long)(startWith + incrementBy), (long)next);
            startWith = next;
        }
        startWith = 0L;
        incrementBy = 100L;
        for (i = 0; i < 10; ++i) {
            next = this.nextValueFor(startWith, incrementBy);
            Assert.assertEquals((long)(startWith + incrementBy), (long)next);
            startWith = next;
        }
    }

    @Test
    public void testGetSampleValue() {
        PDataType[] types = PDataType.values();
        for (int i = 0; i < 10; ++i) {
            for (PDataType type : types) {
                Integer maxLength = type == PChar.INSTANCE || type == PBinary.INSTANCE || type == PCharArray.INSTANCE || type == PBinaryArray.INSTANCE ? Integer.valueOf(10) : null;
                int arrayLength = 10;
                Object sampleValue = type.getSampleValue(maxLength, Integer.valueOf(arrayLength));
                byte[] b = type.toBytes(sampleValue);
                type.toObject(b, 0, b.length, type, SortOrder.getDefault(), maxLength, null);
            }
        }
    }

    private long nextValueFor(long startWith, long incrementBy) {
        long hstartWith = Bytes.toLong((byte[])PLong.INSTANCE.toBytes((Object)startWith));
        return (Long)PLong.INSTANCE.toObject(Bytes.toBytes((long)(hstartWith += incrementBy)));
    }

    @Test
    public void testCoercibleGoldfile() {
        PDataType[] orderedTypes;
        TreeMultimap coercibleToMap = TreeMultimap.create();
        for (PDataType fromType : orderedTypes = PDataTypeFactory.getInstance().getOrderedTypes()) {
            for (PDataType targetType : orderedTypes) {
                if (!fromType.isCoercibleTo(targetType)) continue;
                coercibleToMap.put((Object)fromType.toString(), (Object)targetType.toString());
            }
        }
        Assert.assertEquals((Object)"{BIGINT=[BIGINT, BINARY, DECIMAL, DOUBLE, VARBINARY], BIGINT ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, VARBINARY ARRAY], BINARY=[BINARY, VARBINARY, VARBINARY_ENCODED], BINARY ARRAY=[BINARY ARRAY, VARBINARY ARRAY], BOOLEAN=[BINARY, BOOLEAN, VARBINARY, VARBINARY_ENCODED], BOOLEAN ARRAY=[BINARY ARRAY, BOOLEAN ARRAY, VARBINARY ARRAY], BSON=[BINARY, BSON, VARBINARY], CHAR=[BINARY, CHAR, VARBINARY, VARCHAR], CHAR ARRAY=[BINARY ARRAY, CHAR ARRAY, VARBINARY ARRAY, VARCHAR ARRAY], DATE=[BINARY, DATE, TIME, TIMESTAMP, VARBINARY], DATE ARRAY=[BINARY ARRAY, DATE ARRAY, TIME ARRAY, TIMESTAMP ARRAY, VARBINARY ARRAY], DECIMAL=[DECIMAL, VARBINARY, VARBINARY_ENCODED], DECIMAL ARRAY=[DECIMAL ARRAY, VARBINARY ARRAY], DOUBLE=[BINARY, DECIMAL, DOUBLE, VARBINARY], DOUBLE ARRAY=[BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, VARBINARY ARRAY], FLOAT=[BINARY, DECIMAL, DOUBLE, FLOAT, VARBINARY], FLOAT ARRAY=[BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, VARBINARY ARRAY], INTEGER=[BIGINT, BINARY, DECIMAL, DOUBLE, FLOAT, INTEGER, VARBINARY], INTEGER ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, INTEGER ARRAY, VARBINARY ARRAY], JSON=[BINARY, JSON, VARBINARY], SMALLINT=[BIGINT, BINARY, DECIMAL, DOUBLE, FLOAT, INTEGER, SMALLINT, VARBINARY], SMALLINT ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, INTEGER ARRAY, SMALLINT ARRAY, VARBINARY ARRAY], TIME=[BINARY, DATE, TIME, TIMESTAMP, VARBINARY], TIME ARRAY=[BINARY ARRAY, DATE ARRAY, TIME ARRAY, TIMESTAMP ARRAY, VARBINARY ARRAY], TIMESTAMP=[BINARY, TIMESTAMP, VARBINARY], TIMESTAMP ARRAY=[BINARY ARRAY, TIMESTAMP ARRAY, VARBINARY ARRAY], TINYINT=[BIGINT, BINARY, DECIMAL, DOUBLE, FLOAT, INTEGER, SMALLINT, TINYINT, VARBINARY], TINYINT ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, INTEGER ARRAY, SMALLINT ARRAY, TINYINT ARRAY, VARBINARY ARRAY], UNSIGNED_DATE=[BINARY, DATE, TIME, TIMESTAMP, UNSIGNED_DATE, UNSIGNED_TIME, UNSIGNED_TIMESTAMP, VARBINARY], UNSIGNED_DATE ARRAY=[BINARY ARRAY, DATE ARRAY, TIME ARRAY, TIMESTAMP ARRAY, UNSIGNED_DATE ARRAY, UNSIGNED_TIME ARRAY, UNSIGNED_TIMESTAMP ARRAY, VARBINARY ARRAY], UNSIGNED_DOUBLE=[BINARY, DECIMAL, DOUBLE, UNSIGNED_DOUBLE, VARBINARY], UNSIGNED_DOUBLE ARRAY=[BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, UNSIGNED_DOUBLE ARRAY, VARBINARY ARRAY], UNSIGNED_FLOAT=[BINARY, DECIMAL, DOUBLE, FLOAT, UNSIGNED_DOUBLE, UNSIGNED_FLOAT, VARBINARY], UNSIGNED_FLOAT ARRAY=[BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, UNSIGNED_DOUBLE ARRAY, UNSIGNED_FLOAT ARRAY, VARBINARY ARRAY], UNSIGNED_INT=[BIGINT, BINARY, DECIMAL, DOUBLE, FLOAT, INTEGER, UNSIGNED_DOUBLE, UNSIGNED_FLOAT, UNSIGNED_INT, UNSIGNED_LONG, VARBINARY], UNSIGNED_INT ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, INTEGER ARRAY, UNSIGNED_DOUBLE ARRAY, UNSIGNED_FLOAT ARRAY, UNSIGNED_INT ARRAY, UNSIGNED_LONG ARRAY, VARBINARY ARRAY], UNSIGNED_LONG=[BIGINT, BINARY, DECIMAL, DOUBLE, UNSIGNED_DOUBLE, UNSIGNED_LONG, VARBINARY], UNSIGNED_LONG ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, UNSIGNED_DOUBLE ARRAY, UNSIGNED_LONG ARRAY, VARBINARY ARRAY], UNSIGNED_SMALLINT=[BIGINT, BINARY, DECIMAL, DOUBLE, FLOAT, INTEGER, SMALLINT, UNSIGNED_DOUBLE, UNSIGNED_FLOAT, UNSIGNED_INT, UNSIGNED_LONG, UNSIGNED_SMALLINT, VARBINARY], UNSIGNED_SMALLINT ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, INTEGER ARRAY, SMALLINT ARRAY, UNSIGNED_DOUBLE ARRAY, UNSIGNED_FLOAT ARRAY, UNSIGNED_INT ARRAY, UNSIGNED_LONG ARRAY, UNSIGNED_SMALLINT ARRAY, VARBINARY ARRAY], UNSIGNED_TIME=[BINARY, DATE, TIME, TIMESTAMP, UNSIGNED_DATE, UNSIGNED_TIME, UNSIGNED_TIMESTAMP, VARBINARY], UNSIGNED_TIME ARRAY=[BINARY ARRAY, DATE ARRAY, TIME ARRAY, TIMESTAMP ARRAY, UNSIGNED_DATE ARRAY, UNSIGNED_TIME ARRAY, UNSIGNED_TIMESTAMP ARRAY, VARBINARY ARRAY], UNSIGNED_TIMESTAMP=[BINARY, DATE, TIME, TIMESTAMP, UNSIGNED_DATE, UNSIGNED_TIME, UNSIGNED_TIMESTAMP, VARBINARY], UNSIGNED_TIMESTAMP ARRAY=[BINARY ARRAY, DATE ARRAY, TIME ARRAY, TIMESTAMP ARRAY, UNSIGNED_DATE ARRAY, UNSIGNED_TIME ARRAY, UNSIGNED_TIMESTAMP ARRAY, VARBINARY ARRAY], UNSIGNED_TINYINT=[BIGINT, BINARY, DECIMAL, DOUBLE, FLOAT, INTEGER, SMALLINT, TINYINT, UNSIGNED_DOUBLE, UNSIGNED_FLOAT, UNSIGNED_INT, UNSIGNED_LONG, UNSIGNED_SMALLINT, UNSIGNED_TINYINT, VARBINARY], UNSIGNED_TINYINT ARRAY=[BIGINT ARRAY, BINARY ARRAY, DECIMAL ARRAY, DOUBLE ARRAY, FLOAT ARRAY, INTEGER ARRAY, SMALLINT ARRAY, TINYINT ARRAY, UNSIGNED_DOUBLE ARRAY, UNSIGNED_FLOAT ARRAY, UNSIGNED_INT ARRAY, UNSIGNED_LONG ARRAY, UNSIGNED_SMALLINT ARRAY, UNSIGNED_TINYINT ARRAY, VARBINARY ARRAY], VARBINARY=[BINARY, VARBINARY, VARBINARY_ENCODED], VARBINARY ARRAY=[BINARY ARRAY, VARBINARY ARRAY], VARBINARY_ENCODED=[BINARY, VARBINARY, VARBINARY_ENCODED], VARCHAR=[BINARY, BSON, CHAR, VARBINARY, VARBINARY_ENCODED, VARCHAR], VARCHAR ARRAY=[BINARY ARRAY, CHAR ARRAY, VARBINARY ARRAY, VARCHAR ARRAY]}", (Object)coercibleToMap.toString());
    }

    @Test
    public void testIntVersusLong() {
        long l = -1L;
        int i = -1;
        Assert.assertTrue((PLong.INSTANCE.compareTo((Object)l, (Object)i, (PDataType)PInteger.INSTANCE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((PInteger.INSTANCE.compareTo((Object)i, (Object)l, (PDataType)PLong.INSTANCE) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSeparatorBytes() {
        int biggest = -1;
        Assert.assertEquals((long)biggest, (long)QueryConstants.DESC_SEPARATOR_BYTE);
        byte[] array = new byte[1];
        for (int i = -128; i <= 127; ++i) {
            array[0] = (byte)i;
            Assert.assertTrue((Bytes.compareTo((byte[])array, (byte[])QueryConstants.DESC_SEPARATOR_BYTE_ARRAY) <= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBoolean() {
        byte[] bytes = PBoolean.INSTANCE.toBytes((Object)Boolean.TRUE);
        Assert.assertEquals((long)1L, (long)bytes[0]);
        bytes = PBoolean.INSTANCE.toBytes((Object)Boolean.FALSE);
        Assert.assertEquals((long)0L, (long)bytes[0]);
        bytes = PBoolean.INSTANCE.toBytes((Object)Boolean.TRUE, SortOrder.DESC);
        Assert.assertEquals((long)0L, (long)bytes[0]);
        bytes = PBoolean.INSTANCE.toBytes((Object)Boolean.FALSE, SortOrder.DESC);
        Assert.assertEquals((long)1L, (long)bytes[0]);
        Object dec = PDecimal.INSTANCE.toObject((Object)Boolean.TRUE, (PDataType)PBoolean.INSTANCE);
        bytes = PDecimal.INSTANCE.toBytes(dec);
        Object b = PBoolean.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PDecimal.INSTANCE, SortOrder.ASC);
        Assert.assertEquals((Object)true, (Object)b);
        dec = PDecimal.INSTANCE.toObject((Object)Boolean.FALSE, (PDataType)PBoolean.INSTANCE);
        bytes = PDecimal.INSTANCE.toBytes(dec);
        b = PBoolean.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PDecimal.INSTANCE, SortOrder.ASC);
        Assert.assertEquals((Object)false, (Object)b);
        dec = PDecimal.INSTANCE.toObject((Object)Boolean.TRUE, (PDataType)PBoolean.INSTANCE);
        bytes = PDecimal.INSTANCE.toBytes(dec, SortOrder.DESC);
        b = PBoolean.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PDecimal.INSTANCE, SortOrder.DESC);
        Assert.assertEquals((Object)true, (Object)b);
        dec = PDecimal.INSTANCE.toObject((Object)Boolean.FALSE, (PDataType)PBoolean.INSTANCE);
        bytes = PDecimal.INSTANCE.toBytes(dec, SortOrder.DESC);
        b = PBoolean.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PDecimal.INSTANCE, SortOrder.DESC);
        Assert.assertEquals((Object)false, (Object)b);
    }

    @Test
    public void testTimestampToDateComparison() {
        long now = System.currentTimeMillis();
        Timestamp ts1 = DateUtil.getTimestamp((long)now, (int)1111);
        byte[] bytes1 = PTimestamp.INSTANCE.toBytes((Object)ts1);
        Date ts2 = new Date(now);
        byte[] bytes2 = PDate.INSTANCE.toBytes((Object)ts2);
        Assert.assertTrue((PTimestamp.INSTANCE.compareTo(bytes1, 0, bytes1.length, SortOrder.getDefault(), bytes2, 0, bytes2.length, SortOrder.getDefault(), (PDataType)PDate.INSTANCE) > 0 ? 1 : 0) != 0);
        Timestamp ts3 = DateUtil.getTimestamp((long)now, (int)0);
        byte[] bytes3 = PTimestamp.INSTANCE.toBytes((Object)ts3);
        Assert.assertTrue((PTimestamp.INSTANCE.compareTo(bytes3, 0, bytes3.length, SortOrder.getDefault(), bytes2, 0, bytes2.length, SortOrder.getDefault(), (PDataType)PDate.INSTANCE) == 0 ? 1 : 0) != 0);
        Timestamp ts4 = DateUtil.getTimestamp((long)now, (int)0);
        byte[] bytes4 = PUnsignedTimestamp.INSTANCE.toBytes((Object)ts4);
        Assert.assertTrue((PUnsignedTimestamp.INSTANCE.compareTo(bytes4, 0, bytes4.length, SortOrder.getDefault(), bytes2, 0, bytes2.length, SortOrder.getDefault(), (PDataType)PDate.INSTANCE) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTimestamp() {
        Timestamp ts2;
        byte[] bytes2;
        long now = System.currentTimeMillis();
        Timestamp ts1 = DateUtil.getTimestamp((long)now, (int)1111);
        byte[] bytes1 = PTimestamp.INSTANCE.toBytes((Object)ts1);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes1, (byte[])(bytes2 = PTimestamp.INSTANCE.toBytes((Object)(ts2 = DateUtil.getTimestamp((long)now, (int)1112))))) < 0 ? 1 : 0) != 0);
        byte[] ibytes1 = SortOrder.invert((byte[])bytes1, (int)0, (int)bytes1.length);
        byte[] ibytes2 = SortOrder.invert((byte[])bytes2, (int)0, (int)bytes2.length);
        Assert.assertTrue((Bytes.compareTo((byte[])ibytes1, (byte[])ibytes2) > 0 ? 1 : 0) != 0);
        Timestamp ts3 = new Timestamp(now + 1L);
        byte[] bytes3 = PTimestamp.INSTANCE.toBytes((Object)ts3);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes3, (byte[])bytes2) > 0 ? 1 : 0) != 0);
        byte[] ibytes3 = SortOrder.invert((byte[])bytes3, (int)0, (int)bytes3.length);
        Assert.assertTrue((Bytes.compareTo((byte[])ibytes3, (byte[])ibytes2) < 0 ? 1 : 0) != 0);
        Timestamp ts4 = new Timestamp(now - 1L);
        byte[] bytes4 = PTimestamp.INSTANCE.toBytes((Object)ts4);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes4, (byte[])bytes1) < 0 ? 1 : 0) != 0);
        byte[] ibytes4 = SortOrder.invert((byte[])bytes4, (int)0, (int)bytes4.length);
        Assert.assertTrue((Bytes.compareTo((byte[])ibytes4, (byte[])ibytes1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAscExclusiveTimestampRange() {
        long now = System.currentTimeMillis();
        Timestamp ts1 = DateUtil.getTimestamp((long)now, (int)999999);
        byte[] lowerRange = PTimestamp.INSTANCE.toBytes((Object)ts1);
        Timestamp ts2 = new Timestamp(now + 86400000L);
        byte[] upperRange = PTimestamp.INSTANCE.toBytes((Object)ts2);
        KeyRange range = PTimestamp.INSTANCE.getKeyRange(lowerRange, false, upperRange, false, SortOrder.ASC);
        Timestamp ts3 = new Timestamp(now + 1L);
        byte[] expectedLowerRange = PTimestamp.INSTANCE.toBytes((Object)ts3);
        Assert.assertTrue((Bytes.compareTo((byte[])expectedLowerRange, (byte[])range.getLowerRange()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.compareTo((byte[])upperRange, (byte[])range.getUpperRange()) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDescExclusiveTimestampRange() {
        long now = System.currentTimeMillis();
        Timestamp ts1 = new Timestamp(now + 86400000L);
        byte[] lowerRange = PTimestamp.INSTANCE.toBytes((Object)ts1, SortOrder.DESC);
        Timestamp ts2 = new Timestamp(now);
        byte[] upperRange = PTimestamp.INSTANCE.toBytes((Object)ts2, SortOrder.DESC);
        KeyRange range = PTimestamp.INSTANCE.getKeyRange(lowerRange, false, upperRange, false, SortOrder.DESC);
        Timestamp ts3 = DateUtil.getTimestamp((long)(now + 86400000L - 1L), (int)999999);
        byte[] expectedLowerRange = PTimestamp.INSTANCE.toBytes((Object)ts3, SortOrder.DESC);
        Assert.assertTrue((Bytes.compareTo((byte[])expectedLowerRange, (byte[])range.getLowerRange()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.compareTo((byte[])upperRange, (byte[])range.getUpperRange()) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToNull() {
        Object value2;
        Object value1;
        for (PDataType type1 : PDataType.values()) {
            value1 = type1.getSampleValue();
            for (PDataType type2 : PDataType.values()) {
                value2 = null;
                if (!type1.isComparableTo(type2)) continue;
                Assert.assertTrue((type1.compareTo(value1, value2, type2) > 0 ? 1 : 0) != 0);
            }
        }
        for (PDataType type1 : PDataType.values()) {
            value1 = null;
            for (PDataType type2 : PDataType.values()) {
                value2 = type2.getSampleValue();
                if (!type1.isComparableTo(type2)) continue;
                Assert.assertTrue((type1.compareTo(value1, value2, type2) < 0 ? 1 : 0) != 0);
            }
        }
        for (PDataType type1 : PDataType.values()) {
            value1 = null;
            for (PDataType type2 : PDataType.values()) {
                value2 = null;
                if (!type1.isComparableTo(type2)) continue;
                Assert.assertTrue((type1.compareTo(value1, value2, type2) == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testFromSqlTypeName() {
        Assert.assertEquals((Object)PVarchar.INSTANCE, (Object)PDataType.fromSqlTypeName((String)"varchar"));
    }
}

