/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PArrayDataTypeDecoder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBooleanArray;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PCharArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDataTypeFactory;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDateArray;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDecimalArray;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PDoubleArray;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PFloatArray;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PLongArray;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PSmallintArray;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimeArray;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTimestampArray;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PTinyintArray;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDateArray;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedDoubleArray;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedFloatArray;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedIntArray;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedLongArray;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedSmallintArray;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimeArray;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTimestampArray;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PUnsignedTinyintArray;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.junit.Assert;
import org.junit.Test;

public class PDataTypeForArraysTest {
    @Test
    public void testForIntegerArray() {
        Object[] intArr = new Integer[]{1, 2};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PInteger.INSTANCE, (Object[])intArr);
        PIntegerArray.INSTANCE.toObject((Object)arr, (PDataType)PIntegerArray.INSTANCE);
        byte[] bytes = PIntegerArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PIntegerArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForBooleanArray() {
        Object[] boolArr = new Boolean[]{true, false};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PBoolean.INSTANCE, (Object[])boolArr);
        PBooleanArray.INSTANCE.toObject((Object)arr, (PDataType)PBooleanArray.INSTANCE);
        byte[] bytes = PBooleanArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PBooleanArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForVarCharArray() {
        Object[] strArr = new String[]{"abc", "klmnop"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues1() {
        Object[] strArr = new String[]{"abc", null, "bcd", null, null, "b"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues2() {
        Object[] strArr = new String[]{"abc", null, "bcd", null, "cde", null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues3() {
        Object[] strArr = new String[]{"abc", null, null, null, null, null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues4() {
        Object[] strArr = new String[]{"abc", null, null, null, null, null, "xys"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues5() {
        Object[] strArr = new String[]{"abc", "bcd", "cde", null, null, null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues6() {
        Object[] strArr = new String[]{"abc", null, "cde", "bcd", null, null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayWithNullValues7() {
        Object[] strArr = new String[]{null, "abc", null, "bcd", null, "cde"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForCharArray() {
        Object[] strArr = new String[]{"a", "d"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PChar.INSTANCE, (Object[])strArr);
        byte[] bytes = PCharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PCharArray.INSTANCE.toObject(bytes, 0, bytes.length, (PDataType)PCharArray.INSTANCE, null, Integer.valueOf(1), null);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForLongArray() {
        Object[] longArr = new Long[]{1L, 2L};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PLong.INSTANCE, (Object[])longArr);
        PLongArray.INSTANCE.toObject((Object)arr, (PDataType)PLongArray.INSTANCE);
        byte[] bytes = PLongArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PLongArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForSmallIntArray() {
        Object[] shortArr = new Short[]{(short)1, (short)2};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PSmallint.INSTANCE, (Object[])shortArr);
        PSmallintArray.INSTANCE.toObject((Object)arr, (PDataType)PSmallintArray.INSTANCE);
        byte[] bytes = PSmallintArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PSmallintArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForVarCharArrayForOddNumber() {
        Object[] strArr = new String[]{"abx", "ereref", "random"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForVarCharArrayOneElement() {
        Object[] strArr = new String[]{"ereref"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForVarcharArrayWith1ElementInLargerBuffer() {
        Object[] strArr = new String[]{"abx"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        byte[] moreBytes = new byte[bytes.length + 20];
        for (int i = 0; i < moreBytes.length; ++i) {
            moreBytes[i] = (byte)(-i);
        }
        System.arraycopy(bytes, 0, moreBytes, 10, bytes.length);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(moreBytes, 10, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForVarCharArrayForEvenNumberWithIndex() {
        Object[] strArr = new String[]{"abx", "ereref", "random", "random12", "ranzzz"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)4, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"ranzzz", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayWithOneElementIndex() {
        Object[] strArr = new String[]{"abx"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)0, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"abx", (Object)Bytes.toString((byte[])res));
    }

    public void testVariableLengthArrayWithElementsMoreThanShortMax() {
        Object[] strArr = new String[65634];
        for (int i = 0; i < 65634; ++i) {
            String str = "abc";
            for (int j = 0; j <= i; ++j) {
                str = str + "-";
            }
            strArr[i] = str;
        }
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)3, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"abc---", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testGetArrayLengthForVariableLengthArray() {
        Object[] strArr = new String[]{"abx", "ereref", "random", "random12", "ranzzz"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        int result = PArrayDataType.getArrayLength((ImmutableBytesWritable)ptr, (PDataType)PVarchar.INSTANCE, null);
        Assert.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testForVarCharArrayForOddNumberWithIndex() {
        Object[] strArr = new String[]{"abx", "ereref", "random", "random12", "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)3, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"random12", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithNullValue1() {
        Object[] strArr = new String[]{"abx", "ereref", "random", null, "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)2, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"random", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithNullValue2() {
        Object[] strArr = new String[]{"abx", "ereref", "random", "random12", null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)2, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"random", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayForOddNumberWithIndex3() {
        Object[] strArr = new String[]{"abx", "ereref", "random", "random12", null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)4, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayForOddNumberWithIndex4() {
        Object[] strArr = new String[]{"abx", "ereref", "random", null, null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)3, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayForOddNumberWithIndex5() {
        Object[] strArr = new String[]{"abx", "ereref", "random", null, "random12"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)4, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"random12", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayForOddNumberWithIndex6() {
        Object[] strArr = new String[]{"abx", "ereref", "random", null, "random12", "random17"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)4, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"random12", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithNullValue5() {
        Object[] strArr = new String[]{"abx", "ereref", "random", null, "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)3, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithNullValueAtTheStart1() {
        Object[] strArr = new String[]{null, "ereref", "random", null, "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)3, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithNullValueAtTheStart2() {
        Object[] strArr = new String[]{null, "ereref", "random", null, "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)0, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithNullValueAtTheStart3() {
        Object[] strArr = new String[]{null, "ereref", "random", null, "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)4, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"ran", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testPositionSearchWithVarLengthArrayWithAllNulls() {
        Object[] strArr = new String[]{null, null, null, null, null};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)4, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayForOneElementArrayWithIndex() {
        Object[] strArr = new String[]{"abx"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)0, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"abx", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testForVarCharArrayForWithTwoelementsElementArrayWithIndex() {
        Object[] strArr = new String[]{"abx", "ereref"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)1, (PDataType)PVarchar.INSTANCE, (Integer)PVarchar.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        Assert.assertEquals((Object)"ereref", (Object)Bytes.toString((byte[])res));
    }

    @Test
    public void testLongArrayWithIndex() {
        Object[] longArr = new Long[]{1L, 2L, 4L, 5L};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PLong.INSTANCE, (Object[])longArr);
        PLongArray.INSTANCE.toObject((Object)arr, (PDataType)PLongArray.INSTANCE);
        byte[] bytes = PLongArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)2, (PDataType)PLong.INSTANCE, (Integer)PLong.INSTANCE.getByteSize());
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        byte[] bs = ptr.get();
        byte[] res = new byte[length];
        System.arraycopy(bs, offset, res, 0, length);
        long result = (Long)PLong.INSTANCE.toObject(res);
        Assert.assertEquals((long)4L, (long)result);
    }

    @Test
    public void testGetArrayLengthForFixedLengthArray() {
        Object[] longArr = new Long[]{1L, 2L, 4L, 5L};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PLong.INSTANCE, (Object[])longArr);
        PLongArray.INSTANCE.toObject((Object)arr, (PDataType)PLongArray.INSTANCE);
        byte[] bytes = PLongArray.INSTANCE.toBytes((Object)arr);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        int length = PArrayDataType.getArrayLength((ImmutableBytesWritable)ptr, (PDataType)PLong.INSTANCE, null);
        Assert.assertEquals((long)4L, (long)length);
    }

    @Test
    public void testForVarcharArrayBiggerArraysNumber() {
        Object[] strArr = new String[101];
        for (int i = 0; i <= 100; ++i) {
            strArr[i] = "abc" + i;
        }
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForTinyIntArray() {
        Object[] byteArr = new Byte[]{(byte)1, (byte)2};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PTinyint.INSTANCE, (Object[])byteArr);
        PTinyintArray.INSTANCE.toObject((Object)arr, (PDataType)PTinyintArray.INSTANCE);
        byte[] bytes = PTinyintArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PTinyintArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForFloatArray() {
        Object[] floatArr = new Float[]{Float.valueOf(1.06f), Float.valueOf(2.89f)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PFloat.INSTANCE, (Object[])floatArr);
        PFloatArray.INSTANCE.toObject((Object)arr, (PDataType)PFloatArray.INSTANCE);
        byte[] bytes = PFloatArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PFloatArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForDoubleArray() {
        Object[] doubleArr = new Double[]{1.06, 2.89};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PDouble.INSTANCE, (Object[])doubleArr);
        PDoubleArray.INSTANCE.toObject((Object)arr, (PDataType)PDoubleArray.INSTANCE);
        byte[] bytes = PDoubleArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PDoubleArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForDecimalArray() {
        Object[] bigDecimalArr = new BigDecimal[]{new BigDecimal(89997), new BigDecimal(8999.9951171875)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PDecimal.INSTANCE, (Object[])bigDecimalArr);
        PDecimalArray.INSTANCE.toObject((Object)arr, (PDataType)PDecimalArray.INSTANCE);
        byte[] bytes = PDecimalArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PDecimalArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForTimeStampArray() {
        Object[] timeStampArr = new Timestamp[]{new Timestamp(System.currentTimeMillis()), new Timestamp(900000L)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PTimestamp.INSTANCE, (Object[])timeStampArr);
        PTimestampArray.INSTANCE.toObject((Object)arr, (PDataType)PTimestampArray.INSTANCE);
        byte[] bytes = PTimestampArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PTimestampArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedTimeStampArray() {
        Object[] timeStampArr = new Timestamp[]{new Timestamp(System.currentTimeMillis()), new Timestamp(900000L)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedTimestamp.INSTANCE, (Object[])timeStampArr);
        PUnsignedTimestampArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedTimestampArray.INSTANCE);
        byte[] bytes = PUnsignedTimestampArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedTimestampArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForTimeArray() {
        Object[] timeArr = new Time[]{new Time(System.currentTimeMillis()), new Time(900000L)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PTime.INSTANCE, (Object[])timeArr);
        PTimeArray.INSTANCE.toObject((Object)arr, (PDataType)PTimeArray.INSTANCE);
        byte[] bytes = PTimeArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PTimeArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnsignedTimeArray() {
        Object[] timeArr = new Time[]{new Time(System.currentTimeMillis()), new Time(900000L)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedTime.INSTANCE, (Object[])timeArr);
        PUnsignedTimeArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedTimeArray.INSTANCE);
        byte[] bytes = PUnsignedTimeArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedTimeArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForDateArray() {
        Object[] dateArr = new Date[]{new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + System.currentTimeMillis())};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PDate.INSTANCE, (Object[])dateArr);
        PDateArray.INSTANCE.toObject((Object)arr, (PDataType)PDateArray.INSTANCE);
        byte[] bytes = PDateArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PDateArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedDateArray() {
        Object[] dateArr = new Date[]{new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + System.currentTimeMillis())};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedDate.INSTANCE, (Object[])dateArr);
        PUnsignedDateArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedDateArray.INSTANCE);
        byte[] bytes = PUnsignedDateArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedDateArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedLongArray() {
        Object[] longArr = new Long[]{1L, 2L};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedLong.INSTANCE, (Object[])longArr);
        PUnsignedLongArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedLongArray.INSTANCE);
        byte[] bytes = PUnsignedLongArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedLongArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedIntArray() {
        Object[] intArr = new Integer[]{1, 2};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedInt.INSTANCE, (Object[])intArr);
        PUnsignedIntArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedIntArray.INSTANCE);
        byte[] bytes = PUnsignedIntArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedIntArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedSmallIntArray() {
        Object[] shortArr = new Short[]{(short)1, (short)2};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedSmallint.INSTANCE, (Object[])shortArr);
        PUnsignedSmallintArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedSmallintArray.INSTANCE);
        byte[] bytes = PUnsignedSmallintArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedSmallintArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedTinyIntArray() {
        Object[] byteArr = new Byte[]{(byte)1, (byte)2};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedTinyint.INSTANCE, (Object[])byteArr);
        PUnsignedTinyintArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedTinyintArray.INSTANCE);
        byte[] bytes = PUnsignedTinyintArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedTinyintArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedFloatArray() {
        Object[] floatArr = new Float[]{Float.valueOf(1.9993f), Float.valueOf(2.786f)};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedFloat.INSTANCE, (Object[])floatArr);
        PUnsignedFloatArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedFloatArray.INSTANCE);
        byte[] bytes = PUnsignedFloatArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedFloatArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForUnSignedDoubleArray() {
        Object[] doubleArr = new Double[]{1.9993, 2.786};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedDouble.INSTANCE, (Object[])doubleArr);
        PUnsignedDoubleArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedDoubleArray.INSTANCE);
        byte[] bytes = PUnsignedDoubleArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PUnsignedDoubleArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testForArrayComparisionsForFixedWidth() {
        Object[] doubleArr = new Double[]{1.9993, 2.786};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedDouble.INSTANCE, (Object[])doubleArr);
        PUnsignedDoubleArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedDoubleArray.INSTANCE);
        byte[] bytes1 = PUnsignedDoubleArray.INSTANCE.toBytes((Object)arr);
        doubleArr = new Double[]{1.9993, 2.786};
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedDouble.INSTANCE, (Object[])doubleArr);
        PUnsignedDoubleArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedDoubleArray.INSTANCE);
        byte[] bytes2 = PUnsignedDoubleArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((boolean)Bytes.equals((byte[])bytes1, (byte[])bytes2));
    }

    @Test
    public void testForArrayComparisionsWithInEqualityForFixedWidth() {
        Object[] doubleArr = new Double[]{1.9993, 2.786};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedDouble.INSTANCE, (Object[])doubleArr);
        PUnsignedDoubleArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedDoubleArray.INSTANCE);
        byte[] bytes1 = PUnsignedDoubleArray.INSTANCE.toBytes((Object)arr);
        doubleArr = new Double[]{1.9993, 2.786, 6.3};
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PUnsignedDouble.INSTANCE, (Object[])doubleArr);
        PUnsignedDoubleArray.INSTANCE.toObject((Object)arr, (PDataType)PUnsignedDoubleArray.INSTANCE);
        byte[] bytes2 = PUnsignedDoubleArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes1, (byte[])bytes2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testForArrayComparisonsForVarWidthArrays() {
        Object[] strArr = new String[]{"abc", "ereref", "random", "random1", "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes1 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        strArr = new String[]{"abc", "ereref", "random", "random1", "ran"};
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes2 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((boolean)Bytes.equals((byte[])bytes1, (byte[])bytes2));
    }

    @Test
    public void testForArrayComparisonsInEqualityForVarWidthArrays() {
        Object[] strArr = new String[]{"abc", "ereref", "random", "random1", "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes1 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        strArr = new String[5];
        strArr[0] = "abc";
        strArr[1] = "ereref";
        strArr[2] = "random";
        strArr[3] = "random1";
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes2 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes1, (byte[])bytes2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testForArrayComparsionInEqualityWithNullsRepeatingInTheMiddle() {
        Object[] strArr = new String[]{null, "ereref", "random", null, "ran", "ran"};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes1 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        strArr = new String[]{null, "ereref", "random", null, null, "ran"};
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes2 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes1, (byte[])bytes2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVarCharArrayWithGreatherThan255NullsInMiddle() {
        Object[] strArr = new String[300];
        strArr[0] = "abc";
        strArr[1] = "bcd";
        strArr[2] = null;
        strArr[3] = null;
        strArr[4] = "bcd";
        for (int i = 5; i < strArr.length - 2; ++i) {
            strArr[i] = null;
        }
        strArr[strArr.length - 1] = "abc";
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr);
        PhoenixArray resultArr = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, 0, bytes.length);
        Assert.assertEquals((Object)arr, (Object)resultArr);
    }

    @Test
    public void testVarCharArrayComparisonWithGreaterThan255NullsinMiddle() {
        Object[] strArr = new String[240];
        strArr[0] = "abc";
        strArr[1] = "bcd";
        strArr[2] = null;
        strArr[3] = null;
        strArr[4] = "bcd";
        strArr[strArr.length - 1] = "abc";
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes1 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        strArr = new String[16];
        strArr[0] = "abc";
        strArr[1] = "bcd";
        strArr[2] = null;
        strArr[3] = null;
        strArr[4] = "bcd";
        strArr[strArr.length - 1] = "abc";
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes2 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes1, (byte[])bytes2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVarCharArrayComparisonWithGreaterThan255NullsinMiddle1() {
        Object[] strArr = new String[500];
        strArr[0] = "abc";
        strArr[1] = "bcd";
        strArr[2] = null;
        strArr[3] = null;
        strArr[4] = "bcd";
        strArr[strArr.length - 1] = "abc";
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes1 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        strArr = new String[500];
        strArr[0] = "abc";
        strArr[1] = "bcd";
        strArr[2] = null;
        strArr[3] = null;
        strArr[4] = "bcd";
        strArr[strArr.length - 1] = "abc";
        arr = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])strArr);
        byte[] bytes2 = PVarcharArray.INSTANCE.toBytes((Object)arr);
        Assert.assertTrue((Bytes.compareTo((byte[])bytes1, (byte[])bytes2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsRowKeyOrderOptimized1() {
        Object[] objects = new Object[]{"a", "b", "c"};
        PhoenixArray arr = new PhoenixArray((PDataType)PVarchar.INSTANCE, objects);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr, (PDataType)PVarchar.INSTANCE, SortOrder.ASC);
        Assert.assertTrue((boolean)PArrayDataType.isRowKeyOrderOptimized((PDataType)PVarcharArray.INSTANCE, (SortOrder)SortOrder.ASC, (byte[])bytes, (int)0, (int)bytes.length));
    }

    @Test
    public void testIsRowKeyOrderOptimized2() {
        Object[] objects = new Object[]{"a", "b", "c"};
        PhoenixArray arr = new PhoenixArray((PDataType)PVarchar.INSTANCE, objects);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr, SortOrder.DESC);
        Assert.assertTrue((boolean)PArrayDataType.isRowKeyOrderOptimized((PDataType)PVarcharArray.INSTANCE, (SortOrder)SortOrder.DESC, (byte[])bytes, (int)0, (int)bytes.length));
    }

    @Test
    public void testIsRowKeyOrderOptimized3() {
        Object[] objects = new Object[]{"a", "b", "c"};
        PhoenixArray arr = new PhoenixArray((PDataType)PVarchar.INSTANCE, objects);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr, SortOrder.DESC);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != QueryConstants.DESC_SEPARATOR_BYTE) continue;
            bytes[i] = 0;
        }
        Assert.assertFalse((boolean)PArrayDataType.isRowKeyOrderOptimized((PDataType)PVarcharArray.INSTANCE, (SortOrder)SortOrder.DESC, (byte[])bytes, (int)0, (int)bytes.length));
    }

    @Test
    public void testIsRowKeyOrderOptimized4() {
        Assert.assertTrue((boolean)PArrayDataType.isRowKeyOrderOptimized((PDataType)PVarcharArray.INSTANCE, (SortOrder)SortOrder.DESC, null, (int)0, (int)0));
    }

    @Test
    public void testIsRowKeyOrderOptimized5() {
        Object[] objects = new Object[]{1, 2, 3};
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)PInteger.INSTANCE, objects);
        byte[] bytes = PIntegerArray.INSTANCE.toBytes((Object)arr, (PDataType)PInteger.INSTANCE, SortOrder.ASC);
        Assert.assertTrue((boolean)PArrayDataType.isRowKeyOrderOptimized((PDataType)PIntegerArray.INSTANCE, (SortOrder)SortOrder.ASC, (byte[])bytes, (int)0, (int)bytes.length));
    }

    @Test
    public void testVarcharArrayDesc() {
        Object[] objects = new Object[]{"a", "b", null};
        PhoenixArray arr = new PhoenixArray((PDataType)PVarchar.INSTANCE, objects);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr, (PDataType)PVarchar.INSTANCE, SortOrder.DESC);
        PhoenixArray arr2 = (PhoenixArray)PVarcharArray.INSTANCE.toObject(bytes, SortOrder.DESC);
        Assert.assertEquals((Object)arr, (Object)arr2);
    }

    @Test
    public void testPositionAtArrayElementWithDescArray() {
        Object[] objects = new Object[]{"a", "b", null};
        PhoenixArray arr = new PhoenixArray((PDataType)PVarchar.INSTANCE, objects);
        byte[] bytes = PVarcharArray.INSTANCE.toBytes((Object)arr, (PDataType)PVarchar.INSTANCE, SortOrder.DESC);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(bytes);
        PArrayDataTypeDecoder.positionAtArrayElement((ImmutableBytesWritable)ptr, (int)2, (PDataType)PVarchar.INSTANCE, null);
        String value = (String)PVarchar.INSTANCE.toObject(ptr, SortOrder.DESC);
        Assert.assertEquals(null, (Object)value);
    }

    @Test
    public void testIsCoercibleTo() {
        PDataTypeFactory typeFactory = PDataTypeFactory.getInstance();
        for (PDataType type : typeFactory.getTypes()) {
            if (!type.isArrayType()) continue;
            Object arr = type.getSampleValue();
            Assert.assertTrue((boolean)type.isCoercibleTo(type, arr));
        }
    }

    @Test
    public void testArrayConversion() {
        Object[] data = new String[]{"asdf", "qwerty"};
        PhoenixArray phxArray = PArrayDataType.instantiatePhoenixArray((PDataType)PVarchar.INSTANCE, (Object[])data);
        Assert.assertTrue((String)"Converting a PhoenixArray to a PhoenixArray should return the same object", (phxArray == PVarcharArray.INSTANCE.toPhoenixArray((Object)phxArray, (PDataType)PVarchar.INSTANCE) ? 1 : 0) != 0);
        Array customArray = new Array((String[])data){
            final /* synthetic */ String[] val$data;
            {
                this.val$data = stringArray;
            }

            @Override
            public String getBaseTypeName() throws SQLException {
                return "VARCHAR";
            }

            @Override
            public int getBaseType() throws SQLException {
                return 12;
            }

            @Override
            public Object getArray() throws SQLException {
                return this.val$data;
            }

            @Override
            public Object getArray(Map<String, Class<?>> map) throws SQLException {
                return null;
            }

            @Override
            public Object getArray(long index, int count) throws SQLException {
                return null;
            }

            @Override
            public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
                return null;
            }

            @Override
            public ResultSet getResultSet() throws SQLException {
                return null;
            }

            @Override
            public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
                return null;
            }

            @Override
            public ResultSet getResultSet(long index, int count) throws SQLException {
                return null;
            }

            @Override
            public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
                return null;
            }

            @Override
            public void free() throws SQLException {
            }
        };
        PhoenixArray copy = PVarcharArray.INSTANCE.toPhoenixArray((Object)customArray, (PDataType)PVarchar.INSTANCE);
        Assert.assertEquals((Object)phxArray, (Object)copy);
    }
}

