/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePhoenixArrayToStringTest {
    @Test
    public void testEmptyArray() {
        this.helpTestToString(this.getBaseType(), new Object[0], "[]");
    }

    @Test
    public void testSingleObjectArray() {
        this.helpTestToString(this.getBaseType(), new Object[]{this.getElement1()}, "[" + this.getString1() + "]");
    }

    @Test
    public void testMultipleObjectArray() {
        this.helpTestToString(this.getBaseType(), new Object[]{this.getElement1(), this.getElement2(), this.getElement3()}, "[" + this.getString1() + ", " + this.getString2() + ", " + this.getString3() + "]");
    }

    @Test
    public void testSingleNullObjectArray() {
        this.helpTestToString(this.getBaseType(), new Object[]{null}, "[" + this.getNullString() + "]");
    }

    @Test
    public void testMultipleNullObjectArray() {
        this.helpTestToString(this.getBaseType(), new Object[]{null, null}, "[" + this.getNullString() + ", " + this.getNullString() + "]");
    }

    @Test
    public void testNormalAndNullObjectArray() {
        this.helpTestToString(this.getBaseType(), new Object[]{null, this.getElement1(), null, this.getElement2()}, "[" + this.getNullString() + ", " + this.getString1() + ", " + this.getNullString() + ", " + this.getString2() + "]");
    }

    protected abstract PDataType getBaseType();

    protected abstract Object getElement1();

    protected abstract String getString1();

    protected abstract Object getElement2();

    protected abstract String getString2();

    protected abstract Object getElement3();

    protected abstract String getString3();

    protected String getNullString() {
        return "null";
    }

    protected void helpTestToString(PDataType type, Object[] array, String expected) {
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)type, (Object[])array);
        boolean isPrimitive = this.isPrimitive(arr);
        Assert.assertEquals((String)("Expected " + this.getBaseType() + " array to be " + (isPrimitive ? "" : "not ") + "primitive."), (Object)isPrimitive, (Object)(!arr.getClass().equals(PhoenixArray.class) ? 1 : 0));
        Assert.assertEquals((Object)expected, (Object)arr.toString());
    }

    protected boolean isPrimitive(PhoenixArray arr) {
        return arr.isPrimitiveType();
    }
}

