/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tool;

import java.io.File;
import java.net.URL;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.schema.tool.SchemaToolExtractionIT;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class SchemaToolSynthesisIT {
    private static final String SYNTHESIS_DIR = "synthesis/";
    URL fileUrl = SchemaToolSynthesisIT.class.getClassLoader().getResource("synthesis/");
    String filePath = new File(this.fileUrl.getFile()).getAbsolutePath();

    @Test
    public void testCreateTableStatement_addColumn() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.SAMPLE_TABLE\n(ORG_ID CHAR(15) NOT NULL,\nSOME_ANOTHER_ID BIGINT NOT NULL,\nSECOND_ID BIGINT NOT NULL,\nTYPE VARCHAR,\nSTATUS VARCHAR,\nSTART_TIMESTAMP BIGINT,\nEND_TIMESTAMP BIGINT,\nPARAMS VARCHAR,\nRESULT VARCHAR,\nRELATED_COMMAND BIGINT DEFAULT 100\nCONSTRAINT PK PRIMARY KEY (ORG_ID, SOME_ANOTHER_ID, SECOND_ID))\nVERSIONS=1,MULTI_TENANT=false,REPLICATION_SCOPE=1,TTL=31536000";
        String baseDDL = this.filePath + "/alter_table_add.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_dropColumn() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.SAMPLE_TABLE\n(ORG_ID CHAR(15) NOT NULL,\nSOME_ANOTHER_ID BIGINT NOT NULL,\nSECOND_ID BIGINT NOT NULL,\nSTATUS VARCHAR,\nSTART_TIMESTAMP BIGINT,\nEND_TIMESTAMP BIGINT,\nPARAMS VARCHAR,\nRESULT VARCHAR\nCONSTRAINT PK PRIMARY KEY (ORG_ID, SOME_ANOTHER_ID, SECOND_ID))\nVERSIONS=1,MULTI_TENANT=false,REPLICATION_SCOPE=1,TTL=31536000";
        String baseDDL = this.filePath + "/alter_table_drop.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_changeProperty() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.SAMPLE_TABLE\n(ORG_ID CHAR(15) NOT NULL,\nSOME_ANOTHER_ID BIGINT NOT NULL,\nSECOND_ID BIGINT NOT NULL,\nTYPE VARCHAR,\nSTATUS VARCHAR,\nSTART_TIMESTAMP BIGINT,\nEND_TIMESTAMP BIGINT,\nPARAMS VARCHAR,\nRESULT VARCHAR\nCONSTRAINT PK PRIMARY KEY (ORG_ID, SOME_ANOTHER_ID, SECOND_ID))\nMULTI_TENANT=false,REPLICATION_SCOPE=0,TTL=31536000,VERSIONS=1";
        String baseDDL = this.filePath + "/alter_change_property.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_addProperty() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.SAMPLE_TABLE\n(ORG_ID CHAR(15) NOT NULL,\nSOME_ANOTHER_ID BIGINT NOT NULL,\nSECOND_ID BIGINT NOT NULL,\nTYPE VARCHAR,\nSTATUS VARCHAR,\nSTART_TIMESTAMP BIGINT,\nEND_TIMESTAMP BIGINT,\nPARAMS VARCHAR,\nRESULT VARCHAR\nCONSTRAINT PK PRIMARY KEY (ORG_ID, SOME_ANOTHER_ID, SECOND_ID))\nDISABLE_MIGRATION=true,MULTI_TENANT=false,REPLICATION_SCOPE=1,TTL=31536000,VERSIONS=1";
        String baseDDL = this.filePath + "/alter_add_property.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateViewStatement_addColumn() throws Exception {
        String expected = "CREATE VIEW IF NOT EXISTS TEST.SAMPLE_VIEW\n(DATE_TIME1 DATE NOT NULL,\nINT1 BIGINT NOT NULL,\nSOME_ID CHAR(15) NOT NULL,\nDOUBLE1 DECIMAL(12,3),\nIS_BOOLEAN BOOLEAN,\nRELATE CHAR(15),\nTEXT1 VARCHAR,\nTEXT_READ_ONLY VARCHAR,\nNEW_COLUMN VARCHAR(20)\nCONSTRAINT PKVIEW PRIMARY KEY (DATE_TIME1 DESC, INT1, SOME_ID))\nAS SELECT * FROM TEST.SAMPLE_TABLE_VIEW WHERE FILTER_PREFIX = 'abc'";
        String baseDDL = this.filePath + "/alter_view_add.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_addColumn_pk() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.TABLE_1\n(STATE CHAR(1) NOT NULL,\nSOME_ID VARCHAR\nCONSTRAINT PK PRIMARY KEY (STATE, SOME_ID))";
        String baseDDL = this.filePath + "/alter_table_add_pk.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateViewStatement_dropColumn() throws Exception {
        String expected = "CREATE VIEW IF NOT EXISTS TEST.SAMPLE_VIEW\n(DATE_TIME1 DATE NOT NULL,\nINT1 BIGINT NOT NULL,\nSOME_ID CHAR(15) NOT NULL,\nIS_BOOLEAN BOOLEAN,\nRELATE CHAR(15),\nTEXT1 VARCHAR,\nTEXT_READ_ONLY VARCHAR\nCONSTRAINT PKVIEW PRIMARY KEY (DATE_TIME1 DESC, INT1, SOME_ID))\nAS SELECT * FROM TEST.SAMPLE_TABLE_VIEW WHERE FILTER_PREFIX = 'abc'";
        String baseDDL = this.filePath + "/alter_view_drop.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateIndexStatement_changeProperty() throws Exception {
        String expected = "CREATE INDEX IF NOT EXISTS ANOTHER_INDEX_ON_SOME_TABLE\nON TEST.SOME_TABLE_WITH_INDEX(SOME_VALUE_COL_1, SOME_VALUE_COL)\nINCLUDE (TEXT_VALUE) ASYNC\nTTL=5000";
        String baseDDL = this.filePath + "/alter_index_change_property.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateIndexStatement_addProperty() throws Exception {
        String expected = "CREATE INDEX IF NOT EXISTS ANOTHER_INDEX_ON_SOME_TABLE\nON TEST.SOME_TABLE_WITH_INDEX(SOME_VALUE_COL_1, SOME_VALUE_COL)\nINCLUDE (TEXT_VALUE) ASYNC\nTTL=123000,REPLICATION_SCOPE=1";
        String baseDDL = this.filePath + "/alter_index_add_property.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_dropTable() throws Exception {
        String expected = "";
        String baseDDL = this.filePath + "/drop_table.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_dropRecreateTable() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.SAMPLE_TABLE (\n   ORG_ID CHAR(15) NOT NULL,\n   SOME_ANOTHER_ID BIGINT NOT NULL,\n   TYPE VARCHAR,\n   STATUS VARCHAR,\n   START_TIMESTAMP BIGINT,\n   END_TIMESTAMP BIGINT,\n   PARAMS VARCHAR,   RESULT VARCHAR\n   CONSTRAINT PK PRIMARY KEY (ORG_ID, SOME_ANOTHER_ID)\n) VERSIONS=1,MULTI_TENANT=FALSE,REPLICATION_SCOPE=1,TTL=31536000";
        String baseDDL = this.filePath + "/drop_create_table.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateTableStatement_add_pk() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.TABLE_1\n(STATE CHAR(1) NOT NULL,\nSOME_ID VARCHAR\nCONSTRAINT PK PRIMARY KEY (STATE, SOME_ID))";
        String baseDDL = this.filePath + "/alter_table_add_pk.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testCreateIndexStatement_dropIndex() throws Exception {
        String expected = "";
        String baseDDL = this.filePath + "/drop_index.sql";
        this.runAndVerify(expected, baseDDL);
    }

    private void runAndVerify(String expected, String baseDDL) throws Exception {
        String[] arg = new String[]{"-m", "SYNTH", "-d", baseDDL};
        String result = SchemaToolExtractionIT.runSchemaTool(null, arg);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testMultipleAlterDDL() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS TEST.SAMPLE_TABLE\n(ORG_ID CHAR(15) NOT NULL,\nSOME_ANOTHER_ID BIGINT NOT NULL,\nSECOND_ID BIGINT NOT NULL,\nTYPE VARCHAR,\nSTATUS VARCHAR,\nSTART_TIMESTAMP BIGINT,\nEND_TIMESTAMP BIGINT,\nPARAMS VARCHAR,\nRESULT VARCHAR,\nSOME_NEW_COLUMN BIGINT\nCONSTRAINT PK PRIMARY KEY (ORG_ID, SOME_ANOTHER_ID, SECOND_ID))\nMULTI_TENANT=false,REPLICATION_SCOPE=1,TTL=2000,VERSIONS=1";
        String baseDDL = this.filePath + "/alter_table_multiple.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testMismatchedEntityNames() throws Exception {
        String baseDDL = this.filePath + "/mismatched_entity_name.sql";
        String[] arg = new String[]{"-m", "SYNTH", "-d", baseDDL};
        try {
            SchemaToolExtractionIT.runSchemaTool(null, arg);
        }
        catch (Exception e) {
            e.getMessage().equalsIgnoreCase("Entity name in base and alter DDL don't match");
        }
    }

    @Test
    public void testUnsupportedStatements() {
        String baseDDL = this.filePath + "/create_function.sql";
        String[] arg = new String[]{"-m", "SYNTH", "-d", baseDDL};
        try {
            SchemaToolExtractionIT.runSchemaTool(null, arg);
        }
        catch (Exception e) {
            e.getMessage().equalsIgnoreCase("SchemaTool in Synth mode is supported for CREATE TABLE/VIEW/INDEX ddls");
        }
    }

    @Test
    public void testEscapedPropertyName() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS ABC\n(ORGANIZATION_ID CHAR(15) NOT NULL,\nNETWORK_ID CHAR(15) NOT NULL\nCONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID))\nBLOOMFILTER='ROW',UPDATE_CACHE_FREQUENCY=172800000,DISABLE_BACKUP=true,MULTI_TENANT=true,REPLICATION_SCOPE=1,\"phoenix.max.lookback.age.seconds\"=0,VERSIONS=1";
        String baseDDL = this.filePath + "/escape_property.sql";
        this.runAndVerify(expected, baseDDL);
    }

    @Test
    public void testEscapedColumnName() throws Exception {
        String expected = "CREATE TABLE IF NOT EXISTS ABC\n(NID CHAR(15) NOT NULL,\nDATA VARCHAR,\n\"a\".\"_\" CHAR(1),\n\"b\".\"_\" CHAR(1)\nCONSTRAINT PK PRIMARY KEY (NID))\nBLOOMFILTER='ROW',UPDATE_CACHE_FREQUENCY=172800000,DISABLE_BACKUP=true,MULTI_TENANT=true,REPLICATION_SCOPE=1,\"phoenix.max.lookback.age.seconds\"=0,VERSIONS=1";
        String baseDDL = this.filePath + "/escape_column.sql";
        this.runAndVerify(expected, baseDDL);
    }
}

