/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.schema.stats.UpdateStatisticsTool;
import org.junit.Assert;
import org.junit.Test;

public class UpdateStatisticsToolTest {
    @Test(expected=IllegalStateException.class)
    public void testTableNameIsMandatory() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseOptions(new String[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void testManageSnapshotAndRunFgOption1() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseOptions(new String[]{"-t", "table1", "-ms"});
    }

    @Test
    public void testManageSnapshotAndRunFgOption2() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        try {
            tool.parseOptions(new String[]{"-t", "table1", "-ms", "-runfg"});
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException is not expected since all required parameters are provided.");
        }
    }

    @Test
    public void testSnapshotNameInput() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseArgs(new String[]{"-t", "table1", "-ms", "-runfg", "-s", "snap1"});
        Assert.assertEquals((Object)"snap1", (Object)tool.getSnapshotName());
    }

    @Test
    public void testSnapshotNameDefault() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseArgs(new String[]{"-t", "table1", "-ms", "-runfg"});
        Assert.assertTrue((boolean)tool.getSnapshotName().startsWith("UpdateStatisticsTool_table1_"));
    }

    @Test
    public void testRestoreDirDefault() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseArgs(new String[]{"-t", "table1", "-ms", "-runfg"});
        Assert.assertEquals((Object)"file:/tmp", (Object)tool.getRestoreDir().toString());
    }

    @Test
    public void testRestoreDirInput() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseArgs(new String[]{"-t", "table1", "-d", "fs:/path"});
        Assert.assertEquals((Object)"fs:/path", (Object)tool.getRestoreDir().toString());
    }

    @Test
    public void testRestoreDirFromConfig() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        Configuration configuration = HBaseConfiguration.create();
        configuration.set("fs.defaultFS", "hdfs://base-dir");
        tool.setConf(configuration);
        tool.parseArgs(new String[]{"-t", "table1", "-ms", "-runfg"});
        Assert.assertEquals((Object)"hdfs://base-dir/tmp", (Object)tool.getRestoreDir().toString());
    }

    @Test
    public void testJobPriorityInput() {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.parseArgs(new String[]{"-t", "table1"});
        Assert.assertEquals((Object)"NORMAL", (Object)tool.getJobPriority());
        tool.parseArgs(new String[]{"-t", "table1", "-p", "0"});
        Assert.assertEquals((Object)"VERY_HIGH", (Object)tool.getJobPriority());
        tool.parseArgs(new String[]{"-t", "table1", "-p", "-1"});
        Assert.assertEquals((Object)"NORMAL", (Object)tool.getJobPriority());
        tool.parseArgs(new String[]{"-t", "table1", "-p", "DSAFDAS"});
        Assert.assertEquals((Object)"NORMAL", (Object)tool.getJobPriority());
    }
}

