/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class NoOpStatsCollectorIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoOpStatsCollectorIT.class);
    private String fullTableName;
    private String physicalTableName;
    private Connection conn;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.stats.collection.enabled", Boolean.FALSE.toString());
        NoOpStatsCollectorIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void beforeTest() throws SQLException {
        String schemaName = NoOpStatsCollectorIT.generateUniqueName();
        String tableName = "T_" + NoOpStatsCollectorIT.generateUniqueName();
        this.fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        this.physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)tableName, (boolean)false).getString();
        this.conn = this.getConnection();
        this.conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " ( k VARCHAR, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4] \n CONSTRAINT pk PRIMARY KEY (k, b_string_array DESC)) GUIDE_POSTS_WIDTH = 10");
        this.upsertValues(this.conn, this.fullTableName);
    }

    @Test
    public void testStatsCollectionViaSql() throws SQLException {
        String updateStatisticsSql = "UPDATE STATISTICS " + this.fullTableName;
        LOGGER.info("Running SQL to collect stats: " + updateStatisticsSql);
        Statement stmt = this.conn.createStatement();
        try {
            stmt.execute(updateStatisticsSql);
            Assert.fail((String)"Update Statistics SQL should have failed");
        }
        catch (SQLException e) {
            Assert.assertEquals((String)"StatsCollectionDisabledOnServerException expected", (long)1401L, (long)e.getErrorCode());
            Assert.assertEquals((String)"StatsCollectionDisabledOnServerException expected", (Object)"STS01", (Object)e.getSQLState());
        }
    }

    @Test
    public void testStatsCollectionDuringMajorCompaction() throws Exception {
        LOGGER.info("Running major compaction on table: " + this.physicalTableName);
        TestUtil.doMajorCompaction(this.conn, this.physicalTableName);
        String q1 = "SELECT SUM(GUIDE_POSTS_ROW_COUNT) FROM SYSTEM.STATS WHERE PHYSICAL_NAME = '" + this.physicalTableName + "'";
        ResultSet rs1 = this.conn.createStatement().executeQuery(q1);
        rs1.next();
        int rowCountFromStats = rs1.getInt(1);
        String q2 = "SELECT COUNT(*) FROM " + this.fullTableName;
        ResultSet rs2 = this.conn.createStatement().executeQuery(q2);
        rs2.next();
        int rowCountFromTable = rs2.getInt(1);
        Assert.assertTrue((String)"Stats collection is disabled, hence row counts should not match", (rowCountFromStats != rowCountFromTable ? 1 : 0) != 0);
        Assert.assertEquals((String)"Stats collection is disabled, hence row counts from stats should be 0", (long)0L, (long)rowCountFromStats);
    }

    private Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        return DriverManager.getConnection(NoOpStatsCollectorIT.getUrl(), props);
    }

    private void upsertValues(Connection conn, String tableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkll", null, null, "xxx"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
    }
}

