/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.stats.DefaultStatisticsCollector;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.stats.StatisticsCollectorFactory;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.stats.UpdateStatisticsTool;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class BaseStatsCollectorIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStatsCollectorIT.class);
    private final String tableDDLOptions;
    private final boolean columnEncoded;
    private String tableName;
    private String schemaName;
    private String fullTableName;
    private String physicalTableName;
    private final boolean userTableNamespaceMapped;
    private final boolean mutable;
    private final String transactionProvider;
    private static final int defaultGuidePostWidth = 20;
    private boolean collectStatsOnSnapshot;

    protected BaseStatsCollectorIT(boolean userTableNamespaceMapped, boolean collectStatsOnSnapshot) {
        this(false, null, userTableNamespaceMapped, false, collectStatsOnSnapshot);
    }

    protected BaseStatsCollectorIT(boolean mutable, String transactionProvider, boolean columnEncoded) {
        this(mutable, transactionProvider, false, columnEncoded, false);
    }

    private BaseStatsCollectorIT(boolean mutable, String transactionProvider, boolean userTableNamespaceMapped, boolean columnEncoded, boolean collectStatsOnSnapshot) {
        this.transactionProvider = transactionProvider;
        StringBuilder sb = new StringBuilder();
        if (columnEncoded) {
            sb.append("COLUMN_ENCODED_BYTES=4");
        } else {
            sb.append("COLUMN_ENCODED_BYTES=0");
        }
        if (transactionProvider != null) {
            sb.append(",TRANSACTIONAL=true, TRANSACTION_PROVIDER='" + transactionProvider + "'");
        }
        if (!mutable) {
            sb.append(",IMMUTABLE_ROWS=true");
            if (!columnEncoded) {
                sb.append(",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            }
        }
        this.tableDDLOptions = sb.toString();
        this.userTableNamespaceMapped = userTableNamespaceMapped;
        this.columnEncoded = columnEncoded;
        this.mutable = mutable;
        this.collectStatsOnSnapshot = collectStatsOnSnapshot;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)7);
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.FALSE.toString());
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.FALSE.toString());
        clientProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        BaseStatsCollectorIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Before
    public void generateTableNames() throws SQLException {
        this.schemaName = BaseStatsCollectorIT.generateUniqueName();
        if (this.userTableNamespaceMapped) {
            try (Connection conn = this.getConnection();){
                conn.createStatement().execute("CREATE SCHEMA " + this.schemaName);
            }
        }
        this.tableName = "T_" + BaseStatsCollectorIT.generateUniqueName();
        this.fullTableName = SchemaUtil.getTableName((String)this.schemaName, (String)this.tableName);
        this.physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)this.schemaName, (String)this.tableName, (boolean)this.userTableNamespaceMapped).getString();
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(Integer.MAX_VALUE);
    }

    private Connection getConnection(Integer statsUpdateFreq) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.explain.displayChunkCount", Boolean.TRUE.toString());
        props.setProperty("phoenix.explain.displayRowCount", Boolean.TRUE.toString());
        props.setProperty("phoenix.stats.updateFrequency", Integer.toString(statsUpdateFreq));
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.userTableNamespaceMapped));
        return DriverManager.getConnection(BaseStatsCollectorIT.getUrl(), props);
    }

    private void collectStatistics(Connection conn, String fullTableName) throws Exception {
        this.collectStatistics(conn, fullTableName, null);
    }

    private void collectStatistics(Connection conn, String fullTableName, String guidePostWidth) throws Exception {
        if (this.collectStatsOnSnapshot) {
            this.collectStatsOnSnapshot(conn, fullTableName, guidePostWidth);
            BaseStatsCollectorIT.invalidateStats(conn, fullTableName);
        } else {
            String updateStatisticsSql = "UPDATE STATISTICS " + fullTableName;
            if (guidePostWidth != null) {
                updateStatisticsSql = updateStatisticsSql + " SET \"phoenix.stats.guidepost.width\" = " + guidePostWidth;
            }
            LOGGER.info("Running SQL to collect stats: " + updateStatisticsSql);
            conn.createStatement().execute(updateStatisticsSql);
        }
    }

    private void collectStatsOnSnapshot(Connection conn, String fullTableName, String guidePostWidth) throws Exception {
        if (guidePostWidth != null) {
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET GUIDE_POSTS_WIDTH = " + guidePostWidth);
        }
        this.runUpdateStatisticsTool(fullTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateStatisticsTool(String fullTableName) {
        UpdateStatisticsTool tool = new UpdateStatisticsTool();
        tool.setConf(utility.getConfiguration());
        String randomDir = BaseStatsCollectorIT.getUtility().getRandomDir().toString();
        String[] cmdArgs = this.getArgValues(fullTableName, randomDir);
        try {
            int status = tool.run(cmdArgs);
            Assert.assertEquals((String)"MR Job should complete successfully", (long)0L, (long)status);
            Admin hBaseAdmin = utility.getAdmin();
            Assert.assertEquals((String)"Snapshot should be automatically deleted when UpdateStatisticsTool has completed", (long)0L, (long)hBaseAdmin.listSnapshots(Pattern.compile(tool.getSnapshotName())).size());
        }
        catch (Exception e) {
            Assert.fail((String)("Exception when running UpdateStatisticsTool for " + this.tableName + " Exception: " + e));
        }
        finally {
            Job job = tool.getJob();
            Assert.assertEquals((String)"MR Job should have been configured with UPDATE_STATS job type", (Object)job.getConfiguration().get("phoenix.mapreduce.jobtype"), (Object)PhoenixConfigurationUtil.MRJobType.UPDATE_STATS.name());
        }
    }

    private String[] getArgValues(String fullTableName, String randomDir) {
        ArrayList args = Lists.newArrayList();
        args.add("-t");
        args.add(fullTableName);
        args.add("-d");
        args.add(randomDir);
        args.add("-runfg");
        args.add("-ms");
        return args.toArray(new String[0]);
    }

    @Test
    public void testUpdateEmptyStats() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " ( k CHAR(1) PRIMARY KEY )" + this.tableDDLOptions);
        this.collectStatistics(conn, this.fullTableName);
        ExplainPlan plan = conn.prepareStatement("SELECT * FROM " + this.fullTableName).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes planAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((long)1L, (long)planAttributes.getSplitsChunk().intValue());
        Assert.assertEquals((long)0L, (long)planAttributes.getEstimatedRows());
        Assert.assertEquals((long)20L, (long)planAttributes.getEstimatedSizeInBytes());
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)planAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)planAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.physicalTableName, (Object)planAttributes.getTableName());
        Assert.assertEquals((Object)("SERVER FILTER BY " + (this.columnEncoded ? "FIRST KEY ONLY" : "EMPTY COLUMN ONLY")), (Object)planAttributes.getServerWhereFilter());
        conn.close();
    }

    @Test
    public void testSomeUpdateEmptyStats() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " ( k VARCHAR PRIMARY KEY, a.v1 VARCHAR, b.v2 VARCHAR ) " + this.tableDDLOptions + (this.tableDDLOptions.isEmpty() ? "" : ",") + "SALT_BUCKETS = 3");
        conn.createStatement().execute("UPSERT INTO " + this.fullTableName + "(k,v1) VALUES('a','123456789')");
        this.collectStatistics(conn, this.fullTableName);
        ExplainPlan plan = conn.prepareStatement("SELECT v2 FROM " + this.fullTableName + " WHERE v2='foo'").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes planAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((long)(this.columnEncoded && !this.mutable ? 4L : 3L), (long)planAttributes.getSplitsChunk().intValue());
        Assert.assertEquals((long)(this.columnEncoded && !this.mutable ? 1L : 0L), (long)planAttributes.getEstimatedRows());
        Assert.assertEquals((long)(this.columnEncoded && !this.mutable ? 38L : 20L), (long)planAttributes.getEstimatedSizeInBytes());
        Assert.assertEquals((Object)"PARALLEL 3-WAY", (Object)planAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)planAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.physicalTableName, (Object)planAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY B.V2 = 'foo'", (Object)planAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)planAttributes.getClientSortAlgo());
        long estimatedSizeInBytes = this.columnEncoded ? 28L : (TransactionFactory.Provider.OMID.name().equals(this.transactionProvider) ? 38L : 34L);
        plan = conn.prepareStatement("SELECT * FROM " + this.fullTableName).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        planAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((long)4L, (long)planAttributes.getSplitsChunk().intValue());
        Assert.assertEquals((long)1L, (long)planAttributes.getEstimatedRows());
        Assert.assertEquals((long)estimatedSizeInBytes, (long)planAttributes.getEstimatedSizeInBytes());
        Assert.assertEquals((Object)"PARALLEL 3-WAY", (Object)planAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)planAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.physicalTableName, (Object)planAttributes.getTableName());
        Assert.assertNull((Object)planAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)planAttributes.getClientSortAlgo());
        plan = conn.prepareStatement("SELECT * FROM " + this.fullTableName + " WHERE k = 'a'").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        planAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((long)1L, (long)planAttributes.getSplitsChunk().intValue());
        Assert.assertEquals((long)1L, (long)planAttributes.getEstimatedRows());
        Assert.assertEquals((long)(this.columnEncoded ? 204L : 202L), (long)planAttributes.getEstimatedSizeInBytes());
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)planAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"POINT LOOKUP ON 1 KEY ", (Object)planAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.physicalTableName, (Object)planAttributes.getTableName());
        Assert.assertNull((Object)planAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)planAttributes.getClientSortAlgo());
        conn.close();
    }

    @Test
    public void testUpdateStats() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = this.getConnection();
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " ( k VARCHAR, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4] \n CONSTRAINT pk PRIMARY KEY (k, b_string_array DESC))" + this.tableDDLOptions);
        conn = this.upsertValues(props, this.fullTableName);
        this.collectStatistics(conn, this.fullTableName);
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT k FROM " + this.fullTableName);
        rs.next();
        long rows1 = (Long)rs.getObject("EST_ROWS_READ");
        PreparedStatement stmt = this.upsertStmt(conn, this.fullTableName);
        stmt.setString(1, "z");
        Object[] s = new String[]{"xyz", "def", "ghi", "jkll", null, null, "xxx"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"zya", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        this.collectStatistics(conn, this.fullTableName);
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT k FROM " + this.fullTableName);
        rs.next();
        long rows2 = (Long)rs.getObject("EST_ROWS_READ");
        Assert.assertNotEquals((long)rows1, (long)rows2);
        conn.close();
    }

    private void testNoDuplicatesAfterUpdateStats(String splitKey) throws Throwable {
        Connection conn = this.getConnection();
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " ( k VARCHAR, c1.a bigint,c2.b bigint CONSTRAINT pk PRIMARY KEY (k))" + this.tableDDLOptions + (splitKey != null ? " split on (" + splitKey + ")" : ""));
        conn.createStatement().execute("upsert into " + this.fullTableName + " values ('abc',1,3)");
        conn.createStatement().execute("upsert into " + this.fullTableName + " values ('def',2,4)");
        conn.commit();
        this.collectStatistics(conn, this.fullTableName);
        ResultSet rs = conn.createStatement().executeQuery("SELECT k FROM " + this.fullTableName + " order by k desc");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"def", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        conn.close();
    }

    @Test
    public void testNoDuplicatesAfterUpdateStatsWithSplits() throws Throwable {
        this.testNoDuplicatesAfterUpdateStats("'abc','def'");
    }

    @Test
    public void testNoDuplicatesAfterUpdateStatsWithDesc() throws Throwable {
        this.testNoDuplicatesAfterUpdateStats(null);
    }

    private Connection upsertValues(Properties props, String tableName) throws SQLException, IOException, InterruptedException {
        Connection conn = this.getConnection();
        PreparedStatement stmt = this.upsertStmt(conn, tableName);
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkll", null, null, "xxx"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        stmt = this.upsertStmt(conn, tableName);
        stmt.setString(1, "b");
        s = new String[]{"xyz", "def", "ghi", "jkll", null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"zya", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        stmt = this.upsertStmt(conn, tableName);
        stmt.setString(1, "c");
        s = new String[]{"xyz", "def", "ghi", "jkll", null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"zya", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        stmt = this.upsertStmt(conn, tableName);
        stmt.setString(1, "d");
        s = new String[]{"xyz", "def", "ghi", "jkll", null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"zya", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        stmt = this.upsertStmt(conn, tableName);
        stmt.setString(1, "b");
        s = new String[]{"xyz", "def", "ghi", "jkll", null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"zya", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        stmt = this.upsertStmt(conn, tableName);
        stmt.setString(1, "e");
        s = new String[]{"xyz", "def", "ghi", "jkll", null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"zya", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        return conn;
    }

    private PreparedStatement upsertStmt(Connection conn, String tableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        return stmt;
    }

    @Test
    @Ignore
    public void testCompactUpdatesStats() throws Exception {
        this.testCompactUpdatesStats(0, this.fullTableName);
    }

    @Test
    @Ignore
    public void testCompactUpdatesStatsWithMinStatsUpdateFreq() throws Exception {
        this.testCompactUpdatesStats(900000, this.fullTableName);
    }

    private static void invalidateStats(Connection conn, String tableName) throws SQLException {
        PTable ptable = conn.unwrap(PhoenixConnection.class).getMetaDataCache().getTableRef(new PTableKey(null, tableName)).getTable();
        byte[] name = ptable.getPhysicalName().getBytes();
        conn.unwrap(PhoenixConnection.class).getQueryServices().invalidateStats(new GuidePostsKey(name, SchemaUtil.getEmptyColumnFamily((PTable)ptable)));
    }

    private void testCompactUpdatesStats(Integer statsUpdateFreq, String tableName) throws Exception {
        Result result;
        ResultScanner scanner;
        int nRows = 10;
        Connection conn = this.getConnection(statsUpdateFreq);
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k CHAR(1) PRIMARY KEY, v INTEGER, w INTEGER) " + (!this.tableDDLOptions.isEmpty() ? this.tableDDLOptions + "," : "") + "KEEP_DELETED_CELLS" + "=" + Boolean.FALSE);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        for (int i = 0; i < nRows; ++i) {
            stmt.setString(1, Character.toString((char)(97 + i)));
            stmt.setInt(2, i);
            stmt.setInt(3, i);
            stmt.executeUpdate();
        }
        conn.commit();
        TestUtil.doMajorCompaction(conn, this.physicalTableName);
        if (statsUpdateFreq != 0) {
            BaseStatsCollectorIT.invalidateStats(conn, tableName);
        } else {
            List<KeyRange> keyRanges = TestUtil.getAllSplits(conn, tableName);
            Assert.assertNotEquals((long)(nRows + 1), (long)keyRanges.size());
            int rowCount = conn.createStatement().executeUpdate("UPDATE STATISTICS " + tableName);
            Assert.assertEquals((long)10L, (long)rowCount);
        }
        List<KeyRange> keyRanges = TestUtil.getAllSplits(conn, tableName);
        Assert.assertEquals((long)(nRows + 1), (long)keyRanges.size());
        int nDeletedRows = conn.createStatement().executeUpdate("DELETE FROM " + tableName + " WHERE V < " + nRows / 2);
        conn.commit();
        Assert.assertEquals((long)5L, (long)nDeletedRows);
        Scan scan = new Scan();
        scan.setRaw(true);
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        try (Table htable = phxConn.getQueryServices().getTable(Bytes.toBytes((String)tableName));){
            scanner = htable.getScanner(scan);
            while ((result = scanner.next()) != null) {
                System.out.println(result);
            }
        }
        TestUtil.doMajorCompaction(conn, this.physicalTableName);
        scan = new Scan();
        scan.setRaw(true);
        phxConn = conn.unwrap(PhoenixConnection.class);
        htable = phxConn.getQueryServices().getTable(Bytes.toBytes((String)tableName));
        var11_15 = null;
        try {
            scanner = htable.getScanner(scan);
            while ((result = scanner.next()) != null) {
                System.out.println(result);
            }
        }
        catch (Throwable throwable) {
            var11_15 = throwable;
            throw throwable;
        }
        finally {
            if (htable != null) {
                if (var11_15 != null) {
                    try {
                        htable.close();
                    }
                    catch (Throwable throwable) {
                        var11_15.addSuppressed(throwable);
                    }
                } else {
                    htable.close();
                }
            }
        }
        if (statsUpdateFreq != 0) {
            BaseStatsCollectorIT.invalidateStats(conn, tableName);
        } else {
            Assert.assertEquals((long)(nRows + 1), (long)keyRanges.size());
            int rowCount = conn.createStatement().executeUpdate("UPDATE STATISTICS " + tableName);
            Assert.assertEquals((long)5L, (long)rowCount);
        }
        keyRanges = TestUtil.getAllSplits(conn, tableName);
        Assert.assertEquals((long)(nRows / 2 + 1), (long)keyRanges.size());
        ResultSet rs = conn.createStatement().executeQuery("SELECT SUM(GUIDE_POSTS_ROW_COUNT) FROM \"SYSTEM\".\"STATS\" WHERE PHYSICAL_NAME='" + this.physicalTableName + "'");
        rs.next();
        Assert.assertEquals((long)(nRows - nDeletedRows), (long)rs.getLong(1));
    }

    @Test
    public void testWithMultiCF() throws Exception {
        int i;
        int nRows = 20;
        Connection conn = this.getConnection(0);
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + "(k VARCHAR PRIMARY KEY, a.v INTEGER, b.v INTEGER, c.v INTEGER NULL, d.v INTEGER NULL) " + this.tableDDLOptions);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.fullTableName + " VALUES(?,?, ?, ?, ?)");
        int queryTimeout = conn.unwrap(PhoenixConnection.class).getQueryServices().getProps().getInt("phoenix.query.timeoutMs", 600000);
        byte[] val = new byte[250];
        for (i = 0; i < nRows; ++i) {
            stmt.setString(1, Character.toString((char)(97 + i)) + Bytes.toString((byte[])val));
            stmt.setInt(2, i);
            stmt.setInt(3, i);
            stmt.setInt(4, i);
            stmt.setInt(5, i);
            stmt.executeUpdate();
        }
        conn.commit();
        stmt = conn.prepareStatement("UPSERT INTO " + this.fullTableName + "(k, c.v, d.v) VALUES(?,?,?)");
        for (i = 0; i < 5; ++i) {
            stmt.setString(1, Character.toString((char)(219 + i)) + Bytes.toString((byte[])val));
            stmt.setInt(2, i);
            stmt.setInt(3, i);
            stmt.executeUpdate();
        }
        conn.commit();
        this.collectStatistics(conn, this.fullTableName);
        List<KeyRange> keyRanges = TestUtil.getAllSplits(conn, this.fullTableName);
        Assert.assertEquals((long)26L, (long)keyRanges.size());
        long sizeInBytes = this.columnEncoded ? (long)(this.mutable ? 12530 : 13902) : (TransactionFactory.Provider.OMID.name().equals(this.transactionProvider) ? 25044L : 12420L);
        ExplainPlan plan = conn.prepareStatement("SELECT * FROM " + this.fullTableName).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes planAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((long)26L, (long)planAttributes.getSplitsChunk().intValue());
        Assert.assertEquals((long)25L, (long)planAttributes.getEstimatedRows());
        Assert.assertEquals((long)sizeInBytes, (long)planAttributes.getEstimatedSizeInBytes());
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)planAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)planAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.physicalTableName, (Object)planAttributes.getTableName());
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        List regions = services.getAllTableRegions(Bytes.toBytes((String)this.physicalTableName), queryTimeout);
        Assert.assertEquals((long)1L, (long)regions.size());
        this.collectStatistics(conn, this.fullTableName, Long.toString(1000L));
        keyRanges = TestUtil.getAllSplits(conn, this.fullTableName);
        boolean oneCellPerColFamliyStorageScheme = !this.mutable && this.columnEncoded;
        boolean hasShadowCells = TransactionFactory.Provider.OMID.name().equals(this.transactionProvider);
        Assert.assertEquals((long)(oneCellPerColFamliyStorageScheme ? 13L : (hasShadowCells ? 23L : 12L)), (long)keyRanges.size());
        ResultSet rs = conn.createStatement().executeQuery("SELECT COLUMN_FAMILY,SUM(GUIDE_POSTS_ROW_COUNT),SUM(GUIDE_POSTS_WIDTH),COUNT(*) from \"SYSTEM\".STATS where PHYSICAL_NAME = '" + this.physicalTableName + "' GROUP BY COLUMN_FAMILY ORDER BY COLUMN_FAMILY");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"A", (Object)rs.getString(1));
        Assert.assertEquals((long)24L, (long)rs.getInt(2));
        Assert.assertEquals((long)(this.columnEncoded ? (long)(this.mutable ? 12252 : 13624) : (hasShadowCells ? 24756L : 12144L)), (long)rs.getInt(3));
        Assert.assertEquals((long)(oneCellPerColFamliyStorageScheme ? 12L : (hasShadowCells ? 22L : 11L)), (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"B", (Object)rs.getString(1));
        Assert.assertEquals((long)(oneCellPerColFamliyStorageScheme ? 24L : 20L), (long)rs.getInt(2));
        Assert.assertEquals((long)(this.columnEncoded ? (long)(this.mutable ? 5600 : 6972) : (hasShadowCells ? 11260L : 5540L)), (long)rs.getInt(3));
        Assert.assertEquals((long)(oneCellPerColFamliyStorageScheme ? 6L : (hasShadowCells ? 10L : 5L)), (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"C", (Object)rs.getString(1));
        Assert.assertEquals((long)24L, (long)rs.getInt(2));
        Assert.assertEquals((long)(this.columnEncoded ? (long)(this.mutable ? 6724 : 6988) : (hasShadowCells ? 13520L : 6652L)), (long)rs.getInt(3));
        Assert.assertEquals((long)(hasShadowCells ? 12L : 6L), (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"D", (Object)rs.getString(1));
        Assert.assertEquals((long)24L, (long)rs.getInt(2));
        Assert.assertEquals((long)(this.columnEncoded ? (long)(this.mutable ? 6724 : 6988) : (hasShadowCells ? 13520L : 6652L)), (long)rs.getInt(3));
        Assert.assertEquals((long)(hasShadowCells ? 12L : 6L), (long)rs.getInt(4));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("ALTER TABLE " + this.fullTableName + " SET " + "GUIDE_POSTS_WIDTH" + "=0");
        this.collectStatistics(conn, this.fullTableName);
        rs = conn.createStatement().executeQuery("SELECT count(1) FROM " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " WHERE " + "PHYSICAL_NAME" + "='" + this.physicalTableName + "' AND " + "COLUMN_FAMILY" + " IS NOT NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        plan = conn.prepareStatement("SELECT * FROM " + this.fullTableName).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        planAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((long)1L, (long)planAttributes.getSplitsChunk().intValue());
        Assert.assertNull((Object)planAttributes.getEstimatedRows());
        Assert.assertNull((Object)planAttributes.getEstimatedSizeInBytes());
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)planAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)planAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.physicalTableName, (Object)planAttributes.getTableName());
    }

    @Test
    public void testRowCountAndByteCounts() throws Exception {
        Connection conn = this.getConnection();
        String ddl = "CREATE TABLE " + this.fullTableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2)) " + this.tableDDLOptions + " split on ('e','j','o')";
        conn.createStatement().execute(ddl);
        String[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        for (int i = 0; i < 26; ++i) {
            conn.createStatement().execute("UPSERT INTO " + this.fullTableName + " values('" + strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + strings[25 - i] + "')");
        }
        conn.commit();
        this.collectStatistics(conn, this.fullTableName, Long.toString(20L));
        Random r = new Random();
        int count = 0;
        boolean hasShadowCells = TransactionFactory.Provider.OMID.name().equals(this.transactionProvider);
        while (count < 4) {
            int startIndex = r.nextInt(strings.length);
            int endIndex = r.nextInt(strings.length - startIndex) + startIndex;
            long rows = endIndex - startIndex;
            long c2Bytes = rows * (long)(this.columnEncoded ? (this.mutable ? 37 : 48) : 35);
            String physicalTableName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)this.fullTableName), (boolean)this.userTableNamespaceMapped).toString();
            ResultSet rs = conn.createStatement().executeQuery("SELECT COLUMN_FAMILY,SUM(GUIDE_POSTS_ROW_COUNT),SUM(GUIDE_POSTS_WIDTH) from \"SYSTEM\".STATS where PHYSICAL_NAME = '" + physicalTableName + "' AND GUIDE_POST_KEY>= cast('" + strings[startIndex] + "' as varbinary) AND  GUIDE_POST_KEY<cast('" + strings[endIndex] + "' as varbinary) and COLUMN_FAMILY='C2' group by COLUMN_FAMILY");
            if (startIndex >= endIndex) continue;
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"C2", (Object)rs.getString(1));
            Assert.assertEquals((long)rows, (long)rs.getLong(2));
            long sumOfGuidePostsWidth = rs.getLong(3);
            Assert.assertTrue((boolean)(hasShadowCells ? sumOfGuidePostsWidth > c2Bytes : sumOfGuidePostsWidth == c2Bytes));
            ++count;
        }
    }

    @Test
    public void testRowCountWhenNumKVsExceedCompactionScannerThreshold() throws Exception {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE " + this.fullTableName + "(PK1 VARCHAR NOT NULL, ");
        int numRows = 10;
        try (Connection conn = this.getConnection();){
            int compactionScannerKVThreshold = conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration().getInt(HConstants.COMPACTION_KV_MAX, 10);
            int numKvColumns = compactionScannerKVThreshold * 2;
            for (int i = 1; i <= numKvColumns; ++i) {
                sb.append("KV" + i + " VARCHAR");
                if (i >= numKvColumns) continue;
                sb.append(", ");
            }
            sb.append(" CONSTRAINT PK PRIMARY KEY (PK1))");
            String ddl = sb.toString();
            conn.createStatement().execute(ddl);
            sb = new StringBuilder(200);
            sb.append("UPSERT INTO " + this.fullTableName + " VALUES (");
            for (int i = 1; i <= numKvColumns + 1; ++i) {
                sb.append("?");
                if (i >= numKvColumns + 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            String dml = sb.toString();
            PreparedStatement stmt = conn.prepareStatement(dml);
            String keyValue = "KVVVVVV";
            for (int j = 1; j <= numRows; ++j) {
                for (int i = 1; i <= numKvColumns + 1; ++i) {
                    if (i == 1) {
                        stmt.setString(1, "" + j);
                        continue;
                    }
                    stmt.setString(i, keyValue);
                }
                stmt.executeUpdate();
            }
            conn.commit();
            this.collectStatistics(conn, this.fullTableName);
            String q = "SELECT SUM(GUIDE_POSTS_ROW_COUNT) FROM SYSTEM.STATS WHERE PHYSICAL_NAME = '" + this.physicalTableName + "'";
            ResultSet rs = conn.createStatement().executeQuery(q);
            rs.next();
            Assert.assertEquals((String)"Number of expected rows in stats table after update stats didn't match!", (long)numRows, (long)rs.getInt(1));
            conn.createStatement().executeUpdate("DELETE FROM SYSTEM.STATS WHERE PHYSICAL_NAME = '" + this.physicalTableName + "'");
            conn.commit();
            TestUtil.doMajorCompaction(conn, this.physicalTableName);
            q = "SELECT SUM(GUIDE_POSTS_ROW_COUNT) FROM SYSTEM.STATS WHERE PHYSICAL_NAME = '" + this.physicalTableName + "'";
            rs = conn.createStatement().executeQuery(q);
            rs.next();
            Assert.assertEquals((String)"Number of expected rows in stats table after major compaction didn't match", (long)numRows, (long)rs.getInt(1));
        }
    }

    private void verifyGuidePostGenerated(ConnectionQueryServices queryServices, String tableName, String[] familyNames, long guidePostWidth, boolean emptyGuidePostExpected) throws Exception {
        try (Table statsHTable = queryServices.getTable(SchemaUtil.getPhysicalName((byte[])PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, (ReadOnlyProps)queryServices.getProps()).getName());){
            for (String familyName : familyNames) {
                GuidePostsInfo gps = StatisticsUtil.readStatistics((Table)statsHTable, (GuidePostsKey)new GuidePostsKey(Bytes.toBytes((String)tableName), Bytes.toBytes((String)familyName)), (long)Long.MAX_VALUE);
                Assert.assertTrue((boolean)(emptyGuidePostExpected ? gps.isEmptyGuidePost() : !gps.isEmptyGuidePost()));
                Assert.assertTrue((gps.getByteCounts()[0] >= guidePostWidth ? 1 : 0) != 0);
                Assert.assertTrue((gps.getGuidePostTimestamps()[0] > 0L ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testEmptyGuidePostGeneratedWhenDataSizeLessThanGPWidth() throws Exception {
        try (Connection conn = this.getConnection();){
            long guidePostWidth = 20000000L;
            conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " ( k INTEGER, c1.a bigint,c2.b bigint CONSTRAINT pk PRIMARY KEY (k)) GUIDE_POSTS_WIDTH=" + guidePostWidth + ", SALT_BUCKETS = 4");
            conn.createStatement().execute("upsert into " + this.fullTableName + " values (100,1,3)");
            conn.createStatement().execute("upsert into " + this.fullTableName + " values (101,2,4)");
            conn.commit();
            this.collectStatistics(conn, this.fullTableName);
            ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            this.verifyGuidePostGenerated(queryServices, this.physicalTableName, new String[]{"C1", "C2"}, guidePostWidth, true);
        }
    }

    @Test
    public void testCollectingAllVersionsOfCells() throws Exception {
        try (Connection conn = this.getConnection();){
            long guidePostWidth = 70L;
            String ddl = "CREATE TABLE " + this.fullTableName + " (k INTEGER PRIMARY KEY, c1.a bigint, c2.b bigint) GUIDE_POSTS_WIDTH=" + guidePostWidth + ", USE_STATS_FOR_PARALLELIZATION=true, VERSIONS=3";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("upsert into " + this.fullTableName + " values (100,100,3)");
            conn.commit();
            this.collectStatistics(conn, this.fullTableName);
            ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            this.verifyGuidePostGenerated(queryServices, this.physicalTableName, new String[]{"C1", "C2"}, guidePostWidth, true);
            conn.createStatement().execute("upsert into " + this.fullTableName + " values (100,101,4)");
            conn.commit();
            this.collectStatistics(conn, this.fullTableName);
            this.verifyGuidePostGenerated(queryServices, this.physicalTableName, new String[]{"C1", "C2"}, guidePostWidth, false);
        }
    }

    @Test
    public void testGuidePostWidthUsedInDefaultStatsCollector() throws Exception {
        String baseTable = BaseStatsCollectorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(BaseStatsCollectorIT.getUrl());){
            String ddl = "CREATE TABLE " + baseTable + " (k INTEGER PRIMARY KEY, a bigint, b bigint, c bigint) " + this.tableDDLOptions;
            BaseTest.createTestTable(BaseStatsCollectorIT.getUrl(), ddl, null, null);
            conn.createStatement().execute("upsert into " + baseTable + " values (100,1,1,1)");
            conn.createStatement().execute("upsert into " + baseTable + " values (101,2,2,2)");
            conn.createStatement().execute("upsert into " + baseTable + " values (102,3,3,3)");
            conn.createStatement().execute("upsert into " + baseTable + " values (103,4,4,4)");
            conn.createStatement().execute("upsert into " + baseTable + " values (104,5,5,5)");
            conn.createStatement().execute("upsert into " + baseTable + " values (105,6,6,6)");
            conn.createStatement().execute("upsert into " + baseTable + " values (106,7,7,7)");
            conn.createStatement().execute("upsert into " + baseTable + " values (107,8,8,8)");
            conn.createStatement().execute("upsert into " + baseTable + " values (108,9,9,9)");
            conn.createStatement().execute("upsert into " + baseTable + " values (109,10,10,10)");
            conn.commit();
            DefaultStatisticsCollector statsCollector = this.getDefaultStatsCollectorForTable(baseTable);
            statsCollector.init();
            Assert.assertEquals((long)20L, (long)statsCollector.getGuidePostDepth());
            String globalIndex = "GI_" + BaseStatsCollectorIT.generateUniqueName();
            ddl = "CREATE INDEX " + globalIndex + " ON " + baseTable + " (a) INCLUDE (b) ";
            conn.createStatement().execute(ddl);
            statsCollector = this.getDefaultStatsCollectorForTable(globalIndex);
            statsCollector.init();
            Assert.assertEquals((long)20L, (long)statsCollector.getGuidePostDepth());
            if (this.transactionProvider == null || !TransactionFactory.getTransactionProvider((TransactionFactory.Provider)TransactionFactory.Provider.valueOf((String)this.transactionProvider)).isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) {
                String localIndex = "LI_" + BaseStatsCollectorIT.generateUniqueName();
                ddl = "CREATE LOCAL INDEX " + localIndex + " ON " + baseTable + " (b) INCLUDE (c) ";
                conn.createStatement().execute(ddl);
                statsCollector = this.getDefaultStatsCollectorForTable(baseTable);
                statsCollector.init();
                Assert.assertEquals((long)20L, (long)statsCollector.getGuidePostDepth());
            }
            String view = "V_" + BaseStatsCollectorIT.generateUniqueName();
            ddl = "CREATE VIEW " + view + " AS SELECT * FROM " + baseTable;
            conn.createStatement().execute(ddl);
            String viewIndex = "VI_" + BaseStatsCollectorIT.generateUniqueName();
            ddl = "CREATE INDEX " + viewIndex + " ON " + view + " (b)";
            conn.createStatement().execute(ddl);
            String viewIndexTableName = MetaDataUtil.getViewIndexPhysicalName((String)baseTable);
            statsCollector = this.getDefaultStatsCollectorForTable(viewIndexTableName);
            statsCollector.init();
            Assert.assertEquals((long)20L, (long)statsCollector.getGuidePostDepth());
            long newGpWidth = 500L;
            conn.createStatement().execute("ALTER TABLE " + baseTable + " SET GUIDE_POSTS_WIDTH=" + newGpWidth);
            statsCollector = this.getDefaultStatsCollectorForTable(baseTable);
            statsCollector.init();
            Assert.assertEquals((long)newGpWidth, (long)statsCollector.getGuidePostDepth());
            statsCollector = this.getDefaultStatsCollectorForTable(globalIndex);
            statsCollector.init();
            Assert.assertEquals((long)newGpWidth, (long)statsCollector.getGuidePostDepth());
            statsCollector = this.getDefaultStatsCollectorForTable(viewIndexTableName);
            statsCollector.init();
            Assert.assertEquals((long)newGpWidth, (long)statsCollector.getGuidePostDepth());
        }
    }

    private DefaultStatisticsCollector getDefaultStatsCollectorForTable(String tableName) throws Exception {
        RegionCoprocessorEnvironment env = this.getRegionEnvrionment(tableName);
        return (DefaultStatisticsCollector)StatisticsCollectorFactory.createStatisticsCollector((RegionCoprocessorEnvironment)env, (String)tableName, (long)System.currentTimeMillis(), null, null);
    }

    private RegionCoprocessorEnvironment getRegionEnvrionment(String tableName) throws IOException, InterruptedException {
        return (RegionCoprocessorEnvironment)((HRegion)BaseStatsCollectorIT.getUtility().getMiniHBaseCluster().getRegions(TableName.valueOf((String)tableName)).get(0)).getCoprocessorHost().findCoprocessorEnvironment(UngroupedAggregateRegionObserver.class.getName());
    }
}

