/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PDataType;
import org.junit.Assert;
import org.junit.Test;

public class ValueBitSetTest {
    private KeyValueSchema generateSchema(int nFields, int nRepeating, final int nNotNull) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(nNotNull);
        for (int i = 0; i < nFields; ++i) {
            final int fieldIndex = i;
            for (int j = 0; j < nRepeating; ++j) {
                PDatum datum = new PDatum(){

                    public boolean isNullable() {
                        return fieldIndex <= nNotNull;
                    }

                    public PDataType getDataType() {
                        return PDataType.values()[fieldIndex % PDataType.values().length];
                    }

                    public Integer getMaxLength() {
                        return null;
                    }

                    public Integer getScale() {
                        return null;
                    }

                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }
                };
                builder.addField(datum);
            }
        }
        KeyValueSchema schema = builder.build();
        return schema;
    }

    private static void setValueBitSet(KeyValueSchema schema, ValueBitSet valueSet) {
        for (int i = 0; i < schema.getFieldCount() - schema.getMinNullable(); ++i) {
            if ((i & 1) != 1) continue;
            valueSet.set(i);
        }
    }

    @Test
    public void testMinNullableIndex() {
        int minNullableIndex = 4;
        int numFields = 6;
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(4);
        int i = 0;
        while (i < numFields) {
            final int fieldIndex = i++;
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return fieldIndex < 4;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }

                public Integer getScale() {
                    return null;
                }

                public Integer getMaxLength() {
                    return null;
                }

                public PDataType getDataType() {
                    return PDataType.values()[fieldIndex % PDataType.values().length];
                }
            });
        }
        KeyValueSchema kvSchema = builder.build();
        Assert.assertFalse((boolean)((ValueSchema.Field)kvSchema.getFields().get(0)).isNullable());
        Assert.assertFalse((boolean)((ValueSchema.Field)kvSchema.getFields().get(3)).isNullable());
        Assert.assertTrue((boolean)((ValueSchema.Field)kvSchema.getFields().get(4)).isNullable());
        Assert.assertTrue((boolean)((ValueSchema.Field)kvSchema.getFields().get(5)).isNullable());
    }

    @Test
    public void testNullCount() {
        int nFields = 32;
        int nRepeating = 5;
        int nNotNull = 8;
        KeyValueSchema schema = this.generateSchema(nFields, nRepeating, nNotNull);
        ValueBitSet valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        ValueBitSetTest.setValueBitSet(schema, valueSet);
        Assert.assertEquals((long)5L, (long)valueSet.getNullCount(0, 10));
        Assert.assertEquals((long)5L, (long)valueSet.getNullCount(10, 10));
        Assert.assertEquals((long)10L, (long)valueSet.getNullCount(59, 20));
        Assert.assertEquals((long)5L, (long)valueSet.getNullCount(nFields * nRepeating - nNotNull - 10, 10));
        Assert.assertEquals((long)64L, (long)valueSet.getNullCount(2, 128));
    }

    @Test
    public void testSizing() {
        int nFields = 32;
        int nRepeating = 5;
        int nNotNull = 8;
        KeyValueSchema schema = this.generateSchema(nFields, nRepeating, nNotNull);
        ValueBitSet valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        Assert.assertEquals((long)2L, (long)valueSet.getEstimatedLength());
        ValueBitSetTest.setValueBitSet(schema, valueSet);
        Assert.assertEquals((long)26L, (long)valueSet.getEstimatedLength());
        nFields = 18;
        nRepeating = 1;
        nNotNull = 2;
        schema = this.generateSchema(nFields, nRepeating, nNotNull);
        valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        Assert.assertEquals((long)2L, (long)valueSet.getEstimatedLength());
        ValueBitSetTest.setValueBitSet(schema, valueSet);
        Assert.assertEquals((long)2L, (long)valueSet.getEstimatedLength());
        nFields = 19;
        nRepeating = 1;
        nNotNull = 2;
        schema = this.generateSchema(nFields, nRepeating, nNotNull);
        valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        Assert.assertEquals((long)2L, (long)valueSet.getEstimatedLength());
        ValueBitSetTest.setValueBitSet(schema, valueSet);
        Assert.assertEquals((long)10L, (long)valueSet.getEstimatedLength());
        nFields = 19;
        nRepeating = 1;
        nNotNull = 19;
        schema = this.generateSchema(nFields, nRepeating, nNotNull);
        valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        Assert.assertEquals((long)0L, (long)valueSet.getEstimatedLength());
        nFields = 129;
        nRepeating = 1;
        nNotNull = 0;
        schema = this.generateSchema(nFields, nRepeating, nNotNull);
        valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        Assert.assertEquals((long)2L, (long)valueSet.getEstimatedLength());
        ValueBitSetTest.setValueBitSet(schema, valueSet);
        Assert.assertEquals((long)18L, (long)valueSet.getEstimatedLength());
        valueSet.set(128);
        Assert.assertEquals((long)26L, (long)valueSet.getEstimatedLength());
    }

    @Test
    public void testMaxSetBit() {
        int nFields = 19;
        int nRepeating = 1;
        int nNotNull = 2;
        KeyValueSchema schema = this.generateSchema(nFields, nRepeating, nNotNull);
        ValueBitSet valueSet = ValueBitSet.newInstance((ValueSchema)schema);
        ValueBitSetTest.setValueBitSet(schema, valueSet);
        int length = valueSet.getEstimatedLength();
        byte[] buf = new byte[length];
        valueSet.toBytes(buf, 0);
        ValueBitSet copyValueSet = ValueBitSet.newInstance((ValueSchema)schema);
        copyValueSet.or(new ImmutableBytesWritable(buf));
        Assert.assertTrue((copyValueSet.getMaxSetBit() >= valueSet.getMaxSetBit() ? 1 : 0) != 0);
    }
}

