/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ConditionalTTLExpression;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class TTLExpressionTest {
    @Mock
    private PhoenixConnection pconn;
    @Mock
    private PTable table;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testLiteralExpression() {
        int ttl = 100;
        LiteralTTLExpression literal = new LiteralTTLExpression(ttl);
        Assert.assertEquals((Object)literal, (Object)TTLExpressionFactory.create((int)ttl));
        Assert.assertEquals((Object)literal, (Object)TTLExpressionFactory.create((String)String.valueOf(ttl)));
    }

    @Test
    public void testForever() {
        Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_FOREVER, (Object)TTLExpressionFactory.create((String)"FOREVER"));
        Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_FOREVER, (Object)TTLExpressionFactory.create((int)Integer.MAX_VALUE));
    }

    @Test
    public void testTableTTLInTableDescriptor() {
        Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR, (Object)TTLExpressionFactory.create((int)-1));
    }

    @Test
    public void testNone() throws SQLException {
        Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, (Object)TTLExpressionFactory.create((String)"NONE"));
        Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, (Object)TTLExpressionFactory.create((int)0));
        Assert.assertNull((Object)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED.serialize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLiteral() {
        TTLExpressionFactory.create((int)-10);
    }

    @Test
    public void testConditionalExpression() throws SQLException {
        String ttl = "PK1 = 5 AND COL1 > 'abc'";
        ConditionalTTLExpression expected = new ConditionalTTLExpression(ttl);
        TTLExpression actual = TTLExpressionFactory.create((String)ttl);
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)ttl, (Object)expected.getTTLExpression());
    }
}

