/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SystemFunctionSplitPolicy;
import org.apache.phoenix.schema.SystemStatsSplitPolicy;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class SystemSplitPolicyTest {
    @Test
    public void testStatsSplitPolicy() {
        SystemStatsSplitPolicy policy = new SystemStatsSplitPolicy();
        byte[] table = PVarchar.INSTANCE.toBytes((Object)"FOO.BAR");
        ImmutableBytesPtr family = QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES_PTR;
        byte[] rowKey = ByteUtil.concat((byte[])PLong.INSTANCE.toBytes((Object)20L), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)"BAS"), QueryConstants.SEPARATOR_BYTE_ARRAY, PInteger.INSTANCE.toBytes((Object)100)});
        byte[] splitOn = StatisticsUtil.getRowKey((byte[])table, (ImmutableBytesWritable)family, (byte[])rowKey);
        splitOn = policy.getSplitPoint(splitOn);
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])table, (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])splitOn);
        table = PVarchar.INSTANCE.toBytes((Object)"MY_TABLE");
        family = new ImmutableBytesWritable(Bytes.toBytes((String)"ABC"));
        rowKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"BAS"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PInteger.INSTANCE.toBytes((Object)100), PLong.INSTANCE.toBytes((Object)20L)});
        splitOn = StatisticsUtil.getRowKey((byte[])table, (ImmutableBytesWritable)family, (byte[])rowKey);
        splitOn = policy.getSplitPoint(splitOn);
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])table, (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])splitOn);
    }

    private static byte[] getSystemFunctionRowKey(String tenantId, String funcName, String typeName, byte[] argPos) {
        return ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)funcName), QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)typeName), QueryConstants.SEPARATOR_BYTE_ARRAY, argPos});
    }

    private static byte[] getSystemFunctionSplitKey(String tenantId, String funcName) {
        return ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)funcName), QueryConstants.SEPARATOR_BYTE_ARRAY});
    }

    @Test
    public void testFunctionSplitPolicy() {
        SystemFunctionSplitPolicy policy = new SystemFunctionSplitPolicy();
        byte[] rowKey = SystemSplitPolicyTest.getSystemFunctionRowKey("", "MY_FUNC", "VARCHAR", Bytes.toBytes((int)3));
        byte[] expectedSplitPoint = SystemSplitPolicyTest.getSystemFunctionSplitKey("", "MY_FUNC");
        byte[] splitPoint = policy.getSplitPoint(rowKey);
        Assert.assertArrayEquals((byte[])expectedSplitPoint, (byte[])splitPoint);
        rowKey = SystemSplitPolicyTest.getSystemFunctionRowKey("TENANT1", "F", "", Bytes.toBytes((int)3));
        expectedSplitPoint = SystemSplitPolicyTest.getSystemFunctionSplitKey("TENANT1", "F");
        splitPoint = policy.getSplitPoint(rowKey);
        Assert.assertArrayEquals((byte[])expectedSplitPoint, (byte[])splitPoint);
    }
}

