/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.CompareOperator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.junit.Assert;
import org.junit.Test;

public class SortOrderTest {
    @Test
    public void ascSortOrderDoesNotTransformOp() {
        for (CompareOperator op : CompareOperator.values()) {
            Assert.assertSame((Object)op, (Object)SortOrder.ASC.transform(op));
        }
    }

    @Test
    public void booleanLogic() {
        Assert.assertTrue((PBoolean.INSTANCE.toObject(PDataType.TRUE_BYTES, SortOrder.ASC) == PBoolean.INSTANCE.toObject(PDataType.FALSE_BYTES, SortOrder.DESC) ? 1 : 0) != 0);
        Assert.assertTrue((PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)true), SortOrder.ASC) == PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)false), SortOrder.DESC) ? 1 : 0) != 0);
        Assert.assertTrue((PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)true, SortOrder.ASC)) == PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)false, SortOrder.DESC)) ? 1 : 0) != 0);
        Assert.assertFalse((PBoolean.INSTANCE.toObject(PDataType.FALSE_BYTES, SortOrder.ASC) == PBoolean.INSTANCE.toObject(PDataType.FALSE_BYTES, SortOrder.DESC) ? 1 : 0) != 0);
        Assert.assertFalse((PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)false), SortOrder.ASC) == PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)false), SortOrder.DESC) ? 1 : 0) != 0);
        Assert.assertFalse((PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)false, SortOrder.ASC)) == PBoolean.INSTANCE.toObject(PBoolean.INSTANCE.toBytes((Object)false, SortOrder.DESC)) ? 1 : 0) != 0);
    }

    @Test
    public void descSortOrderTransformsOp() {
        block9: for (CompareOperator op : CompareOperator.values()) {
            CompareOperator oppositeOp = SortOrder.DESC.transform(op);
            switch (op) {
                case EQUAL: {
                    Assert.assertSame((Object)CompareOperator.EQUAL, (Object)oppositeOp);
                    continue block9;
                }
                case GREATER: {
                    Assert.assertSame((Object)CompareOperator.LESS, (Object)oppositeOp);
                    continue block9;
                }
                case GREATER_OR_EQUAL: {
                    Assert.assertSame((Object)CompareOperator.LESS_OR_EQUAL, (Object)oppositeOp);
                    continue block9;
                }
                case LESS: {
                    Assert.assertSame((Object)CompareOperator.GREATER, (Object)oppositeOp);
                    continue block9;
                }
                case LESS_OR_EQUAL: {
                    Assert.assertSame((Object)CompareOperator.GREATER_OR_EQUAL, (Object)oppositeOp);
                    continue block9;
                }
                case NOT_EQUAL: {
                    Assert.assertSame((Object)CompareOperator.NOT_EQUAL, (Object)oppositeOp);
                    continue block9;
                }
                case NO_OP: {
                    Assert.assertSame((Object)CompareOperator.NO_OP, (Object)oppositeOp);
                }
            }
        }
    }

    @Test
    public void defaultIsAsc() {
        Assert.assertSame((Object)SortOrder.ASC, (Object)SortOrder.getDefault());
    }

    @Test
    public void ddlValue() {
        Assert.assertSame((Object)SortOrder.ASC, (Object)SortOrder.fromDDLValue((String)"ASC"));
        Assert.assertSame((Object)SortOrder.ASC, (Object)SortOrder.fromDDLValue((String)"asc"));
        Assert.assertSame((Object)SortOrder.ASC, (Object)SortOrder.fromDDLValue((String)"aSc"));
        Assert.assertSame((Object)SortOrder.DESC, (Object)SortOrder.fromDDLValue((String)"DESC"));
        Assert.assertSame((Object)SortOrder.DESC, (Object)SortOrder.fromDDLValue((String)"desc"));
        Assert.assertSame((Object)SortOrder.DESC, (Object)SortOrder.fromDDLValue((String)"DesC"));
        try {
            SortOrder.fromDDLValue((String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void systemValue() {
        Assert.assertSame((Object)SortOrder.ASC, (Object)SortOrder.fromSystemValue((int)SortOrder.ASC.getSystemValue()));
        Assert.assertSame((Object)SortOrder.DESC, (Object)SortOrder.fromSystemValue((int)SortOrder.DESC.getSystemValue()));
        Assert.assertSame((Object)SortOrder.ASC, (Object)SortOrder.fromSystemValue((int)0));
    }

    @Test
    public void invertByte() {
        byte b = 42;
        Assert.assertNotEquals((long)b, (long)SortOrder.invert((byte)b));
        Assert.assertEquals((long)b, (long)SortOrder.invert((byte)SortOrder.invert((byte)b)));
    }

    @Test
    public void invertByteArray() {
        byte[] b = new byte[]{1, 2, 3, 4};
        Assert.assertArrayEquals((byte[])b, (byte[])SortOrder.invert((byte[])SortOrder.invert((byte[])b, (int)0, (int)b.length), (int)0, (int)b.length));
    }
}

