/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;

public class SchemaUtilTest {
    @Test
    public void testExceptionCode() throws Exception {
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode((int)SQLExceptionCode.AGGREGATE_IN_GROUP_BY.getErrorCode());
        Assert.assertEquals((Object)SQLExceptionCode.AGGREGATE_IN_GROUP_BY, (Object)code);
    }

    @Test
    public void testGetTableName() {
        String tableDisplayName = SchemaUtil.getTableName((String)"schemaName", (String)"tableName");
        Assert.assertEquals((Object)tableDisplayName, (Object)"schemaName.tableName");
        tableDisplayName = SchemaUtil.getTableName(null, (String)"tableName");
        Assert.assertEquals((Object)tableDisplayName, (Object)"tableName");
    }

    @Test
    public void testGetColumnName() {
        String columnDisplayName = SchemaUtil.getMetaDataEntityName((String)"schemaName", (String)"tableName", (String)"familyName", (String)"columnName");
        Assert.assertEquals((Object)columnDisplayName, (Object)"schemaName.tableName.familyName.columnName");
        columnDisplayName = SchemaUtil.getMetaDataEntityName(null, (String)"tableName", (String)"familyName", (String)"columnName");
        Assert.assertEquals((Object)columnDisplayName, (Object)"tableName.familyName.columnName");
        columnDisplayName = SchemaUtil.getMetaDataEntityName((String)"schemaName", (String)"tableName", null, (String)"columnName");
        Assert.assertEquals((Object)columnDisplayName, (Object)"schemaName.tableName.columnName");
        columnDisplayName = SchemaUtil.getMetaDataEntityName(null, null, (String)"familyName", (String)"columnName");
        Assert.assertEquals((Object)columnDisplayName, (Object)"familyName.columnName");
        columnDisplayName = SchemaUtil.getMetaDataEntityName(null, null, null, (String)"columnName");
        Assert.assertEquals((Object)columnDisplayName, (Object)"columnName");
    }

    @Test
    public void testEscapingColumnName() {
        Assert.assertEquals((Object)"\"ID\"", (Object)SchemaUtil.getEscapedFullColumnName((String)"ID"));
        Assert.assertEquals((Object)"\"0\".\"NAME\"", (Object)SchemaUtil.getEscapedFullColumnName((String)"0.NAME"));
        Assert.assertEquals((Object)"\"CF1\".\"LOCATION\"", (Object)SchemaUtil.getEscapedFullColumnName((String)"CF1.LOCATION"));
    }

    @Test
    public void testGetTableNameFromFullNameByte() {
        String tableDisplayName = SchemaUtil.getTableNameFromFullName((byte[])Bytes.toBytes((String)"schemaName.tableName"));
        Assert.assertEquals((Object)tableDisplayName, (Object)"tableName");
    }

    @Test
    public void testGetTableNameFromFullName() {
        String tableDisplayName = SchemaUtil.getTableNameFromFullName((String)"schemaName.tableName");
        Assert.assertEquals((Object)tableDisplayName, (Object)"tableName");
    }
}

