/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;

public class RowKeySchemaTest
extends BaseConnectionlessQueryTest {
    private void assertExpectedRowKeyValue(String dataColumns, String pk, Object[] values) throws Exception {
        this.assertIteration(dataColumns, pk, values, "");
    }

    private void assertIteration(String dataColumns, String pk, Object[] values, String dataProps) throws Exception {
        Object value;
        SortOrder sortOrder;
        PDataType type;
        Boolean hasValue;
        int i;
        String schemaName = "";
        String tableName = "T";
        Connection conn = DriverManager.getConnection(RowKeySchemaTest.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SchemaUtil.normalizeIdentifier((String)schemaName), (String)SchemaUtil.normalizeIdentifier((String)tableName));
        conn.createStatement().execute("CREATE TABLE " + fullTableName + "(" + dataColumns + " CONSTRAINT pk PRIMARY KEY (" + pk + "))  " + (dataProps.isEmpty() ? "" : dataProps));
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName));
        StringBuilder buf = new StringBuilder("UPSERT INTO " + fullTableName + " VALUES(");
        for (int i2 = 0; i2 < values.length; ++i2) {
            buf.append("?,");
        }
        buf.setCharAt(buf.length() - 1, ')');
        PreparedStatement stmt = conn.prepareStatement(buf.toString());
        for (int i3 = 0; i3 < values.length; ++i3) {
            stmt.setObject(i3 + 1, values[i3]);
        }
        stmt.execute();
        Iterator iterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        List dataKeyValues = (List)((Pair)iterator.next()).getSecond();
        Cell keyValue = (Cell)dataKeyValues.get(0);
        ArrayList sortOrders = Lists.newArrayListWithExpectedSize((int)table.getPKColumns().size());
        for (PColumn col : table.getPKColumns()) {
            sortOrders.add(col.getSortOrder());
        }
        RowKeySchema schema = table.getRowKeySchema();
        int minOffset = keyValue.getRowOffset();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        int nExpectedValues = values.length;
        for (i = values.length - 1; i >= 0 && values[i] == null; --i) {
            --nExpectedValues;
        }
        i = 0;
        int maxOffset = schema.iterator(keyValue.getRowArray(), minOffset, (int)keyValue.getRowLength(), ptr);
        for (i = 0; i < schema.getFieldCount() && (hasValue = schema.next(ptr, i, maxOffset)) != null; ++i) {
            Assert.assertTrue((boolean)hasValue);
            type = PDataType.fromLiteral((Object)values[i]);
            sortOrder = (SortOrder)sortOrders.get(i);
            value = type.toObject(ptr, schema.getField(i).getDataType(), sortOrder);
            Assert.assertEquals((Object)values[i], (Object)value);
        }
        Assert.assertEquals((long)nExpectedValues, (long)i);
        Assert.assertNull((Object)schema.next(ptr, i, maxOffset));
        --i;
        while (i >= 0 && (hasValue = schema.previous(ptr, i, minOffset)) != null) {
            Assert.assertTrue((boolean)hasValue);
            type = PDataType.fromLiteral((Object)values[i]);
            sortOrder = (SortOrder)sortOrders.get(i);
            value = type.toObject(ptr, schema.getField(i).getDataType(), sortOrder);
            Assert.assertEquals((Object)values[i], (Object)value);
            --i;
        }
        Assert.assertEquals((long)-1L, (long)i);
        Assert.assertNull((Object)schema.previous(ptr, i, minOffset));
        conn.close();
    }

    @Test
    public void testFixedLengthValueAtEnd() throws Exception {
        this.assertExpectedRowKeyValue("n VARCHAR NOT NULL, s CHAR(1) NOT NULL, y SMALLINT NOT NULL, o BIGINT NOT NULL", "n,s,y DESC,o DESC", new Object[]{"Abbey", "F", 2012, 253});
    }

    @Test
    public void testFixedVarVar() throws Exception {
        this.assertExpectedRowKeyValue("i INTEGER NOT NULL, v1 VARCHAR, v2 VARCHAR", "i, v1, v2", new Object[]{1, "a", "b"});
    }

    @Test
    public void testFixedFixedVar() throws Exception {
        this.assertExpectedRowKeyValue("c1 INTEGER NOT NULL, c2 BIGINT NOT NULL, c3 VARCHAR", "c1, c2, c3", new Object[]{1, 2, "abc"});
    }

    @Test
    public void testVarNullNull() throws Exception {
        this.assertExpectedRowKeyValue("c1 VARCHAR, c2 VARCHAR, c3 VARCHAR", "c1, c2, c3", new Object[]{"abc", null, null});
    }

    @Test
    public void testVarFixedVar() throws Exception {
        this.assertExpectedRowKeyValue("c1 VARCHAR, c2 CHAR(1) NOT NULL, c3 VARCHAR", "c1, c2, c3", new Object[]{"abc", "z", "de"});
    }

    @Test
    public void testVarFixedFixed() throws Exception {
        this.assertExpectedRowKeyValue("c1 VARCHAR, c2 CHAR(1) NOT NULL, c3 INTEGER NOT NULL", "c1, c2, c3", new Object[]{"abc", "z", 5});
    }

    private static byte[] getKeyPart(PTable t, String ... keys) throws SQLException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        byte[][] keyByteArray = new byte[keys.length][];
        int i = 0;
        for (String key : keys) {
            keyByteArray[i++] = key == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)key);
        }
        t.newKey(ptr, (byte[][])keyByteArray);
        return ptr.copyBytes();
    }

    @Test
    public void testClipLeft() throws Exception {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Connection conn = DriverManager.getConnection(RowKeySchemaTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T1(K1 CHAR(1) NOT NULL, K2 VARCHAR, K3 VARCHAR, CONSTRAINT pk PRIMARY KEY (K1,K2,K3))  ");
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), "T1"));
        RowKeySchema schema = table.getRowKeySchema();
        KeyRange r = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A", "B", "C"), (boolean)true, (byte[])RowKeySchemaTest.getKeyPart(table, "B", "C"), (boolean)true);
        KeyRange rLeft = schema.clipLeft(0, r, 1, ptr);
        KeyRange expectedResult = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A"), (boolean)true, (byte[])RowKeySchemaTest.getKeyPart(table, "B"), (boolean)true);
        r = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A", "B", "C"), (boolean)true, (byte[])RowKeySchemaTest.getKeyPart(table, "B"), (boolean)true);
        rLeft = schema.clipLeft(0, r, 1, ptr);
        expectedResult = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A"), (boolean)true, (byte[])RowKeySchemaTest.getKeyPart(table, "B"), (boolean)true);
        Assert.assertEquals((Object)expectedResult, (Object)rLeft);
        rLeft = schema.clipLeft(0, r, 2, ptr);
        expectedResult = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A", "B"), (boolean)true, (byte[])RowKeySchemaTest.getKeyPart(table, "B"), (boolean)true);
        Assert.assertEquals((Object)expectedResult, (Object)rLeft);
        r = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A", "B", "C"), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)true);
        rLeft = schema.clipLeft(0, r, 2, ptr);
        expectedResult = KeyRange.getKeyRange((byte[])RowKeySchemaTest.getKeyPart(table, "A", "B"), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false);
        Assert.assertEquals((Object)expectedResult, (Object)rLeft);
        r = KeyRange.getKeyRange((byte[])KeyRange.UNBOUND, (boolean)false, (byte[])RowKeySchemaTest.getKeyPart(table, "A", "B", "C"), (boolean)true);
        rLeft = schema.clipLeft(0, r, 2, ptr);
        expectedResult = KeyRange.getKeyRange((byte[])KeyRange.UNBOUND, (boolean)false, (byte[])RowKeySchemaTest.getKeyPart(table, "A", "B"), (boolean)true);
        Assert.assertEquals((Object)expectedResult, (Object)rLeft);
    }
}

