/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Assert;
import org.junit.Test;

public class MutationTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testDurability() throws Exception {
        this.testDurability(true);
        this.testDurability(false);
    }

    private void testDurability(boolean disableWAL) throws Exception {
        try (Connection conn = DriverManager.getConnection(MutationTest.getUrl());){
            Durability expectedDurability = disableWAL ? Durability.SKIP_WAL : Durability.USE_DEFAULT;
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE t1 (k integer not null primary key, a.k varchar, b.k varchar) " + (disableWAL ? "DISABLE_WAL=true" : ""));
            conn.createStatement().execute("UPSERT INTO t1 VALUES(1,'a','b')");
            conn.createStatement().execute("DELETE FROM t1 WHERE k=2");
            this.assertDurability(conn, expectedDurability);
            conn.createStatement().execute("DELETE FROM t1 WHERE k=1");
            this.assertDurability(conn, expectedDurability);
            conn.rollback();
            conn.createStatement().execute("DROP TABLE t1");
        }
    }

    private void assertDurability(Connection conn, Durability durability) throws SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Iterator it = pconn.getMutationState().toMutations();
        Assert.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            Assert.assertFalse((boolean)((List)pair.getSecond()).isEmpty());
            for (Mutation m : (List)pair.getSecond()) {
                Assert.assertEquals((Object)durability, (Object)m.getDurability());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSizeConstraint() throws Exception {
        try (Connection conn = DriverManager.getConnection(MutationTest.getUrl());){
            int maxLength1 = 3;
            int maxLength2 = 20;
            conn.setAutoCommit(false);
            String bvalue = "01234567890123456789";
            Assert.assertEquals((long)20L, (long)PVarchar.INSTANCE.toBytes((Object)bvalue).length);
            String value = "\u6fb4\u7c96\u87e4\u092f\u893b\u9143\u5ca4\u8c66\ud311\u85b0\u9129\u813c\u056a\ub066\u7889\u7889\u7889\u7889\u7889";
            String validValue = "abcd";
            String columnTypeInfo1 = "CHAR(3)";
            String columnTypeInto2 = "VARBINARY(20)";
            String columnTypeInto3 = "BINARY(20)";
            String columnTypeInto4 = "VARCHAR(20)";
            Assert.assertTrue((value.length() <= maxLength2 ? 1 : 0) != 0);
            Assert.assertTrue((PVarchar.INSTANCE.toBytes((Object)value).length > maxLength2 ? 1 : 0) != 0);
            conn.createStatement().execute("CREATE TABLE t1 (k1 char(" + maxLength1 + ") not null, k2 varchar(" + maxLength2 + "), v1 varchar(" + maxLength2 + "), v2 varbinary(" + maxLength2 + "), v3 binary(" + maxLength2 + "), constraint pk primary key (k1, k2))");
            conn.createStatement().execute("UPSERT INTO t1 VALUES('a','" + value + "', '" + value + "','" + bvalue + "','" + bvalue + "')");
            try {
                conn.createStatement().execute("UPSERT INTO t1(k1,v1) VALUES('" + validValue + "','" + value + "')");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
                Assert.assertFalse((boolean)e.getMessage().contains(validValue));
                Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInfo1));
            }
            try {
                conn.createStatement().execute("UPSERT INTO t1(k1,v2) VALUES('b','" + value + "')");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
                Assert.assertFalse((boolean)e.getMessage().contains(value));
                Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInto2));
            }
            try {
                conn.createStatement().execute("UPSERT INTO t1(k1,v3) VALUES('b','" + value + "')");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
                Assert.assertFalse((boolean)e.getMessage().contains(value));
                Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInto3));
            }
            value = "\u6fb4\u7c96\u87e4\u092f\u893b\u9143\u5ca4\u8c66\ud311\u85b0\u9129\u813c\u056a\ub066\u7889\u7889\u7889\u7889\u7889\u7889\u7889\u7889\u7889";
            Assert.assertTrue((value.length() > maxLength2 ? 1 : 0) != 0);
            try {
                conn.createStatement().execute("UPSERT INTO t1(k1,k2) VALUES('a','" + value + "')");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
                Assert.assertFalse((boolean)e.getMessage().contains(value));
                Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInto4));
            }
            try {
                conn.createStatement().execute("UPSERT INTO t1(k1,v1) VALUES('a','" + value + "')");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
                Assert.assertFalse((boolean)e.getMessage().contains(value));
                Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInto4));
            }
        }
    }
}

