/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetaDataClientTest
extends BaseConnectionlessQueryTest {
    private static String schema;
    private static String baseTable;
    private static PhoenixConnection phxConn;
    private static MetaDataClient mockClient;
    private static String ddlFormat;
    private static CreateTableStatement stmt;

    @BeforeClass
    public static synchronized void setupTest() throws SQLException {
        schema = MetaDataClientTest.generateUniqueName();
        baseTable = MetaDataClientTest.generateUniqueName();
        phxConn = (PhoenixConnection)DriverManager.getConnection(MetaDataClientTest.getUrl());
        mockClient = new MetaDataClient(phxConn);
        ddlFormat = "CREATE TABLE " + schema + "." + baseTable + " (A VARCHAR PRIMARY KEY, B BIGINT, C VARCHAR)";
        stmt = (CreateTableStatement)new SQLParser(ddlFormat).parseStatement();
    }

    @Test
    public void testHandleCreateTableMutationCode() throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, new PSchema(schema), EnvironmentEdgeManager.currentTimeMillis());
        try {
            mockClient.handleCreateTableMutationCode(result, result.getMutationCode(), stmt, schema, baseTable, null);
            TestCase.fail();
        }
        catch (SQLException e) {
            TestCase.assertEquals((int)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (int)e.getErrorCode());
        }
    }

    @Test
    public void testHandleCreateTableMutationCodeWithNewCode() throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_PK_COLUMNS, new PSchema(schema), EnvironmentEdgeManager.currentTimeMillis());
        try {
            mockClient.handleCreateTableMutationCode(result, result.getMutationCode(), stmt, schema, baseTable, null);
        }
        catch (SQLException e) {
            TestCase.assertEquals((int)SQLExceptionCode.UNEXPECTED_MUTATION_CODE.getErrorCode(), (int)e.getErrorCode());
            TestCase.assertTrue((boolean)e.getMessage().contains("NO_PK_COLUMNS"));
        }
    }
}

