/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.phoenix.coprocessor.CDCCompactionUtil;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ConditionalTTLExpressionIT
extends ParallelStatsDisabledIT {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalTTLExpressionIT.class);
    private static final Random RAND = new Random(11L);
    private static final int MAX_ROWS = 1000;
    private static final String[] PK_COLUMNS = new String[]{"ID1", "ID2"};
    private static final String[] PK_COLUMN_TYPES = new String[]{"VARCHAR", "BIGINT"};
    private static final String[] COLUMNS = new String[]{"VAL1", "VAL2", "VAL3", "VAL4", "VAL5", "VAL6"};
    private static final String[] COLUMN_TYPES = new String[]{"CHAR(15)", "SMALLINT", "DATE", "TIMESTAMP", "BOOLEAN", "BSON"};
    private static final String[] DEFAULT_COLUMN_FAMILIES = new String[COLUMNS.length];
    private ManualEnvironmentEdge injectEdge;
    private String tableDDLOptions;
    private final boolean columnEncoded;
    private final Integer tableLevelMaxLookback;
    private final boolean isStrictTTL;
    private PhoenixTestBuilder.SchemaBuilder schemaBuilder;
    private Map<Integer, String> dataRowPosToKey = Maps.newHashMap();
    private Map<Integer, String> indexRowPosToKey = Maps.newHashMap();
    private static final ObjectMapper OBJECT_MAPPER;

    public ConditionalTTLExpressionIT(boolean columnEncoded, Integer tableLevelMaxLooback, boolean isStrictTTL) {
        this.columnEncoded = columnEncoded;
        this.tableLevelMaxLookback = tableLevelMaxLooback;
        this.isStrictTTL = isStrictTTL;
        this.schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ConditionalTTLExpressionIT.getUrl());
    }

    @Parameterized.Parameters(name="columnEncoded={0}, tableLevelMaxLookback={1}, isStrictTTL={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, 0, false}, {true, 15, false}, {false, 0, true}, {true, 0, true}, {false, 15, true}, {true, 15, true});
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(0));
        props.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        props.put("phoenix.cdc.ttl.shared.cache.expiry.seconds", Integer.toString(1));
        ConditionalTTLExpressionIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void beforeTest() {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" TTL = '%s'");
        optionBuilder.append(", \"phoenix.max.lookback.age.seconds\" = " + this.tableLevelMaxLookback);
        if (this.columnEncoded) {
            optionBuilder.append(", COLUMN_ENCODED_BYTES=2");
        } else {
            optionBuilder.append(", COLUMN_ENCODED_BYTES=0");
        }
        if (!this.isStrictTTL) {
            optionBuilder.append(", IS_STRICT_TTL = false");
        } else {
            optionBuilder.append(", IS_STRICT_TTL = true");
        }
        this.tableDDLOptions = optionBuilder.toString();
        EnvironmentEdgeManager.reset();
        this.injectEdge = new ManualEnvironmentEdge();
        this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
    }

    @After
    public synchronized void afterTest() {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testBasicMaskingAndCompaction() throws Exception {
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        ArrayList indexedColumns = Lists.newArrayList((Object[])new String[]{"VAL1"});
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{ttlCol});
        String indexName = this.createIndex(indexedColumns, includedColumns, false);
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            int i;
            this.populateTable(conn, rowCount);
            this.populateRowPosToRowKey(conn, true);
            ResultSet rs = this.readRow(conn, 3);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getBoolean(ttlCol));
            this.updateColumn(conn, 3, ttlCol, true);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 1) : (long)rowCount), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 1) : (long)rowCount), (long)actual);
            rs = this.readRow(conn, 3);
            Assert.assertNotEquals((Object)this.isStrictTTL, (Object)rs.next());
            this.updateColumn(conn, 2, ttlCol, true);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 2) : (long)rowCount), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 2) : (long)rowCount), (long)actual);
            this.updateColumn(conn, 3, ttlCol, false);
            rs = this.readRow(conn, 3);
            Assert.assertTrue((boolean)rs.next());
            for (String col : COLUMNS) {
                if (!col.equals(ttlCol)) {
                    if (!this.isStrictTTL) continue;
                    Assert.assertNull((Object)rs.getObject(col));
                    continue;
                }
                Assert.assertFalse((boolean)rs.getBoolean(ttlCol));
            }
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 1) : (long)rowCount), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 1) : (long)rowCount), (long)actual);
            this.updateColumn(conn, 3, ttlCol, true);
            this.injectEdge.incrementValue((long)(2 * this.tableLevelMaxLookback) * 1000L + 5L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            for (i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
            }
            expectedCellCount.removeRow(this.dataRowPosToKey.get(2));
            expectedCellCount.removeRow(this.dataRowPosToKey.get(3));
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            this.doMajorCompaction(indexName);
            expectedCellCount = new TestUtil.CellCount();
            for (i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.indexRowPosToKey.get(i), includedColumns.size() + 1);
            }
            expectedCellCount.removeRow(this.indexRowPosToKey.get(2));
            expectedCellCount.removeRow(this.indexRowPosToKey.get(3));
            this.validateTable(conn, indexName, expectedCellCount, this.indexRowPosToKey.values());
        }
    }

    @Test
    public void testEverythingRetainedWithinMaxLookBack() throws Exception {
        Assume.assumeTrue((this.tableLevelMaxLookback > 0 && this.isStrictTTL ? 1 : 0) != 0);
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        long startTime = this.injectEdge.currentTime();
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            ResultSet rs = this.readRow(conn, 3);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getBoolean(ttlCol));
            this.updateColumn(conn, 3, ttlCol, true);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(rowCount - 1), (long)actual);
            rs = this.readRow(conn, 3);
            Assert.assertFalse((boolean)rs.next());
            this.updateColumn(conn, 2, ttlCol, true);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(rowCount - 2), (long)actual);
            this.updateColumn(conn, 3, ttlCol, false);
            rs = this.readRow(conn, 3);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.getBoolean(ttlCol));
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(rowCount - 1), (long)actual);
            this.updateColumn(conn, 3, ttlCol, true);
            this.injectEdge.setValue(startTime + (long)this.tableLevelMaxLookback.intValue() * 1000L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            for (int i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
            }
            expectedCellCount.addOrUpdateCells(this.dataRowPosToKey.get(2), 2);
            expectedCellCount.addOrUpdateCells(this.dataRowPosToKey.get(3), 4 + COLUMNS.length + 1);
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
        }
    }

    @Test
    public void testPartialRowRetainedInMaxLookBack() throws Exception {
        Assume.assumeTrue((this.tableLevelMaxLookback > 0 && this.isStrictTTL ? 1 : 0) != 0);
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol, ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 1;
        this.injectEdge.currentTime();
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            this.updateColumn(conn, 0, ttlCol, true);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(rowCount - 1), (long)actual);
            this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 5L);
            this.updateColumn(conn, 0, "VAL2", 2345);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            this.injectEdge.incrementValue(1L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            for (int i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
            }
            expectedCellCount.addOrUpdateCells(this.dataRowPosToKey.get(0), COLUMNS.length + 1);
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 5L);
            this.doMajorCompaction(tableName);
            expectedCellCount.insertRow(this.dataRowPosToKey.get(0), 2);
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
        }
    }

    @Test
    public void testPhoenixRowTimestamp() throws Exception {
        int ttl = 50000;
        String ttlExpression = String.format("TO_NUMBER(CURRENT_TIME()) - TO_NUMBER(PHOENIX_ROW_TIMESTAMP()) >= %d", ttl);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            this.injectEdge.incrementValue((long)ttl);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 0L : 5L), (long)actual);
            long currentTime = this.injectEdge.currentTime();
            this.updateColumn(conn, 1, "VAL4", currentTime);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 1L : 5L), (long)actual);
            try (ResultSet rs = this.readRow(conn, 1);){
                Assert.assertTrue((boolean)rs.next());
                for (String col : COLUMNS) {
                    if (!col.equals("VAL4")) {
                        if (!this.isStrictTTL) continue;
                        Assert.assertNull((Object)rs.getObject(col));
                        continue;
                    }
                    Assert.assertEquals((long)currentTime, (long)rs.getTimestamp("VAL4").getTime());
                }
            }
            this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 2L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            expectedCellCount.insertRow(this.dataRowPosToKey.get(1), this.isStrictTTL ? 2 : COLUMNS.length + 1);
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            this.injectEdge.incrementValue((long)(ttl + 2));
            this.doMajorCompaction(tableName);
            expectedCellCount = new TestUtil.CellCount();
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
        }
    }

    @Test
    public void testPhoenixRowTimestampWithCdc() throws Exception {
        int ttl = 50000;
        String ttlExpression = String.format("TO_NUMBER(CURRENT_TIME()) - TO_NUMBER(PHOENIX_ROW_TIMESTAMP()) >= %d", ttl);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        String cdcName = "cdc_" + ConditionalTTLExpressionIT.generateUniqueName();
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            conn.createStatement().execute("CREATE CDC " + cdcName + " ON " + tableName);
            this.populateTable(conn, rowCount);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((String)"Table should contain all inserted rows", (long)5L, (long)actual);
            String cdcQuery1 = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM TEST_ENTITY." + cdcName;
            String cdcQuery2 = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM TEST_ENTITY." + cdcName + " LIMIT 7";
            String cdcQuery3 = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM TEST_ENTITY." + cdcName + " LIMIT 10 OFFSET 2";
            List<Map<String, Object>> postImageList1 = ConditionalTTLExpressionIT.getPostImageList(conn, cdcQuery1, 5);
            List<Map<String, Object>> postImageList2 = ConditionalTTLExpressionIT.getPostImageList(conn, cdcQuery2, 5);
            List<Map<String, Object>> postImageList3 = ConditionalTTLExpressionIT.getPostImageList(conn, cdcQuery3, 3);
            this.injectEdge.incrementValue((long)ttl);
            this.doMajorCompaction(tableName);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((String)"All rows should be expired after TTL", (long)0L, (long)actual);
            cdcQuery2 = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM TEST_ENTITY." + cdcName + " LIMIT 11";
            ConditionalTTLExpressionIT.compareTtlPreImagesWithLastPostImages(conn, cdcQuery1, postImageList1, 5);
            ConditionalTTLExpressionIT.compareTtlPreImagesWithLastPostImages(conn, cdcQuery2, postImageList2, 5);
            ConditionalTTLExpressionIT.compareTtlPreImagesWithLastPostImages(conn, cdcQuery3, postImageList3, 3);
            this.injectEdge.incrementValue(1L);
            long currentTime = this.injectEdge.currentTime();
            this.updateColumn(conn, 1, "VAL4", currentTime);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((String)"Only one row should be resurrected after update", (long)1L, (long)actual);
            try (ResultSet rs = this.readRow(conn, 1);){
                Assert.assertTrue((String)"Resurrected row should exist", (boolean)rs.next());
                for (String col : COLUMNS) {
                    if (!col.equals("VAL4")) {
                        Assert.assertNull((String)"Non-updated columns should be null in resurrected row", (Object)rs.getObject(col));
                        continue;
                    }
                    Assert.assertEquals((String)"Updated column should have new timestamp", (long)currentTime, (long)rs.getTimestamp("VAL4").getTime());
                }
            }
            this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 2L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            expectedCellCount.insertRow(this.dataRowPosToKey.get(1), 2);
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            String cdcQuery = "SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM TEST_ENTITY." + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ?";
            PreparedStatement ps = conn.prepareStatement(cdcQuery);
            ps.setTimestamp(1, new Timestamp(currentTime));
            ResultSet resultSet = ps.executeQuery();
            ArrayList<Map> postImageList = new ArrayList<Map>();
            while (resultSet.next()) {
                String cdcVal = resultSet.getString(4);
                Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
                Assert.assertEquals((String)"Resurrection event should be UPSERT type", (Object)"upsert", map.get("event_type"));
                Map preImage = (Map)map.get("pre_image");
                Assert.assertTrue((String)"Resurrection event should have empty pre-image", (boolean)preImage.isEmpty());
                Map postImage = (Map)map.get("post_image");
                Assert.assertFalse((String)"Resurrection event should have non-empty post-image", (boolean)postImage.isEmpty());
                postImageList.add(postImage);
            }
            Assert.assertEquals((String)("Post image list size should be 5 but it is " + postImageList.size()), (long)1L, (long)postImageList.size());
            this.injectEdge.incrementValue((long)ttl);
            Thread.sleep(700L);
            this.cleanUpSharedTtlImageCache();
            this.doMajorCompaction(tableName);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((String)"All rows should be expired after TTL", (long)0L, (long)actual);
            expectedCellCount = new TestUtil.CellCount();
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            ps = conn.prepareStatement(cdcQuery);
            ps.setTimestamp(1, new Timestamp(currentTime));
            resultSet = ps.executeQuery();
            int i = 0;
            while (resultSet.next()) {
                String cdcVal = resultSet.getString(4);
                Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
                Assert.assertEquals((String)"Second TTL expiration should generate TTL_DELETE events", (Object)"ttl_delete", map.get("event_type"));
                Map preImage = (Map)map.get("pre_image");
                Assert.assertFalse((String)"Second TTL_DELETE should have non-empty pre-image", (boolean)preImage.isEmpty());
                Assert.assertNull((String)"TTL_DELETE events should have empty post-image", map.get("post_image"));
                Assert.assertEquals((String)"Second TTL_DELETE pre-image should match resurrection post-image", postImageList.get(i), (Object)preImage);
                ++i;
            }
            Assert.assertEquals((String)("Num of TTL_DELETE events verified should be 5 but it is " + i), (long)1L, (long)i);
        }
    }

    private static void compareTtlPreImagesWithLastPostImages(Connection conn, String cdcQuery, List<Map<String, Object>> postImageList, int expectedCount) throws SQLException, JsonProcessingException {
        ResultSet resultSet = conn.createStatement().executeQuery(cdcQuery);
        int i = 0;
        while (resultSet.next()) {
            String cdcVal = resultSet.getString(4);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Assert.assertEquals((String)"TTL expired rows should generate TTL_DELETE events", (Object)"ttl_delete", map.get("event_type"));
            Map preImage = (Map)map.get("pre_image");
            Assert.assertFalse((String)"TTL_DELETE events should have non-empty pre-image", (boolean)preImage.isEmpty());
            Assert.assertNull((String)"TTL_DELETE events should have empty post-image", map.get("post_image"));
            Assert.assertEquals((String)"TTL_DELETE pre-image should match original insert post-image", postImageList.get(i), (Object)preImage);
            ++i;
        }
        Assert.assertEquals((String)("Num of TTL_DELETE events verified should be " + expectedCount + " but it is " + i), (long)expectedCount, (long)i);
    }

    private static List<Map<String, Object>> getPostImageList(Connection conn, String cdcQuery, int expectedCount) throws SQLException, JsonProcessingException {
        ResultSet resultSet = conn.createStatement().executeQuery(cdcQuery);
        ArrayList<Map<String, Object>> postImageList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            String cdcVal = resultSet.getString(4);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            Assert.assertTrue((String)"Insert events should have empty pre-image", (boolean)preImage.isEmpty());
            Map postImage = (Map)map.get("post_image");
            Assert.assertFalse((String)"Insert events should have non-empty post-image", (boolean)postImage.isEmpty());
            postImageList.add(postImage);
            Assert.assertEquals((String)"Initial events should be UPSERT type", (Object)"upsert", map.get("event_type"));
        }
        Assert.assertEquals((String)("Post image list size should be " + expectedCount + " but it is " + postImageList.size()), (long)expectedCount, (long)postImageList.size());
        return postImageList;
    }

    @Test
    public void testDeleteMarkers() throws Exception {
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            TestUtil.CellCount expectedCellCount;
            int[] rowsToDelete;
            this.populateTable(conn, rowCount);
            for (int rowPosition : rowsToDelete = new int[]{2, 3}) {
                this.deleteRow(conn, rowPosition);
            }
            this.updateColumn(conn, 1, ttlCol, true);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 2L : 3L), (long)actual);
            if (this.tableLevelMaxLookback == 0) {
                this.injectEdge.incrementValue(2L);
                this.doMajorCompaction(tableName);
                expectedCellCount = new TestUtil.CellCount();
                expectedCellCount.insertRow(this.dataRowPosToKey.get(0), COLUMNS.length + 1);
                expectedCellCount.insertRow(this.dataRowPosToKey.get(4), COLUMNS.length + 1);
                this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            } else {
                this.doMajorCompaction(tableName);
                expectedCellCount = new TestUtil.CellCount();
                for (int i = 0; i < rowCount; ++i) {
                    expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
                }
                expectedCellCount.addOrUpdateCells(this.dataRowPosToKey.get(1), 2);
                for (int rowPosition : rowsToDelete) {
                    expectedCellCount.addOrUpdateCell(this.dataRowPosToKey.get(rowPosition));
                }
                this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
                this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 1L);
                this.doMajorCompaction(tableName);
                for (int rowPosition : rowsToDelete) {
                    expectedCellCount.removeRow(this.dataRowPosToKey.get(rowPosition));
                }
                expectedCellCount.removeRow(this.dataRowPosToKey.get(1));
                this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            }
        }
    }

    @Test
    public void testDateExpression() throws Exception {
        String ttlCol = "VAL3";
        String ttlExpression = String.format("CURRENT_DATE() >= %s + 1", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            this.injectEdge.incrementValue(86401200L);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 0L : 5L), (long)actual);
            int newVal = -1;
            Date d = new Date(this.injectEdge.currentTime());
            ArrayList updatedCols = Lists.newArrayList((Object[])new String[]{"VAL2", ttlCol});
            ArrayList newVals = Lists.newArrayList((Object[])new Object[]{newVal, d});
            this.updateColumns(conn, 2, updatedCols, newVals);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 1L : 5L), (long)actual);
            try (ResultSet rs = this.readRow(conn, 2);){
                Assert.assertTrue((boolean)rs.next());
                for (String col : COLUMNS) {
                    if (col.equals("VAL2")) {
                        Assert.assertEquals((long)newVal, (long)rs.getInt("VAL2"));
                        continue;
                    }
                    if (col.equals(ttlCol)) {
                        Assert.assertEquals((Object)d, (Object)rs.getDate(ttlCol));
                        continue;
                    }
                    if (!this.isStrictTTL) continue;
                    Assert.assertNull((Object)rs.getObject(col));
                }
            }
            this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 2L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            expectedCellCount.insertRow(this.dataRowPosToKey.get(2), this.isStrictTTL ? updatedCols.size() + 1 : COLUMNS.length + 1);
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
            this.injectEdge.incrementValue(86401400L);
            this.doMajorCompaction(tableName);
            expectedCellCount = new TestUtil.CellCount();
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
        }
    }

    @Ignore(value="CURRENT_TIME() doesn't honour scn")
    public void testSCN() throws Exception {
        int ttl = 2000;
        String ttlExpression = String.format("TO_NUMBER(CURRENT_TIME()) - TO_NUMBER(PHOENIX_ROW_TIMESTAMP()) >= %d", ttl);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        long actual = 0L;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
        }
        this.injectEdge.incrementValue((long)(ttl + rowCount + 1));
        Properties props = new Properties();
        long scn = this.injectEdge.currentTime() - (long)ttl;
        props.setProperty("CurrentSCN", Long.toString(scn));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl(), props);){
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)0L, (long)actual);
        }
    }

    @Test
    public void testRowWithExpressionEvalFailure() throws Exception {
        String ttlCol = "VAL2";
        String ttlExpression = String.format("%s > 5", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        int rowCount = 1;
        this.injectEdge();
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            this.updateColumn(conn, 0, ttlCol, null);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)1L, (long)actual);
        }
    }

    @Test
    public void testIndexTool() throws Exception {
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol);
        this.createTable(ttlExpression);
        String fullDataTableName = this.schemaBuilder.getEntityTableName();
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullDataTableName);
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullDataTableName);
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            int i;
            this.populateTable(conn, rowCount);
            this.deleteRow(conn, 2);
            this.updateColumn(conn, 0, ttlCol, true);
            this.updateColumn(conn, 4, ttlCol, true);
            String indexName = ConditionalTTLExpressionIT.generateUniqueName();
            String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
            String indexDDL = String.format("create index %s on %s (%s) include (%s) async ", indexName, fullDataTableName, "VAL1", ttlCol, this.tableLevelMaxLookback);
            conn.createStatement().execute(indexDDL);
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(it);
            try {
                Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 2) : (long)rowCount), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 2) : (long)rowCount), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT.name()).getValue());
                String missingIndexRowCounter = this.tableLevelMaxLookback != 0 ? PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT.name() : PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT.name();
                Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 2) : (long)rowCount), (long)mrJobCounters.findCounter(missingIndexRowCounter).getValue());
            }
            catch (AssertionError e) {
                IndexToolIT.dumpMRJobCounters(mrJobCounters);
                throw e;
            }
            this.populateRowPosToRowKey(conn, true);
            long actual = TestUtil.getRowCount(conn, fullDataTableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 3) : (long)(rowCount - 1)), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, fullDataTableName, fullIndexName);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 3) : (long)(rowCount - 1)), (long)actual);
            this.injectEdge.incrementValue((long)(2 * this.tableLevelMaxLookback) * 1000L + 5L);
            this.doMajorCompaction(fullDataTableName);
            this.doMajorCompaction(fullIndexName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            for (i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
            }
            expectedCellCount.removeRow(this.dataRowPosToKey.get(0));
            expectedCellCount.removeRow(this.dataRowPosToKey.get(4));
            expectedCellCount.removeRow(this.dataRowPosToKey.get(2));
            this.validateTable(conn, fullDataTableName, expectedCellCount, this.dataRowPosToKey.values());
            expectedCellCount = new TestUtil.CellCount();
            for (i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.indexRowPosToKey.get(i), 2);
            }
            expectedCellCount.removeRow(this.indexRowPosToKey.get(0));
            expectedCellCount.removeRow(this.indexRowPosToKey.get(4));
            expectedCellCount.removeRow(this.indexRowPosToKey.get(2));
            this.validateTable(conn, fullIndexName, expectedCellCount, this.indexRowPosToKey.values());
            it = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            mrJobCounters = IndexToolIT.getMRJobCounters(it);
            try {
                Assert.assertEquals((long)(rowCount - 3), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)(rowCount - 3), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT.name()).getValue());
            }
            catch (AssertionError e) {
                IndexToolIT.dumpMRJobCounters(mrJobCounters);
                throw e;
            }
        }
    }

    @Test
    public void testNullPKColumn() throws Exception {
        Assume.assumeTrue((this.tableLevelMaxLookback == 0 ? 1 : 0) != 0);
        String tableName = "T_" + ConditionalTTLExpressionIT.generateUniqueName();
        String indexName = "I_" + ConditionalTTLExpressionIT.generateUniqueName();
        String ddlTemplate = "create table %s (id1 varchar, id2 varchar, col1 varchar, col2 varchar constraint pk primary key(id1, id2)) %s";
        String ttlExpression = "id1='a'";
        this.tableDDLOptions = this.tableDDLOptions + " ,IMMUTABLE_ROWS=true";
        this.tableDDLOptions = !this.columnEncoded ? this.tableDDLOptions + " ,IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'" : this.tableDDLOptions + " ,IMMUTABLE_STORAGE_SCHEME='SINGLE_CELL_ARRAY_WITH_OFFSETS'";
        String ddl = String.format(ddlTemplate, tableName, String.format(this.tableDDLOptions, TestUtil.retainSingleQuotes(ttlExpression)));
        String indexDDL = String.format("create index %s ON %s (col1) INCLUDE(col2) ", indexName, tableName, this.tableLevelMaxLookback, this.isStrictTTL);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(indexDDL);
            conn.createStatement().execute("upsert into " + tableName + " values('a', '0', 'col1', 'col2')");
            conn.createStatement().execute("upsert into " + tableName + " values('a', '1', null, 'col2')");
            conn.createStatement().execute("upsert into " + tableName + " values('b','0', 'col1', 'col2')");
            conn.createStatement().execute("upsert into " + tableName + " values('b','1', null, 'col2')");
            conn.createStatement().execute("upsert into " + tableName + " values(null, '0', 'col1', 'col2')");
            conn.commit();
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 3L : 5L), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? 3L : 5L), (long)actual);
            ttlExpression = "id1 is null";
            ddl = "alter table %s set TTL='%s'";
            conn.createStatement().execute(String.format(ddl, tableName, ttlExpression));
            conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 4L : 5L), (long)actual);
            PTable table = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableName);
            Assert.assertEquals((Object)TTLExpressionFactory.create((String)ttlExpression), (Object)table.getTTLExpression());
            PTable index = PhoenixRuntime.getTableNoCache((Connection)conn, (String)indexName);
            Assert.assertEquals((Object)TTLExpressionFactory.create((String)ttlExpression), (Object)index.getTTLExpression());
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? 4L : 5L), (long)actual);
            ttlExpression = "col1='col1'";
            ddl = "alter table %s set TTL='%s'";
            conn.createStatement().execute(String.format(ddl, tableName, TestUtil.retainSingleQuotes(ttlExpression)));
            conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 2L : 5L), (long)actual);
            table = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableName);
            Assert.assertEquals((Object)TTLExpressionFactory.create((String)ttlExpression), (Object)table.getTTLExpression());
            index = PhoenixRuntime.getTableNoCache((Connection)conn, (String)indexName);
            Assert.assertEquals((Object)TTLExpressionFactory.create((String)ttlExpression), (Object)index.getTTLExpression());
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? 2L : 5L), (long)actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnverifiedRows() throws Exception {
        Assume.assumeTrue((this.tableLevelMaxLookback == 0 ? 1 : 0) != 0);
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol);
        this.createTable(ttlExpression);
        String fullDataTableName = this.schemaBuilder.getEntityTableName();
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullDataTableName);
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullDataTableName);
        ArrayList indexedColumns = Lists.newArrayList((Object[])new String[]{"VAL1"});
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{ttlCol, "VAL2"});
        String fullIndexName = this.createIndex(indexedColumns, includedColumns, false);
        String indexName = SchemaUtil.getTableNameFromFullName((String)fullIndexName);
        this.injectEdge();
        int rowCount = 2;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            String explainPlan;
            PhoenixResultSet prs;
            this.populateTable(conn, rowCount);
            this.populateRowPosToRowKey(conn, true);
            ResultSet rs = this.readRow(conn, 0);
            Assert.assertTrue((boolean)rs.next());
            String val1_0 = rs.getString("VAL1");
            rs = this.readRow(conn, 1);
            Assert.assertTrue((boolean)rs.next());
            String val1_1 = rs.getString("VAL1");
            this.deleteRow(conn, 0);
            int val2 = 4567;
            this.updateColumns(conn, 0, Lists.newArrayList((Object[])new String[]{"VAL1", "VAL2", ttlCol}), Lists.newArrayList((Object[])new Object[]{val1_0, val2, false}));
            this.deleteRow(conn, 1);
            this.updateColumns(conn, 1, Lists.newArrayList((Object[])new String[]{"VAL1", "VAL2", ttlCol}), Lists.newArrayList((Object[])new Object[]{val1_1, val2, true}));
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            try {
                this.updateColumns(conn, 0, Lists.newArrayList((Object[])new String[]{"VAL1", "VAL2", ttlCol}), Lists.newArrayList((Object[])new Object[]{val1_0, 2345, false}));
                Assert.fail((String)"An exception should have been thrown");
            }
            catch (Exception exception) {
            }
            finally {
                IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            try {
                this.updateColumns(conn, 1, Lists.newArrayList((Object[])new String[]{"VAL1", "VAL2", ttlCol}), Lists.newArrayList((Object[])new Object[]{val1_1, 2345, false}));
                Assert.fail((String)"An exception should have been thrown");
            }
            catch (Exception exception) {
            }
            finally {
                IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            }
            this.injectEdge.incrementValue(10L);
            TestUtil.dumpTable(conn, TableName.valueOf((String)fullIndexName));
            long actual = TestUtil.getRowCountFromIndex(conn, fullDataTableName, fullIndexName);
            TestUtil.dumpTable(conn, TableName.valueOf((String)fullIndexName));
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount - 1) : (long)rowCount), (long)actual);
            String dql = String.format("select VAL2, VAL5 from %s where VAL1='%s' AND ID2=0", fullDataTableName, val1_0);
            try (ResultSet rs1 = conn.createStatement().executeQuery(dql);){
                prs = rs1.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(fullIndexName));
                Assert.assertTrue((boolean)rs1.next());
                Assert.assertEquals((long)rs1.getInt("VAL2"), (long)val2);
                Assert.assertFalse((boolean)rs1.getBoolean(ttlCol));
            }
            dql = String.format("select VAL2, VAL5 from %s where VAL1='%s' AND ID2=1", fullDataTableName, val1_1);
            rs1 = conn.createStatement().executeQuery(dql);
            var21_25 = null;
            try {
                prs = rs1.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(fullIndexName));
                Assert.assertNotEquals((Object)this.isStrictTTL, (Object)rs1.next());
            }
            catch (Throwable prs2) {
                var21_25 = prs2;
                throw prs2;
            }
            finally {
                if (rs1 != null) {
                    if (var21_25 != null) {
                        try {
                            rs1.close();
                        }
                        catch (Throwable prs2) {
                            var21_25.addSuppressed(prs2);
                        }
                    } else {
                        rs1.close();
                    }
                }
            }
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi");
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(it);
            try {
                Assert.assertEquals((long)(this.isStrictTTL ? 1L : 2L), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)(this.isStrictTTL ? 1L : 2L), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            }
            catch (AssertionError e) {
                IndexToolIT.dumpMRJobCounters(mrJobCounters);
                throw e;
            }
            this.doMajorCompaction(fullIndexName);
            TestUtil.dumpTable(conn, TableName.valueOf((String)fullIndexName));
            actual = TestUtil.getRowCountFromIndex(conn, fullDataTableName, fullIndexName);
            Assert.assertEquals((long)(rowCount - 1), (long)actual);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            expectedCellCount.insertRow(this.indexRowPosToKey.get(0), includedColumns.size() + 1);
            this.validateTable(conn, fullIndexName, expectedCellCount, this.indexRowPosToKey.values());
        }
    }

    @Test
    public void testLocalIndex() throws Exception {
        Assume.assumeTrue((boolean)this.isStrictTTL);
        String ttlCol = "VAL5";
        String ttlExpression = String.format("%s=TRUE", ttlCol);
        this.createTable(ttlExpression);
        String fullDataTableName = this.schemaBuilder.getEntityTableName();
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullDataTableName);
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullDataTableName);
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            this.deleteRow(conn, 2);
            this.updateColumn(conn, 0, ttlCol, true);
            this.updateColumn(conn, 4, ttlCol, true);
            String indexName = ConditionalTTLExpressionIT.generateUniqueName();
            String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
            String indexDDL = String.format("create local index %s on %s (%s) include (%s) async", indexName, fullDataTableName, "VAL1", ttlCol);
            conn.createStatement().execute(indexDDL);
            IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            this.populateRowPosToRowKey(conn, true);
            long actual = TestUtil.getRowCount(conn, fullDataTableName, true);
            Assert.assertEquals((long)(rowCount - 3), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, fullDataTableName, fullIndexName);
            Assert.assertEquals((long)(rowCount - 3), (long)actual);
            this.injectEdge.incrementValue((long)(2 * this.tableLevelMaxLookback) * 1000L + 5L);
            this.doMajorCompaction(fullDataTableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            for (int i = 0; i < rowCount; ++i) {
                expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
            }
            expectedCellCount.removeRow(this.dataRowPosToKey.get(0));
            expectedCellCount.removeRow(this.dataRowPosToKey.get(4));
            expectedCellCount.removeRow(this.dataRowPosToKey.get(2));
            expectedCellCount.insertRow(this.indexRowPosToKey.get(1), 2);
            expectedCellCount.insertRow(this.indexRowPosToKey.get(3), 2);
            List<String> rowKeys = Stream.concat(this.dataRowPosToKey.values().stream(), this.indexRowPosToKey.values().stream()).collect(Collectors.toList());
            this.validateTable(conn, fullDataTableName, expectedCellCount, rowKeys);
        }
    }

    @Test
    public void testNulls() throws Exception {
        Assume.assumeTrue((this.tableLevelMaxLookback == 0 ? 1 : 0) != 0);
        String ttlExpression = "VAL2 = -1 AND VAL6 IS NULL";
        this.createTable(ttlExpression);
        ArrayList indexedColumns = Lists.newArrayList((Object[])new String[]{"VAL1"});
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"VAL2", "VAL6"});
        String indexName = this.createIndex(indexedColumns, includedColumns, false);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 10;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            int i;
            this.populateTable(conn, rowCount);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            for (i = 0; i < rowCount; ++i) {
                if (i % 2 == 0) continue;
                this.updateColumn(conn, i, "VAL6", null);
            }
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            for (i = 0; i < rowCount; ++i) {
                if (i % 2 == 0) continue;
                this.updateColumn(conn, i, "VAL2", -1);
            }
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2) : (long)rowCount), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2) : (long)rowCount), (long)actual);
            this.updateColumn(conn, 3, "VAL4", null);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2 + 1) : (long)rowCount), (long)actual);
            this.deleteRow(conn, 5);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2 + 1) : (long)(rowCount - 1)), (long)actual);
            this.injectEdge.incrementValue(2L);
            this.doMajorCompaction(tableName);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2 + 1) : (long)(rowCount / 2)), (long)actual);
            this.doMajorCompaction(indexName);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2 + 1) : (long)(rowCount / 2)), (long)actual);
        }
    }

    @Test
    public void testNulls2() throws Exception {
        Assume.assumeTrue((this.tableLevelMaxLookback == 0 ? 1 : 0) != 0);
        String ttlExpression = "VAL2 IS NULL AND VAL4 IS NULL";
        this.createTable(ttlExpression);
        ArrayList indexedColumns = Lists.newArrayList((Object[])new String[]{"VAL2"});
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"VAL4"});
        String indexName = this.createIndex(indexedColumns, includedColumns, false);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 1;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            this.updateColumns(conn, 0, Lists.newArrayList((Object[])new String[]{"VAL2", "VAL4"}), Lists.newArrayList((Object[])new Object[]{null, null}));
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 0L : 1L), (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)(this.isStrictTTL ? 0L : 1L), (long)actual);
            int newVal = 123;
            this.updateColumn(conn, 0, "VAL2", newVal);
            try (ResultSet rs = this.readRow(conn, 0);){
                Assert.assertTrue((boolean)rs.next());
                for (String col : COLUMNS) {
                    if (!col.equals("VAL2")) {
                        if (!this.isStrictTTL) continue;
                        Assert.assertNull((Object)rs.getObject(col));
                        continue;
                    }
                    Assert.assertEquals((long)newVal, (long)rs.getInt("VAL2"));
                }
            }
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)1L, (long)actual);
            actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
            Assert.assertEquals((long)1L, (long)actual);
            IndexToolIT.verifyIndexTable(tableName, indexName, conn);
        }
    }

    @Test
    public void testImmutableTable() throws Exception {
        String tableName = ConditionalTTLExpressionIT.generateUniqueName();
        String indexName = ConditionalTTLExpressionIT.generateUniqueName();
        String ttlExpression = "CURRENT_TIME() >= CREATED_TS + CASE WHEN EVENT_TYPE = ''ERROR'' THEN 7 ELSE 1 END";
        this.tableDDLOptions = this.tableDDLOptions + " ,IMMUTABLE_ROWS=true";
        this.tableDDLOptions = !this.columnEncoded ? this.tableDDLOptions + " ,IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'" : this.tableDDLOptions + " ,IMMUTABLE_STORAGE_SCHEME='SINGLE_CELL_ARRAY_WITH_OFFSETS'";
        String ddl = String.format("CREATE TABLE %s (ID BIGINT NOT NULL PRIMARY KEY, EVENT_TYPE CHAR(15), CREATED_TS TIMESTAMP) %s", tableName, String.format(this.tableDDLOptions, ttlExpression));
        String indexDDL = String.format("CREATE INDEX %s ON %s (EVENT_TYPE) INCLUDE(CREATED_TS) ", indexName, tableName, this.tableLevelMaxLookback);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(indexDDL);
            conn.commit();
            this.injectEdge();
            int rowCount = 10;
            String dml = String.format("UPSERT INTO %s VALUES (?, ?, ?)", tableName);
            try (PreparedStatement ps = conn.prepareStatement(dml);){
                for (int i = 0; i < rowCount; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, i % 2 == 0 ? "INFO" : "ERROR");
                    ps.setTimestamp(3, new Timestamp(this.injectEdge.currentTime()));
                    ps.executeUpdate();
                }
                conn.commit();
                long actual = TestUtil.getRowCount(conn, tableName, true);
                Assert.assertEquals((long)rowCount, (long)actual);
                this.injectEdge.incrementValue(86400000L);
                actual = TestUtil.getRowCount(conn, tableName, true);
                Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2) : (long)rowCount), (long)actual);
                actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
                Assert.assertEquals((long)(this.isStrictTTL ? (long)(rowCount / 2) : (long)rowCount), (long)actual);
                this.injectEdge.incrementValue(518400000L);
                actual = TestUtil.getRowCount(conn, tableName, true);
                Assert.assertEquals((long)(this.isStrictTTL ? 0L : (long)rowCount), (long)actual);
                actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
                Assert.assertEquals((long)(this.isStrictTTL ? 0L : (long)rowCount), (long)actual);
                this.injectEdge.incrementValue(1L);
                this.doMajorCompaction(tableName);
                actual = TestUtil.getRowCount(conn, tableName, true);
                Assert.assertEquals((long)0L, (long)actual);
                this.doMajorCompaction(indexName);
                actual = TestUtil.getRowCountFromIndex(conn, tableName, indexName);
                Assert.assertEquals((long)0L, (long)actual);
            }
        }
    }

    @Test
    public void testConcurrentUpserts() throws Exception {
        int i;
        Assume.assumeTrue((this.tableLevelMaxLookback == 0 ? 1 : 0) != 0);
        int nThreads = 10;
        int batchSize = 100;
        int nRows = 499;
        int nIndexVals = 23;
        String tableName = ConditionalTTLExpressionIT.generateUniqueName();
        String indexName = ConditionalTTLExpressionIT.generateUniqueName();
        String ttlExpression = "v1 is null and v3 is null";
        String ddl = String.format("CREATE TABLE %s (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 INTEGER, v2 INTEGER, v3 INTEGER, v4 INTEGER CONSTRAINT pk PRIMARY KEY (k1,k2)) COLUMN_ENCODED_BYTES=%d, TTL='%s'", tableName, this.columnEncoded ? 2 : 0, ttlExpression);
        String indexDDL = String.format("CREATE INDEX %s ON %s (v2) INCLUDE (v1, v3)", indexName, tableName);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(indexDDL);
        }
        CountDownLatch doneSignal = new CountDownLatch(10);
        Runnable[] runnables = new Runnable[10];
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        for (i = 0; i < 10; ++i) {
            runnables[i] = () -> {
                try {
                    Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());
                    String dml = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?, ?)";
                    try (PreparedStatement ps = conn.prepareStatement(dml);){
                        for (int i1 = 0; i1 < 10000; ++i1) {
                            int k1 = i1 % 499;
                            int k2 = 0;
                            Integer v1 = RAND.nextBoolean() ? null : Integer.valueOf(RAND.nextInt() % 23);
                            Integer v2 = RAND.nextBoolean() ? null : Integer.valueOf(RAND.nextInt());
                            Integer v3 = RAND.nextBoolean() ? null : Integer.valueOf(RAND.nextInt());
                            Integer v4 = RAND.nextBoolean() ? null : Integer.valueOf(RAND.nextInt());
                            ps.setInt(1, k1);
                            ps.setInt(2, k2);
                            ps.setObject(3, v1);
                            ps.setObject(4, v2);
                            ps.setObject(5, v3);
                            ps.setObject(6, v4);
                            ps.executeUpdate();
                            if (i1 % 100 != 0) continue;
                            conn.commit();
                        }
                        conn.commit();
                    }
                }
                catch (SQLException e) {
                    LOG.warn("Exception during upsert : " + e);
                }
                finally {
                    doneSignal.countDown();
                }
            };
        }
        for (i = 0; i < 10; ++i) {
            Thread t = new Thread(runnables[i]);
            t.start();
        }
        Assert.assertTrue((String)"Ran out of time", (boolean)doneSignal.await(120L, TimeUnit.SECONDS));
        LOG.info("Total upsert time in ms : " + (EnvironmentEdgeManager.currentTimeMillis() - startTime));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            IndexToolIT.verifyIndexTable(tableName, indexName, conn);
        }
    }

    @Test
    public void testBsonDataType() throws Exception {
        String ttlCol = "VAL6";
        String ttlExpression = String.format("BSON_VALUE(%s, ''attr_0'', ''VARCHAR'') IS NULL", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            this.populateTable(conn, rowCount);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)(this.isStrictTTL ? 2L : 5L), (long)actual);
            this.injectEdge.incrementValue((long)(2 * this.tableLevelMaxLookback) * 1000L + 5L);
            this.doMajorCompaction(tableName);
            TestUtil.CellCount expectedCellCount = new TestUtil.CellCount();
            for (int i = 0; i < rowCount; ++i) {
                if (i % 2 == 0) continue;
                expectedCellCount.insertRow(this.dataRowPosToKey.get(i), COLUMNS.length + 1);
            }
            this.validateTable(conn, tableName, expectedCellCount, this.dataRowPosToKey.values());
        }
    }

    @Test
    public void testCDCIndex() throws Exception {
        String ttlCol = "VAL2";
        String ttlExpression = String.format("%s = -1", ttlCol);
        this.createTable(ttlExpression);
        String tableName = this.schemaBuilder.getEntityTableName();
        this.injectEdge();
        int rowCount = 5;
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            String cdcName = ConditionalTTLExpressionIT.generateUniqueName();
            String cdc_sql = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(cdc_sql);
            this.populateTable(conn, rowCount);
            String schemaName = SchemaUtil.getSchemaNameFromFullName((String)tableName);
            String cdcIndexName = CDCUtil.getCDCIndexName((String)cdcName);
            String fullCdcIndexName = SchemaUtil.getTableName((String)schemaName, (String)CDCUtil.getCDCIndexName((String)cdcName));
            PTable cdcIndex = ((PhoenixConnection)conn).getTableNoCache(fullCdcIndexName);
            Assert.assertEquals((Object)cdcIndex.getTTLExpression(), (Object)LiteralTTLExpression.TTL_EXPRESSION_FOREVER);
            long actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            actual = TestUtil.getRawRowCount(conn, TableName.valueOf((String)fullCdcIndexName));
            Assert.assertEquals((long)rowCount, (long)actual);
            this.injectEdge.incrementValue((long)this.tableLevelMaxLookback.intValue() * 1000L + 2L);
            TestUtil.doMajorCompaction(conn, fullCdcIndexName);
            actual = TestUtil.getRawRowCount(conn, TableName.valueOf((String)fullCdcIndexName));
            Assert.assertEquals((long)0L, (long)actual);
            actual = TestUtil.getRowCount(conn, tableName, true);
            Assert.assertEquals((long)rowCount, (long)actual);
            String alterDDL = String.format("alter table %s set TTL='%s = %d'", tableName, ttlCol, 0);
            conn.createStatement().execute(alterDDL);
            cdcIndex = ((PhoenixConnection)conn).getTableNoCache(fullCdcIndexName);
            Assert.assertEquals((Object)cdcIndex.getTTLExpression(), (Object)LiteralTTLExpression.TTL_EXPRESSION_FOREVER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTable(Connection conn, String tableName, TestUtil.CellCount expectedCellCount, Collection<String> rowKeys) throws Exception {
        TestUtil.CellCount actualCellCount = TestUtil.getRawCellCount(conn, TableName.valueOf((String)tableName));
        try {
            Assert.assertEquals((String)("Expected cellCount: " + expectedCellCount + " , actual: " + actualCellCount), (Object)expectedCellCount, (Object)actualCellCount);
        }
        catch (AssertionError e) {
            try {
                TestUtil.dumpTable(conn, TableName.valueOf((String)tableName));
                for (String rowKey : rowKeys) {
                    LOG.info(String.format("Key=%s expected=%d, actual=%d", Bytes.toStringBinary((byte[])rowKey.getBytes()), expectedCellCount.getCellCount(rowKey), actualCellCount.getCellCount(rowKey)));
                }
            }
            finally {
                throw e;
            }
        }
    }

    private void cleanUpSharedTtlImageCache() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getSharedCacheMethod = CDCCompactionUtil.class.getDeclaredMethod("getSharedRowImageCache", Configuration.class);
        getSharedCacheMethod.setAccessible(true);
        Cache cache = (Cache)getSharedCacheMethod.invoke(null, new Object[]{null});
        cache.cleanUp();
    }

    private void doMajorCompaction(String tableName) throws IOException, InterruptedException {
        TestUtil.flush(ConditionalTTLExpressionIT.getUtility(), TableName.valueOf((String)tableName));
        TestUtil.majorCompact(ConditionalTTLExpressionIT.getUtility(), TableName.valueOf((String)tableName));
    }

    private void createTable(String ttlExpression) throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = new PhoenixTestBuilder.SchemaBuilder.TableOptions();
        tableOptions.setTablePKColumns(Arrays.asList(PK_COLUMNS));
        tableOptions.setTablePKColumnTypes(Arrays.asList(PK_COLUMN_TYPES));
        tableOptions.setTableColumns(Arrays.asList(COLUMNS));
        tableOptions.setTableColumnTypes(Arrays.asList(COLUMN_TYPES));
        tableOptions.setTableProps(String.format(this.tableDDLOptions, ttlExpression));
        tableOptions.setMultiTenant(false);
        PhoenixTestBuilder.SchemaBuilder.OtherOptions otherOptions = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        otherOptions.setTableCFs(Arrays.asList(DEFAULT_COLUMN_FAMILIES));
        this.schemaBuilder.withTableOptions(tableOptions).withOtherOptions(otherOptions).build();
    }

    private String createIndex(List<String> indexedColumns, List<String> includedColumns, boolean isAsync) throws SQLException {
        String indexName = "I_" + ConditionalTTLExpressionIT.generateUniqueName();
        String tableName = this.schemaBuilder.getEntityTableName();
        String schema = SchemaUtil.getSchemaNameFromFullName((String)tableName);
        String indexDDL = String.format("create index %s on %s (%s) include (%s) ", indexName, tableName, Joiner.on((String)",").join(indexedColumns), Joiner.on((String)",").join(includedColumns));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionIT.getUrl());){
            conn.createStatement().execute(indexDDL);
        }
        return SchemaUtil.getTableName((String)schema, (String)indexName);
    }

    private void injectEdge() {
        long startTime = System.currentTimeMillis() + 1000L;
        startTime = startTime / 1000L * 1000L;
        this.injectEdge.setValue(startTime);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
    }

    private List<Object> generatePKColumnValues(int rowPosition) {
        String ID1_FORMAT = "id1_%d";
        String id1 = String.format("id1_%d", rowPosition / 2);
        int id2 = rowPosition;
        return Lists.newArrayList((Object[])new Object[]{id1, id2});
    }

    private BsonDocument generateBsonDocument(int rowPosition) {
        BsonDocument bsonDocument = new BsonDocument();
        if (rowPosition % 2 != 0) {
            bsonDocument.put("attr_0", (BsonValue)new BsonString("str_val_" + rowPosition));
        }
        bsonDocument.put("attr_1", (BsonValue)new BsonInt32(rowPosition * rowPosition));
        bsonDocument.put("attr_2", (BsonValue)new BsonBoolean(rowPosition % 2 == 0));
        return bsonDocument;
    }

    private List<Object> generateRow(int rowPosition) {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        List<Object> pkCols = this.generatePKColumnValues(rowPosition);
        String val1 = "val1_" + RAND.nextInt(1000);
        int val2 = RAND.nextInt(1000);
        Date val3 = new Date(startTime + (long)RAND.nextInt(1000));
        Timestamp val4 = new Timestamp(val3.getTime());
        boolean val5 = false;
        BsonDocument val6 = this.generateBsonDocument(rowPosition);
        ArrayList cols = Lists.newArrayList((Object[])new Object[]{val1, val2, val3, val4, val5, val6});
        ArrayList values = Lists.newArrayListWithExpectedSize((int)(pkCols.size() + cols.size()));
        values.addAll(pkCols);
        values.addAll(cols);
        return values;
    }

    private void updateColumn(Connection conn, int rowPosition, String columnName, Object newColumnValue) throws Exception {
        this.updateColumns(conn, rowPosition, Lists.newArrayList((Object[])new String[]{columnName}), Lists.newArrayList((Object[])new Object[]{newColumnValue}));
    }

    private void updateColumns(Connection conn, int rowPosition, List<String> columnNames, List<Object> newColumnValues) throws Exception {
        assert (columnNames.size() == newColumnValues.size());
        String tableName = this.schemaBuilder.getEntityTableName();
        ArrayList upsertColumns = Lists.newArrayList();
        upsertColumns.addAll(Arrays.asList(PK_COLUMNS));
        upsertColumns.addAll(columnNames);
        StringBuilder buf = new StringBuilder("UPSERT INTO ");
        buf.append(tableName);
        buf.append(" (").append(Joiner.on((String)",").join((Iterable)upsertColumns)).append(") VALUES(");
        for (int i = 0; i < upsertColumns.size(); ++i) {
            buf.append("?,");
        }
        buf.setCharAt(buf.length() - 1, ')');
        ArrayList upsertValues = Lists.newArrayList();
        upsertValues.addAll(this.generatePKColumnValues(rowPosition));
        upsertValues.addAll(newColumnValues);
        try (PreparedStatement stmt = conn.prepareStatement(buf.toString());){
            for (int i = 0; i < upsertValues.size(); ++i) {
                stmt.setObject(i + 1, upsertValues.get(i));
            }
            stmt.executeUpdate();
            conn.commit();
        }
        this.injectEdge.incrementValue(1L);
    }

    private void updateRow(Connection conn, int rowPosition) throws Exception {
        String tableName = this.schemaBuilder.getEntityTableName();
        List<Object> upsertValues = this.generateRow(rowPosition);
        StringBuilder buf = new StringBuilder("UPSERT INTO ");
        buf.append(tableName);
        buf.append(" VALUES(");
        for (int i = 0; i < upsertValues.size(); ++i) {
            buf.append("?,");
        }
        buf.setCharAt(buf.length() - 1, ')');
        try (PreparedStatement stmt = conn.prepareStatement(buf.toString());){
            for (int i = 0; i < upsertValues.size(); ++i) {
                stmt.setObject(i + 1, upsertValues.get(i));
            }
            stmt.executeUpdate();
            conn.commit();
        }
        this.injectEdge.incrementValue(1L);
    }

    private void deleteRow(Connection conn, int rowPosition) throws SQLException {
        String tableName = this.schemaBuilder.getEntityTableName();
        String dml = String.format("delete from %s where ID1 = ? and ID2 = ?", tableName);
        try (PreparedStatement ps = conn.prepareStatement(dml);){
            List<Object> pkCols = this.generatePKColumnValues(rowPosition);
            for (int i = 0; i < pkCols.size(); ++i) {
                ps.setObject(i + 1, pkCols.get(i));
            }
            ps.executeUpdate();
            conn.commit();
        }
        this.injectEdge.incrementValue(1L);
    }

    private void populateTable(Connection conn, int rowCount) throws Exception {
        for (int i = 0; i < rowCount; ++i) {
            this.updateRow(conn, i);
        }
        this.populateRowPosToRowKey(conn, false);
    }

    private void populateRowPosToRowKey(Connection conn, boolean useIndex) throws SQLException {
        String tableName = this.schemaBuilder.getEntityTableName();
        String query = String.format("SELECT %s ID2, ROWKEY_BYTES_STRING() FROM %s", useIndex ? "" : "/*+ NO_INDEX */", tableName);
        Map<Integer, String> rowPosToKey = useIndex ? this.indexRowPosToKey : this.dataRowPosToKey;
        try (ResultSet rs = conn.createStatement().executeQuery(query);){
            while (rs.next()) {
                int rowPos = rs.getInt(1);
                String rowKey = rs.getString(2);
                rowPosToKey.put(rowPos, Bytes.toString((byte[])Bytes.toBytesBinary((String)rowKey)));
            }
        }
    }

    private ResultSet readRow(Connection conn, int rowPosition) throws SQLException {
        String tableName = this.schemaBuilder.getEntityTableName();
        String query = String.format("select * FROM %s where ID1 = ? AND ID2 = ?", tableName);
        List<Object> pkCols = this.generatePKColumnValues(rowPosition);
        PreparedStatement ps = conn.prepareStatement(query);
        for (int i = 0; i < pkCols.size(); ++i) {
            ps.setObject(i + 1, pkCols.get(i));
        }
        return ps.executeQuery();
    }

    static {
        assert (PK_COLUMNS.length == PK_COLUMN_TYPES.length);
        assert (COLUMNS.length == COLUMN_TYPES.length);
        OBJECT_MAPPER = new ObjectMapper();
    }
}

