/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.rpc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.apache.phoenix.util.ValidateLastDDLTimestampUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
public class UpdateCacheIT
extends ParallelStatsDisabledIT {
    private boolean isLastDDLTimestampValidationEnabled = ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled((Configuration)config);
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCacheIT.class);

    private static void setupSystemTable(String fullTableName) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ");
        }
    }

    @Test
    public void testUpdateCacheForTxnTable() throws Exception {
        for (TransactionFactory.Provider provider : TransactionFactory.Provider.available()) {
            String tableName = UpdateCacheIT.generateUniqueName();
            String fullTableName = "INDEX_TEST." + tableName;
            Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + provider + "'");
            int[] expectedRPCs = new int[]{1, 3};
            if (this.isLastDDLTimestampValidationEnabled) {
                expectedRPCs = new int[]{0, 0};
            }
            UpdateCacheIT.helpTestUpdateCache(fullTableName, expectedRPCs, false);
        }
    }

    @Test
    public void testUpdateCacheForNonTxnTable() throws Exception {
        String tableName = UpdateCacheIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + tableName;
        Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ");
        int[] expectedRPCs = new int[]{1, 3};
        if (this.isLastDDLTimestampValidationEnabled) {
            expectedRPCs = new int[]{0, 0};
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, expectedRPCs, false);
    }

    @Test
    public void testUpdateCacheForNonTxnSystemTable() throws Exception {
        String fullTableName = "\"SYSTEM\"." + UpdateCacheIT.generateUniqueName();
        UpdateCacheIT.setupSystemTable(fullTableName);
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{0, 0}, false);
    }

    @Test
    public void testUpdateCacheForNeverUpdatedTable() throws Exception {
        String tableName = UpdateCacheIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        AtomicBoolean isSysMutexEmpty = new AtomicBoolean(true);
        ExecutorService executorService = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("check-sys-mutex-count-%d").build());
        for (int i = 0; i < 5; ++i) {
            executorService.submit(new SystemMutexCaller(isSysMutexEmpty, props, "INDEX_TEST", tableName));
        }
        Thread.sleep(500L);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ");
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET UPDATE_CACHE_FREQUENCY=NEVER");
        }
        Assert.assertTrue((String)"Mutex should not have been acquired", (boolean)isSysMutexEmpty.get());
        try {
            executorService.shutdown();
            executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.debug("Error during ExecutorService shutdown");
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{0, 0}, false);
    }

    @Test
    public void testUpdateCacheForAlwaysUpdatedTable() throws Exception {
        String fullTableName = "INDEX_TEST." + UpdateCacheIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + " UPDATE_CACHE_FREQUENCY=always");
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{1, 3}, false);
    }

    @Test
    public void testUpdateCacheForTimeLimitedUpdateTable() throws Exception {
        String fullTableName = "INDEX_TEST." + UpdateCacheIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + " UPDATE_CACHE_FREQUENCY=" + 10000);
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{0, 0}, false);
        Thread.sleep(10000L);
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{1, 0}, false);
    }

    @Test
    public void testUpdateCacheForChangingUpdateTable() throws Exception {
        String tableName = UpdateCacheIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + " UPDATE_CACHE_FREQUENCY=never");
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{0, 0}, false);
        AtomicBoolean isSysMutexEmpty = new AtomicBoolean(true);
        ExecutorService executorService = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("check-sys-mutex-count-%d").build());
        for (int i = 0; i < 5; ++i) {
            executorService.submit(new SystemMutexCaller(isSysMutexEmpty, props, "INDEX_TEST", tableName));
        }
        Thread.sleep(500L);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET UPDATE_CACHE_FREQUENCY=ALWAYS");
        }
        Assert.assertTrue((String)"Mutex should not have been acquired", (boolean)isSysMutexEmpty.get());
        try {
            executorService.shutdown();
            executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.debug("Error during ExecutorService shutdown");
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{1, 3}, false);
    }

    @Test
    public void testUpdateCacheFreqPropagatedToIndexes() throws Exception {
        String baseTableName = UpdateCacheIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + baseTableName;
        String localIndex = "LOCAL_" + baseTableName;
        String globalIndex = "GLOBAL_" + baseTableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + " UPDATE_CACHE_FREQUENCY=never");
            conn.createStatement().execute("CREATE LOCAL INDEX " + localIndex + " on " + fullTableName + " (a.date1, b.varchar_col2)");
            conn.createStatement().execute("CREATE INDEX " + globalIndex + " on " + fullTableName + " (a.int_col1, a.long_col1)");
        }
        int numRPCUpsert = 0;
        int numRPCSelect = 0;
        if (this.isLastDDLTimestampValidationEnabled) {
            numRPCUpsert = 1;
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{numRPCUpsert, numRPCSelect}, false);
        UpdateCacheIT.helpTestUpdateCache("INDEX_TEST." + localIndex, new int[]{0}, true);
        UpdateCacheIT.helpTestUpdateCache("INDEX_TEST." + globalIndex, new int[]{0}, true);
        try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), props);){
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET UPDATE_CACHE_FREQUENCY=ALWAYS");
        }
        UpdateCacheIT.helpTestUpdateCache(fullTableName, new int[]{1, 21}, false);
        UpdateCacheIT.helpTestUpdateCache("INDEX_TEST." + localIndex, new int[]{3}, true);
        UpdateCacheIT.helpTestUpdateCache("INDEX_TEST." + globalIndex, new int[]{3}, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void helpTestUpdateCache(String fullTableName, int[] expectedRPCs, boolean skipUpsertForIndexes) throws Exception {
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullTableName);
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullTableName);
        String selectSql = "SELECT * FROM " + fullTableName;
        ConnectionQueryServices connectionQueryServices = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(UpdateCacheIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)));
        Properties props = new Properties();
        props.putAll((Map<?, ?>)PhoenixEmbeddedDriver.DEFAULT_PROPS.asMap());
        try (PhoenixConnection conn = connectionQueryServices.connect(UpdateCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            if (!skipUpsertForIndexes) {
                String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
                PreparedStatement stmt = conn.prepareStatement(upsert);
                for (int i = 0; i < 3; ++i) {
                    TestUtil.setRowKeyColumns(stmt, i);
                    stmt.execute();
                }
                conn.commit();
                int numUpsertRpcs = expectedRPCs[0];
                ((ConnectionQueryServices)Mockito.verify((Object)connectionQueryServices, (VerificationMode)Mockito.times((int)numUpsertRpcs))).getTable((PName)ArgumentMatchers.isNull(), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)schemaName)), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
                Mockito.reset((Object[])new ConnectionQueryServices[]{connectionQueryServices});
            }
            UpdateCacheIT.validateSelectRowKeyCols((Connection)conn, selectSql, skipUpsertForIndexes);
            UpdateCacheIT.validateSelectRowKeyCols((Connection)conn, selectSql, skipUpsertForIndexes);
            UpdateCacheIT.validateSelectRowKeyCols((Connection)conn, selectSql, skipUpsertForIndexes);
            int numRpcs = skipUpsertForIndexes ? expectedRPCs[0] : expectedRPCs[1];
            ((ConnectionQueryServices)Mockito.verify((Object)connectionQueryServices, (VerificationMode)Mockito.times((int)numRpcs))).getTable((PName)ArgumentMatchers.isNull(), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)schemaName)), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        }
    }

    private static void validateSelectRowKeyCols(Connection conn, String selectSql, boolean skipUpsertForIndexes) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery(selectSql);
        if (skipUpsertForIndexes) {
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)rs.next());
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                TestUtil.validateRowKeyColumns(rs, i);
            }
        }
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testInvalidConnUpdateCacheFrequencyShouldThrow() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        ArrayList<String> invalidUCF = new ArrayList<String>();
        invalidUCF.add("GIBBERISH");
        invalidUCF.add("10000.6");
        for (String connLevelUCF : invalidUCF) {
            props.put("phoenix.default.update.cache.frequency", connLevelUCF);
            try {
                DriverManager.getConnection(UpdateCacheIT.getUrl(), props);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Connection's phoenix.default.update.cache.frequency"));
            }
        }
    }

    private static class SystemMutexCaller
    implements Runnable {
        private final AtomicBoolean isSysMutexEmpty;
        private final Properties props;
        private final String schemaName;
        private final String tableName;

        public SystemMutexCaller(AtomicBoolean isSysMutexEmpty, Properties props, String schemaName, String tableName) {
            this.isSysMutexEmpty = isSysMutexEmpty;
            this.props = props;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        @Override
        public void run() {
            try (Connection conn = DriverManager.getConnection(UpdateCacheIT.getUrl(), this.props);){
                while (!Thread.interrupted() && !conn.isClosed()) {
                    try {
                        ResultSet resultSet = conn.createStatement().executeQuery("SELECT * FROM " + PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME + " WHERE TENANT_ID IS NULL AND TABLE_SCHEM='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "' AND COLUMN_NAME IS NULL AND COLUMN_FAMILY IS NULL");
                        if (!resultSet.next()) continue;
                        this.isSysMutexEmpty.set(false);
                        break;
                    }
                    catch (SQLException e) {
                        if (conn.isClosed()) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        LOGGER.error("Error while scanning {} , thread: {}", new Object[]{PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME, Thread.currentThread().getName(), e});
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("Connection access error. Thread: {}", (Object)Thread.currentThread().getName(), (Object)e);
            }
        }
    }
}

