/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.rpc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ValidateLastDDLTimestampUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={ParallelStatsDisabledTest.class})
public class UpdateCacheConnectionLevelPropIT
extends ParallelStatsDisabledIT {
    private static Connection conn1;
    private static Connection conn2;
    private static ConnectionQueryServices spyForConn2;
    private boolean isLastDDLTimestampValidationEnabled = ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled((Configuration)config);

    @AfterClass
    public static synchronized void freeResources() {
        try {
            conn1.close();
            conn2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testWithConnLevelUCFNoTableLevelUCF() throws Exception {
        long connUpdateCacheFrequency = 1000L;
        String fullTableName = "S." + UpdateCacheConnectionLevelPropIT.generateUniqueName();
        UpdateCacheConnectionLevelPropIT.setUpTableAndConnections(fullTableName, null, String.valueOf(1000L));
        int numExecutions = 2;
        int numExpectedGetTableCalls = 0;
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
        Thread.sleep(1000L);
        numExpectedGetTableCalls = 1;
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
    }

    @Test
    public void testWithTableLevelUCFNoConnLevelUCF() throws Exception {
        long tableUpdateCacheFrequency = 1000L;
        String fullTableName = "S." + UpdateCacheConnectionLevelPropIT.generateUniqueName();
        int numExecutions = 2;
        int numExpectedGetTableCalls = 0;
        UpdateCacheConnectionLevelPropIT.setUpTableAndConnections(fullTableName, String.valueOf(1000L), null);
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
        Thread.sleep(1000L);
        numExpectedGetTableCalls = 1;
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
    }

    @Test
    public void testWithNoConnAndTableLevelUCF() throws Exception {
        String fullTableName = "S." + UpdateCacheConnectionLevelPropIT.generateUniqueName();
        int numExecutions = 2;
        int numExpectedGetTableCalls = 4;
        if (this.isLastDDLTimestampValidationEnabled) {
            numExpectedGetTableCalls = 0;
        }
        UpdateCacheConnectionLevelPropIT.setUpTableAndConnections(fullTableName, null, null);
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
    }

    @Test
    public void testWithBothConnAndTableLevelUCF() throws Exception {
        long tableUpdateCacheFrequency = 5000L;
        long connUpdateCacheFrequency = 1000L;
        String fullTableName = "S." + UpdateCacheConnectionLevelPropIT.generateUniqueName();
        int numExecutions = 2;
        int numExpectedGetTableCalls = 0;
        UpdateCacheConnectionLevelPropIT.setUpTableAndConnections(fullTableName, String.valueOf(5000L), String.valueOf(1000L));
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
        Thread.sleep(1000L);
        numExpectedGetTableCalls = 0;
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
        Thread.sleep(4000L);
        numExpectedGetTableCalls = 1;
        UpdateCacheConnectionLevelPropIT.verifyExpectedGetTableCalls(fullTableName, numExecutions, numExpectedGetTableCalls);
    }

    private static void setUpTableAndConnections(String fullTableName, String tableUpdateCacheFrequency, String connUpdateCacheFrequency) throws SQLException {
        Properties props = new Properties();
        conn1 = DriverManager.getConnection(UpdateCacheConnectionLevelPropIT.getUrl(), props);
        conn1.setAutoCommit(true);
        if (connUpdateCacheFrequency != null) {
            props.put("phoenix.default.update.cache.frequency", connUpdateCacheFrequency);
        }
        spyForConn2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(UpdateCacheConnectionLevelPropIT.getUrl(), props));
        conn2 = spyForConn2.connect(UpdateCacheConnectionLevelPropIT.getUrl(), props);
        conn2.setAutoCommit(true);
        String createTableQuery = "CREATE TABLE " + fullTableName + " (k UNSIGNED_DOUBLE NOT NULL PRIMARY KEY, v1 UNSIGNED_DOUBLE, v2 UNSIGNED_DOUBLE, v3 UNSIGNED_DOUBLE)";
        if (tableUpdateCacheFrequency != null) {
            createTableQuery = createTableQuery + " UPDATE_CACHE_FREQUENCY = " + tableUpdateCacheFrequency;
        }
        try (Statement stmt = conn1.createStatement();){
            stmt.execute(createTableQuery);
            stmt.execute("UPSERT INTO " + fullTableName + " VALUES (1, 2, 3, 4)");
        }
        conn1.commit();
    }

    private static void verifyExpectedGetTableCalls(String fullTableName, int numExecutions, int numExpectedGetTableCalls) throws SQLException {
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullTableName);
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullTableName);
        String selectFromTableQuery = "SELECT k, v1, v2, v3 FROM " + fullTableName;
        for (int i = 0; i < numExecutions; ++i) {
            try (Statement stmt = conn2.createStatement();
                 ResultSet rs = stmt.executeQuery(selectFromTableQuery);){
                Assert.assertTrue((boolean)rs.next());
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES (1, 2, 3, 4)");
                continue;
            }
        }
        ((ConnectionQueryServices)Mockito.verify((Object)spyForConn2, (VerificationMode)Mockito.times((int)numExpectedGetTableCalls))).getTable((PName)Mockito.isNull(), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)schemaName)), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Mockito.reset((Object[])new ConnectionQueryServices[]{spyForConn2});
    }
}

