/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.rpc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.PhoenixRpcScheduler;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.mockito.Mockito;

public class TestPhoenixIndexRpcSchedulerFactory
extends PhoenixRpcSchedulerFactory {
    private static Abortable abortable = new AbortServer();
    private static final Configuration conf = HBaseConfiguration.create();
    private static PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
    private static RpcExecutor indexRpcExecutor = (RpcExecutor)Mockito.spy((Object)new BalancedQueueRpcExecutor("test-index-queue", 30, 1, qosFunction, conf, abortable));
    private static RpcExecutor metadataRpcExecutor = (RpcExecutor)Mockito.spy((Object)new BalancedQueueRpcExecutor("test-metataqueue", 30, 1, qosFunction, conf, abortable));

    public RpcScheduler create(Configuration conf, PriorityFunction priorityFunction, Abortable abortable) {
        PhoenixRpcScheduler phoenixIndexRpcScheduler = (PhoenixRpcScheduler)super.create(conf, priorityFunction, abortable);
        phoenixIndexRpcScheduler.setIndexExecutorForTesting(indexRpcExecutor);
        phoenixIndexRpcScheduler.setMetadataExecutorForTesting(metadataRpcExecutor);
        return phoenixIndexRpcScheduler;
    }

    public RpcScheduler create(Configuration configuration, PriorityFunction priorityFunction) {
        return this.create(configuration, priorityFunction, null);
    }

    public static RpcExecutor getIndexRpcExecutor() {
        return indexRpcExecutor;
    }

    public static RpcExecutor getMetadataRpcExecutor() {
        return metadataRpcExecutor;
    }

    public static void reset() {
        Mockito.reset((Object[])new RpcExecutor[]{metadataRpcExecutor});
        Mockito.reset((Object[])new RpcExecutor[]{indexRpcExecutor});
    }

    private static class AbortServer
    implements Abortable {
        private boolean aborted = false;

        private AbortServer() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

