/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.rpc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.rpc.TestPhoenixIndexRpcSchedulerFactory;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixServerRpcIT
extends BaseTest {
    private String schemaName;
    private String indexName;
    private String dataTableFullName;
    private String indexTableFullName;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Map<String, String> serverProps = Collections.singletonMap("hbase.region.server.rpc.scheduler.factory.class", TestPhoenixIndexRpcSchedulerFactory.class.getName());
        Map clientProps = Collections.emptyMap();
        NUM_SLAVES_BASE = 2;
        PhoenixServerRpcIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @After
    public void cleanUpAfterTest() throws Exception {
        TestPhoenixIndexRpcSchedulerFactory.reset();
    }

    @Before
    public void generateTableNames() throws SQLException {
        this.schemaName = PhoenixServerRpcIT.generateUniqueName();
        this.indexName = PhoenixServerRpcIT.generateUniqueName();
        this.indexTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.indexName);
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)PhoenixServerRpcIT.generateUniqueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexQos() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = driver.connect(PhoenixServerRpcIT.getUrl(), props);){
            this.createTable(conn, this.dataTableFullName);
            this.createIndex(conn, this.indexName);
            this.ensureTablesOnDifferentRegionServers(this.dataTableFullName, this.indexTableFullName);
            TestPhoenixIndexRpcSchedulerFactory.reset();
            this.upsertRow(conn, this.dataTableFullName);
            ((RpcExecutor)Mockito.verify((Object)TestPhoenixIndexRpcSchedulerFactory.getIndexRpcExecutor(), (VerificationMode)Mockito.times((int)2))).dispatch((CallRunner)Mockito.any(CallRunner.class));
            TestPhoenixIndexRpcSchedulerFactory.reset();
            String selectSql = "SELECT k, v2 from " + this.dataTableFullName + " WHERE v1=?";
            PreparedStatement stmt = conn.prepareStatement(selectSql);
            stmt.setString(1, "v1");
            ResultSet rs = stmt.executeQuery("EXPLAIN " + selectSql);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.indexTableFullName + " ['v1']"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"v2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + this.indexName + " ON " + this.dataTableFullName);
            this.createTable(conn, this.indexTableFullName);
            TestPhoenixIndexRpcSchedulerFactory.reset();
            this.upsertRow(conn, this.indexTableFullName);
            ((RpcExecutor)Mockito.verify((Object)TestPhoenixIndexRpcSchedulerFactory.getIndexRpcExecutor(), (VerificationMode)Mockito.never())).dispatch((CallRunner)Mockito.any(CallRunner.class));
            selectSql = "SELECT k, v2 from " + this.indexTableFullName + " WHERE v1=?";
            stmt = conn.prepareStatement(selectSql);
            stmt.setString(1, "v1");
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"v2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectServerDisabled() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.select", "false");
        try (Connection conn = driver.connect(PhoenixServerRpcIT.getUrl(), props);){
            this.createTable(conn, this.dataTableFullName);
            this.upsertRow(conn, this.dataTableFullName);
            String tableName2 = this.dataTableFullName + "_2";
            this.createTable(conn, tableName2);
            this.ensureTablesOnDifferentRegionServers(this.dataTableFullName, tableName2);
            this.upsertSelectRows(conn, this.dataTableFullName, tableName2);
            ((RpcExecutor)Mockito.verify((Object)TestPhoenixIndexRpcSchedulerFactory.getIndexRpcExecutor(), (VerificationMode)Mockito.never())).dispatch((CallRunner)Mockito.any(CallRunner.class));
        }
    }

    private void createTable(Connection conn, String tableName) throws SQLException {
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)");
    }

    private void createIndex(Connection conn, String indexName) throws SQLException {
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + this.dataTableFullName + " (v1) INCLUDE (v2)");
    }

    private void upsertRow(Connection conn, String tableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        stmt.setString(1, "k1");
        stmt.setString(2, "v1");
        stmt.setString(3, "v2");
        stmt.execute();
        conn.commit();
    }

    private void upsertSelectRows(Connection conn, String tableName1, String tableName2) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName2 + " (k, v1, v2) SELECT k, v1, v2 FROM " + tableName1);
        stmt.execute();
        conn.commit();
    }

    private void ensureTablesOnDifferentRegionServers(String tableName1, String tableName2) throws Exception {
        byte[] table1 = Bytes.toBytes((String)tableName1);
        byte[] table2 = Bytes.toBytes((String)tableName2);
        Admin admin = driver.getConnectionQueryServices(PhoenixServerRpcIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        HBaseTestingUtility util = PhoenixServerRpcIT.getUtility();
        MiniHBaseCluster cluster = util.getHBaseCluster();
        HMaster master = cluster.getMaster();
        AssignmentManager am = master.getAssignmentManager();
        List tableRegions = admin.getRegions(TableName.valueOf((byte[])table1));
        Assert.assertEquals((String)("Expected single region for " + table1), (long)tableRegions.size(), (long)1L);
        RegionInfo hri1 = (RegionInfo)tableRegions.get(0);
        tableRegions = admin.getRegions(TableName.valueOf((byte[])table2));
        RegionInfo hri2 = (RegionInfo)tableRegions.get(0);
        Assert.assertEquals((String)("Expected single region for " + table2), (long)tableRegions.size(), (long)1L);
        ServerName serverName1 = am.getRegionStates().getRegionServerOfRegion(hri1);
        ServerName serverName2 = am.getRegionStates().getRegionServerOfRegion(hri2);
        if (serverName1.equals((Object)serverName2)) {
            HRegionServer server1 = util.getHBaseCluster().getRegionServer(0);
            HRegionServer server2 = util.getHBaseCluster().getRegionServer(1);
            HRegionServer dstServer = null;
            HRegionServer srcServer = null;
            if (server1.getServerName().equals((Object)serverName2)) {
                dstServer = server2;
                srcServer = server1;
            } else {
                dstServer = server1;
                srcServer = server2;
            }
            byte[] encodedRegionNameInBytes = hri2.getEncodedNameAsBytes();
            admin.move(encodedRegionNameInBytes, dstServer.getServerName());
            while (dstServer.getOnlineRegion(hri2.getRegionName()) == null || dstServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameInBytes) || srcServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameInBytes) || master.getAssignmentManager().getRegionStates().isRegionInTransition(hri2)) {
                Thread.sleep(1L);
            }
        }
        hri1 = (RegionInfo)admin.getRegions(TableName.valueOf((byte[])table1)).get(0);
        serverName1 = am.getRegionStates().getRegionServerOfRegion(hri1);
        hri2 = (RegionInfo)admin.getRegions(TableName.valueOf((byte[])table2)).get(0);
        serverName2 = am.getRegionStates().getRegionServerOfRegion(hri2);
        Assert.assertNotEquals((String)("Tables " + tableName1 + " and " + tableName2 + " should be on different region servers"), (Object)serverName1, (Object)serverName2);
    }
}

