/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.rpc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.rpc.TestPhoenixIndexRpcSchedulerFactory;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixClientRpcIT
extends BaseTest {
    private String schemaName;
    private String indexName;
    private String indexFullName;
    private String dataTableFullName;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Map<String, String> serverProps = Collections.singletonMap("hbase.region.server.rpc.scheduler.factory.class", TestPhoenixIndexRpcSchedulerFactory.class.getName());
        NUM_SLAVES_BASE = 2;
        PhoenixClientRpcIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), ReadOnlyProps.EMPTY_PROPS);
    }

    @AfterClass
    public static synchronized void cleanUpAfterTestSuite() throws Exception {
        TestPhoenixIndexRpcSchedulerFactory.reset();
    }

    @Before
    public void generateTableNames() throws SQLException {
        this.schemaName = PhoenixClientRpcIT.generateUniqueName();
        this.indexName = PhoenixClientRpcIT.generateUniqueName();
        this.indexFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.indexName);
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)PhoenixClientRpcIT.generateUniqueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexQos() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = driver.connect(PhoenixClientRpcIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) IMMUTABLE_ROWS=true");
            conn.createStatement().execute("CREATE INDEX " + this.indexName + " ON " + this.dataTableFullName + " (v1) INCLUDE (v2)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.dataTableFullName + " VALUES(?,?,?)");
            stmt.setString(1, "k1");
            stmt.setString(2, "v1");
            stmt.setString(3, "v2");
            stmt.execute();
            conn.commit();
            String selectSql = "SELECT k, v2 from " + this.dataTableFullName + " WHERE v1=?";
            stmt = conn.prepareStatement(selectSql);
            stmt.setString(1, "v1");
            ResultSet rs = stmt.executeQuery("EXPLAIN " + selectSql);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + this.indexFullName + " ['v1']"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"v2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            ((RpcExecutor)Mockito.verify((Object)TestPhoenixIndexRpcSchedulerFactory.getIndexRpcExecutor(), (VerificationMode)Mockito.never())).dispatch((CallRunner)Mockito.any(CallRunner.class));
        }
    }

    @Test
    public void testMetadataQos() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = driver.connect(PhoenixClientRpcIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR)");
            ((RpcExecutor)Mockito.verify((Object)TestPhoenixIndexRpcSchedulerFactory.getMetadataRpcExecutor(), (VerificationMode)Mockito.atLeastOnce())).dispatch((CallRunner)Mockito.any(CallRunner.class));
        }
    }
}

